128 MSDOS

\ INCLUDE DEFAULT
INCLUDE IBMMINI
INCLUDE DOSINT
INCLUDE KEYCODES


DECIMAL
128 CONSTANT SPAN

HANDLE EDITFILE


0 EQU TEXTBUFFER
0 EQU TEMPBUFFER

200  CONSTANT LINELEN

1 CONSTANT  RESERVED-LINES



H: +!  ( N ADDR -- )   DUP @  ROT +  SWAP !  ;

\ CURRENT EDIT FILE PARAMETERS

4 CONSTANT #FILES
VARIABLE CURRENT-FILE
VARIABLE NEXTFILEPARAMETER
H: FILEPARAMETER
                  CREATE  CELL NEXTFILEPARAMETER  DUP @ , +!
                  DOES>  @ FILEPARS CURRENT-FILE @ +  ;


HERE
FILEPARAMETER LEFTBORDER
FILEPARAMETER TOPBORDER
FILEPARAMETER CURSORLINE
FILEPARAMETER CURSORCOLUMN
FILEPARAMETER FILELEN
FILEPARAMETER THREADS
HERE SWAP - 2/  CONSTANT #FILEPARAMETERS

CREATE FILEPARAMETERTABLE
FILEPARAMETERTABLE CURRENT-FILE !
#FILEPARAMETERS   CELL *   #FILES *   ALLOT

 : +FILE      #FILEPARAMETERS CELL *         CURRENT-FILE +!  ;
 : -FILE      #FILEPARAMETERS CELL * NEGATE  CURRENT-FILE +!  ;
 : 0FILE      FILEPARAMETERTABLE  CURRENT-FILE !  ;
H: +FILE      #FILEPARAMETERS CELL *         CURRENT-FILE +!  ;
H: -FILE      #FILEPARAMETERS CELL * NEGATE  CURRENT-FILE +!  ;
H: 0FILE      FILEPARAMETERTABLE  CURRENT-FILE !  ;


H: NEW-THREAD   CREATE   HERE DUP , ,   -1 ,   ;


NEW-THREAD MAIN-TEXT
NEW-THREAD DELETED-LINES

0FILE    MAIN-TEXT    THREADS !
+FILE  DELETED-LINES  THREADS !
0FILE


: STATUS...     ( -- )            0 0 AT  ;
: STATUS...CLS  ( -- )            0 0 AT
                   RESERVED-LINES 0 DO  80 SPACES  LOOP
                                  0 0 AT  ;

: EDIT...    ( -- )               0 RESERVED-LINES AT  ;
: >DATA  ( ADDR -- ADDR' )        CELL 2* +  ;
: END-OF-THREAD ( ADDR -- FL )	  CELL 2* + @	-1 =  ;
: +LINE  ( ADDR -- ADDR' )        CELL +  @  ;
: -LINE  ( ADDR -- ADDR' )        @    ;






\       Ŀ
\                  -1  
\       
\         Ŀ
\             
\          Ŀ
\                               -1  
\          
\                 Ŀ
\                          
\                       Ŀ
\                                 
\                       
\                          
\                       Ŀ
\                                 
\                       
\                          
\                       Ŀ
\                                 
\                       
\                           
\                      
\          Ŀ
\                               -1  
\          
\                 Ŀ
\                          
\                       Ŀ
\                                 
\                       
\                          
\                       Ŀ
\                                 
\                       
\                          
\                       Ŀ
\                                 
\                       
\                           
\                      
\          Ŀ
\                               -1  
\          
\                  Ŀ
\                 
\                           Ŀ
\                                     
\                           
\                              
\                           Ŀ
\                                     
\                           
\                              
\                           Ŀ
\                                     
\                           
\                               
\                          






VARIABLE NEW-ERROR

H: MAKE-ERROR    1 NEW-ERROR
                 DUP @ , +!  ;

H: ERROR?  CREATE  MAKE-ERROR
           DOES> OVER IF
                   STATUS...CLS
		   @ REPORT-ERROR
		   KEY 2DROP  BYE
                 THEN
                 2DROP ;

ERROR?  CAN'T-OPEN?
ERROR?  CAN'T-CLOSE?
ERROR?  CAN'T-REWIND?
ERROR?  CAN'T-WRITE?
ERROR?  CAN'T-CREATE?



: ALLOCATE-TEXTBUFFER
             HERE EQU TEMPBUFFER
             LINELEN ALLOT
             HERE 256 + EQU TEXTBUFFER
             ;


: CUDDLE  ( ADDR CHAR -- ADDR' FL )
              OVER C! 1+ FALSE ( WANT MORE INPUT )  ;


: -TAB-   ( ADDR CHAR -- ADDR' FL )
          DROP   8 2DUP BLANK  + FALSE  ;

1000 CONSTANT END-OF-LINE ( NEW FILE ERROR )
: -LINEFEED-   ( ADDR CHAR -- ADDR err -1 )
        DROP
        DUP 1- C@
        13 = IF 1- THEN
        END-OF-LINE TRUE ;



( BUFADR CHAR -- BUFADR' TRUE | BUFADR 0 )
TABLE CONTROL-CHARACTER
 ' CUDDLE  ,
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,         ' CUDDLE  , ( 4 )
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,         ' CUDDLE  , ( 8 )
 '  -TAB-  ,       ' -LINEFEED- ,     ' CUDDLE  ,         ' CUDDLE  , ( 12 )
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,         ' CUDDLE  ,
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,         ' CUDDLE  ,
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,         ' CUDDLE  ,
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,         ' CUDDLE  ,
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,


: INSERT-LINE  ( ADDR1 ADDR2 -- )         \ add ADDR1 below ADDR2
        2DUP   +LINE !
        2DUP   <-
        CELL +   2DUP @
        SWAP CELL +  ! ! ;

: APPEND-LINE  ( ADDR1 ADDR2 )               \ ADDR2 is THREAD
        -LINE INSERT-LINE  ;

: UNLINK-LINE   ( ADDR -- )
       DUP +LINE   SWAP -LINE  2DUP CELL +  !  <-  ;


: READ-LINE    ( ADDR -- LEN 0 | LEN ERR )
             DUP  FALSE                          ( NOT END OF LINE YET )
             BEGIN
               NOT  IF                           ( END-OF-LINE )
               GET  THEN
             ?DUP 0= WHILE                       ( NO ERROR / END-OF-LINE )
               DUP BL U<
               IF                                ( BUFADR CHAR )
                 DUP CONTROL-CHARACTER EXECUTE   ( FL true   ABORTS )
               ELSE
                 CUDDLE
               THEN
             REPEAT
             END-OF-LINE <>                      ( MUST BE ERROR THEN )
             >R
             SWAP -
             R>    ;



: READ-TEXT  ( ADDR -- #LINES )
             0                              \ LINES COUNTER
              BEGIN
                SWAP                        \ L A
                DUP >DATA                   \ L A A'
                DUP CELL +
                READ-LINE                   \ L A A' # ERR
              0= WHILE                      \ L A A' #
                TUCK <-                     \ L A #
                OVER
                MAIN-TEXT  APPEND-LINE
                +
                >DATA CELL +
                SWAP 1+
              REPEAT
              2DROP
              DROP  ;



\ files don't get shorter ...
: OPEN-FILES
             1STPAR READ$
             EDITFILE FILENM
             DROP
             EDITFILE OPEN-FILE
             CAN'T-OPEN?                   \ CREATE NEW FILE INSTEAD
             EDITFILE FROMFILE
             EDITFILE TOFILE
             ALLOCATE-TEXTBUFFER  ;


: CLOSE-FILES  ( -- )        ENDTO   CAN'T-CLOSE?    ;
: CHANGED      ( -- F )      KEY CAPITALIZE ASCII W =  ;

( ADDR CNT -- 0 | ADDR )
\ ADDR IS THE CHAR WHERE WRITE ERROR OCCURED )
: WRITE-LINE  ( ADDR CNT -- FL )
             0 ?DO
                COUNT PUT
                IF 0 LEAVE THEN
               LOOP

             ?DUP IF

                13 ( CR ) PUT
                10 ( LF ) PUT
                OR
                0= IF
                   DROP FALSE
                THEN
             THEN  ;


: WRITE-TEXT   ( ADDR -- )
             BEGIN
               DUP END-OF-THREAD
             0= WHILE
               DUP >DATA SKIM WRITE-LINE  CAN'T-WRITE?
               +LINE
             REPEAT  DROP
               ;

\ ------------------------------------------------------------

: CLS-EDIT  ( -- )     CHARS/LINE RESERVED-LINES *  -CLS  ;

: EDIT...CLS    EDIT...  CLS-EDIT  ;

: EMITS   0 ?DO DUP EMIT LOOP  DROP  ;


: .STATUS     ( -- )
              REVERSE
              STATUS...CLS
              EDITFILE .FILENAME
              SPACE  FILELEN @ U. ." lines  "
              LEFTBORDER @  CURSORCOLUMN @ + 1+ .
              TOPBORDER @  CURSORLINE @ + 1+ .
              3 SPACES  .S  NORMAL   ;


: SCREEN     ( ADDR -- )
	    EDIT...CLS
            #LINES RESERVED-LINES DO
               DUP END-OF-THREAD
               IF  LEAVE  THEN
               0 I AT
               DUP >DATA
                       SKIM
                       LEFTBORDER @ TUCK -
                       -ROT + SWAP
                       CHARS/LINE MIN  0 MAX  TYPE
               +LINE
            LOOP
            DROP
            WHERE  ;






\ ------------------------------------------------------------------
\                        EDIT KEY MAPPING
\ ------------------------------------------------------------------

 1 CONSTANT FORW
-1 CONSTANT BACKW

: WHERE   ( -- )
      CURSORCOLUMN @
      CURSORLINE @  RESERVED-LINES +
      AT PUT-CURSOR  ;




: -LEFT-  ( TADDR CADDR -- TADDR CADDR )
        CURSORCOLUMN @ 1-
        DUP  0<
        IF   ( CURSOR COLUMN 0 )
           DROP
           LEFTBORDER @ 1-
           0 MAX
           LEFTBORDER !
           OVER SCREEN
        ELSE
           CURSORCOLUMN !
           WHERE
        THEN   ;


: -RIGHT- ( TADDR CADDR -- TADDR CADDR )
        CURSORCOLUMN @ 1+
        DUP  CHARS/LINE U<
        IF   ( NO NEED TO SCROLL RIGHT )
           CURSORCOLUMN !
           WHERE
        ELSE
           DROP
           LEFTBORDER @ 1+
           LINELEN CHARS/LINE -  MIN
           LEFTBORDER !
           OVER SCREEN
        THEN   ;




: -UP-  ( TADDR CADDR -- TADDR CADDR )
        CURSORLINE @
        IF
          -LINE
          -1 CURSORLINE +!
          WHERE
        ELSE
          TOPBORDER @
          IF
             -LINE
             -1 TOPBORDER +!
             SWAP -LINE DUP SCREEN  SWAP
          THEN
        THEN  ;


: -DOWN-  ( TADDR CADDR -- TADDR CADDR )
        TOPBORDER @  CURSORLINE @ +
        FILELEN @ U<
        IF
           +LINE
           CURSORLINE @  #LINES RESERVED-LINES 1+  - U<
           IF
              1 CURSORLINE +!
              WHERE
           ELSE
              1 TOPBORDER +!
              SWAP +LINE  DUP SCREEN  SWAP
           THEN
        THEN  ;



: NOPE   ( TADDR CADDR -- TADDR CADDR )   ;

: -BOF-   ( TADDR CADDR -- TADDR CADDR )
        2DROP MAIN-TEXT +LINE DUP
        0 CURSORLINE !  0 TOPBORDER !
        OVER SCREEN ;

: -EOF-   ( TADDR CADDR -- TADDR CADDR )
        2DROP
        MAIN-TEXT DUP -LINE SWAP

        FILELEN @ 1- TOPBORDER !
        1 CURSORLINE !
        OVER SCREEN  ;


: (PGDN)  ( TADDR CADDR -- TADDR CADDR )
        #LINES RESERVED-LINES
        DO
          1 TOPBORDER +!
          +LINE SWAP
          +LINE SWAP
        LOOP
        OVER SCREEN   ;

: (PGUP)  ( TADDR CADDR -- TADDR CADDR )
        #LINES RESERVED-LINES
        DO
          -1 TOPBORDER +!
          -LINE SWAP
          -LINE SWAP
        LOOP
        OVER SCREEN   ;


: -PGDN-   ( TADDR CADDR -- TADDR CADDR )
    FILELEN @
    TOPBORDER @ -
    CURSORLINE @ -
    #LINES RESERVED-LINES -  >
    IF   (PGDN)  ELSE  -EOF-  THEN  ;


: -PGUP-   ( TADDR CADDR -- TADDR CADDR )
    TOPBORDER @
    CURSORLINE @ +
    #LINES   RESERVED-LINES -  <
    IF    -BOF-  ELSE   (PGUP)  THEN  ;




: -DLIN-   ( TADDR CADDR -- TADDR CADDR )
       DUP   END-OF-THREAD
       NOT IF
          2DUP =  ( CURSORLINE IS TOP OF SCREEN )
          IF
             +LINE TUCK
          ELSE
             DUP +LINE
          THEN
          OVER UNLINK-LINE
          -1 FILELEN +!
          SWAP DELETED-LINES APPEND-LINE
          OVER SCREEN
       THEN    ;


: -UNDEL-   ( TADDR CADDR -- TADDR CADDR )
       DELETED-LINES -LINE
       DUP END-OF-THREAD
       IF
          DROP
       ELSE
          DUP UNLINK-LINE
          OVER -LINE INSERT-LINE
          1 FILELEN +!
          2DUP = IF
             DROP -LINE DUP
          ELSE
             -LINE
          THEN
          OVER SCREEN
       THEN  ;


2VARIABLE SWAPDELFILE      DELETED-LINES DUP  SWAPDELFILE 2!

: -.DEL-   ( TADDR CADDR -- TADDR CADDR )
       SWAPDELFILE 2@  +LINE >R +LINE >R
       -LINE SWAP -LINE SWAP  SWAPDELFILE 2!
       R> R>  OVER SCREEN  ;


DECIMAL
: -SHELL-   ( TADDR CADDR -- TADDR CADDR )
            STATUS...CLS
            ." enter DOS command"
            IN$  SWAP 1- TUCK C!
            EDIT...CLS
            64  SHELL  DROP
            STATUS...CLS
            ." press key ..."
            BEGIN ?TERMINAL UNTIL
            OVER SCREEN   ;


TABLE NORMAL-KEY
\ 00..1F
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' -UNDEL- , ' NOPE , ' NOPE ,
 ' NOPE ,  ' -DLIN- , ' NOPE , ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,

\ 20..3F
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' -.DEL- ,

\ 40..5F
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,

\ 60..7F
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,




TABLE EXTENDED-KEY
      \ 00..1F
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,

      \ 20..3F
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' -SHELL- ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,

      \ 40..5F
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' -UP- ,       ' -PGUP- ,       ' NOPE ,        ' -LEFT- ,
       ' NOPE ,      ' -RIGHT- ,       ' NOPE ,        ' NOPE ,
       ' -DOWN- ,     ' -PGDN- ,       ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,

      \ 60..7F
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' -EOF- ,       ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,

      \ 80..9F
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' -BOF- ,       ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,


: ENGAGE    ( TOPADDR CURADDR ASC -- ADDR )
                 ?DUP IF NORMAL-KEY
                 ELSE  KEY   [HEX]  09F  MIN   [DECIMAL]
                 EXTENDED-KEY  THEN
                 EXECUTE  ;

: EDIT      ( TOPADDR CURADDR -- )
                OVER SCREEN
                BEGIN
                   .STATUS
                   KEY  127 AND
                   DUP ESC =
                NOT WHILE
                   ENGAGE
                REPEAT
                DROP  2DROP  ;

\ ------------------------------------------------------------

: GENERAL-INIT   ( CGA )  25 1-  0 [HEX] 0484  C!L   SETUP-VID   ;

: MAIN        GENERAL-INIT   CLS
              OPEN-FILES
              TEXTBUFFER READ-TEXT
              FILELEN !
              MAIN-TEXT +LINE DUP  EDIT
              STATUS...CLS  ." W to write"
              CHANGED IF
                  EDITFILE MAKE-FILE   CAN'T-CREATE?
                  MAIN-TEXT +LINE  WRITE-TEXT  THEN
              CLOSE-FILES
              UNSETUP-VID   ;


INCLUDE FORTHLIB  END


