128 MSDOS

\ INCLUDE DEFAULT
INCLUDE IBMMINI
INCLUDE DOSINT
INCLUDE KEYCODES


DECIMAL
128 CONSTANT SPAN

HANDLE EDITFILE


0 EQU TEXTBUFFER
0 EQU TEMPBUFFER

200  CONSTANT LINELEN

1 CONSTANT  RESERVED-LINES



\
\                       COMPILE TIME ACTION
\                 ===============================



H: +!  ( N ADDR -- )   DUP @  ROT +  SWAP !  ;

\ CURRENT EDIT FILE PARAMETERS

4 CONSTANT #FILES
VARIABLE CURRENT-FILE
H: EDITPARAMETER
                  CREATE  CELL CURRENT-FILE  DUP @ , +!
                  DOES>  @  CURRENT-FILE @ +  ;


EDITPARAMETER LEFT
EDITPARAMETER TOP
EDITPARAMETER XCURSOR
EDITPARAMETER YCURSOR
EDITPARAMETER LEN
EDITPARAMETER THREAD
EDITPARAMETER TOPLINE
EDITPARAMETER CURSORLINE


CURRENT-FILE @
DUP 2/ CONSTANT #EDITPARAMETERS
CONSTANT SIZE-OF-EPT


CREATE EPT   ( EDITPARAMETERTABLE )
  SIZE-OF-EPT  #FILES *  ALLOT
HERE CONSTANT END-OF-EPT

H: 0FILE                       EPT           CURRENT-FILE !  ;
H: +FILE      #EDITPARAMETERS CELL *         CURRENT-FILE +!  ;
H: -FILE      #EDITPARAMETERS CELL * NEGATE  CURRENT-FILE +!  ;


H: NEW-THREAD   CREATE   HERE DUP , ,   -1 ,   ;

NEW-THREAD FILE0
NEW-THREAD FILE1
NEW-THREAD FILE2
NEW-THREAD FILE3



: OWNER   ( ADDR -- )
           DUP THREAD !
           0 LEFT !
           0 TOP !
           0 YCURSOR !
           0 XCURSOR !
           0 LEN !
           DUP TOPLINE !
           CURSORLINE !  ;


: INIT-EDITFILES
     0FILE      FILE3 FILE2 FILE1 FILE0
     #FILES 0 DO   OWNER  +FILE  LOOP
     0FILE  ;


( didn't I have something herefor ? )

: (+FILE)    ( -- addr )  \ returns base address of next file parameter set
              CURRENT-FILE @
              SIZE-OF-EPT +
              DUP END-OF-EPT <
              NOT IF  DROP  EPT THEN  ;

: (-FILE)     ( addr -- )
              CURRENT-FILE @
              DUP EPT > NOT
              IF DROP END-OF-EPT  THEN
              SIZE-OF-EPT -  ;


 : +FILE      (+FILE)   CURRENT-FILE !  ;
 : -FILE      (-FILE)   CURRENT-FILE !  ;
 : 0FILE        EPT     CURRENT-FILE !  ;


: STATUS...     ( -- )            0 0 AT  ;
: STATUS...CLS  ( -- )            0 0 AT
                   RESERVED-LINES 0 DO  80 SPACES  LOOP
                                  0 0 AT  ;

: EDIT...    ( -- )               0 RESERVED-LINES AT  ;
: >DATA  ( ADDR -- ADDR' )        CELL 2* +  ;
: END-OF-THREAD ( ADDR -- FL )	  CELL 2* + @	-1 =  ;
: +LINE  ( ADDR -- ADDR' )        CELL +  @  ;
: -LINE  ( ADDR -- ADDR' )        @    ;




\       Ŀ
\                  -1  
\       
\         Ŀ
\             
\          Ŀ
\                               -1  
\          
\                 Ŀ
\                          
\                       Ŀ
\                                 
\                       
\                          
\                       Ŀ
\                                 
\                       
\                          
\                       Ŀ
\                                 
\                       
\                           
\                      
\          Ŀ
\                               -1  
\          
\                 Ŀ
\                          
\                       Ŀ
\                                 
\                       
\                          
\                       Ŀ
\                                 
\                       
\                          
\                       Ŀ
\                                 
\                       
\                           
\                      
\          Ŀ
\                               -1  
\          
\                  Ŀ
\                 
\                           Ŀ
\                                     
\                           
\                              
\                           Ŀ
\                                     
\                           
\                              
\                           Ŀ
\                                     
\                           
\                               
\                          






VARIABLE NEW-ERROR

H: MAKE-ERROR    1 NEW-ERROR
                 DUP @ , +!  ;

H: ERROR?  CREATE  MAKE-ERROR
           DOES> OVER IF
                   STATUS...CLS
		   @ REPORT-ERROR
		   KEY 2DROP  BYE
                 THEN
                 2DROP ;

ERROR?  CAN'T-OPEN?
ERROR?  CAN'T-CLOSE?
ERROR?  CAN'T-REWIND?
ERROR?  CAN'T-WRITE?
ERROR?  CAN'T-CREATE?



: ALLOCATE-TEXTBUFFER
             HERE EQU TEMPBUFFER
             LINELEN ALLOT
             HERE 256 + EQU TEXTBUFFER
             ;


: CUDDLE  ( ADDR CHAR -- ADDR' FL )
              OVER C! 1+ FALSE ( WANT MORE INPUT )  ;


: -TAB-   ( ADDR CHAR -- ADDR' FL )
          DROP   8 2DUP BLANK  + FALSE  ;

1000 CONSTANT END-OF-LINE ( NEW FILE ERROR )
: -LINEFEED-   ( ADDR CHAR -- ADDR err -1 )
        DROP
        DUP 1- C@
        13 = IF 1- THEN
        END-OF-LINE TRUE ;



( BUFADR CHAR -- BUFADR' TRUE | BUFADR 0 )
TABLE CONTROL-CHARACTER
 ' CUDDLE  ,
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,         ' CUDDLE  , ( 4 )
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,         ' CUDDLE  , ( 8 )
 '  -TAB-  ,       ' -LINEFEED- ,     ' CUDDLE  ,         ' CUDDLE  , ( 12 )
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,         ' CUDDLE  ,
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,         ' CUDDLE  ,
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,         ' CUDDLE  ,
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,         ' CUDDLE  ,
 ' CUDDLE  ,         ' CUDDLE  ,      ' CUDDLE  ,


: (INSERT-LINE)
        2DUP   +LINE !
        2DUP   <-
        CELL +   2DUP @
        SWAP CELL +  ! ! ;

: INSERT-LINE  ( ADDR1 ADDR2 -- )         \ add ADDR1 below ADDR2
            (INSERT-LINE)
             1 LEN +!
              ;

: APPEND-LINE  ( ADDR1 ADDR2 )               \ ADDR2 is THREAD
        -LINE INSERT-LINE  ;



: (UNLINK-LINE)   ( ADDR -- )
       DUP +LINE   SWAP -LINE  2DUP CELL +  !  <-  ;

: UNLINK-LINE   ( ADDR -- )
            (UNLINK-LINE)
            -1 LEN +!  ;


: READ-LINE    ( ADDR -- LEN 0 | LEN ERR )
             DUP  FALSE                          ( NOT END OF LINE YET )
             BEGIN
               NOT  IF                           ( END-OF-LINE )
               GET  THEN
             ?DUP 0= WHILE                       ( NO ERROR / END-OF-LINE )
               DUP BL U<
               IF                                ( BUFADR CHAR )
                 DUP CONTROL-CHARACTER EXECUTE   ( FL true   ABORTS )
               ELSE
                 CUDDLE
               THEN
             REPEAT
             END-OF-LINE <>                      ( MUST BE ERROR THEN )
             >R
             SWAP -
             R>    ;



: READ-TEXT  ( ADDR -- #LINES )
             0                              \ LINES COUNTER
              BEGIN
                SWAP                        \ L A
                DUP >DATA                   \ L A A'
                DUP CELL +
                READ-LINE                   \ L A A' # ERR
              0= WHILE                      \ L A A' #
                TUCK <-                     \ L A #
                OVER
                THREAD @  APPEND-LINE
                +
                >DATA CELL +
                SWAP 1+
              REPEAT
              2DROP
              DROP  ;



\ files don't get shorter ...
: OPEN-FILES
             1STPAR READ$
             EDITFILE FILENM
             DROP
             EDITFILE OPEN-FILE
             CAN'T-OPEN?                   \ CREATE NEW FILE INSTEAD
             EDITFILE FROMFILE
             EDITFILE TOFILE
             ALLOCATE-TEXTBUFFER
             INIT-EDITFILES
              ;


: CLOSE-FILES  ( -- )        ENDTO   CAN'T-CLOSE?    ;
: CHANGED      ( -- F )      KEY CAPITALIZE ASCII W =  ;

( ADDR CNT -- 0 | ADDR )
\ ADDR IS THE CHAR WHERE WRITE ERROR OCCURED )
: WRITE-LINE  ( ADDR CNT -- FL )
             0 ?DO
                COUNT PUT
                IF 0 LEAVE THEN
               LOOP

             ?DUP IF

                13 ( CR ) PUT
                10 ( LF ) PUT
                OR
                0= IF
                   DROP FALSE
                THEN
             THEN  ;


: WRITE-TEXT   ( ADDR -- )
             BEGIN
               DUP END-OF-THREAD
             0= WHILE
               DUP >DATA SKIM WRITE-LINE  CAN'T-WRITE?
               +LINE
             REPEAT  DROP
               ;

\ ------------------------------------------------------------

: CLS-EDIT  ( -- )     CHARS/LINE RESERVED-LINES *  -CLS  ;

: EDIT...CLS    EDIT...  CLS-EDIT  ;

: EMITS   0 ?DO DUP EMIT LOOP  DROP  ;


: .STATUS     ( -- )
              REVERSE
              STATUS...CLS
\              EDITFILE .FILENAME
              SPACE  LEN @ U. ." lines  "
              LEFT @  XCURSOR @ + 1+ .
              TOP @  YCURSOR @ + 1+ .
              ASCII * EMIT
              CURRENT-FILE @ .
              THREAD @ .
              CURSORLINE @ .
                .S  NORMAL   ;


: SCREEN     ( ADDR -- )
	    EDIT...CLS
            #LINES RESERVED-LINES DO
               DUP END-OF-THREAD
               IF  LEAVE  THEN
               0 I AT
               DUP >DATA
                       SKIM
                       LEFT @ TUCK -
                       -ROT + SWAP
                       CHARS/LINE MIN  0 MAX  TYPE
               +LINE
            LOOP
            DROP
            WHERE  ;






\ ------------------------------------------------------------------
\                        EDIT KEY MAPPING
\ ------------------------------------------------------------------

 1 CONSTANT FORW
-1 CONSTANT BACKW

: WHERE   ( -- )
      XCURSOR @
      YCURSOR @  RESERVED-LINES +
      AT PUT-CURSOR  ;




: -LEFT-  ( -- )
        TOPLINE @   CURSORLINE @
        XCURSOR @ 1-
        DUP  0<
        IF   ( CURSOR COLUMN 0 )
           DROP
           LEFT @ 1-
           0 MAX
           LEFT !
           OVER SCREEN
        ELSE
           XCURSOR !
           WHERE
        THEN
        CURSORLINE ! TOPLINE !  ;


: -RIGHT- ( -- )
        TOPLINE @   CURSORLINE @
        XCURSOR @ 1+
        DUP  CHARS/LINE U<
        IF   ( NO NEED TO SCROLL RIGHT )
           XCURSOR !
           WHERE
        ELSE
           DROP
           LEFT @ 1+
           LINELEN CHARS/LINE -  MIN
           LEFT !
           OVER SCREEN
        THEN
        CURSORLINE ! TOPLINE !  ;




: -UP-  ( -- )
        TOPLINE @   CURSORLINE @
        YCURSOR @
        IF
          -LINE
          -1 YCURSOR +!
          WHERE
        ELSE
          TOP @
          IF
             -LINE
             -1 TOP +!
             SWAP -LINE DUP SCREEN  SWAP
          THEN
        THEN
        CURSORLINE ! TOPLINE !  ;


: -DOWN-  ( -- )
        TOPLINE @  CURSORLINE @
        TOP @  YCURSOR @ +
        LEN @ U<
        IF
           +LINE
           YCURSOR @  #LINES RESERVED-LINES 1+  - U<
           IF
              1 YCURSOR +!
              WHERE
           ELSE
              1 TOP +!
              SWAP +LINE  DUP SCREEN  SWAP
           THEN
        THEN
        CURSORLINE !  TOPLINE !
         ;



: NOPE   ( -- )   ;

: -BOF-   ( -- )
        THREAD @
        +LINE DUP
        CURSORLINE !
        DUP TOPLINE !
        0 YCURSOR !  0 TOP !
        SCREEN ;

: -EOF-   ( -- )
            THREAD @
            DUP CURSORLINE !
            -LINE DUP TOPLINE !
            LEN @   DUP 1-   0 MAX
            DUP TOP !   - YCURSOR !
            SCREEN   ;



\   : -EOF-   ( -- )
\           THREAD @
\           DUP -LINE
\           LEN @ TOP !
\           1 YCURSOR !
\           DUP SCREEN
\           TOPLINE !
\           CURSORLINE !  ;


: (PGDN)  ( -- )
        TOPLINE @  CURSORLINE @
        #LINES RESERVED-LINES
        DO
          1 TOP +!
          +LINE SWAP
          +LINE SWAP
        LOOP
        CURSORLINE !
        DUP TOPLINE !
        SCREEN   ;


: (PGUP)  ( -- )
        TOPLINE @  CURSORLINE @
        #LINES RESERVED-LINES
        DO
          -1 TOP +!
          -LINE SWAP
          -LINE SWAP
        LOOP
        CURSORLINE !
        DUP TOPLINE !
        SCREEN   ;


: -PGDN-   ( -- )
    LEN @
    TOP @ -
    YCURSOR @ -
    #LINES RESERVED-LINES -  >
    IF   (PGDN)  ELSE  -EOF-  THEN  ;


: -PGUP-   ( -- )
    TOP @
    YCURSOR @ +
    #LINES   RESERVED-LINES -  <
    IF    -BOF-  ELSE   (PGUP)  THEN  ;




: -DLIN-   ( -- )
       CURSORLINE @  END-OF-THREAD
       NOT IF
          CURSORLINE @
          DUP UNLINK-LINE
          DUP +LINE
          CURSORLINE @  TOPLINE @ =
          IF  DUP TOPLINE !   THEN
          CURSORLINE !

     +FILE  THREAD @          \ TEMPORARY DELETED-LINES FILE
          APPEND-LINE
     -FILE                    \ BACK TO PRIMARY EDIT FILE
          TOPLINE @ SCREEN
       THEN
         ;




: GETLAST   ( -- ADDR )
         THREAD @ -LINE
         DUP UNLINK-LINE
         LEN @
         YCURSOR @   TOP @ + <
         IF
            -1
            YCURSOR @
            IF   YCURSOR   ELSE   TOP   THEN
            +!
         THEN   ;



: -UNDEL-  ( -- )
      +FILE
      LEN @
      IF
         GETLAST
     -FILE
         CURSORLINE @
         INSERT-LINE
         TOPLINE @ SCREEN
      ELSE
         -FILE
      THEN  ;




\ -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
\  : -UNDEL-   ( -- )
\       +FILE
\        THREAD @  -LINE             \ TEMPORARY DELETED-LINES FILE
\         DUP END-OF-THREAD
\         IF
\            DROP
\       -FILE
\         ELSE
\            DUP UNLINK-LINE
\
\            LEN @
\            YCURSOR @  TOP @  +
\            < IF
\              THREAD @ -LINE
\              CURSORLINE !
\              YCURSOR @ 1-
\              DUP 0<
\              IF
\                 DROP -1 TOP +!
\              ELSE
\                 YCURSOR !
\              THEN
\            THEN
\
\       -FILE                        \ BACK TO MAIN EDIT FILE
\
\            CURSORLINE @  -LINE
\            INSERT-LINE
\
\            CURSORLINE @  -LINE
\            CURSORLINE @  TOPLINE @ =
\            IF
\               DUP TOPLINE !
\            THEN
\            CURSORLINE !
\
\            TOPLINE @  SCREEN
\         THEN  ;
\



: -NFILE-  ( -- )
         +FILE
         TOPLINE @
         DUP END-OF-THREAD
         IF  +LINE
            DUP TOPLINE !
            DUP CURSORLINE !
         THEN
         SCREEN  ;



DECIMAL
: -SHELL-   ( -- )
            STATUS...CLS
            ." enter DOS command"
            IN$  SWAP 1- TUCK C!
            EDIT...CLS
            64  SHELL  DROP
            STATUS...CLS
            ." press key ..."
            BEGIN ?TERMINAL UNTIL
            TOPLINE @ SCREEN   ;


TABLE NORMAL-KEY
\ 00..1F
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' -UNDEL- , ' NOPE , ' NOPE ,
 ' NOPE ,  ' -DLIN- , ' NOPE , ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,

\ 20..3F
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' -NFILE- ,

\ 40..5F
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,

\ 60..7F
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,
 ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,  ' NOPE ,




TABLE EXTENDED-KEY
      \ 00..1F
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,

      \ 20..3F
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' -SHELL- ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,

      \ 40..5F
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' -UP- ,       ' -PGUP- ,       ' NOPE ,        ' -LEFT- ,
       ' NOPE ,      ' -RIGHT- ,       ' NOPE ,        ' NOPE ,
       ' -DOWN- ,     ' -PGDN- ,       ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,

      \ 60..7F
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' -EOF- ,       ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,

      \ 80..9F
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' -BOF- ,       ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,
       ' NOPE ,        ' NOPE ,        ' NOPE ,        ' NOPE ,


: ENGAGE    ( ASC -- )
                 ?DUP IF NORMAL-KEY
                 ELSE  KEY   [HEX]  09F  MIN   [DECIMAL]
                 EXTENDED-KEY  THEN
                 EXECUTE  ;

: EDIT      ( -- )
                TOPLINE @ SCREEN
                BEGIN
                   .STATUS
                   KEY  127 AND
                   DUP ESC =
                NOT WHILE
                   ENGAGE
                REPEAT
                DROP   ;

\ ------------------------------------------------------------

: GENERAL-INIT   ( CGA )  25 1-  0 [HEX] 0484  C!L   SETUP-VID   ;

: MAIN        GENERAL-INIT   CLS
              OPEN-FILES
              TEXTBUFFER READ-TEXT
              LEN !
              THREAD @ +LINE DUP
              TOPLINE ! CURSORLINE !
              EDIT
              STATUS...CLS  ." W to write"
              CHANGED IF
                  EDITFILE MAKE-FILE   CAN'T-CREATE?
                  THREAD @  +LINE  WRITE-TEXT  THEN
              CLOSE-FILES
              UNSETUP-VID   ;


INCLUDE FORTHLIB  END


