page 44,109

	title	'victor calculator'

;
; 10 Mar 82 JFP:
;	Initial a86 coding; hand translation of
;	RMM's running C program.

; 30 Mar 82 JFP & HSP:
;	Separated external and internal functionality
;	as follows:
;		1)Internal functionality is vested in
;		  the includable module vcalc.a86.
;		2)System-interface responsibility is
;		  vested in this module, which expects
;		  to include vcalc.a86.
;		3)The general idea is to allow Sirius
;		  the maximum latitude in interface
;		  design, while retaining the ability to
;		  operate as a .cmd file for debugging
;		  purposes.  This modus will also simplify
;		  the revision process.
; 04 Apr 82  hsp:
;	This module is now converted to interface with the 
;	User Defined Console.
;
; 07 Apr JFP:
;	Make prolog and epilog self-contained; invent
;	the 'constr' function that calls conout directly
;	instead of winding back through putchar.  One
;	advantage of doing it this way is there's no
;	need to fool with enable and disable of exit-string
;	accrual.
;
; 15 Apr 82  hsp:
;       fixed return of null data on 2nd shifted calc key
;
; 04 Aug 82  bem:
;	modified to run under MSDOS with the worm.
;
; 21 Aug 82 eaj:
;	added UDC function 6 and check for previous installation

	page

; Data and Stack segs both start here 

PROG	SEGMENT
ASSUME	CS:PROG,DS:PROG,ES:PROG

UDC_CALC_ID	equ	0ca1ch	;Our identifier. Returned by UDC function 6

msend	 equ    20h		;msdos function -- end of job
msdos	 equ	21h		;msdos function request interrupt
xbiosint equ	223		;super bios function request interrupt
msres	 equ	27h		;msdos interrupt to remain resident

	org	0
pdummy	dw	1

	org	5ch		;bdos fcb
fcb	label	byte		;start of fcb
	org	80h		;bdos buffer
buf	label	byte		;start of buffer
	org	100h		;ordinary data

	jmp	start		;skip around data

debug	db	0		;on for .cmd, off for UDC


VRESULTindex dw  0
VRESULToffset dw 0
VRESULTbase   dw 0

	include	b:vdata.asm
	include b:vdata1.asm

	page

; Code segment and execution start here.  Just call vcalc
;   INIT {hsp  04-Apr-82}
; and go back to bdos when he returns.

start:	mov	AX,0
	MOV	ES,AX		;SET ES: TO OFFSET ZERO

	jmp	UDC_init	; {hsp  04-Apr-82}


; cistring()     deleted {hsp  16-Apr-82}


; conin() - wait for a character and return same.
;	Uses UDC interface

conin:	push	bp		;save caller frp

; switch to environment stack

	pushf			;push flags
	pop	ax		;get them in ax
	cli			;now hold ints
	mov	savss,ss	;preserve our stkseg
	mov	savsp,sp	;and stackoff
	mov	ss,parss	;set env ss
	mov	sp,parsp	;and sp
	push	ax		;now psh flgs
	popf			;and restore state

; Get ch using UDC interface.

	push	es		;save es over bdos
	call	UDC_conin
	pop	es		;yes, restore es.
	mov	ah,0		;zero-ext char

; switch back to our own stack

	pushf			;push flags
	pop	bx		;get them in bx
	cli			;now hold ints
	mov	ss,savss	;restore ss
	mov	sp,savsp	;and sp
	push	bx		;now psh flgs
	popf			;and restore state

	pop	bp		;restore caller frp
	ret			;and ret (no args)

; conout(ch) - put one character to console interface.

con_ch	equ	4		;char to send

conout:	push	bp		;save caller frp
	mov	bp,sp		;set cur frp
	mov	cl,[bp]+put_ch	;get outgoing ch

; switch to environment stack

	pushf			;push flags
	pop	ax		;get them in ax
	cli			;now hold ints
	mov	savss,ss	;preserve our stkseg
	mov	savsp,sp	;and stackoff
	mov	ss,parss	;set env ss
	mov	sp,parsp	;and sp
	push	ax		;now psh flgs
	popf			;and restore state

	push	es		;preserve es
	call	UDC_conout
	pop	es		;restore es

; switch back to our own stack

	pushf			;push flags
	pop	bx		;get them in bx
	cli			;now hold ints
	mov	ss,savss	;restore ss
	mov	sp,savsp	;and sp
	push	bx		;now psh flgs
	popf			;and restore state

	pop	bp		;retrieve caller frp
	ret	2		;ret past 2 argbytes


; constr(ostr) - put null-term string direct to conout
;	Used only by calcinit and calcexit.

con_os	equ	4		;o(string)

constr:
	push	bp		;save caller frp
	mov	bp,sp		;set cur frp
constr10:
	mov	si,[bp]+con_os	;get current offset
	lodsb			;get current byte
	mov	[bp]+con_os,si	;repl new offset
	cmp	al,0		;cur byte v. 0
	je	constr20	;done if 0
	mov	ah,0		;not done, zero-ext
	push	ax		;and push this byte
	call	conout		;emit this byte
	jmp	short constr10	;and repeat
constr20:
	mov	sp,bp		;delete automatics
	pop	bp		;get caller frameptr
	ret	2		;and ret past 2 bytes

;				{hsp  04-Apr-82}

USERinit:			;NEAR routine expected by UDC...
				;... to provide attach-time initialization
	mov	VRESULTindex,0	;
	ret

USERget:			;NEAR routine expected by UDC...
				;... to provide USER get subfunction
	cmp	VRESULTindex,0
	jne	UGresult	;continue to return result
UG10:
	call	UDC_conin	;call UDC provided console input

	cmp	al,0FDh		;if not calculator code,
	jne	UGexit		; then pass data on

	mov	cl,al		;set up for vcalc
	call	vcalc
				;save address of vcalc result descriptor 
	mov	VRESULToffset,bx
	mov	VRESULTbase,es
	mov	VRESULTindex,0	;set string index to zero

	cmp	es:word ptr [bx],0 ;test the string size for null data
	je	UG10		;it is, restart process

UGresult:			;return current data byte of result
				;address of result descriptor
	mov	es,VRESULTbase	
	mov	bx,VRESULToffset

	mov	dx,es:[bx]	;obtain string size
	mov	ax,es:[bx]+4	;obtain segment of string
	mov	bx,es:[bx]+2	;obtain offset of string

	mov	es,ax
	mov	si,VRESULTindex	;set current index into string
	mov	al,es:[bx+si]	;copy data byte from string
	inc	si		;bump index
	mov	VRESULTindex,si	;store current index

	cmp	si,dx		;check index against size
	jb	UGexit		;not the last byte of string

	mov	VRESULTindex,0	;clear result index & flag	
UGexit:
	ret			;return AL= console input data



USERput:			;NEAR routine expected by UDC...
				;... to provide USER put subfunction
	call	UDC_conout
	ret

USERgetstat:			;NEAR routine expected by UDC...
				;... to provide USER get stat subfunction
	cmp	VRESULTindex,0
	je	USERgs10

	mov	al,0FFh
	ret
USERgs10:
	call	UDC_coninstat
	ret

USERputstat:			;NEAR routine expected by UDC...
				;... to provide USER put stat subfunction
	call	UDC_conoutstat
	ret

	include	b:UDC.asm
;nolist

	include b:vcalc.asm

endpgm:
PROG	ENDS
	END
