32 MSDOS
INCLUDE IBMMINI
INCLUDE DOSINT
INCLUDE KEYCODES

HANDLE INPUT


4 CONSTANT LINKSIZE

0 0 2CONSTANT STATUSPOS
CHARS/LINE CONSTANT STATUSLEN

\ ---------------------------------------------------------------
\                     file parameters
\ ---------------------------------------------------------------

VARIABLE CURRENTFILE

1 1 IN/OUT
H: FILEPARAMETER
        CREATE  CURRENTFILE @ DUP ,
                CELL + CURRENTFILE !
        DOES>   @ CURRENTFILE @ +  ;


FILEPARAMETER LISTNAME              \ filename
FILEPARAMETER LASTLINE              \ seg of last line in file
FILEPARAMETER LASTLINE_A            \ off to last line in file
FILEPARAMETER 1STLINE               \ seg of 1st line in file
FILEPARAMETER 1STLINE_A             \ off to 1st line in file
FILEPARAMETER START_OF_FILE         \ seg to read file into
FILEPARAMETER START_OF_FILE_A       \ off to read file into

FILEPARAMETER LINES_IN_FILE
FILEPARAMETER TOPLINE

FILEPARAMETER WINDOWHEIGHT
FILEPARAMETER WINDOWWIDTH
FILEPARAMETER WINDOWTOP
FILEPARAMETER WINDOWLEFT
FILEPARAMETER RIGHTPAN



1 0 IN/OUT
H: FILEDATA   CREATE DOES> CURRENTFILE !  ;
FILEDATA FILE1


HEX
0 0 IN/OUT
: NEWFILE  ( -- )
        INPUT LISTNAME !
        ?CS: LASTLINE
        2DUP 1STLINE 2!  LASTLINE 2!
        ?CS: 1000 +  0  START_OF_FILE 2!

        0 LINES_IN_FILE !
        0 TOPLINE !

        1 WINDOWTOP !
        #LINES WINDOWTOP @ - WINDOWHEIGHT !
        0 WINDOWLEFT !
        CHARS/LINE WINDOWLEFT @ -  WINDOWWIDTH !
        0 RIGHTPAN !  ;



\ ---------------------------------------------------------------
\                            links
\ ---------------------------------------------------------------


1 2 IN/OUT : LINE1  ( ADDR -- ADDR SEG )      LINKSIZE + 2@     0 TOPLINE  !  ;
2 2 IN/OUT : +LINE  ( SEG OFF -- SEG OFF )    LINKSIZE + 2@L   ;
2 2 IN/OUT : -LINE  ( SEG OFF -- SEG OFF )               2@L   ;

HEX
2 2 IN/OUT : NORMALIZE  ( seg off -- seg off )
        DUP 0< IF  8000 - SWAP 0800 + SWAP  THEN   ;

2 0 IN/OUT : LINK  ( addr offs -- )
        0 DUP  2OVER LINKSIZE +  2!L
        LASTLINE 2@  2OVER   2OVER
        LINKSIZE + 2OVER 2SWAP  2!L 2!L
        LASTLINE 2!
        1 LINES_IN_FILE +!  ;




\ ---------------------------------------------------------------
\                          file read
\ ---------------------------------------------------------------


: GETLINE    ( SEG OFFS -- SEG OFFS F )
           BEGIN
              GET    ( asc 0 | err )
              IF
                 FALSE FALSE
              ELSE
                 DUP CONTROL J =
                 DUP 0= >R
                 IF
                    DROP TRUE
                 THEN
                 R>
              THEN
           WHILE
              1 SWAP
              2OVER C!L
              +
           REPEAT

           DUP IF
              DROP 2DUP 1- C@L
              ENTER = IF 1- THEN
              TRUE
           THEN
              ;


0 0 IN/OUT : GETFILE ( --  
 )
        START_OF_FILE 2@
        BEGIN
           NORMALIZE
           2DUP
           LINKSIZE 2* +
           2DUP
           2+            ( ROOM FOR LINE LEN )
           GETLINE
        WHILE
           2SWAP 2OVER 2OVER
           ROT SWAP - -ROT -
           4 << +  2- -ROT !L      ( store line len )
           2SWAP LINK
        REPEAT
        2DROP 2DROP 2DROP  ;



\ ---------------------------------------------------------------
\                         statusline
\ ---------------------------------------------------------------
0 0 IN/OUT : .STATUS ( -- )
           REVERSE
              STATUSPOS AT
              STATUSLEN SPACES
              STATUSPOS AT
              LISTNAME @ .FILENAME 3 SPACES
              ." Lines: "  LINES_IN_FILE @ .
              ." Top: "    TOPLINE @ .
              ." Pan: "    RIGHTPAN @ .
           NORMAL ;


\ ---------------------------------------------------------------
\                        file display
\ ---------------------------------------------------------------


2 1 IN/OUT : .LINE ( SEG OFFS -- N )
        2DUP 2+
        RIGHTPAN @ +
        2SWAP @L
        RIGHTPAN @ -
        0 MAX
        WINDOWWIDTH @ MIN
        DUP >R
        0 ?DO
          LCOUNT EMIT
         LOOP  2DROP
         R>  ;


0 2 IN/OUT
: EACH_LINE ( -- N1 N2 )
        WINDOWTOP @
        WINDOWHEIGHT @
        RANGE  ;

: PUTLINE  ( ADDR OFF N -- ADDR OFF N )
        WINDOWLEFT @ SWAP !XY
        2DUP +LINE 2SWAP
        LINKSIZE 2* + .LINE  ;

2 0 IN/OUT : .SCREEN  ( SEG OFF -- )
        EACH_LINE ?DO
           I PUTLINE
           WINDOWWIDTH @ SWAP - SPACES
           2DUP OR  0=
           IF LEAVE THEN
        LOOP
        2DROP  ;

\ ---------------------------------------------------------------
\                         interaction
\ ---------------------------------------------------------------


: UPS    ( SEG OFF N -- SEG OFF )
        WINDOWHEIGHT @
        TOPLINE @
        MIN MIN
        ?DUP IF
                DUP NEGATE TOPLINE +!
                0 ?DO  -LINE  LOOP
                2DUP .SCREEN
        THEN ;

: UP    ( SEG OFF -- SEG OFF )        1 UPS    ;
: PG-UP    ( SEG OFF -- SEG OFF )     WINDOWHEIGHT @ 1- UPS    ;


: DOWNS  ( SEG OFF N -- SEG OFF )
        WINDOWHEIGHT @
        LINES_IN_FILE @
        OVER
        TOPLINE @ +
        -  MIN  MIN
        ?DUP IF
                DUP TOPLINE +!
                0 ?DO  +LINE  LOOP
                2DUP .SCREEN
        THEN ;

: DOWN  ( SEG OFF -- SEG OFF )        1 DOWNS  ;

: PG-DOWN  ( SEG OFF -- SEG OFF )     WINDOWHEIGHT @ 1- DOWNS  ;


: RIGHT ( SEG OFF -- SEG OFF )  1 RIGHTPAN +!   2DUP  .SCREEN  ;
: LEFT  ( SEG OFF -- SEG OFF )  RIGHTPAN DUP @ 1- 0 MAX <- 2DUP .SCREEN  ;


VARIABLE STOP
: DONE  STOP ON  ;

CREATE SCROLLKEYS  0 ,
         C-UP ,        '  UP ,
         C-DOWN  ,     ' DOWN ,
         C-RIGHT ,     ' RIGHT ,
         C-LEFT ,      ' LEFT ,
         PAGE-UP   ,   ' PG-UP   ,
         PAGE-DOWN ,   ' PG-DOWN ,
         ESC ,         ' DONE ,

HERE SCROLLKEYS 2+ -  4 /   SCROLLKEYS !


0 0 IN/OUT : BROWSE   ( -- )
        STOP OFF
        LASTLINE LINE1
        2DUP .SCREEN

        BEGIN
           .STATUS
           ATKEY SCROLLKEYS LOOKUP
           ?DUP IF EXECUTE THEN
        STOP @ UNTIL
        2DROP   ;

DECIMAL
: MAIN          SETUP-VID
                1STPAR READ$ INPUT FILENM DROP   \ read name from cmdline
                INPUT  OPEN-FILE-R/O             \ attempt opening
                0= IF
                  HERE >R
                  ADAPTER 0  ?CS:
                  R@ CHARS/LINE #LINES * 2*
                  DUP ALLOT CMOVEL
                  FILE1 NEWFILE
                  INPUT FROMFILE
                     GETFILE
                     CLS BROWSE
                  ?CS: R>  ADAPTER 0 CHARS/LINE #LINES * 2* CMOVEL
                  ENDFROM
                THEN
                UNSETUP-VID  ;

INCLUDE FORTHLIB
END
