
128 MSDOS
INCLUDE IBMMINI
INCLUDE DOSINT
INCLUDE KEYCODES

HANDLE INPUT

4 CONSTANT LINKSIZE

0 0 2CONSTANT STATUSPOS
CHARS/LINE CONSTANT STATUSLEN


FALSE CONSTANT DON'T-REMOVE-MENU
TRUE  CONSTANT       REMOVE-MENU
      VARIABLE    AFTER-SELECTION


\ maybe executed by any item code to close remove window after selection
: QUITMENU    REMOVE-MENU AFTER-SELECTION ! ;


2 1 IN/OUT
H: TRANSLATE ( -- ADDR )     CREATE HERE  0 ,  DOES> LOOKUP  ;
H: END-TRANSLATE ( ADDR -- )  HERE OVER CELL + -  CELL 2* / SWAP ! ;

DECIMAL
1 0 IN/OUT
: SOUND ( N -- )
        DEBUG
        30000 OVER / 2* 0
        ?DO
                CLICK
                DUP 0 DO LOOP
        LOOP DROP ;

: BEEP1   800 SOUND ;
: BEEP2   750 SOUND ;
: BEEP3   700 SOUND ;
: BEEP4   650 SOUND ;
: BEEP5   600 SOUND ;
: BEEP6   550 SOUND ;
: NOOP   ;

\ ---------------------------------------------------------------
\                     file parameters
\ ---------------------------------------------------------------

VARIABLE CURRENTFILE

1 1 IN/OUT
H: FILEPARAMETER
        CREATE  CURRENTFILE @ DUP ,
                CELL + CURRENTFILE !
        DOES>   @ CURRENTFILE @ +  ;


FILEPARAMETER LISTNAME              \ filename
FILEPARAMETER LASTLINE              \ seg of last line in file
FILEPARAMETER LASTLINE_A            \ off to last line in file
FILEPARAMETER 1STLINE               \ seg of 1st line in file
FILEPARAMETER 1STLINE_A             \ off to 1st line in file
FILEPARAMETER START_OF_FILE         \ seg to read file into
FILEPARAMETER START_OF_FILE_A       \ off to read file into

FILEPARAMETER LINES_IN_FILE
FILEPARAMETER TOPLINE

FILEPARAMETER WINDOWHEIGHT
FILEPARAMETER WINDOWWIDTH
FILEPARAMETER WINDOWTOP
FILEPARAMETER WINDOWLEFT
FILEPARAMETER RIGHTPAN



1 0 IN/OUT
H: FILEDATA   CREATE DOES> CURRENTFILE !  ;
FILEDATA FILE1


HEX
0 0 IN/OUT
: NEWFILE  ( -- )
        INPUT LISTNAME !
        ?CS: LASTLINE
        2DUP 1STLINE 2!  LASTLINE 2!
        ?CS: 1000 +  0  START_OF_FILE 2!

        0 LINES_IN_FILE !
        0 TOPLINE !

        1 WINDOWTOP !
        #LINES WINDOWTOP @ - WINDOWHEIGHT !
        0 WINDOWLEFT !
        CHARS/LINE WINDOWLEFT @ -  WINDOWWIDTH !
        0 RIGHTPAN !  ;



\ ---------------------------------------------------------------
\                          windows
\ ---------------------------------------------------------------

: RESIZEWINDOW   ;
: MOVEWINDOW     ;
: ZOOMWINDOW     ;
: HIDEWINDOW     ;

\ ---------------------------------------------------------------
\                        menu stuff
\ ---------------------------------------------------------------

H: MENUDATA  DUP CONSTANT CELL +   ;

     0
        MENUDATA MENUHEIGHT
        MENUDATA MENUWIDTH
        MENUDATA MENUCHOICE
        MENUDATA MENUITEMS
     DROP

2 0 IN/OUT
: EMITS ( N ASC -- )  SWAP 0 ?DO  DUP EMIT LOOP  DROP  ;

1 0 IN/OUT
: ROOF  ( ADDR -- )
        ?XY
        ASCII  EMIT
        ROT MENUWIDTH + @   ASCII  EMITS
        ASCII  EMIT
        !XY   ;

1 0 IN/OUT
: FLOOR ( ADDR -- )
        >R  ?XY
        2DUP    R@ MENUHEIGHT + @ 1+ +  !XY
        ASCII  EMIT                           ( bottom left corner )
        R>  MENUWIDTH + @  ASCII  EMITS         ( bottom )
        ASCII  EMIT                           ( bottom right corner )
        !XY   ;


1 2 IN/OUT
: $ITEM ( ADDR -- ADDR' CNT )   CELL +  COUNT  ;


1 1 IN/OUT
: +ITEM ( ADDR -- ADDR )        $ITEM + ;


2 0 IN/OUT
: .ITEM    ( ADDR N -- )
        DUP ?XY
        2DUP >R >R
           ROT + 1+ !XY                ( put cursor to item location )

           OVER MENUITEMS +              ( locate first menu item )
           SWAP 0 ?DO
                +ITEM
           LOOP

           ASCII  EMIT
           $ITEM  TUCK TYPE
           SWAP MENUWIDTH + @
           SWAP - SPACES
           ASCII  EMIT
        R> R> !XY
        NORMAL  ;


2 0 IN/OUT
: .MENU  ( ADDR n -- )
        OVER ROOF
        OVER MENUHEIGHT + @ 0 ?DO
           2DUP I TUCK =
           IF REVERSE THEN
           .ITEM
        LOOP  DROP
        FLOOR  ;


H: MENUMESSAGE 1+ DUP CONSTANT ;
     0
        MENUMESSAGE SELECT
        MENUMESSAGE ESCAPE
     DROP


: ITEM-UP     ( ADDR N -- ADDR N F )   1- OVER MENUHEIGHT + @ MOD  FALSE   ;
: ITEM-DOWN   ( ADDR N -- ADDR N F )   1+ OVER MENUHEIGHT + @ MOD  FALSE   ;
: ITEM-BACK   ( ADDR N -- ADDR N F )   2DUP SWAP MENUCHOICE + !    ESCAPE  ;
: ITEM-SELECT ( ADDR N -- ADDR N F )   2DUP SWAP MENUCHOICE + !    SELECT  ;


TRANSLATE MENUKEYS
        C-UP ,     '  ITEM-UP  ,
        C-DOWN ,   ' ITEM-DOWN ,
        ESC  ,     ' ITEM-BACK ,
        ENTER ,    ' ITEM-SELECT ,
        F1  ,      ' ITEM-SELECT ,
END-TRANSLATE


( ADDR N N -- ADDR N N )
: DIFFERENT-ITEM
        >R  OVER R>  .ITEM    ( normal intensity old item )
        2DUP REVERSE .ITEM    ( reverse the now current item )
        DUP ;

( N MADDR N XADDR -- ADDR N F )
: MENUKEY-VALID
        EXECUTE  >R          ( execute key action, save menu message )
        ROT 2DUP <>
        IF  DIFFERENT-ITEM  THEN
        DROP  R>  ;


( N ADDR N ADDR -- ADDR N 0 )
: MENUKEY-INVALID
        2DROP SWAP FALSE   ;


2 1 IN/OUT
( ADDR N -- msg )  \ msg =  SELECT or ESCAPE
: CHOOSE-ITEM      \ last item always in MENUCHOICE
        BEGIN
           TUCK
           ATKEY  MENUKEYS
           DUP IF
              MENUKEY-VALID
           ELSE
              MENUKEY-INVALID
           THEN
        ?DUP UNTIL ( menu message )
        -ROT  2DROP  ;


: SAVEWINDOW ( ADDR -- MANY )
        ?XY SWAP  ROT TUCK
        MENUWIDTH + @ 2+ RANGE  2SWAP
        MENUHEIGHT + @ 2+ RANGE
        ?DO
           2DUP >R >R
           ?DO
              I J PICKCHAR
           LOOP
           R> R>
        LOOP  2DROP   ;


: RESTOREWINDOW ( MANY ADDR -- )
        ?XY SWAP  ROT TUCK
        MENUWIDTH + @ 2+ OVER + 1-  2SWAP
        MENUHEIGHT + @ 2+ OVER + 1-
        ?DO
           2DUP >R >R
           ?DO
              I J PUTCHAR
           -1 +LOOP
           R> R>
        -1 +LOOP  2DROP   ;


: DOITEM ( ADDR N MSG -- ADDR N )
            NIP OVER
            MENUCHOICE + @

            SWAP SELECT =
            IF
               OVER MENUITEMS +
               OVER 0 ?DO +ITEM LOOP
               @ EXECUTE
            THEN    ;


1 0 IN/OUT
: DOMENU   ( ADDR -- )
         DUP >R  SAVEWINDOW
         R@ DUP MENUCHOICE + @
         2DUP  .MENU
         DON'T-REMOVE-MENU AFTER-SELECTION !
         BEGIN
            AFTER-SELECTION @
            IF
               FALSE DUP
            ELSE
               2DUP CHOOSE-ITEM
               DUP ESCAPE <>
            THEN
         WHILE
            DOITEM
         REPEAT
         DROP 2DROP
         R> RESTOREWINDOW ;


1 0 IN/OUT
H: MENU   ( -- ADDR )   ( COMPILE )
          ( -- )        ( RUN )
        CREATE HERE
          0 ,    ( menu height )
          0 ,    ( window width )
          0 ,    ( menu choice )
        DOES>
          DOMENU   ;

H: ENDMENU  ( N -- )    DROP   ;

H: ITEM" ( ADDR ADDR -- ADDR )
        ,
        HERE
        0 C,   ( LEN )
        ,"
        HERE OVER -
        1- DUP ROT C!
        OVER MENUWIDTH + @
        MAX
        OVER MENUWIDTH + !
        DUP MENUHEIGHT + DUP @
        1+ SWAP !  ;







DECIMAL

MENU BEEPMENU
        ' BEEP1 ITEM"  Beep 1 "
        ' BEEP2 ITEM"  Beep 2"
        ' BEEP3 ITEM"  Beep 3"
        ' BEEP4 ITEM"  Beep 4"
        ' BEEP5 ITEM"  Beep 5"
        ' BEEP6 ITEM"  Beep 6"
ENDMENU

: DO-BEEPMENU     ?XY 15 1  !XY  BEEPMENU  !XY   QUITMENU  ;





MENU WINDOWMENU
    ' RESIZEWINDOW ITEM"  Resize "
    ' MOVEWINDOW   ITEM"  Move"
    ' ZOOMWINDOW   ITEM"  Zoom"
    ' HIDEWINDOW   ITEM"  Hide"
ENDMENU

: DO-WINDOWMENU   ?XY  15 1  !XY WINDOWMENU  !XY  ;




MENU MAINMENU
    ' DO-WINDOWMENU ITEM"  Windows menu "
    ' DO-BEEPMENU   ITEM"  Beep menu"
    ' QUITMENU      ITEM"  Quit menu"
    ' NOOP          ITEM"  not defined"
    ' NOOP          ITEM"  not defined"
    ' NOOP          ITEM"  not defined"
    ' NOOP          ITEM"  not defined"
    ' NOOP          ITEM"  not defined"
    ' NOOP          ITEM"  not defined"
ENDMENU

: DO-MAINMENU     ?XY  0 1  !XY MAINMENU  !XY  ;








\ ---------------------------------------------------------------
\                            links
\ ---------------------------------------------------------------


1 2 IN/OUT : LINE1  ( ADDR -- ADDR SEG )      LINKSIZE + 2@     0 TOPLINE  !  ;
2 2 IN/OUT : +LINE  ( SEG OFF -- SEG OFF )    LINKSIZE + 2@L   ;
2 2 IN/OUT : -LINE  ( SEG OFF -- SEG OFF )               2@L   ;

HEX
2 2 IN/OUT : NORMALIZE  ( seg off -- seg off )
        DUP 0< IF  8000 - SWAP 0800 + SWAP  THEN   ;

2 0 IN/OUT : LINK  ( addr offs -- )
        0 DUP  2OVER LINKSIZE +  2!L
        LASTLINE 2@  2OVER   2OVER
        LINKSIZE + 2OVER 2SWAP  2!L 2!L
        LASTLINE 2!
        1 LINES_IN_FILE +!  ;




\ ---------------------------------------------------------------
\                          file read
\ ---------------------------------------------------------------


: GETLINE    ( SEG OFFS -- SEG OFFS F )
           BEGIN
              GET    ( asc 0 | err )
              IF
                 FALSE FALSE
              ELSE
                 DUP CONTROL J =
                 DUP 0= >R
                 IF
                    DROP TRUE
                 THEN
                 R>
              THEN
           WHILE
              1 SWAP
              2OVER C!L
              +
           REPEAT

           DUP IF
              DROP 2DUP 1- C@L
              ENTER = IF 1- THEN
              TRUE
           THEN
              ;


0 0 IN/OUT : GETFILE ( -- )
        START_OF_FILE 2@
        BEGIN
           NORMALIZE
           2DUP
           LINKSIZE 2* +
           2DUP
           2+            ( ROOM FOR LINE LEN )
           GETLINE
        WHILE
           2SWAP 2OVER 2OVER
           ROT SWAP - -ROT -
           4 << +  2- -ROT !L      ( store line len )
           2SWAP LINK
        REPEAT
        2DROP 2DROP 2DROP  ;



\ ---------------------------------------------------------------
\                         statusline
\ ---------------------------------------------------------------
0 0 IN/OUT : .STATUS ( -- )
           REVERSE
              STATUSPOS !XY
              STATUSLEN SPACES
              STATUSPOS !XY
              ." File: "  LISTNAME @ .FILENAME SPACE
              ."  Lines: "  LINES_IN_FILE @ .
              ."  Top: "    TOPLINE @ .
              ."  Pan: "    RIGHTPAN @ .
              ."  Depth: "  DEPTH .
           NORMAL ;


\ ---------------------------------------------------------------
\                        file display
\ ---------------------------------------------------------------


2 1 IN/OUT : .LINE ( SEG OFFS -- N )
        2DUP 2+
        RIGHTPAN @ +
        2SWAP @L
        RIGHTPAN @ -
        0 MAX
        WINDOWWIDTH @ MIN
        DUP >R
        0 ?DO
          LCOUNT EMIT
         LOOP  2DROP
         R>  ;


0 2 IN/OUT
: EACH_LINE ( -- N1 N2 )
        WINDOWTOP @
        WINDOWHEIGHT @
        RANGE  ;

: PUTLINE  ( ADDR OFF N -- ADDR OFF N )
        WINDOWLEFT @ SWAP !XY
        2DUP +LINE 2SWAP
        LINKSIZE 2* + .LINE  ;

2 0 IN/OUT : .SCREEN  ( SEG OFF -- )
        EACH_LINE ?DO
           I PUTLINE
           WINDOWWIDTH @ SWAP - SPACES
           2DUP OR  0=
           IF LEAVE THEN
        LOOP
        2DROP  ;

\ ---------------------------------------------------------------
\                         interaction
\ ---------------------------------------------------------------


: UPS    ( SEG OFF N -- SEG OFF )
        WINDOWHEIGHT @
        TOPLINE @
        MIN MIN
        ?DUP IF
                DUP NEGATE TOPLINE +!
                0 ?DO  -LINE  LOOP
                2DUP .SCREEN
        THEN ;

: UP    ( SEG OFF -- SEG OFF )        1 UPS    ;

: PG-UP    ( SEG OFF -- SEG OFF )     WINDOWHEIGHT @ 1- UPS    ;

: DOWNS  ( SEG OFF N -- SEG OFF )
        WINDOWHEIGHT @
        LINES_IN_FILE @
        OVER
        TOPLINE @ +
        -  MIN  MIN
        ?DUP IF
                DUP TOPLINE +!
                0 ?DO  +LINE  LOOP
                2DUP .SCREEN
        THEN ;

: DOWN  ( SEG OFF -- SEG OFF )        1 DOWNS  ;

: PG-DOWN  ( SEG OFF -- SEG OFF )     WINDOWHEIGHT @ 1- DOWNS  ;


: RIGHT ( SEG OFF -- SEG OFF )  1 RIGHTPAN +!   2DUP  .SCREEN  ;
: LEFT  ( SEG OFF -- SEG OFF )  RIGHTPAN DUP @ 1- 0 MAX <- 2DUP .SCREEN  ;


VARIABLE STOP
: DONE  STOP ON  ;


TRANSLATE SCROLLKEYS
         C-UP ,        '  UP ,
         C-DOWN  ,     ' DOWN ,
         C-RIGHT ,     ' RIGHT ,
         C-LEFT ,      ' LEFT ,
         PAGE-UP   ,   ' PG-UP   ,
         PAGE-DOWN ,   ' PG-DOWN ,
         F1 ,          ' DO-MAINMENU ,
         ESC ,         ' DONE ,
END-TRANSLATE


0 0 IN/OUT
: BROWSE   ( -- )
        STOP OFF
        LASTLINE LINE1
        2DUP .SCREEN

        BEGIN
           .STATUS
           ATKEY SCROLLKEYS
            ?DUP IF EXECUTE THEN
        STOP @ UNTIL
        2DROP   ;


: savescreen    ( -- many )
           #LINES 0 DO
           CHARS/LINE 0 DO
             I J PICKCHAR
           LOOP
           LOOP ;

: restorescreen ( many -- )
        0 #LINES 1- DO
        0 CHARS/LINE 1- DO
            I J  PUTCHAR
        -1 +LOOP
        -1 +LOOP ;


: MAIN
        SETUP-VID
        1STPAR READ$ INPUT FILENM DROP   \ read name from cmdline
        INPUT  OPEN-FILE-R/O             \ attempt opening
        0= IF
              savescreen
              FILE1 NEWFILE
              INPUT FROMFILE
              GETFILE
              CLS BROWSE
              restorescreen
           ENDFROM
        THEN
        UNSETUP-VID  ;

INCLUDE FORTHLIB
END
