\
\         link / unlink tested and found to be ok.
\


\ bugs problems quirks
\
\ last line wrong cursor position
\




128 MSDOS

  FALSE EQU LARGE     \ 16 BIT LINE LINKS


\ INCLUDE IBMMINI
  INCLUDE SIRTEXT

INCLUDE DOSINT
INCLUDE KEYCODES


DECIMAL
128 CONSTANT SPAN

1024 CONSTANT IBUFSIZE

HANDLE LISTFILE

VARIABLE DONE?


VARIABLE STATUSLINES       \ no,single,double statusline
2        STATUSLINES !

                   0 EQU POOL_LO




0 EQU BENCH             \ doing editing work in here


( CHARS/LINE     from Library;  number of chars fitting on one display line )
256  CONSTANT LONGEST    ( longest line the editor can handle )


\
\                       COMPILE TIME ACTION
\                 ===============================

\ file selection


H: +!  ( N ADDR -- )   DUP @  ROT +  SWAP !  ;



\ CURRENT LIST FILE PARAMETERS

4 CONSTANT #FILES

\ contains the base of the used edit parameter table
VARIABLE CURRENT-FILE           \ also used at compile time

H: LISTPARAMETER
                  CREATE  CELL CURRENT-FILE  DUP @ , +!
                  DOES>  @  CURRENT-FILE @ +  ;


LISTPARAMETER ORIGIN            \ thread to edit

LISTPARAMETER LEFTEDGE          \ ...upper left edit window corner
LISTPARAMETER CEILING           \ screen coordinate of the...
LISTPARAMETER WIDTH             \ edit window width in columns
LISTPARAMETER HEIGHT            \ edit window height in lines

LISTPARAMETER XCURSOR           \ cursor horizontal relative to LEFTEDGE
LISTPARAMETER YCURSOR           \ cursor vertical relative to CEILING

LISTPARAMETER LEFT              \ ...upper left edit window corner
LISTPARAMETER TOP               \ file coordinate of the ...

LISTPARAMETER TOPLINE_LO
LISTPARAMETER CURSORLINE_LO

LISTPARAMETER LINES             \ number of lines in file

HERE
LISTPARAMETER ZOOMAREA
LISTPARAMETER ZOOMAREA1
LISTPARAMETER ZOOMAREA2
LISTPARAMETER ZOOMAREA3
HERE SWAP -  CONSTANT ZOOMAREASIZE
LISTPARAMETER ZOOMED

CURRENT-FILE @    CONSTANT SIZE-OF-EPT


\ better create each table for each file opened at run time.
CREATE EPT   ( LISTPARAMETERTABLE )
  SIZE-OF-EPT  #FILES *  ALLOT
HERE CONSTANT END-OF-EPT

H: 0FILE              EPT          CURRENT-FILE !  ;
H: +FILE      SIZE-OF-EPT          CURRENT-FILE +!  ;
H: -FILE      SIZE-OF-EPT  NEGATE  CURRENT-FILE +!  ;


TRUE CONSTANT END-OF-THREAD
H: NEW-THREAD   CREATE   HERE DUP , ,   END-OF-THREAD ,   ;
\ a THREAD originates a linked list

HERE   NEW-THREAD THREAD0    HERE
       NEW-THREAD THREAD1
       NEW-THREAD THREAD2
       NEW-THREAD THREAD3

SWAP - CONSTANT THREADSIZE



\      NEW-THREAD WINDOWS


TABLE (WINDOW)   THREAD0 ,  THREAD1 , THREAD2 , THREAD3 ,

1 0 IN/OUT
: WINDOW  ( N -- )
        (WINDOW)
        ORIGIN !   ;

0 CONSTANT USERTEXT
1 CONSTANT DELETEDTEXT
2 CONSTANT CHANGEDTEXT


\ ------------ GENERAL PRIMITIVES -------------

\ SWAP STACK WITH MEMORY
2 1 IN/OUT
: XCHG   ( N ADDR -- N )
        DUP @  -ROT !  ;




\ ------------- SCREEN PRIMITIVES -------------



2 0 IN/OUT
: REPEATCHAR  ( asc n -- )
        SWAP ?XY ROT VFILL  ;



CREATE SINGLE-TABLE
      ASCII  C,      ASCII  C,      ASCII    C,
      ASCII  C,       BL     C,      ASCII    C,
      ASCII  C,      ASCII  C,      ASCII    C,

CREATE DOUBLE-TABLE
      ASCII  C,      ASCII  C,      ASCII    C,
      ASCII  C,       BL     C,      ASCII    C,
      ASCII  C,      ASCII  C,      ASCII    C,

CREATE SOLID-TABLE
      ASCII    C,    ASCII  C,      ASCII    C,
      ASCII    C,      BL    C,      ASCII    C,
      ASCII    C,    ASCII  C,      ASCII    C,

\ CREATE SOLID-TABLE
\       ASCII    C,    ASCII  C,      ASCII    C,
\       ASCII    C,      BL    C,      ASCII    C,
\       ASCII    C,    ASCII  C,      ASCII    C,


VARIABLE LINESTYLE
SINGLE-TABLE  ( DEFAULT- ) LINESTYLE !

H: LINECHAR  CREATE C, DOES> C@ LINESTYLE @ + C@  ;

 0 LINECHAR "7"
 1 LINECHAR "8"
 2 LINECHAR "9"
 3 LINECHAR "4"
 4 LINECHAR "5"
 5 LINECHAR "6"
 6 LINECHAR "1"
 7 LINECHAR "2"
 8 LINECHAR "3"


: SINGLE  SINGLE-TABLE  LINESTYLE !  ;
: DOUBLE  DOUBLE-TABLE  LINESTYLE !  ;
: SOLID   SOLID-TABLE   LINESTYLE !  ;


\                                                                     \
\                               BOX DRAWING                           \
\                                                                     \


1 0 IN/OUT
: RIGHTBORDER ( N -- )
      LEFTEDGE @ WIDTH @ + 1-
      SWAP AT   ;

: BOX  ( -- )
      UPPER-LEFT
      2DUP AT   "7" EMIT
      "8" WIDTH @ 2- REPEATCHAR
      DUP RIGHTBORDER "9" EMIT 1+
      HEIGHT @ 2 ?DO
         2DUP AT  "4" EMIT
\        "5" WIDTH @ 2- REPEATCHAR
         DUP RIGHTBORDER "6" EMIT 1+
      LOOP
      2DUP AT   "1" EMIT
      "2" WIDTH @ 2- REPEATCHAR
      DUP RIGHTBORDER "3" EMIT 1+
      2DROP  ;



\ ------------- FILE > WINDOW > SCREEN  coordinate conversions --------------


0 2 IN/OUT
: UPPER-LEFT  ( -- X Y )
        LEFTEDGE @
        CEILING @  ;


1 1 IN/OUT
: +LEFT    ( N -- N' )
        LEFT @ +   ;

0 1 IN/OUT
: LINE# ( -- N )
        TOP @
        YCURSOR @
        +   ;

0 1 IN/OUT
: COL#  ( -- N )
        XCURSOR @
        +LEFT   ;



           0 2 IN/OUT
           : @ORIENTATION  ( -- TOP CUR )
                           TOPLINE_LO @
                           CURSORLINE_LO @  ;

           2 0 IN/OUT
           : !ORIENTATION ( TOP CUR -- )
                           CURSORLINE_LO !
                           TOPLINE_LO !   ;


\ ---------------------------------------------------------------

: LIMIT-WINDOWSIZE ( -- )
	#LINES
        STATUSLINES @
        CEILING @ MAX
	DUP CEILING !
	-
	HEIGHT @ MIN
        HEIGHT !

        CHARS/LINE
        LEFTEDGE @ -
        WIDTH @ MIN
        WIDTH !  ;




1 0 IN/OUT
: SETUP-FILE ( ADDR -- )

           SKIM DUP ORIGIN !              \ thread to get text from
           DUP !ORIENTATION               \ set top of line and cursorline

           SKIM LEFTEDGE !                \ ...of edit window
           SKIM CEILING !
           SKIM WIDTH !
             @  HEIGHT !

           XCURSOR OFF
           YCURSOR OFF                  \ cursor top left

           LEFT OFF                     \ left margin
           TOP OFF                      \ 1st line of file

           LINES OFF                    \ file is empty...
           ZOOMED OFF  ;


DECIMAL
CREATE INITDATA
\      ORIGIN LEFTEDGE CEILING WIDTH HEIGHT
HERE   THREAD0 , 20 ,    10 ,   40 ,   12 ,   HERE
       THREAD1 , 14 ,     8 ,   40 ,   12 ,
       THREAD2 ,  8 ,     6 ,   40 ,   12 ,
       THREAD3 ,  2 ,     4 ,   40 ,   12 ,
SWAP - CONSTANT (INITDATA)



0 0 IN/OUT
: INIT-LISTFILES   ( -- )
     0FILE  INITDATA
     #FILES 0
     DO
        DUP SETUP-FILE
        +FILE
        (INITDATA) +
     LOOP
     DROP
     0FILE  ;


( didn't I have something herefor ? )

0 1 IN/OUT
: (+FILE)    ( -- addr )  \ returns base address of next file parameter set
              CURRENT-FILE @
              SIZE-OF-EPT +
              DUP END-OF-EPT <
              NOT IF  DROP  EPT THEN  ;

0 1 IN/OUT
: (-FILE)     ( -- addr )
              CURRENT-FILE @
              DUP EPT > NOT
              IF DROP END-OF-EPT  THEN
              SIZE-OF-EPT -  ;


0 0 IN/OUT
 : +FILE      (+FILE)   CURRENT-FILE !  ;
0 0 IN/OUT
 : -FILE      (-FILE)   CURRENT-FILE !  ;
0 0 IN/OUT
 : 0FILE        EPT     CURRENT-FILE !  ;


DECIMAL


0 0 IN/OUT
: INIT-VIDEO  ( -- )
        SETUP-VID   ;

: FREE ( -- N )  
     MEMEND HERE - 
     dssize - rssize -   ;


0 0 IN/OUT
: INIT-MEMORY  ( -- )
        HERE EQU BENCH         \
        LONGEST CELL + ALLOT    \ room to do the line editing work in

        HERE EQU POOL_LO       \ no PAD reserve -- ALLOT for any entry

        POOL_LO DUP OFF        \ setup text buffer as first and only chunk
        CELL +   FREE 
        1024  -                \ allow some mem for pad / num conversion etc
        IBUFSIZE -             \ reserved for input file buffers
        DUP ALLOT <-  ;



1 0 IN/OUT
: CLEARSTATUSLINE ( N -- )        0 OVER AT
                                  CHARS/LINE SPACES
                                  0 SWAP AT   ;
0 0 IN/OUT
: STATUS...CLS  ( -- )            0 CLEARSTATUSLINE  ;

1 1 IN/OUT
: >DATA  ( ADDR -- ADDR' )        CELL 2* +  ;
1 1 IN/OUT
: END-OF-THREAD? ( ADDR -- FL )   >DATA  @   END-OF-THREAD =  ;
1 1 IN/OUT
: +LINE  ( ADDR -- ADDR' )        CELL +  @  ;
1 1 IN/OUT
: -LINE  ( ADDR -- ADDR' )        @    ;







\
\ --------------------  error handling  --------------------
\
  
VARIABLE NEW-ERROR

H: MAKE-ERROR    1 NEW-ERROR
                 DUP @ , +!  ;

H: ERROR?  CREATE  MAKE-ERROR
           DOES> OVER IF
                   0 CLEARSTATUSLINE
		   KEY 2DROP  BYE
                 THEN
                 2DROP ;



ERROR?  CAN'T-OPEN?
ERROR?  CAN'T-CLOSE?
ERROR?  CAN'T-REWIND?
ERROR?  CAN'T-WRITE?
ERROR?  CAN'T-CREATE?
ERROR?  OUT-OF-MEMORY?




\
\ -------------- link / unlink lines --------------
\

1 0 IN/OUT
\ /////////////
: NEWTOPLINE   ( ADDR -- )
        DUP !ORIENTATION  ;

2 0 IN/OUT
: ?NEWTOPLINE   ( ADDR F -- )
        IF
           DUP NEWTOPLINE
        THEN  DROP   ;



2 0 IN/OUT
: (LINK-LINE)  ( addr1 addr2 -- )
        2DUP   +LINE !
        2DUP   <-
        CELL +   2DUP @
        SWAP CELL +  ! !
        1 LINES +!   ;


2 0 IN/OUT
: LINK-LINE  ( ADDR1 ADDR2 -- )         \ add ADDR1 below ADDR2
        OVER
        LINES @ 0=              ( linking to an empty thread )
        ?NEWTOPLINE
        (LINK-LINE)  ;



2 0 IN/OUT
: APPEND-LINE  ( LINE FILE -- )        \ LINE ADDR1 APPENDED TO FILE ADDR2
        -LINE LINK-LINE  ;



1 0 IN/OUT
\ //////////////
: INSERT-LINE    ( ADDR -- )
        DUP CURSORLINE_LO  XCHG
        2DUP  -LINE          \ above current cursorline
        LINK-LINE
        TOPLINE_LO @  =
        ?NEWTOPLINE  ;    \ was linked above top of screen


\
\  ---------------------  read and translate disk file  ---------------------
\


1000 CONSTANT END-OF-LINE ( NEW FILE ERROR )

: CUDDLE  ( ADDR CHAR -- ADDR' FL )
        OVER C! 1+ FALSE ( WANT MORE INPUT )  ;


: -TAB-   ( ADDR CHAR -- ADDR' FL )
        DROP   8 2DUP BLANK  + FALSE  ;

: -LINEFEED-   ( ADDR CHAR -- ADDR err -1 )
        DROP
        DUP 1- C@            ( previous chars was CR ? )
        13 = IF 1- THEN      ( throw away CR as well )
        END-OF-LINE TRUE ;




\ file input control character translation table
( BUFADR CHAR -- BUFADR' TRUE | BUFADR 0 )
TABLE CONTROL-CHARACTER
 (  ^@  )   ' CUDDLE  ,
 (  ^A  )   ' CUDDLE  ,
 (  ^B  )   ' CUDDLE  ,
 (  ^C  )   ' CUDDLE  ,
 (  ^D  )   ' CUDDLE  ,
 (  ^E  )   ' CUDDLE  ,
 (  ^F  )   ' CUDDLE  ,
 (  ^G  )   ' CUDDLE  ,
 (  BS  )   ' CUDDLE  ,
 ( TAB  )   '  -TAB-  ,
 (  LF  )   ' -LINEFEED- ,
 (  ^K  )   ' CUDDLE  ,
 (  FF  )   ' CUDDLE  ,
 (  CR  )   ' CUDDLE  ,
 (  ^N  )   ' CUDDLE  ,
 (  ^O  )   ' CUDDLE  ,
 (  ^P  )   ' CUDDLE  ,
 (  ^Q  )   ' CUDDLE  ,
 (  ^R  )   ' CUDDLE  ,
 (  ^S  )   ' CUDDLE  ,
 (  ^T  )   ' CUDDLE  ,
 (  ^U  )   ' CUDDLE  ,
 (  ^V  )   ' CUDDLE  ,
 (  ^W  )   ' CUDDLE  ,
 (  ^X  )   ' CUDDLE  ,
 (  ^Y  )   ' CUDDLE  ,
 (  ^Z  )   ' CUDDLE  ,
 ( ESC  )   ' CUDDLE  ,
 (  $1C )   ' CUDDLE  ,
 (  $1D )   ' CUDDLE  ,
 (  $1E )   ' CUDDLE  ,
 (  $1F )   ' CUDDLE  ,

\ *****

\ ///////////////////
1 1 IN/OUT
: REQUEST-MEMORY  ( N -- ADDR | 0 )
        POOL_LO
        CELL + @
        2DUP U<
        IF
           OVER -                         \ S RS
           POOL_LO  ROT                \ RS FC S
           OVER +                         \ RS FC FC'
           OVER @  OVER !
           DUP EQU POOL_LO
           CELL +
           ROT <-
        ELSE                              \ S RS
           2DROP 0
        THEN ;



1 2 IN/OUT
: READ-LINE    ( ADDR -- LEN 0 | LEN ERR )
        DUP  FALSE                          ( NOT END OF LINE YET )
        BEGIN
          NOT  IF                           ( END-OF-LINE )
          GET  THEN
        ?DUP 0= WHILE                       ( NO ERROR / END-OF-LINE )
          DUP BL U<
          IF                                ( BUFADR CHAR )
            DUP CONTROL-CHARACTER EXECUTE   ( FL true   ABORTS )
          ELSE
            CUDDLE
          THEN
        REPEAT
        END-OF-LINE <>                      ( MUST BE ERROR THEN )
        >R
        SWAP -
        R>    ;



\ about changing to administration of free-memory.
0 1 IN/OUT
\ /////////////////
: READ-TEXT   ( -- #LINES )
        0                            \ LINES COUNTER
        BEGIN
           BENCH READ-LINE             \ L LEN F
        0= WHILE                       \ L LEN
           DUP THREADSIZE +       \ L LEN LEN+
           REQUEST-MEMORY              \ L LEN ADDR | L LEN 0
           DUP 0=  OUT-OF-MEMORY?      \ L LEN ADDR
           TUCK  >DATA                 \ L ADDR LEN ADDR'
           2DUP !   CELL +             \ L ADDR LEN $ADDR
           BENCH SWAP ROT              \ L ADDR EB $ADDR LEN
           CMOVE                       \ L ADDR
           ORIGIN @  APPEND-LINE
           1+
        REPEAT
        DROP  ;



0 0 IN/OUT
: OPEN-FILES ( -- )
             1STPAR READ$
             LISTFILE FILENM
             DROP
             LISTFILE OPEN-FILE-R/O
             CAN'T-OPEN?                   \ CREATE NEW FILE INSTEAD
             LISTFILE FROMFILE
             INIT-LISTFILES
              ;


0 0 IN/OUT
: CLOSE-FILES  ( -- )
        LISTFILE CLOSE-FILE  CAN'T-CLOSE? ;





\                  ------ screen job -------


: SCROLLUP   ( N1 N2 -- )
    TUCK SWAP DO
      I 1+ 'LINE   I 'LINE  CHARS/LINE 2* CMOVEL
    LOOP     
    'LINE    CHARS/LINE ATTR @ BL + LFILLW 

5 8     6 5   7 6   8 5   8 




0 0 IN/OUT
: CLSWINDOW  ( -- )
        WIDTH @
        UPPER-LEFT
        HEIGHT @
        RANGE DO                ( N A X )
           2DUP I BL VFILL
        LOOP
        2DROP  ;



0 2 IN/OUT
: CURSORPOSITION ( -- X Y )
        XCURSOR @   LEFTEDGE @ +
        YCURSOR @   CEILING @ +   ;


0 0 IN/OUT
: .STATUSLINE1   ( -- )
        REVERSE
        0 CLEARSTATUSLINE
        LISTFILE .FILENAME SPACE

        DECIMAL
        ." XY:"
        COL#  1+ U.
        LINE# 1+ U.
        ." LINES:" LINES @ U.

        NORMAL   ;






0 0 IN/OUT
: .STATUSLINE2   ( -- )
        0 1 AT
        CHARS/LINE
        DUP 2*           ( prepare for integer rounding )
        LINE#  LINES @
        1 MAX            ( may not divide thru zero )
        */  1+  2/       ( do rounding )
        ASCII   OVER REPEATCHAR
        DUP 1 AT
      - ASCII   SWAP REPEATCHAR  ;


TABLE DO-STATUSLINE
   ' .STATUSLINE1 ,
   ' .STATUSLINE2 ,
HERE ' DO-STATUSLINE - CELL /  CONSTANT MAXSTATUSLINES

0 0 IN/OUT
: .STATUS  ( -- )
   STATUSLINES @ 0 ?DO
   I DO-STATUSLINE EXECUTE  LOOP  ;




1 0 IN/OUT
\ ///////////////
: SCREEN     ( ADDR -- )
            CLSWINDOW
            CURSORLINE_LO @  SWAP
            CEILING @ HEIGHT @
            RANGE DO
               DUP END-OF-THREAD?
               IF  LEAVE  THEN

               LEFTEDGE @ I AT

               DUP >DATA
               SKIM
               LEFT @ TUCK -
               -ROT + SWAP
               WIDTH @  MIN 0 MAX  TYPE

               +LINE
            LOOP
            2DROP  ;


0 0 IN/OUT
\ /////////////
: REFRESH  ( -- )
        TOPLINE_LO @ SCREEN  ;





\ ------------------------------------------------------------------
\                        LIST KEY MAPPING
\ ------------------------------------------------------------------

 1 CONSTANT FORW
-1 CONSTANT BACKW

0 0 IN/OUT
: WHERE   ( -- )
      CURSORPOSITION AT    PUT-CURSOR    ;

0 0 IN/OUT
: UNDEFINED ( -- )   ;




\ ------------- cursor movements --------------


: -UP-  ( -- )
	@ORIENTATION
        YCURSOR @
        IF
          -LINE
          -1 YCURSOR +!
        ELSE
          TOP @
          IF
             -LINE
             -1 TOP +!
             SWAP -LINE DUP SCREEN  SWAP
          THEN
        THEN
	!ORIENTATION  ;


: -DOWN-  ( -- )
	@ORIENTATION
        LINE#   LINES @ U<
        IF
           +LINE
           1  ( gets plus-stored )
           YCURSOR @  HEIGHT @ 1- U<
           IF
              YCURSOR +!
           ELSE
              TOP +!
              SWAP +LINE  DUP SCREEN  SWAP
           THEN
        THEN
	!ORIENTATION  ;



: -TOF-   ( -- )
        ORIGIN @
        +LINE
        DUP NEWTOPLINE
        0 YCURSOR !  0 TOP !
        SCREEN
          ;


: -EOF-   ( -- )
        ORIGIN @
        DUP CURSORLINE_LO !
        -LINE DUP TOPLINE_LO !
        LINES @   DUP 1-   0 MAX
        DUP TOP !   - YCURSOR !
        SCREEN
        ;


: (PGDN)  ( -- )
        @ORIENTATION
        HEIGHT @ 1- 0
        DO
          FORW TOP +!
          +LINE SWAP
          +LINE SWAP
        LOOP
        !ORIENTATION  ;


: (PGUP)  ( -- )
        @ORIENTATION
        HEIGHT @ 1- 0
        DO
          BACKW TOP +!
          -LINE SWAP
          -LINE SWAP
        LOOP
        !ORIENTATION ;


: -PGDN-   ( -- )
        LINE# HEIGHT @ +
        LINES @ U>
        IF
           -EOF-
        ELSE
           (PGDN)
           REFRESH
        THEN  ;


: -PGUP-   ( -- )
        LINE# HEIGHT @ U<
        IF
           -TOF-
        ELSE
           (PGUP)
           REFRESH
        THEN    ;


: UNSHRINK ( -- )
        -1 LEFTEDGE +!
        -1 CEILING +!
        2 WIDTH +!
        2 HEIGHT +!  ;

: SHRINK   ( -- )
        1 LEFTEDGE +!
        1 CEILING +!
        -2 WIDTH +!
        -2 HEIGHT +!  ;


: SAVELISTPARS      ( -- )   LEFTEDGE ZOOMAREA  ZOOMAREASIZE CMOVE ;
: RESTORELISTPARS   ( -- )   ZOOMAREA LEFTEDGE  ZOOMAREASIZE CMOVE ;
: MAXIMIZE          ( -- )
        0 LEFTEDGE !
        STATUSLINES @ CEILING !
        CHARS/LINE WIDTH !
        #LINES STATUSLINES @ - HEIGHT !  ;

: RECONSTRUCT  ( -- )
        UNSHRINK
        SOLID BOX
        SHRINK
        REFRESH ;


: -ZOOM-  ( -- )
        ZOOMED @
        IF
           RESTORELISTPARS
           RECONSTRUCT
           ZOOMED OFF
        ELSE
           SAVELISTPARS
           MAXIMIZE
           ZOOMED ON
           REFRESH
        THEN   ;



: CLEARSTATUSLINES  ( n1 n2 -- )
        OVER MIN               ( do loop only if n1 > n2 )
        ?DO
            I CLEARSTATUSLINE
        LOOP  ;


DECIMAL
: -STATUS-   ( -- )     ( CHANGE STATUS LINES )
    STATUSLINES @
    DUP  1+ MAXSTATUSLINES 1+ MOD
    DUP  STATUSLINES !
    CLEARSTATUSLINES
\    LIMIT-WINDOWSIZE
       ;

: -DONE-  ( -- )   DONE? ON  ;

HEX
H: EXT   FF00 OR  ;   
  
CREATE KEYTABLE  0 ,
	     ESC ,	' -DONE- ,   
     ASCII A EXT ,	' -UP- ,
     ASCII B EXT ,      ' -DOWN- ,
     ASCII C EXT ,      ' -PGDN- ,
     ASCII D EXT ,      ' -PGUP- ,
     ASCII Z     ,      ' -ZOOM- ,
     ASCII S     ,      ' -STATUS- ,
HERE KEYTABLE - 2-  4 /  KEYTABLE !




: ENGAGE    ( ASC -- )
        KEYTABLE LOOKUP
        ?DUP IF  EXECUTE  THEN  ;

: DONE  DONE? @ ;

HEX
: SKEY  
	KEY  DUP ESC =
        IF ?TERMINAL IF
        DROP KEY FF00 OR
        THEN THEN  ;

	

: LIST      ( -- )
                  SOLID BOX  SHRINK  REFRESH
                   BEGIN
                   .STATUS
                   WHERE
                   SKEY ENGAGE
                   DONE UNTIL
                   UNSHRINK
                 ;



\ ------------------------------------------------------------

: INIT-ALL
        INIT-MEMORY
        INIT-VIDEO
        CLS  ;


: MAIN
        INIT-ALL
        OPEN-FILES
        READ-TEXT LINES !
        0 WINDOW LIST
        CLOSE-FILES
        UNSETUP-VID   ;


NOMAP
INCLUDE FORTHLIB  END

