\ =======================================================================
\                     IBM BIOS EMULATING LOADER
\       		1991 NoCreditWare
\ =======================================================================
CREATE TSR-PROCESS
3000 CONSTANT MEMEND
128  MSDOS

INCLUDE SIRTEXT

CREATE IDENTIFICATION  ," Sub-ether radio v0.78"
HERE IDENTIFICATION - CONSTANT ID-LEN


DECIMAL
: MESSAGE    CLS
NORMAL
\    15 4 AT  ." Issue + NoCreditWare 1991  / launching peanut drive"
\ this could go at beginning and end - (set mode call) 
;


\ =======================================================================
\                    just show we're genuine 
\ =======================================================================

HEX
E000 CONSTANT CODEC

CREATE SOUND-INIT-DATA
CODEC , 	00 C,   8060 ,        5E C,   8061 ,
                40 C,   8060 ,        0D C,   8061 ,
                80 C,   8060 ,        0F C,   8061 ,
                C0 C,   8060 ,        00 C,   8061 , 
                C0 C,   808B ,        00 C,   8084 ,
        	00 C,   8085 ,

CREATE PITCH-DATA
CODEC ,          80 C,   8060 ,        0F C,   8061 ,
               ( USER )               00 C,   8085 ,


DECIMAL

: VALUES  ( ADDR N -- SEG ADDR )  
  	OVER @   ( SEGMENT )
  	ROT 2+
  	ROT 0 DO
	   2DUP COUNT 
           -ROT  @  
           C!L  3 +  
        LOOP  ;


: SOUND-INIT   ( -- )      SOUND-INIT-DATA   11 VALUES   2DROP  ;


HEX
: FREQ!      ( N -- )    PITCH-DATA 2 VALUES >R 8084 C!L R> 1 VALUES 2DROP ;

DECIMAL


  : SOUND8   ( DELAY -- )     ( samba ole )
      200 0 DO
         I DUP 1+ XOR FREQ!
      DUP  0 DO LOOP
     LOOP   0 FREQ!   DROP ;
  
  : SOUND8A 
   2DUP U<   1 OR ( 001 / 111 ) 
	-ROT    
   	?DO
   	    256 0 DO I J AND FREQ!  LOOP   
       DUP +LOOP  
       DROP  0 FREQ! ;


: SOUND 
   SOUND-INIT
\   1 0 DO 1000 SOUND8 LOOP     
   1200 SOUND8
   1 8 SOUND8A   ;



\ =======================================================================
\                     IBM BIOS KEYBOARD EMULATION
\ =======================================================================

HEX
1B CONSTANT EXTENDED    ( when received, scancode instead of ASCII )
16 CONSTANT 16EMUL


\ int 16  fn 0
\ read ASCII from keyboard, return in AL.
\ if extended (non-ASCII) key, AL=0, Scancode is AH
\
\ we use DOS fn 08.

HEX
CREATE SCANCODE ( TRANSLATION TABLE )

L: INT16FN00         ( -- )
    08 #  AH MOV
    21 INT
    EXTENDED # AL CMP
    =0 IF,     ( need scancode )
       21 INT
       ( SCANCODE XLAT )  
       AL AH MOV
       AL AL XOR
       4100 # AX CMP
       =0 IF,  
		ASCII P  #  AX MOV  
	ELSE,
	       4200 # AX CMP
       		=0 IF,  
			ASCII N  #  AX MOV
      		ELSE,  
	       4400 # AX CMP
       		=0 IF,  
			ASCII P  #  AX MOV
      		ELSE,  
	       4300 # AX CMP
       		=0 IF,  
			ASCII N  #  AX MOV
      		THEN,  
              THEN,
            THEN,
          THEN,
 THEN,
    RET

END-CODE


\ int 16  fn 1
\ check keyboard status
\ key available : clear zero flag  ( not-zero condition )
\
\ it is the copy of the flag register on the stack we
\ are to modify, without corrupting registers.
\
\ DOS fn 0B has similar function.


HEX 0040 CONSTANT ZeroFlag
VARIABLE TEMPCS
VARIABLE TEMPIP
VARIABLE TEMPFL

L: INT16FN01         ( -- )

    CS: TEMPIP [] POP       ( ret addr to memory )
    CS: TEMPCS [] POP       ( cs to mem )
    CS: TEMPFL [] POP       ( flags to mem )           ( 1 )
    AX PUSH
    0B # AH MOV    ( DOS fn check input status )
    21 INT         ( AL=0FF if key available )
    CBW            ( AX=0FFFF if key available )       ( 2 )
    CS: TEMPFL [] AX XOR                               ( 3 )
    AX NOT                                             ( 4 )
    ZeroFlag # AX AND                                  ( 5 )
    CS: AX TEMPFL [] XOR                               ( 6 )
    AX POP
    CS: TEMPFL [] PUSH
    CS: TEMPCS [] PUSH
    CS: TEMPIP [] PUSH
    IRET





\ IBM BIOS keyboard services emulator, INT 16 replacement handler
L: KEYB-EMULATION
        0 # AH  CMP   ( READ KEY )     =0  IF,  INT16FN00 CALL  ELSE,
        1 # AH  CMP   ( STATUS )       =0  IF,  INT16FN01 JMP   THEN,
\ the other functions we don't emulate for hitchhiker's guide
                                          THEN,      IRET



\ =======================================================================
\                     IBM BIOS DEVICE LIST EMULATION
\ =======================================================================


2 BASE !
L: DEVICE-EMULATION
      0000000001001101 # AX MOV
      IRET



\ =======================================================================
\                     IBM printer emul
\ ======================================================================


HEX


L: INT17FN00
	DX PUSH
	5 #  AH MOV
	AL DL MOV
	21 INT
	DX POP
	0D0 # AH MOV
	RET
END-CODE    


2 2 IN/OUT
: INT17FN01   
  	00FF AND   0D000 OR  ;

2 2 IN/OUT 
: INT17FN02   ( BX AX -- BX AX )  
	00FF AND    0D000 OR    ;




L: PRN-EMULATION
        0 # AH  CMP   ( PRINT AL )     =0  IF,  CALL'  INT17FN00  ELSE,
        1 # AH  CMP   ( INIT     )       =0  IF, CALL'  INT17FN01  ELSE,
	2 # AH  CMP   ( STATUS )        =0 IF,   CALL' INT17FN02 
       THEN,   THEN,  THEN,  	IRET
END-CODE





\ =======================================================================
\                     IBM BIOS VIDEO EMULATION
\ =======================================================================

HEX
FALSE #IF
CREATE LAST-ATTR  -1 ,

HEX
: SHOW-ATTR  ( N -- )	CURSOR @   BASE @ 
        2 BASE !
        ROT  20 0 AT   10 U.R
        BASE !   CURSOR !    ;

#THEN

1 0 IN/OUT 
: PUT-ATTR ( ATTR -- ) 
\     DUP LAST-ATTR <>  IF
\            DUP SHOW-ATTR
\            DUP LAST-ATTR !	
\                 THEN
     0007 AND  0=  IF    REVERSE
              ELSE   NORMAL   THEN ;



REQUIRE INT10FN06
CODE CLS    
        0184F # AX MOV   AX PUSH   ( WINDOW END )
 	 0000 # AX MOV   AX PUSH   ( WINDOW START )
                         AX PUSH   ( CLEAR SCREEN )
			 AX INC    ( normal attribute )
                         AX PUSH   ( ATTRIBUTE )
        CALL' INT10FN06    ( SCROLL / CLS )
	RET    
END-CODE 



0 0 IN/OUT 
: INT10FN00   ( SET MODE )    MESSAGE   SOUND   ;


: INT10FN02   ( YX -- )  ( CURSOR TO DH=LINE DL=COLUMN )
     DUP 0FF AND  SWAP  ><  0FF AND  AT PUT-CURSOR  ;
	

: 'LINE ( N -- SEG OFF )
        CHARS/LINE 2* * +SCROLLED  VSEG @ SWAP  ; 
  
HEX      
\ CX DX AX BX
: INT10FN06  ( YXEND YXSTART N ATTR -- )
        PUT-ATTR
	0FF AND 
        DUP 0= IF 
	  2DROP DROP 
          184F ( BOTTOM RIGHT )
          0000 ( UPPER LEFT )
          19   ( 25 LINES )
       THEN  SCROLLWINDOW  ;



: SCROLLWINDOW  ( YXEND YXSTART N -- )
        ROT >< 0FF AND  
	ROT >< 0FF AND 

          >R 1+ TUCK R@ - MIN
          TUCK - SWAP OVER R>

          ?DO
            DUP I + 'LINE
	        I   'LINE
    	    CHARS/LINE 2* CMOVEL
          LOOP
          0 ?DO
            DUP 'LINE 
            CHARS/LINE 2*  
            ATTR @ BL +
            LFILLW   1+
          LOOP  DROP  ;



0 0 IN/OUT 
: INT10FN05   ( PAGE ZERO )    ;


: INT10FN09   ( N ASC ATTR -- )   ( SEND AL WITH ATTR BH  CX TIMES )
	PUT-ATTR 
	0FF AND SWAP 0 
	?DO   DUP I +PUTCHAR
	LOOP DROP  ;		


2 2 IN/OUT 
: INT10FN0F   ( BX AX -- BX AX )  
	DROP 00FF AND 05003 ( CHARS , MODE ) ;

HEX




L: VIDEO-EMULATION 
		SAVE-REGISTERS

		        0 # AH CMP  =0 
  IF,  			BX PUSH AX PUSH
	 		CALL' INT10FN00     ( SET MODE ) 
			AX POP BX POP			ELSE,

        		2 # AH CMP  =0
    IF,   		BX PUSH AX PUSH DX PUSH   
          		CALL' INT10FN02  
			AX POP BX POP ( CURSOR TO X,Y )   ELSE,

		        5 # AH CMP  =0
      IF,  		CALL' INT10FN05  ( SWITCH PAGE )     ELSE,

		        6 # AH CMP  =0
        IF, 		BX PUSH AX PUSH  DX PUSH CX PUSH AX PUSH BX PUSH
			CALL' INT10FN06  ( SCROLL / CLS )  
			AX POP BX POP			ELSE,

     			9 # AH CMP  =0
          IF,           BX PUSH AX PUSH CX PUSH  AX PUSH  BX PUSH 
    		 	CALL' INT10FN09  ( OUTPUT CHAR )
			AX POP BX POP			ELSE,

		        F # AH CMP  =0
            IF, 	CALL' INT10FN0F  ( VIDEO PARAMETER )  ELSE,
            THEN,
          THEN,
        THEN,
      THEN, 
    THEN,
  THEN,

  RESTORE-REGISTERS
  IRET
END-CODE




\ ===========================================================
\               IBM BIOS EMULATING LOADER
\ ===========================================================
INCLUDE FORTHLIB
TRANSIENT

: >IDENTIFICATION   ( OFFS -- OFFS' )
	IDENTIFICATION + VIDEO-EMULATION - ;

HEX 
: ALREADY?   ( -- F )
	10 GET-HANDLER  >IDENTIFICATION 
	?CS: VIDEO-EMULATION  >IDENTIFICATION 
	2OVER 2OVER D= NOT >R
	ID-LEN  COMPAREL
	?DUP NIP R> AND ;



1 0 IN/OUT
   HERE 1 ALLOT                                                   HEX
VARIABLE of       1 of !  \ dos file handle
   CODE DOSEMIT
       AL OVER [] MOV
       40 # AH MOV
       1 # CX MOV
       DUP # DX MOV
       of [] BX MOV
       21 INT
       RET
    END-CODE DROP


DECIMAL
: INTRO-MSG
\     REVERSE
 11 4 AT  ." Sirius Initializer for Hitchhiker's Guide to the Galaxy." ;


: INSTALL-MSG
 5 6 AT  ." Stays resident in memory (grabs 3Kb). HITCH EXE without this will crash."

 11 8 AT  ." Issue + NoCreditWare 1991. Tea will be served shortly..."   

 32 10 AT ." (Hit a key)" ;


: INSTALLED-MSG
 13 6 AT  ." HITCHER is already installed. HITCH EXE can be run." 

 11 8 AT  ." Issue + NoCreditWare 1991. Tea will be served shortly..."   ;



DECIMAL
: MAIN

        SETUP-VID
        25 0 DO 10 DOSEMIT LOOP \ put DOS cursor at bottom ( 25 linefeeds )
        INTRO-MSG        
\     10 0 DO   0 0 DO LOOP   LOOP   
        ALREADY?
        IF INSTALLED-MSG 1 RETURN \ error level to DOS, exit directly
        ELSE INSTALL-MSG

	KEY DROP

 	[HEX]

        ?CS: VIDEO-EMULATION  10 SET-HANDLER
	?CS: DEVICE-EMULATION 11 SET-HANDLER
        ?CS: KEYB-EMULATION   16 SET-HANDLER
        ?CS: PRN-EMULATION    17 SET-HANDLER

        0 TSR  

	THEN
;

INCLUDE FORTHLIB
END
