page	42, 132
name	Init_voc

public	audio_init
public	keybuf
public	iobuf

extrn	initvoc : near
extrn	initkey : near

codec	segment	public 'code'
	assume	cs: codec, ds:codec

key_record_len equ 54

; This routine allocates the memory necessary for the Audio Toolkit Kernal.
; The Audio Toolkit Kernal requires two seperate memory areas - one to keep
; track of the key names  and the other to store the  actual Voice or Sound
; data. There are two variables that define the size of these memory areas:
; NUM_KEYNAMES and BUF_SIZE.  NUM_KEYNAMES should be equated to the maximum
; number of keys that the user program will need to load at one time, while
; BUF_SIZE  should be equated  with the  maximum number  of paragraphs that
; will be required by a  Voice or Sound during program execution. The maxi-
; mum number  of keys allowed is 128,  while the  maximum  amount  of Voice
; memory is 3200 paragraphs, or 50 Kilobytes.  This module is currently set
; up for the maximum size Key Table and Voice Buffer.
;
; By editing the values of  NUM_KEYNAMES and BUF_SIZE,  the user can tailor
; the Audio Kernal  to use only as much memory as is required by the appli-
; cation program.  After assembling  this module,  the application  program
; will use only the necessary amount of memory.

NUM_KEYNAMES	equ	128  	    
BUF_SIZE	equ	3200  	      		; paragraphs  ( 50K buffer )

; Allocate enough memory for the specified number of keys.

keybuf	db	0
	org	$ + ( ( NUM_KEYNAMES * key_record_len )	+ 16 )

; Allocate enough memory for the voice buffer.

iobuf	db	0
	org	$ + ( ( BUF_SIZE + 1 ) * 16 )

audio_init proc far

	mov	ax, num_keynames
	call	initkey				; initialize key name buffer

	mov	ax, buf_size
	call	initvoc				; initialize sound buffer
	ret

audio_init endp
codec    ends
         end
