	NAME	EPSON
	PAGE	64,132
	TITLE	EPSON.COM     SETUP UTILITY FOR EPSON PRINTER
;------------------------------------------------------------------------
;    EPSON.COM - Version 1.0 - Setup Utility for Epson Printer		;
;    by:    Douglas Ritari		DATE:  December 6, 1983		;
;    Published in PC-TECH Journal, Sept 1984    Vol. 2, No. 3		;
;------------------------------------------------------------------------
;    1.01    Changed int 17 to int 21 function 5 for Victor 9000	;
;------------------------------------------------------------------------

MAIN	SEGMENT	PARA	PUBLIC	'CODE'
	ORG	100H
START	PROC	FAR

	ASSUME	CS:MAIN,DS:MAIN,ES:MAIN,SS:MAIN

	JMP	SSTART	;JUMP TO REAL START OF PROGRAM

;----------------------- INITIALIZE DATA VARIABLES ----------------------

SWITCH	DB	0	;switch for hex '/' seq.- either '0' or 'FFh'
SIXTEEN	DB	16	;the number 16 used in hex conversion multiplication
TESTPR	DB	0	;switch to test if any output was produced
DIGITS	DB	0	;number of hex digits processed - '0' or '1'
HEX	DB	0	;hexadecimal accumlator
PARM	DB	0	;move parameters to here - 1 byte at a time

;------------------------------------------------------------------------
;		BEGIN PROGRAM - SAVE RETURN ADDRESS TO DOS		;
;------------------------------------------------------------------------

SSTART:
	PUSH	DS	;save PSP segment address
	MOV	AX,0
	PUSH	AX	;save return address offset (PSP + 0)

;-------------- MOVE COUNT OF CHARACTERS INTO PARM AREA -----------------

	MOV	SI,80H	;source string offset (within PSP)
	LEA	DI,PARM	;destination string offset
	CLD		;set 'forward' string operations
	MOVSB		;move # of prams entered into 'parm' variable
	DEC	DI

;----------------------- SET UP PARM FIELD'S POINTERS -------------------

	MOV	AL,PARM	;put number of char. in parm in AL register
	MOV	CX,AX	;put number of char. in parm in CX register
	LEA	BX,PARM	;point to parms base address
	CMP	CX,0	;were no parms entered?
	JE	SEAREN	;send defaults - no parms - end program

	PAGE
;------------------------------------------------------------------------
;	PARM(S) WERE ENTERED - SEARCH FOR AND PROCESS PARAMETERS	;
;------------------------------------------------------------------------

SEAR:	MOVSB		;read in parm from command line
	DEC	DI
	MOV	AL,[BX]	;move next parm into input register
	CMP	AL,'a'	;
	JL	SEARCP	;do not modify this letter if lower than 'a'
	AND	AL,0DFH	;make caps
SEARCP:	CMP	AL,'/'	;Hex sequence begun or terminated
	JE	TOGGLE	;Turn escape sequence flag ON or OFF
	MOV	AH,0	;Clear AH register
	CMP	AH,SWITCH	;is hex sequence OFF?
	JNE	PASTHRU	;print char.'s hex value if hex switch is ON
	CMP	AL,'E'	;parm to EMPHASIZE?
	JE	PARM_E	;
	CMP	AL,'D'	;parm to DOUBLE-STRIKE?
	JE	PARM_D	;
	CMP	AL,'C'	;parm to COMPRESS?
	JE	PARM_C	;
	CMP	AL,'T'	;parm to TOP OF FORM?
	JE	PARM_T	;
	CMP	AL,'R'	;parm to REINITIALIZE PRINTER?
	JE	PARM_R	;
	CMP	AL,'I'	;parm to ITALICS?
	JE	PARM_I	;
	CMP	AL,'U'	;parm to UNI-DIRECTIONAL?
	JE	PARM_U	;
	CMP	AL,'W'	;parm to WIDE?
	JE	PARM_W	;
SEARBK:	LOOP	SEAR	;loop back for other parms

SEAREN:	JMP	PGMEND	;jump end-program proceedure

;------------- BACKSLASH TOGGLES HEXIDECIMAL INPUT MODE ON/OFF ----------

TOGGLE:	NOT	SWITCH
	JMP	SEARBK	;return to parm search procedure

;------------- EDIT FOR VALID HEXIDECIMAL NUMBERS -----------------------

PASTHRU: 
	SUB	AL,'0'	;convert from ASCII to binary
	JC	BELEND	;end program if wrong parm - sound bell
	CMP	AL,9	;check for digit > 9
	JBE	PASTHR2	;valid number - jump to math routine call
	SUB	AL,7	;convert from ASCII HEX A-F to binary
	JC	BELEND	;end program if wrong parm - sound bell
	CMP	AL,0FH	;check for digit > 15
	JA	BELEND	;end program if wrong parm - sound bell
PASTHR2:
	CALL	HEXMATH	;convert input parm to hex number
	JMP	SEARBK	;return for next parm

	PAGE

;-------------- PRE-DEFINED EPSON PRINTER PARMS PROCEDURE ---------------

PARM_E:	MOV	AL,'E'	;code for EMPHASIZED font
	CALL	ESCAPE
	JMP	SEARBK

PARM_D:	MOV	AL,'G'	;code for DOUBLE-STRIKE mode
	CALL	ESCAPE
	JMP	SEARBK

PARM_C:	MOV	AL,0FH	;code for COMPRESSED font
	CALL	PRINTER	;compressed mode does not need escape prefix
	JMP	SEARBK

PARM_T:	MOV	AL,0CH	;code for TOP-OF-FORM
	CALL	PRINTER	;Form Feed does not need escape prefix
	JMP	SEARBK

PARM_R:	MOV	AL,'@'	;code for RESET
	CALL	ESCAPE
	JMP	SEARBK

PARM_I:	MOV	AL,'4'	;code for ITALICS font
	CALL	ESCAPE
	JMP	SEARBK

PARM_U:	MOV	AL,'U'	;code for SET UNI-DIRECTIONAL mode
	CALL	ESCAPE
	MOV	AL,1	;code to set mode ON
	CALL	PRINTER
	JMP	SEARBK

PARM_W:	MOV	AL,'W'	;code for PERMANENT DOUBLE-WIDE font
	CALL	ESCAPE
	MOV	AL,1	;code to set mode ON
	CALL	PRINTER
	JMP	SEARBK

;----------------------- END OF PROGRAM PROCEDURE -----------------------

BELEND:	MOV	DIGITS,0	;clear unpaired digits hex check
	MOV	AL,07H		;bad parm in program - sound bell
	CALL	PRINTER		;program ended with errors!
PGMEND:	CMP	DIGITS,0	;was unpaired hexcodes entered?
	JNE	BELEND		;sound bell to signal error
	CMP	TESTPR,0	;
	JE	DEFAULT		;no output was produced - send default

	RET			;return to DOS - end of program

	PAGE
;------------------------------------------------------------------------
;  NO PARMS WERE ENTERED - DEFAULT SETTING OF DOUBLE-STRIKE/EMPHASIZE	;
;------------------------------------------------------------------------

DEFAULT:
	MOV	AL,'G'	;put DOUBLE-STRIKE code in output register
	CALL	ESCAPE	;
	MOV	AL,'E'	;put EMPHASIZE code in output register
	CALL	ESCAPE	;
	JMP	PGMEND	;jump to end-of-program routine

	START 	ENDP

;--------------- ESCAPE SUBROUTINE - SEND ESCAPE CODE TO PRINTER --------

ESCAPE	PROC	NEAR
	PUSH	AX	;save potential char. to be printed on stack
	MOV	AL,1BH	;move escape char to out register
	CALL	PRINTER	;send character to printer
	POP	AX	;get char from stack
	CALL	PRINTER	;send it to printer
	RET
ESCAPE	ENDP

;--------------- PRINTER SUBROUTINE - ALL PRINTING IS DONE HERE ---------

PRINTER	PROC	NEAR		;SEND CHARACTER IN AL REGISTER TO PRINTER
	MOV	TESTPR,1	;valid output has ben produced
	MOV	DL,AL		;set register for printer output interrupt
	MOV	AH,5		;set register for printer output interrupt
	INT	21H		;call printer driver in BIOS
	RET
PRINTER	ENDP

;--------------- CONVERT INPUT PARMS TO HEXIDECIMAL NUMBERS -------------

HEXMATH	PROC	NEAR		;ROUTINE TO CONVERT PARM TO HEX NUMBERS
	CMP	DIGITS,0	;0 -> 1st #, 1 -> 2nd #
	JNE	MATH2		;jump & process 2nd #
	MUL	SIXTEEN		;multiply 1st # by 16
	MOV	HEX,AL		;clear & store result in HEX
	INC	DIGITS		;1st number processed
	RET

MATH2:	ADD	AL,HEX		;total the two hex digits
	MOV	DIGITS,0	;clear digit variable for future parms
	CALL	PRINTER		;send hex # in AL to printer
	RET
HEXMATH	ENDP

;------------------------------------------------------------------------

MAIN	ENDS
	END	START
