;                          PROGRAM  GRFX
;
;      Program to send commands to the Victor 9000 Grafix Kernel
;            from the  DOS  command line in the Text Window.
;
;                           Written by
;
;                           J. E. Diem
;                         2020 Short St
;                     New Orleans, LA 70118
;
;                   Tel. Home (504)866-7214
;                        Work (504)588-5265
;                        Work (504)865-5727
;
;                         March 7, 1984
;
;   The Grafix command and parameters, if any, are passed to GRFX
;   from the DOS command line.  No error checking is done by GRFX.
;
;                             USAGE
;        At DOS command line type   GRFX command [par1 [,par2]...]
;        followed by a (CR).
;                           Examples
;        1: GRFX U 100,300 (CR)  draws a line from the current Grafix
;              cursor position to screen coordinates 100,300.
;        2. grfx 4 (CR)  enables Grafix.
;        3. grfx 3 (CR)  disables Grafix.   
;        4. GRFX pTEST STRING (CR)  prints the string 'TEST STRING'
;              at the current Grafix cursor position using the
;              currently enabled character set.
;
STACK    SEGMENT PARA STACK 'STACK'
         DB      100 DUP(0)       ;100 bytes of stack space
STACK    ENDS
;
DATA     SEGMENT PARA PUBLIC 'DATA'
LNGTH    DB      0                ; length of parameter string input
                                  ; to GRFX gets moved to here.
PARM     DB      128 DUP(0)       ; parameter string input to GRFX
                                  ; gets moved to here.
DATA     ENDS
;
CODE     SEGMENT PARA PUBLIC 'CODE'
MAIN     PROC    FAR
;
         ASSUME  CS:CODE
         PUSH    DS               ;save address for return from
         MOV     AX,0             ;program to DOS.
         PUSH    AX
;
;       This block moves parameter string passed to GRFX from
;           DOS command line and its length from the
;            Program Segment Prefix (PSP) to DATA.
;
;  The string is moved from PSP:81H to OFFSET PARM in data segment;
;  its length is moved from PSP:80H to OFFSET LNGTH in data segment.
;  
;  Before the move DS must point to PSP as the source segment of 
;  the strings to be moved; ES must point to DATA as the destination
;  segment.  Since DOS, on loading GRFX, makes DS and ES point to
;  PSP, ES must be made to point to DATA before the move; DS is made
;  to point to DATA after the moves.
;
         MOV     AX,DATA          ;set up addressability for
         MOV     ES,AX            ;designation in DATA of 
         ASSUME  ES:DATA          ;parameter string and its length.
;
                                  ;DS still points to start of PSP.
                                  ;ES now points to DATA.
;
         MOV     SI,80H           ;move length of parameter
         MOV     DI,OFFSET LNGTH  ;string from PSP:80H to
         CLD                      ;to LNGTH in
         MOVSB                    ;data segment.
;
         MOV     CL,DATA:LNGTH    ;CX now holds what is in DS:80H
         MOV     CH,0H            ;i.e. length of parameter string
                                  ;passed to GRFX.
; 
         MOV     SI,81H           ;move parameter string
         MOV     DI,OFFSET PARM   ;from PSP:81H to
         CLD                      ;PARM in
         REP     MOVSB            ;data segment.
;
;  The parameter string is now at OFFSET PARM in DATA;
;  its length is at OFFSET LNGTH in DATA
;
         MOV     AX,DATA          ;make DS point 
         MOV     DS,AX            ;to data segment.
         ASSUME  DS:DATA
;
         MOV     AH,2H            ;move to AH number of function which
                                  ;outputs character to console.
         MOV     DL,1BH           ;output ESC
         INT     21H              ;to GRAFIX.
         MOV     DL,35H           ;output "5"
         INT     21H              ;to GRAFIX.
;
;     prepare to output the parameter string to GRAFIX
;
         MOV     BX,OFFSET PARM   ;make BX point to start of parameter string.
;
         MOV     CL,LNGTH         ;put length of parameter
         MOV     CH,0H            ;string in CX.
         DEC     CX               ;decrements length of string by 1
                                  ;to account for leading space.
;
ST_LP:   MOV     DL,[BX+1]        ;This loop 
         INT     21H              ;outputs the
         INC     BX               ;the parameter string
         LOOP    ST_LP            ;to GRAFIX.
;
         MOV     DL,0DH           ;output a
         INT     21H              ;CR and a
         MOV     DL,0AH           ;LF to
         INT     21H              ;GRAFIX.
;
         RET                      ;return to DOS.
MAIN     ENDP
CODE     ENDS
         END
