;
UDC_passthru:				;unrecognized call & recursing exit..
	jmp  CS:dword ptr UDC_CONvector ;...for passing on control

UDC_entry:
	cmp	ax,UDC_maxsubfn
	ja	UDC_passthru		;if not valid pass it on
	push	bx			;	(save bx)
	mov	bl,0ffh			;set UDC_semaphore and
	xchg	bl,cs:UDC_semaphore	;  keep previous setting
	or	bl,bl			;If previous non_zero then recursing
	pop	bx			;	(restore bx)
	jnz	UDC_passthru		;Recursing. Pass request on.

	push	ds
;
	mov	cs:save_es,ES		;save entry vector
	mov	cs:save_bx,bx		;save entry vector
;
	mov	bx,cs
	mov	ds,bx
	mov	es,bx

	mov	bx,ax			;dispatch to UDC subfunctions
	shl	bx,1
	jmp 	UDC_dispatch[bx]


;   /*
;    *	User Defined Console GET subfunction #0
;    */

UDC_get:
;   /*
;    *	user coded section for UDC get
;    */

	call	USERget
;   /*
;    */ 

	jmp	UDC_exit



;   /*
;    *	User Defined Console GET STATUS subfunction #2
;    */

UDC_getstat:

;   /*
;    *	user coded section for UDC getstat
;    */

	call	USERgetstat
;   /*
;    */ 

	jmp	UDC_exit

;   /*
;    *	User Defined Console PUT subfunction #1
;    */

UDC_put:
	cmp	UDC_pending,0		;check pending multi-sequence
	jne	UDC_passthruput		;last callee wants more

;   /*
;    *	user coded section for UDC put
;    */
	call	USERput
;   /*
;    */ 

UDC_exit:
	MOV	UDC_semaphore,0
	pop	ds
dummy	proc	far
	ret
dummy	endp

UDC_passthruput:
	call    dword ptr UDC_CONvector
	mov	UDC_pending,al		;save multi-sequence flag
	jmp	UDC_exit


;   /*
;    *	User Defined Console PUT STATUS subfunction #3
;    */

UDC_putstat:

;   /*
;    *	user coded section for UDC putstat
;    */

	call	USERputstat
;   /*
;    */ 

	jmp	UDC_exit

;   /*
;    *	User Defined Console GET VECTOR subfunction #4
;    */

UDC_GETvector:
	mov	bx,offset UDC_CONvector
	mov	ax,2[bx]
	mov	es,ax
	mov	bx,0[bx]
	mov	al,0ffh			;return proper status
	jmp	UDC_exit		;modified B.E.M. 6/17/82


;   /*
;    *	User Defined Console SET VECTOR subfunction #5
;    */

UDC_SETvector:
	mov	ES,save_es		;restore
	mov	bx,save_bx		;  vector pointers
	mov	word ptr UDC_CONvector,bx
	mov	word ptr UDC_CONvector+2,es
	jmp	UDC_exit		;modified B.E.M. 6/24/82



;   /*
;    *	User Defined Console GET ID subfunction #6
;    */

UDC_GET_ID:
	mov	ax,UDC_CALC_ID		; return my id
	jmp	UDC_exit




;   /*
;    *	external references to subservient console routines
;    */

UDC_conin:
	xor	ax,ax			;get subfunction #0
	call    dword ptr UDC_CONvector
	ret				;return AL= input data byte

UDC_conout:					;CL= output data byte
	mov	ax,1			;get subfunction #1
	call    dword ptr UDC_CONvector
	mov	UDC_pending,al		;record pending multi-code state
	ret

UDC_coninstat:
	mov	ax,2			;get stat subfunction #2
	call	dword ptr UDC_CONvector
	ret				;return AL= input status byte

UDC_conoutstat:
	mov	ax,3			;get stat subfunction #3
	call	dword ptr UDC_CONvector
	ret				;return AL= console output status

UDC_init:			;jump entry point for .CMD module startup
	mov	ax,ds			;ready to request vector
	mov	es,ax			;set the ES: to  internal data/code
	mov	bx,offset udc_getparms	;point to BIOS vector destination
	mov	ax,14			;request get vector
	int	xbiosint		; call super bios
	or	ax,ax			;error from super BIOS?
	jnz	udc_initerr			;yes, error exit
;
;  Now check if the calculator is already installed
;
	mov	ax,UDC_CONvector	; Move first UDC address to
	mov	UDC_next,ax		;    UDC_next
	mov	ax,UDC_CONvector+2	;	(both
	mov	UDC_next+2,ax		;	      words)

UDC_check:
	mov	ax,UDC_GET_ID_Fn
	call dword ptr UDC_next		; Who is there?
	cmp	ax,UDC_CALC_ID
	jne	UDC_not_I

	mov	dx,offset alrdy_in_msg	; Calculator already in.
	jmp short UDC_INITerr_msg	; Abort

UDC_not_I:
	mov	ax,UDC_GETvectorsubFn	; Get next UDC vector
	call dword ptr UDC_next
	mov	ax,es
	or	ax,bx			; Was return zero?
	jz	UDC_check_ok		;  Yes. All done.
;					;  No. Carry on.
	mov	UDC_next,bx		;Store next UDC vector
	mov	UDC_next+2,es		;	address
	jmp short UDC_check		;Check next UDC

UDC_check_ok:
	mov	bx,DS			;set to internal 
	mov	ES,bx			; vector segment
	mov	bx,offset udc_setparms	;point to secondary UDC carrier
	mov	4[bx],cs		;set vector addr seg,off is set by dw
	mov	ax,15			;request set vector
	int	xbiosint		;call Super Bios to set vector addr
	or	ax,ax			;error from Super Bios??
	jnz	udc_initerr			;bad error - exit

	mov	UDC_pending,0
;  /*
;   *	user initialization code goes here
;   */
	call	USERinit

	CALL	SIGNON			;DISPLAY SIGNON MSG
	mov	dx,offset endpgm+1	;point to last byte of pgm+1
	int	msres
;	ret far

UDC_INITerr:
	mov	dx,offset UDC_errmsg
UDC_INITerr_msg:
	mov	ah,9
	int	msdos			;Display first part of msg

	mov	dx,offset err_signon
	mov	ah,9
	int	msdos			;Display standard part of err msg

	int	msend			; MS-DOS function -- End of Job


SIGNON:
	MOV	ah,9			;CONSOLE STRING OUT
	MOV	DX,OFFSET SIGNON1	;ADDR OF SIGNON MSG
	INT	msdos
	RET

