	page


; vcalc(cl=shift-calc code) - next-to-outermost level
; of calculator.
; interface is non-standard:
;	*entered with a short call on a stack not our own,
;	 ds is set, ss & sp reference another stack, es
;	 is not defined.
;	*cl = charcode for shift-calc key
;	*return with es:bx indicating long string descriptor
;	 for numeric exit string.

vcalc:	mov	parss,ss	;save father's sseg
	mov	parsp,sp	;and his sp
	mov	ax,ds		;now pick up our ds
	mov	es,ax		;copy to es
	mov	ss,ax		;copy to ss
	mov	sp,offset stbeg	;set init sp
	mov	exitcode,cl	;log down exitcode
	cld			;set forward-going stringops
	call	calcinit	;perform calculator prolog
	call	main		;enter calculator proper

; return from main or jump here for exit

exit:
	mov	sp,offset stbeg	;reinit our stack
	call	calcexit	;perform epilog functions

; at this point we have es:bx indicating long descriptor
; for the exit string.  Don't step on it.

	mov	ss,parss	;get parent's sseg
	mov	sp,parsp	;and his sp
	ret			;and ret (no args)
	

; calcinit() - perform prolog functions for calculator

calcinit:
	push	bp		;save caller frp
	mov	bp,sp		;set cur frp

; disable exit-string accrue during startup putstrs,
; first call to display will reset to normal state

	mov	exstrp,offset exstre ;move ptr beyond buf

; if not debugging, save screen status (just cursor
; position at this time), get down to the status line,
; and get it in shape.

	cmp	debug,0		;debugging?
	jne	calcin10	;if so, bypass
	push	ocins1		;else psh o(report cur)
	call	putstr		;and emit same
	call	conin		;get 1st byte of pos
	mov	savepos0,al	;set in exit string
	call	conin		;get 2nd byte of pos
	mov	savepos1,al	;set in exit string
	call	conin		;get 3rd byte of pos
	mov	savepos2,al	;set in exit string
	call	conin		;get 4th byte of pos
	mov	savepos3,al	;set in exit string
	push	ocins2		;now psh o(remaining cmds)
	call	putstr		;and emit them
calcin10:

; Startup functions complete; clean up stack and return

	mov	sp,bp		;peel off autos
	pop	bp		;get back caller frp
	ret			;and return
	

; (calcinit continues)
	

; calcexit() - handle epilog functions for calculator

calcexit:
	push	bp		;save caller frp
	mov	bp,sp		;set current frp

; disable further exit-string accrual

	mov	exstrp,offset exstre ;move ptr beyond buf

; If debugging, put out exitstring to the console;
; in any case set up a long descriptor for this
; string.

	cmp	debug,0		;debugging?
	je	calcex10	;n, forget this
	push	ocexs1		;y, psh 'exitstr=*'
	call	putstr		;emit same
	mov	ax,offset exstro ;form o(string)
	push	ax		 ;push this
	call	putstr		;emit same
	push	ocexs2		;psh '*crlf'
	call	putstr		;emit terminator
calcex10:
	mov	exstrds,ds	;set longdescr seg
	mov	ax,offset exstro;form o(string)
	mov	exstrdo,ax	;set longdescr off
	push	ax		;now psh o(str)
	call	strlen		;compute length
	mov	exstrdl,ax	;set longdescr len

; if not debugging, restore screen status.

	cmp	debug,0		;debugging?
	jne	calcex20	;if so, bypass
	push	ocexs3		;else psh o(cmdstr)
	call	putstr		;emit him
calcex20:

; get nonstandard return value in es:bx, then flow
; into ordinary stack mgmt code.

	mov	bx,offset exstrdl ;es=ds already

	mov	sp,bp		;peel off autos
	pop	bp		;retrieve caller frp
	ret			;ret (no args)
	

; (calcexit continues)
	

; main program

ma_cch	equ	-2		;current char

main:	push	bp		;save caller frp
	mov	bp,sp		;set cur frp
	sub	sp,2		;alloc autos

; start off by clearing accumulator and const regs,
; clearing opstack, and displaying zero.

	push	oa		;psh o(acc)
	call	zero		;zero same
	push	oc		;psh o(con)
	call	zero		;zero him also
	mov	stkop,0		;clear opstack
	push	oc		;psh o(con) again
	call	display		;and display him

; this is the top of the big state machine loop.

ma10:	call	vgetchar	;get one character
	mov	[bp]+ma_cch,ax	;log as current char
	push	ax		;psh isdig arg
	call	isdig		;see if digit
	cmp	ax,0		;was it a digit?
	jne	ma12		;if so, start accumulate
	jmp	ma70		;else go switch

; got a digit or radix...get ready to accumulate

ma12:
	cmp	lasttok,'='	;just seen eqop?
	jne	ma15		;no, proceed
	push	oa		;y, psh o(a)
	call	zero		;and zero him
ma15:
	mov	lasttok,0	;clr lasttok glob
	mov	pflag,0		;clr radptseen flg
	push	ok		;psh o(kbdreg)
	call	zero		;clr kbdreg

; top of accumulate loop - continue while ch is digit
; or radixpt.

ma20:	push	word ptr[bp]+ma_cch ;push char
	call	isdig		;call classifier
	cmp	ax,0		;a digit?
	je	ma70		;if not, go switch

; have digit or radixpt - enter in kbd reg.

	push	word ptr[bp]+ma_cch ;push char
	call	enter	            ;enter in kbdreg

; now get another char, log him in the frame, and
; flow into backspace test.

ma30:	call	vgetchar	;get one ch
	mov	[bp]+ma_cch,ax	;set in frame

; still in number-accrue loop, is this backspace?

	cmp	al,bac		;backsp cmd?
	jne	ma60		;no, ck for clr cmd
	cmp	pflag,0		;yes, radpt seen?
	je	ma40		;not radpt backover
	cmp	byte ptr k+r_rpos,0 ;right on radpt?
	jne	ma40		;not on radpt
	mov	pflag,0		;on radpt, just clr flg
	jmp short ma65		;and join display
ma40:	push	ok		;ordinary backsp,
	call	rshift		;just shift off 1 dig
	cmp	byte ptr k+r_rpos,0 ;nonneg fracdig?
	jge	ma45		;y, ck ndig too
	mov	byte ptr k+r_rpos,0 ;no, force zero
ma45:	cmp	byte ptr k+r_ndig,0 ; nonneg totdig?
	jge	ma65		;y, proceed
	mov	byte ptr k+r_ndig,0 ;no, force zero
	jmp short ma65		;and join display code

; still in number-accrue loop, is this clear char?

ma60:	cmp	al,clr		;clear cmd?
	jne	ma20		;no, handle as usual
	push	ok		;yes, psh o(kbdreg)
	call	zero		;zero the reg
	mov	pflag,0		;clear radptseen flg
ma65:	push	ok		;now psh o(kbdreg)
	call	display		;put it out
	jmp short ma30		;and get another char

; This character is not acceptable to number-accrue,
; possibly it is a command character.  We special-case
; the worthless integer-divide symbol right here, changing
; it to a '/'.  When that's done, enter the primary
; command switch.

ma70:	mov	ax,[bp]+ma_cch	;get command char
;	cmp	al,0f6h		;useless int-divide sym?
;	jne	ma75		;drive on if not
;	mov	ax,'/'		;xlate to / if so
;	mov	[bp]+ma_cch,ax	;set in frame also
ma75:	mov	bx,offset masw1	;get o(casetable)
	jmp	lswit		;and enter switchcode
	

; (main continues)
	

; (main continues)
; + and - postfix operators

maad:
	cmp	lasttok,'='	;just see eqop?
	jne	maad02		;proceed if not
	push	oa		;else push o(a)
	call	zero		;and zero him
maad02:
	cmp	lasttok,0	;just see num?
	je	maad05		;y, get on with add
	cmp	lasttok,'='	;seen eqop perhaps?
	jne	maad10		;n, skip addop
maad05:
	push	ok		;else psh o(k)
	push	oa		;and o(a)
	call	addx		;a +=k;
maad10:
	push	oa		;now psh o(a)
	call 	display		;display him
	mov	al,[bp]+ma_cch	;pick up cur ch
	mov	lasttok,al	;and set lasttok glob
	jmp	ma80		;leave big switch


masb:
	cmp	lasttok,'='	;just see eqop?
	jne	masb02		;proceed if not
	push	oa		;else push o(a)
	call	zero		;and zero him
masb02:
	cmp	lasttok,0	;just see num?
	je	masb05		;y, get on with sub
	cmp	lasttok,'='	;seen eqop perhaps?
	jne	masb10		;n, skip subop
masb05:
	push	ok		;else psh o(k)
	push	oa		;and o(a)
	call	subx		;a -= k;
masb10:
	push	oa		;now psh o(a)
	call 	display		;display him
	mov	al,[bp]+ma_cch	;pick up cur ch
	mov	lasttok,al	;and set lasttok glob
	jmp	ma80		;leave big switch
	

;(main continues)
; multiply and divide operations

maml:
madv:
	cmp	stkop,0		;anything on stack?
	jne	maml10		;y, ck for chainop
	cmp	lasttok,0	;num entered?
	jne	maml10		;n, ck for chainop
	push	ok		;else psh o(k)
	push	oc		;and o(c)
	call	rcopy		;c = k;
	jmp short maml20	;join display
maml10:
	cmp	lasttok,0	;num entered?
	je	chain		;y, join chainop
maml20:
	push	oc		;psh o(c)
	call	display		;display him
	push	oa		;psh o(a)
	call	zero		;zero a-reg
	mov	al,[bp]+ma_cch	;pick up cmdchar
	mov	lasttok,al	;set lasttok glob
	mov	stkop,al	;set stkop glob
	jmp	ma80		;leave big switch
	

; (main continues)
; = and % operators

maeq:
mapc:
chain:
	cmp	lasttok,'-'	;lasttok a -?
	je	maeq06		;y, go asg c to a
	cmp	lasttok,'+'	;lasttok a +?
	jne	maeq07		;no, go ck stackop
maeq06:
	push	oa		;else psh o(a)
	push	oc		;and o(c)
	call	rcopy		;c = a;
	jmp short maeq60	;join display
maeq07:
	cmp	stkop,0		;anything to pop?
	jne	maeq10		;yes, get on with it
	push	oc		;else get o(c)
	call	zero		;and zero him
	jmp	maeq60		;join display
maeq10:
	cmp	lasttok,0	;number keyed?
	je	maeq20		;yes, pop is useful
	jmp	maeq60		;else join display
maeq20:
	cmp	stkop,timesop	;stacked op times?
	jne	maeq30		;if not, try dvd
	push	ok		;else push o(k)
	push	oc		;and o(c)
	call	mulx		;call multiplier
	cmp	byte ptr[bp]+ma_cch,'%' ;percent?
	jne	maeq60		;n, join display
	cmp	err,0		;have percent, err?
	jne	maeq60		;omit div if err
	push	oh		;else psh oh
	push	oc		;and o(c)
	call	divx		;c /= 100.0;
	jmp short maeq60	;join display
maeq30:
	cmp	stkop,'/'	;stacked op a dvd?
	jne	maeq60		;if not, join display
	push	ok		;else psh o(k)
	push	oc		;and o(c)
	call	divx		;c /= k;
	cmp	byte ptr[bp]+ma_cch,'%' ;percentop?
	jne	maeq60		;if not, join display
	cmp	err,0		;have err already?
	jne	maeq60		;forget % if err
	push	oh		;else psh o(h)
	push	oc		;and o(c)
	call	mulx		;c *= 100.0;
maeq60:
	push	oc		;psh o(c)
	call	display		;display him
	push	oc		;psh o(c)
	push	ok		;and o(k)
	call	rcopy		;k = c;
	cmp	byte ptr[bp]+ma_cch,'%' ;percent op?
	jne	maeq61		;n, no xlate
	mov	byte ptr[bp]+ma_cch,'=' ;y, force eq
maeq61:
	cmp	byte ptr[bp]+ma_cch,'=' ;eq op?
	je	maeq62		;y, go set a=c
	push	oa		;else psh o(a)
	call	zero		;zero him
	jmp short maeq63	;join mainline
maeq62:
	push	oc		;equal op, get o(c)
	push	oa		;and o(a)
	call	rcopy		;set a = c;
maeq63:
	mov	al,[bp]+ma_cch	;pick up cmdchar
	mov	lasttok,al	;set lasttok
	cmp	al,'='		;eqop?
	jne	maeq64		;drive on if not
	mov	al,0		;else force 0
maeq64:
	mov	stkop,al	;set stkop glob
	jmp	ma80		;leave big switch
	

; (main continues)
; command character is not in switch, just beep
; and goto top of state machine.

madf1:
	call	beep		;make a noise
	jmp	ma10		;and start over

; main command switch ends here... do whatever cleanup
; is required, and reenter big state machine at top.

ma80:
	jmp	ma10		;join big statemachine

	

; addx(l,r) - add r reg to l reg

ad_ol	equ	4		;o(left reg)
ad_or	equ	6		;o(right reg)

addx:	push	bp		;save caller bp
	mov	bp,sp		;set cur frp
	push	word ptr[bp]+ad_ol ;psh o(lop)
	push	ot		   ;psh o(t-reg)
	call	rcopy		   ;s = *ol
	push	word ptr[bp]+ad_or ;psh o(rop)
	push	os		   ;psh o(s-reg)
	call	rcopy		   ;s = *or
	push	os		   ;psh doadd rop
	push	ot		   ;and doadd lop
	call	doadd		   ;sum to t-reg
	cmp	err,0		   ;error?
	jne	ad10	           ;no copyback if err
	push	ot		   ;else psh o(t-reg)
	push	word ptr[bp]+ad_ol ;and o(lop)
	call	rcopy		   ;copy back result
ad10:	mov	sp,bp		;delete autos
	pop	bp		;retrieve caller frp
	ret	4		;ret past 4 argbytes
	

; subx(l,r) - subtract r reg from l reg

sb_ol	equ	4		;o(left reg)
sb_or	equ	6		;o(right reg)

subx:	push	bp		;save caller bp
	mov	bp,sp		;set cur frp
	push	word ptr[bp]+sb_ol ;psh o(lop)
	push	ot		   ;psh o(t-reg)
	call	rcopy		   ;s = *ol
	push	word ptr[bp]+sb_or ;psh o(rop)
	push	os		   ;psh o(s-reg)
	call	rcopy		   ;s = *or
	mov	al,s+r_sgn	;pickup signcode
	xor	al,1		;toggle same
	mov	s+r_sgn,al	;and put back
	push	os		   ;psh doadd rop
	push	ot		   ;and doadd lop
	call	doadd		   ;sum to t-reg
	cmp	err,0		   ;error?
	jne	sb10	           ;no copyback if err
	push	ot		   ;else psh o(t-reg)
	push	word ptr[bp]+sb_ol ;and o(lop)
	call	rcopy		   ;copy back result
sb10:	mov	sp,bp		;delete autos
	pop	bp		;retrieve caller frp
	ret	4		;ret past 4 argbytes
	

; mulx(ol,or) -- multiply lop by rop

mul_ol	equ	4		;o(lop)
mul_or	equ	6		;o(rop)

mul_ti	equ	-2		;local temp
mul_tj	equ	-4		;local temp
mul_dd	equ	-6		;1st discarded digit

mulx:	push	bp		;save caller frp
	mov	bp,sp		;set cur frp
	sub	sp,6		;alloc autos
	mov	byte ptr[bp]+mul_dd,'0' ;init discard dig

; we'll be using the t and s global regs as work temps.
; Copy over lop and rop respectively.  The product will
; eventually appear in t, which will be copied back to
; lop if no errors occur.

	push	word ptr [bp]+mul_ol ;o(lop)
	push	ot		     ;o(t-reg)
	call	rcopy		     ;t = *ol
	push	word ptr [bp]+mul_or ;o(rop)
	push	os		     ;o(s-reg)
	call	rcopy		     ;s = *or

; we will be summing into the mdtmp vector; paint it
; with '0'.

	mov	di,offset mdtmp	;get o(mdtmp)
	mov	cx,vsize*2	;get mbrct for clrg
	mov	al,'0'		;get clrg val
	rep stosb            	;init vector

; Product sign is xor of opnd signs.  Product fracdigct
; is sum of opnd fracdig counts.  (May have to discard
; some fracdigits later.)

	mov	al,s+r_sgn	;pickup rop sign
	xor	t+r_sgn,al	;set result sign
	mov	al,s+r_rpos	;pick up rop fracdigct
	add	t+r_rpos,al	;set result fracdigct

	

; (mulx continues)
; This outer loop is executed s.ndig times.  For each
; digit, we'll shift mdtmp left one place, and then
; repetitively add in t.

mulx10:	cmp	byte ptr s+r_ndig,0 ;still have s digits?
	jne	mulx11		    ;if so, keep going
	jmp	mulx60		    ;if not, prod complete
mulx11:

; shift mdtmp one place left (toward msd)

	lea	si,mdtmp+vsize*2-2 ;set src idx
	lea	di,[si]+1	   ;and dst idx
	mov	cx,vsize*2-1	   ;and shiftct
	pushf			   ;pres flgs
	std		           ;get in decrmode
	rep movsb                  ;shift one pl
	popf			   ;get out of decmode
	mov	mdtmp,'0'	   ;shift in a '0'

; pick up current s-digit and debias him from the ascii.
; This will be the number of times we'll add t.  log
; this number down in a local variable.

	dec	byte ptr s+r_ndig   ;pre-decr s.ndig
	mov	bl,s+r_ndig	;this is digitidx
	mov	bh,0		;zero-extend him
	mov	al,s+r_v[bx]   ;pick up digit
	sub	al,'0'		;debias him
	cbw			;ext to fullwd
	mov	[bp]+mul_ti,ax	;log in framevar

; This is inner loop, to be executed mul_ti times.
; On each pass we add t to mdtmp.

mulx20:	cmp	word ptr[bp]+mul_ti,0 ;done yet?
	je	mulx10		;yes, back to outerloop
	dec	word ptr[bp]+mul_ti   ;n, dec fornexttime
	mov	carry,0		;init carry for this addn
	mov	word ptr[bp]+mul_tj,0 ;init digidx for add
mulx30:	mov	bx,[bp]+mul_tj	      ;get in idxreg
	cmp	bl,t+r_ndig	      ;hit ndig yet?
	jge	mulx40		      ;yes ck final carries
	mov	al,mdtmp[bx]	      ;pickup mdtmp dig
	sub	al,'0'		      ;debias fr ascii
	add	al,t+r_v[bx]	      ;add t-dig&rebias
	add	al,carry	      ;add pndg carry
	cbw		              ;ext to fulwrd
	push	ax		      ;now psh dig
	call	adj		      ;adj same, set carry
	mov	bx,[bp]+mul_tj        ;get digidx back in bx
	mov	mdtmp[bx],al	      ;set dig in mdtmp
	inc	word ptr[bp]+mul_tj   ;inc digidx
	jmp short mulx30		;and repeat
	

; still in inner loop, with one t-addition almost done.
; propagate final carry into j-th (and succeeding)
; mdtmp digits.

mulx40:	cmp	carry,0		;have carry?
	je	mulx20		;no, t-addn complete
	mov	bx,[bp]+mul_tj	;y, get j in idx
	mov	al,mdtmp[bx]	;get j-th mdtmp digit
	add	al,carry	;plus carry
	cbw		        ;converted to fulwrd
	push	ax		;is arg for adj
	call	adj		;adj dig, set new carry
	mov	bx,[bp]+mul_tj  ;retrieve j-idx
	mov	mdtmp[bx],al	;store updated digit
	inc	word ptr[bp]+mul_tj ;bump to next digit
	jmp short mulx40	;and repeat

; Outer loop is complete and mdtmp holds the product digits.
; Starting at most-sig end of mdtmp, scan for the first
; non-zero digit.  Hitindex+1 will be the tentative digit
; count.

mulx60:	mov	word ptr[bp]+mul_ti,vsize*2 ;init scanidx
mulx70: dec	word ptr[bp]+mul_ti	;dec to next item
	jl	mulx80			;quit below zero
	mov	bx,[bp]+mul_ti		;get scanidx in reg
	cmp	mdtmp[bx],'0'		;curdig a '0'?
	je	mulx70		        ;keep going if 0
mulx80:	mov	ax,[bp]+mul_ti		;done, get curidx
	inc	ax			;and form digitct

; product ndig can't possibly be less than product rpos, 
; take product rpos as minimum value.

	cmp	al,t+r_rpos		;ndig v.rpos
	jge	mulx90			;ok if ge
	mov	al,t+r_rpos		;else get rpos
	cbw				;and make fullwd
mulx90:	mov	[bp]+mul_ti,ax		;set i=product ndig

; intpart digits aren't dispensable - if they won't
; all fit in a register, declare overflow and quit now.

	sub	al,byte ptr t+r_rpos	;form intdigct
	cmp	al,vsize		;v. reglength
	jle	mulx100			;continue if fit ok
	mov	err,offset ovfs		;won't fit,set errvar
	jmp	mulx150			;and quit now

; product is known to fit one way or the other, compute
; overhang to be trimmed off.

mulx100:mov	ax,[bp]+mul_ti		;get prod ndig
	sub	ax,vsize		;less vsize

; neg overhang means product fits without trimming,
; just force up to zero and let matters run their course.

	jge	mulx110			;cont if ge 0
	sub	ax,ax			;else force 0

; Overhang gt 0 means we need to trim off that many
; digits.  Pick up most significant discarded digit 
; and hold on to it for final rounding.

mulx110:jz	mulx115			;cont if 0
	mov	bx,ax			;else bx=ohang
	mov	cl,mdtmp-1[bx]		;pick up ms discard
	mov	[bp]+mul_dd,cl		;log in frame

; ax has nonnegative overhang to be trimmed, bump down
; product fracdigit ct by that much, and set overhang
; in frame temp.

mulx115:sub	byte ptr t+r_rpos,al	;adjust prod rpos
	mov	[bp]+mul_tj,ax		;set ohangct in frame

; Now set t.ndig to (product ndig - overhang), and copy
; that many mdtmp digits, beginning at the overhang-th
; position.
	mov	cx,[bp]+mul_ti	;product ndig
	sub	cx,[bp]+mul_tj	;minus overhang
	mov	t+r_ndig,cl	;= final ndig&copyct
	mov	si,offset mdtmp ;srcadr=mdtmp
	add	si,[bp]+mul_tj	;plus overhang
	mov	di,offset t+r_v ;destadr=t-vector
	rep movsb               ;move bytes

; fill uncopied part of t-reg with '0'.

	mov	cx,offset t+r_v+vsize ;final idxval
	sub	cx,di		;num to go
	jcxz	mulx120		;quit if done
	mov	al,'0'		;else get storeval
	rep stosb            	;and paint bal of reg

; T-reg is almost done.  Check up on the discard digit
; and round if necessary.

mulx120:cmp	byte ptr[bp]+mul_dd,'5' ;discard v. '5'
	jl	mulx130		;ordinary norm if lt
	push	ot		;else psh o(t-reg)
	call	incr		;bump one
	jmp short mulx140	;and get on to copyback
mulx130:push	ot		;no round, just psh o(t)
	call	setndig		;and do ordinary norm

; finally.  If err didn't get set along the line, copy
; t-reg back into lop.

mulx140:cmp	err,0		;err v. 0
	jne	mulx150		;had err, just ret
	push	ot		;else psh o(t)
	push	word ptr[bp]+mul_ol ;psh o(lop)
	call	rcopy		;copy product back

; clean up stack and return

mulx150:mov	sp,bp		;peel autos
	pop	bp		;retrieve caller frp
	ret	4		;ret past 4 argbytes
	

; divx(lop,rop) - divide lop by rop

div_ol	equ	4		;o(lop)
div_or	equ	6		;o(rop)

divx:	push	bp		;save caller frp
	mov	bp,sp		;set cur frp

; As in multiply, the t and s global registers will be
; our work temps.  Make copies of lop and rop.

	push	word ptr[bp]+div_ol ;psh o(lop)
	push	ot		    ;psh o(t)
	call	rcopy		    ;t = *ol
	push	word ptr[bp]+div_or ;psh o(rop)
	push	os		    ;psh o(s)
	call	rcopy		    ;s = *or

; Prenormalize divisor; we don't want to overlook a 
; lurking zero.

	push	os		;psh o(divisor)
	call	setndig		;normalize him

; If dividend is zero, just proceed straight to
; the windup sequence.

	cmp	byte ptr t+r_ndig,0 ;a zero?
	jne	divx05		    ;proceed if not zro
	jmp	divx130		    ;else join windup

; If divisor is zero, set up a complaint and quit.

divx05:	cmp	byte ptr s+r_ndig,0 ;a zero?
	jne	divx10		    ;continue if nonzero
	mov	err,offset dvzs     ;else set o(message)
	jmp	divx130		    ;and return now

; We're going to divide, clear vsize+1 positions in
; the quotient vector.

divx10:	mov	di,offset mdtmp	    ;set o(vector)
	mov	cx,vsize+1	    ;get storing ct
	mov	al,'0'		    ;and store val
	rep stosb            	    ;set vec to zeroes

; Left-adjust both dividend and divisor.

divx20: cmp	byte ptr t+r_v+vsize-1,'0' ;dvd msd==0?
	jne	divx30			   ;n, do dvsr
	push	ot			   ;y, take dvd
	call	lshift			   ;shift left
	jmp short divx20		   ;and rpt
divx30: cmp	byte ptr s+r_v+vsize-1,'0' ;ms pos zro?
	jne	divx35			   ;n, go set char
	push	os			   ;y, take dvsr
	call	lshift			   ;shift left
	jmp short divx30		   ;and rpt

; Compute quotient characteristic, and init guard digit.

divx35: mov	al,s+r_rpos	;divisor charac
	add	al,2		;plus 2
	sub	t+r_rpos,al	;quochr=dvdchr-dvschr+2
	mov	guard,'0'	;clear guard digit

; This is the outer loop of an ordinary restoring
; divide; we want to keep going until we produce
; vsize+1 quotient digits.

divx40: cmp	mdtmp+vsize,'0' ;sig in vsize+1 pos?
	jne	divx70		;yes, quo is done

; Shift mdtmp left one position to make room for 
; quotient digit at mdtmp[0].  Note we are only
; using vsize+1 positions in mdtmp and don't
; attempt to shift the unused part.

	mov	si,offset mdtmp+vsize-1 ;src idx
	lea	di,[si]+1		;destidx
	mov	cx,vsize	        ;repct
	pushf				;now save flgs
	std				;set decrmode
	rep movsb                       ;shift chrs
	popf				;restore flgs
	mov	mdtmp,'0'		;shift in '0'

; This is the inner loop of restoring divide. Keep
; counting up current quodigit as long as the
; 'bigger' routine succeeds in subtracting s from t.
; The 'bigger' routine will also handle the restore
; when t goes below zero.

divx50:	call	bigger		;ax = (t-=s)>=0
	cmp	ax,0		;success?
	je	divx60		;no, done with quodigit
	inc	mdtmp		;else ct up mdtmp[0]
	jmp short divx50	;and repeat

; This quotient digit is complete. Now shift the 
; dividend left one place (just like an old Monroe
; calculator) and repeat the whole procedure for
; the next quotient digit.

divx60:	push	ot		;psh o(dividend)
	call	lshift		;shift left one pos
	jmp short divx40	;and repeat

; Hard work is done; we have vsize+1 quotient digits
; in the mdtmp vector.  Put the least significant
; digit in the guard cell and copy the balance to
; the t-register.

divx70: mov	al,mdtmp	;pick up mdtmp[0]
	mov	guard,al	;and set guard
	mov	si,offset mdtmp+1 ;srcidx
	mov	di,offset t+r_v   ;destidx
	mov	cx,vsize	  ;copyct
	rep movsb                 ;copy digs

; We can't have more than vsize frac digits in quotient.
; As long as there are too many, keep shifting them off.

divx80: cmp byte ptr t+r_rpos,vsize ;rpos v. vsize
	jle	divx90		    ;ok if le
	push	ot		    ;too many, psh o(t)
	call	rshift		    ;shift off a dig
	jmp short divx80	    ;and repeat

; If quotient is too large, declare overflow and quit.

divx90: cmp	byte ptr t+r_rpos,0 ;charac in range?
	jge	divx100		    ;drive on if ok
	mov	err,offset ovfs	    ;not ok, get o(msg)
	jmp short divx130	    ;join ret seq

; Look at guard-digit, and decide between roundup-then-
; normalize versus ordinary normalize.

divx100:cmp	guard,'5'	    ;guarddig v. 5
	jge	divx110		    ;round+norm if ge
	push	ot		    ;else ordinary norm,
	call	setndig		    ;without round.
	jmp short divx120           ;join copyback
divx110:push	ot		    ;guardig ge 5, 
	call	incr		    ;bump up and norm

; almost done, copy back t-reg onto lop if no error
; has arisen.

divx120:cmp	err,0		    ;err still 0?
	jne	divx130		    ;if not just windup
	push	ot		    ;yes, psh o(treg)
	push	word ptr[bp]+div_ol ;and o(lop)
	call	rcopy		    ;*ol = t;

; all done, clean up our stack and return

divx130:mov	sp,bp		    ;peel autos
	pop	bp		    ;retrieve caller frp
	ret	4		    ;ret past 4 argbytes
	

; bigger() - subtract s-reg from t-reg...
;	return 1 if new t-register still ge 0
;	return 0 if new t-register was lt 0
;		 in which case a restore has
;	         already been accomplished.

big_idx	equ	-2		;running digitindex

bigger:	push	bp		;save caller frp
	mov	bp,sp		;set current frp
	sub	sp,2		;alloc autos

; Subtract s-reg from t-reg including guarddigit.

	mov	carry,0		;init carry
	mov	word ptr[bp]+big_idx,0 ;init digidx
big10:	cmp	word ptr[bp]+big_idx,vsize ;idx v. stopval
	jge	big20			   ;done if ge
	mov	bx,[bp]+big_idx		   ;not done, get idx
	mov	al,t+r_v[bx]		   ;get t-dig
	sub	al,s+r_v[bx]		   ;minus s-dig
	add	al,'0'			   ;rebias
	sub	al,carry		   ;and subtract carry
	cbw				   ;ext to fwrd
	push	ax			   ;psh as adj arg
	call	adj			   ;adj dig&carry
	mov	bx,[bp]+big_idx		   ;retrieve idx
	mov	t+r_v[bx],al	  	   ;replace t-dig
	inc	word ptr[bp]+big_idx	   ;bump runidx
	jmp short big10			   ;and repeat
big20:	cmp	carry,0			   ;borrow fr last pos
	je	big30			   ;no
	mov	al,guard		   ;y, get guard
	dec	ax		           ;-1
	push	ax			   ;psh as adj arg
	call	adj			   ;adj dig&carry
	mov	guard,al		   ;replace

; If no borrow at this point, we're done.

big30:	cmp	carry,0			   ;borrow fr guard?
	jne	big35			   ;y, restore
	mov	ax,1			   ;else get succval
	jmp short big60			   ;and join retseq
	

; (bigger continues)
; The last subtract took us below zero; now we have to
; add s-reg back into t-reg before returning zero.

big35:	mov	carry,0		;init carry
	mov	word ptr[bp]+big_idx,0 ;init digidx
big40:	cmp	word ptr[bp]+big_idx,vsize ;idx v. stopval
	jge	big50			   ;done if ge
	mov	bx,[bp]+big_idx		   ;not done, get idx
	mov	al,t+r_v[bx]		   ;get t-dig
	sub	al,'0'			   ;unbias
	add	al,s+r_v[bx]		   ;plus s-dig
	add	al,carry		   ;plus carry
	cbw				   ;ext to fwrd
	push	ax			   ;psh as adj arg
	call	adj			   ;adj dig&carry
	mov	bx,[bp]+big_idx		   ;retrieve idx
	mov	t+r_v[bx],al	  	   ;replace t-dig
	inc	word ptr[bp]+big_idx	   ;bump runidx
	jmp short big40			   ;and repeat
big50:	cmp	carry,0			   ;borrow fr last pos
	je	big55			   ;no
	mov	al,guard		   ;y, get guard
	inc	ax			   ;+1
	push	ax			   ;psh as adj arg
	call	adj			   ;adj dig&carry
	mov	guard,al		   ;replace

; done with restore, get zero for return

big55:	mov	ax,0			   ;pickup retval

; clean up stack and return

big60:	mov	sp,bp			   ;peel autos
	pop	bp			   ;get caller frp
	ret				   ;and return
	

; enter(dig) - insert ckd dig or '.' in kbdreg

en_dig	equ	4		;incoming digit

enter:	push	bp		;save caller frp
	mov	bp,sp		;set current frp
	mov	ax,[bp]+en_dig	;pick up digit
	cmp	al,'.'		;ck for radixpt
	jne	ent30		;not pt? go enter dig

; have a '.' character, see if the first.

	cmp	pflag,0		;radixpt seen?
	je	ent20		;no, log down
ent10:	call	beep		;else publish err
	jmp short ent40		;and join windup
ent20:	mov	pflag,1		;set pflag var
	jmp short ent40		;join windup

; have a digit 0-9. First make sure there's room
; in the keyboard register.

ent30:	cmp	byte ptr k+r_ndig,vsize ;ndig v. max
	jge	ent10		;join beep+ret if ovf

; have room in kbreg, ignore '0' keyed against empty
; register (ndig==pflag==0)

	cmp	byte ptr k+r_ndig,0 ;any digits?
	jne	ent35		    ;y, enter this one
	cmp	pflag,0		    ;rdxpt keyed?
	jne	ent35		    ;y, enter digit
	cmp	al,'0'		    ;n, is this '0'
	jne	ent35		    ;no, enter it
	jmp short ent40		    ;y, just dsply

; shift left one place and set cur digit in the
; least-significant position.

ent35:	push	ok		;psh o(kbdreg)
	call	lshift		;pull left one dig
	mov	ax,[bp]+en_dig	;now get digit
	mov	byte ptr k+r_v,al ;set in as l.s. dig

; lshift increments frac-dig fld, correct same if
; we are still on intpart.

	cmp	pflag,0		;rdxpt seen?
	jne	ent40		;forget corr ifnot
	dec	byte ptr k+r_rpos ;else correct fracdig

; new digit is inserted, display new kbdreg and ret

ent40:	push	ok		;psh o(kbdreg)
	call	display		;display same
ent50:	mov	sp,bp		;delete autos
	pop	bp		;restore caller frp
	ret	2		;pop 2 argbytes and ret
	

; display(oac) - display a register or errmsg

di_oac	equ	4		;o(reg to dspy)

di_ipc	equ	-2		;int-part cardinality
di_idx	equ	-4		;running digit idx

display:push	bp		;save caller frp
	mov	bp,sp		;set cur frp
	sub	sp,4		;alloc autospace

; Emit prefix strings to console, and set exitstring
; empty for a fresh display.

	cmp	debug,0		;scrolling?
	jne	disp05		;bypass l25 cmd if scroll
	push	odif4		;no, psh o(cmd)
	call	putstr		;and emit him
disp05:
	push	odif1		;psh o(prefix str)
	call	putstr		;and emit
	mov	exstrp,offset exstro ;curptr=o(0th byte)
	mov	exstro,0	     ;set null term

; if global 'err' variable is nonzero, it is taken to
; be the offset of a null-terminated complaint string.
; In that case we simply emit the complaint and don't
; fool with numeric display at all.

	cmp	err,0		;err var==0?
	je	disp10		;keep going ifnot
	push	err		;else psh for putstr
	call	putstr		;emit complaint
	push	err		;psh again for len
	call	strlen		;ax=len(str)
	neg	ax		;ax = -len(str)
	add	ax,dsize	;ax = dsize - len(str)
	push	ax		;this is putbl arg
	call	putbl		;emit this many blanks
	mov	err,0		;clear err 1-shot
	jmp	disp100		;and join windup
	

; (display continues)
; No error message is pending; get on with the 
; numeric display.  First compute the number of
; intpart digits to be dealt with.

disp10:	mov	bx,[bp]+di_oac	;get o(reg)
	mov	al,[bx]+r_ndig	;pick up totdigct
	sub	al,[bx]+r_rpos	;minus fracdigct
	cbw			;is intpart cardinality,
	mov	[bp]+di_ipc,ax	;log in frame

; Compute the number of non-sig chars to be put
; out ahead of the radixpt.  Consider non-sig zero
; and triplet separators.

	mov	cx,0		;assume no nonsig chrs
	cmp	ax,0		;no intpart digs?
	jne	disp20		;compute seps if some
	mov	cx,1		;else just ldg zero
	jmp short disp30	;get on with ldg-blank
disp20:	jl	disp30		;filter away ipc<0
	dec	ax		;ipc - 1
	cwd			;extd to dblwrd
	div	c3		;/3 gives sepct in ax
	mov	cx,ax		;get sepct in cx
	

; (display continues)
; At this point we have cx=no of nonsig chars ahead 
; of radixpt.  Find ct of leading spaces and emit
; them.

disp30:	mov	al,dsize-2	;dispwidth-2
	sub	al,[bx]+r_ndig	;- totdigct
	cbw			;ext to fullwrd
	sub	ax,cx		;-nonsig chrct
	push	ax		;is ldg blankct,psh
	call	putbl		;and emit them
	mov	bx,[bp]+di_oac	;retrieve o(reg)

; All done with leading blanks, put out the nonsig
; zero if necessary.

	cmp	word ptr[bp]+di_ipc,0 ;intpart ct v. 0
	jne	disp40		;have digs, forget ldgzro
	mov	al,'0'		;else get a '0'
	push	ax		;push same
	call	putchar		;emit
	mov	bx,[bp]+di_oac	;and retrieve o(reg)

; Put out the intpart digits, not omitting the 
; separator business.  We do this by putting out
; the ndig-th digit, and thence downwards till we
; strike rpos.

disp40:	mov	al,[bx]+r_ndig	;pick up totdigct
	cbw			;ext to fullwd
	mov	[bp]+di_idx,ax	;log as runningidx

; If running index hits rpos, we're done.

disp50:	mov	al,[bx]+r_rpos	;get fracdigct
	cbw			;ext to fullwrd
	cmp	ax,[bp]+di_idx	;rpos v. runidx
	jge	disp60		;done if runidx<=rpos

; not done yet; bump down running idx to indicate the
; current digit, actually pick up the digit, and
; put him out.

	dec	word ptr[bp]+di_idx ;idx -= 1
	mov	si,[bp]+di_idx	    ;and get in si
	mov	al,[bx+si]+r_v	;pick up digit
	push	ax		;psh as putchar arg
	call	putchar		;emit this digit
	mov	bx,[bp]+di_oac	;and retrieve o(reg)
	

; (display continues)
; If the remaining intpart cardinality is divisible
; by three, we put out a separator.

	dec	word ptr[bp]+di_ipc ;bumpdown intpartct
	mov	ax,[bp]+di_ipc	;and get in ax
	cmp	ax,0		;ipc now zero?
	jle	disp50		;yes, no sep
	cwd			;no, must divide
	div	c3		;dvd by 3, rem to dx
	cmp	dx,0		;is rmdr zero?
	jne	disp50		;no sep if not zero
	push	sep		;else push sep
	call	putchar		;and emit
	mov	bx,[bp]+di_oac	;retrieve o(reg)
	jmp short disp50	;rep for next dig

; all done with intpart, now put out radix point

disp60:	push	radix		;psh radixmark
	call	putchar		;and emit
	mov	bx,[bp]+di_oac	;retrieve o(reg)

; done with radixpoint, put out frac digits

disp70:	cmp	word ptr[bp]+di_idx,0 ;runidx zero yet?
	jle	disp80		;yes, done with frac
	dec	word ptr[bp]+di_idx   ;no, bump idx down
	mov	si,[bp]+di_idx	      ;and get in si
	mov	al,[bx+si]+r_v	;pick up digit
	push	ax		;psh for putchar
	call	putchar		;emit this digit
	mov	bx,[bp]+di_oac	;and retrieve o(reg)
	jmp short disp70	;rpt for next fracdig

; done with number, now put out trailing sign ...
; ' ' for positive, '-' for negative.

disp80:	mov	al,' '		;assume positive
	cmp	byte ptr[bx]+r_sgn,0 ;sign zero?
	je	disp90		;y, get on with it
	mov	al,'-'		;n, get '-'
disp90: push	ax		;push signcode
	call	putchar		;emit to display

; all done with display -- turn off exitstr accruing,
; put out windup string, and return

disp100:mov	exstrp,offset exstre ;set curptr=bufend
	push	odif3		;o(windup format)
	call	putstr		;emit string
	mov	sp,bp		;delete autos
	pop	bp		;retrieve caller frp
	ret	2		;ret past 2 argbytes

	

; lshift(oac) - shift reg 1 dig 'left' (toward msd)

ls_oac	equ	4		;o(reg)

lshift:	push	bp		;save caller frp
	mov	bp,sp		;set cur frp
	mov	bx,[bp]+ls_oac	;get o(reg)
	inc	byte ptr[bx]+r_ndig ;bump totdig
	inc	byte ptr[bx]+r_rpos ;bump fracdig
	lea	si,[bx]+r_v+vsize-1 ;form o(lastdig)
	mov	di,si		    ;and make copy
	pushf			    ;now pres flgs
	std			    ;and getin decmode
	lodsb            	    ;pick up msd,dec si
	mov	guard,al	    ;log into guarddig
	mov	cx,vsize-1	    ;get movs ct
	rep movsb                   ;move digs
	popf			    ;restore flags
	mov	byte ptr[bx]+r_v,'0';shift in a zero
	mov	sp,bp		    ;peel autos
	pop	bp		    ;restore caller frp
	ret	2		    ;ret popping 2 bytes


; rshift(oac) - shift reg 1 dig 'right' (toward lsd)

rs_oac	equ	4		;o(register)

rshift:	push	bp		;save caller frp
	mov	bp,sp		;set cur frp
	mov	bx,[bp]+rs_oac	;pick up o(reg)
	dec	byte ptr[bx]+r_ndig ;ctdown totdig
	dec	byte ptr[bx]+r_rpos ;ctdown fracdig
	lea	si,[bx]+r_v	    ;form o(lsd)
	mov	di,si		    ;and copy to di
	lodsb               	    ;get lsd in al
	mov	guard,al	    ;and set guarddig
	mov	cx,vsize-1	    ;now get movs chct
	rep movsb                   ;move digs
	mov	byte ptr[bx]+r_v+vsize-1,'0';shiftin '0'
	mov	sp,bp		    ;peel autos
	pop	bp		    ;restore caller frp
	ret	2		;ret popping 2 argbytes
	

; beep() - send beep code to screen, or print an
;	error message. Or something.

beep:	push	bp		;save caller frp
	mov	bp,sp		;set current frp
	push	c7		;push bell code
	call	putchar		;and emit
	mov	err,offset badkey	;set bad input B.E.M. 6/17/82
	CALL	DISPLAY			;DISPLAY THE ERROR
	mov	sp,bp		;peel autos
	pop	bp		;retrieve caller frp
	ret			;and return


; isdig(ch) - ret 1 if ch is '.' or '0'-'9' else 0

isdig:	push	bp		;save caller frp
	mov	bp,sp		;set cur frp
	mov	ax,[bp]+4	;pick up char
	cmp	al,'.'		;test v. '.'
	je	isd10		;digit if '.'
	cmp	al,'0'		;test v. '0'
	jb	isd20		;nondig if lt '0'
	cmp	al,'9'		;test v. '9'
	ja	isd20		;nondig if gt '9'
isd10:	mov	ax,1		;is a digit, get 1
	jmp short isd30		;and join retseq
isd20:	mov	ax,0		;non-digit, get 0
isd30:	mov	sp,bp		;peel autos
	pop	bp		;retrieve caller frp
	ret	2		;ret popping 2 argbytes


; putbl(n) - send n blanks to putchar

putbl:	push	bp		;save caller frp
	mov	bp,sp		;set cur frp
putbl10:dec	word ptr[bp]+4	;decr n
	jl	putbl20		;quit if lt 0
	mov	al,' '		;else get a blank
	push	ax		;push same
	call	putchar		;and emit
	jmp short putbl10	;repeat as needed
putbl20:mov	sp,bp		;remove autos
	pop	bp		;restore caller frp
	ret	2		;ret popping 2 argbytes
	

; doadd(lop,rop) -- add rop to lop register

do_lop	equ	4		;o(lop)
do_rop	equ	6		;o(rop)

do_sav	equ	-2		;temp storage

doadd:	push	bp		;save caller frp
	mov	bp,sp		;set cur frp
	sub	sp,2		;alloc autos

; init guard digit and decide about alignment.

	mov	guard,'0'	;start at '0'
	mov	si,[bp]+do_lop	;si=o(lop)
	mov	di,[bp]+do_rop	;di=o(rop)
	mov	al,[si]+r_rpos	;al=lop.rpos
	mov	bl,[di]+r_rpos	;bl=rop.rpos
	cmp	al,bl		;lop.rpos v. rop.rpos
	je	doa20		;no align if the same
	jg	doa10		;lop is moresig
	xchg	si,di		;rop moresig
doa10:	push	di		;psh o(lesssig)
	push	si		;psh o(moresig)
	call	align		;align for addn
	mov	si,[bp]+do_lop	;get o(lop)
	mov	di,[bp]+do_rop	;and o(rop) again

; init carry and see if signs match. Matching signs
; cause a real add, else we must do a real subtract.

doa20:	mov	carry,0		;start at 0
	mov	al,[si]+r_sgn	;get lop.sgn
	cmp	al,[di]+r_sgn	;v. rop.sgn
	jne	doa70		;must sub if not eq

; signs match, do a real add

	mov	bx,0		;init digit idx
doa30:	cmp	bx,vsize	;idx v. max+1
	jge	doa40		;done if ge
	mov	al,[bx+si]+r_v	;else get digit
	add	al,[bx+di]+r_v	;+rop digit
	sub	al,'0'		;de-bias ascii
	add	al,carry	;plus pndg carry
	cbw			;is new digit
	mov	[bp]+do_sav,bx	;save digidx over adj
	push	ax		;push new digit
	call	adj		;psbl fixup+carryprop
	mov	bx,[bp]+do_sav	;get back runidx
	mov	si,[bp]+do_lop	;o(lopreg)
	mov	di,[bp]+do_rop	;o(ropreg)
	mov	[bx+si]+r_v,al	;set new digit in lop
	inc	bx		;step to nextdig
	jmp short doa30		;and repeat

; real add is done, see if we overflowed

doa40:	cmp	carry,0		;carry out?	
	je	doa110		;no, go norm+ret

; uh-oh.  This is ovf unless there's an opportunity
; to discard a fracdig.

	cmp	byte ptr[si]+r_rpos,0 ;fracdigs?
	jne	doa50		     ;yes, pitch one
	mov	err,offset ovfs	;no, set errmsg
	jmp	doa110		;and join norm+ret
doa50:	push	si		;have fracdig, psh o(reg)
	call	rshift		;shift one off
	mov	si,[bp]+do_lop	;get o(lop)back
	mov	byte ptr[si]+r_v+vsize-1,'1';set '1' in hole
	cmp	guard,'5'	;guarddig worth rounding?
	jl	doa110		;no, join norm+ret
	push	si		;yes, psh o(reg)
	call	incr		;add one
	mov	si,[bp]+do_lop	;get o(lop) back
	jmp	doa110		;join norm+ret

; signs don't match, get with real subtract.

doa70:	mov	bx,0		;init digit idx
doa80:	cmp	bx,vsize	;idx v. max+1
	jge	doa85		;done if ge
	mov	al,[bx+si]+r_v	;get lopdigit
	sub	al,[bx+di]+r_v	;minus ropdigit
	add	al,'0'		;bias back to ascii
	sub	al,carry	;minus pndg borrow
	cbw			;is new lopdigit
	mov	[bp]+do_sav,bx	;save runidx over adj
	push	ax		;psh new digit
	call	adj		;correct/set carry
	mov	bx,[bp]+do_sav	;retrieve runidx
	mov	si,[bp]+do_lop	;retrieve o(lop)
	mov	di,[bp]+do_rop	;and o(rop)
	mov	[bx+si]+r_v,al	;set new lopdigit
	inc	bx		;bump to nxt digit
	jmp short doa80		;and repeat

; subtract is done..if carry is set we must flip sign,
; recomplement digits, and add one.  Ugh.

doa85:	cmp	carry,0		;carry set?
	je	doa110		;no, join norm+ret
	
; This is hard-way retrench, complement all digits

	mov	bx,0		;init idx
doa90:	cmp	bx,vsize	;idx v. max+1
	jge	doa100		;done if ge
	mov	al,'9'		;get '9'
	sub	al,[bx+si]+r_v	;minus curdig
	add	al,'0'		;reattach asciibias
	mov	[bx+si]+r_v,al	;set back in lop
	inc	bx		;step to nxtdigit
	jmp short doa90		;and repeat

; flip lopsign and add one to reg

doa100:	mov	al,[si]+r_sgn	;pick up sign
	xor	al,1		;flip same
	mov	[si]+r_sgn,al	;and replace
	push	si		;now push o(lop)
	call	incr		;go add 1
	mov	si,[bp]+do_lop	;and retrieve o(lop)

; almost done.  Normalize lop, clean off stack, and ret.

doa110:	push	si		;psh o(lop)
	call	setndig		;normalize him
	mov	sp,bp		;now peel autos
	pop	bp		;restore caller frp
	ret	4		;ret past 4 argbytes
	

;setndig(oac) - normalize a register

se_oac	equ	4		;o(reg)

se_idx	equ	-2		;sig-dig scanidx

setndig:push	bp		;save caller frp
	mov	bp,sp		;set cur frp
	sub	sp,2		;alloc autos
	mov	bx,[bp]+se_oac	;get o(reg) in bx

; starting at the leftmost position, scan across till
; we hit significance.  Indexval+1 for this digit is 
; probationary ndig value.

	mov	word ptr[bp]+se_idx,vsize ;set lmost pos
setn10:	dec	word ptr[bp]+se_idx ;count down one
	jl	setn20		;done if lt zero
	mov	si,[bp]+se_idx 	;else get in si
	cmp	byte ptr[bx+si]+r_v,'0' ;zero?
	je	setn10		;yes, keep going
setn20:	mov	ax,[bp]+se_idx	;no, get curidx
	inc	ax		;form tentative ndig

; ndig can't possibly be less than rpos, take rpos
; as minimum and set ndig fld in register.

	cmp	al,[bx]+r_rpos	;prob ndig v. rpos
	jge	setn30		;ok if ge
	mov	al,[bx]+r_rpos	;else get rpos
setn30:	mov	[bx]+r_ndig,al	;and set ndig

; now we want to rid ourselves of trailing fracpart
; zeroes; keep shifting them off as long as we see
; any.

setn40:	cmp	byte ptr[bx]+r_rpos,0 ;any fracdig?
	jle	setn50      	      ;no, quit
	cmp	byte ptr[bx]+r_v,'0'  ;yes, trail zro?
	jne	setn50		      ;done if not zro
	push	bx		      ;else psh o(reg)
	call	rshift		      ;shift off zero
	mov	bx,[bp]+se_oac	      ;getback o(reg)
	jmp short setn40	      ;and rpt

; if ndig is now zero, clr sign and rpos to avoid
; confusion in the future.

setn50:	cmp	byte ptr[bx]+r_ndig,0 ;ndig v. zero
	jne	setn60		      ;done if not
	mov	byte ptr[bx]+r_sgn,0  ;is zro, clr sgn
	mov	byte ptr[bx]+r_rpos,0 ;and rpos
setn60:	mov	sp,bp		;peel autos
	pop	bp		;retrieve caller frp
	ret	2		;ret past 2 argbytes
	

; incr(oac) -- add 1 to register

in_oac	equ	4		;o(reg)

incr:	push	bp		;save caller frp
	mov	bp,sp		;set cur frp
	mov	bx,[bp]+in_oac	;get o(reg)

; propagate 'carry-in' as high as possible

	mov	si,0		;init idx
inc10:	cmp	si,vsize	;curidx v. max+1
	jge	inc20		;done if ge
	cmp	byte ptr[bx+si]+r_v,'9' ;a '9'
	jne	inc20		;done if not '9'
	mov	byte ptr[bx+si]+r_v,'0' ;set '0'
	inc	si		;step to next dig
	jmp short inc10		;and rpt

; now si references the digit to be incremented--if
; this digit is actually in the register.

inc20:	cmp	si,vsize	;si v. max+1
	jge	inc40		;psbl ovf if ge
	inc	byte ptr[bx+si]+r_v ;else bump dig
inc30:	push	bx		;now psh o(reg)
	call	setndig		;normalize him
	jmp short inc60		;and join windup

; bad news -- we propagated carries clear to the end
; of the register.  Maybe we can retrench by discarding
; a fracdigit, then planting a '1' in the freshly-
; opened hole.

inc40:	cmp	byte ptr[bx]+r_rpos,0 ;any fracdigs?
	jle	inc50		;no, this is overflow
	push	bx		;yes, psh o(reg)
	call	rshift		;make a hole
	mov	bx,[bp]+in_oac	;get back o(reg)
	mov	byte ptr[bx]+r_v+vsize-1,'1';plant '1'
	jmp short inc30		;join normalize-ret

; overflow for sure - mov o(err string) into
; global err variable.

inc50:	mov	err,offset ovfs	;set up errvar

; clean up stack and return.

inc60:	mov	sp,bp		;delete autos
	pop	bp		;restore caller frp
	ret	2		;ret past 2 arg bytes
	

; zero(oac) - zero a register

zero:	push	bp		;save caller frp
	mov	bp,sp		;set cur frp
	mov	bx,[bp]+4	;pick up o(reg)
	mov	al,0		;get zero for store
	mov	[bx]+r_sgn,al	;clr sgn fld
	mov	[bx]+r_ndig,al	;clr digct fld
	mov	[bx]+r_rpos,al	;clr fracdigct fld
	mov	al,'0'		;now get ascii '0'
	lea	di,[bx]+r_v	;form o(vecorg)
	mov	cx,vsize	;get vec itemct
	rep stosb            	;set vec to '0'
	mov	sp,bp		;del autos
	pop	bp		;getback caller frp
	ret	2		;ret past 2 bytes


; adj(n) - adjust a digit and return; side effect
;	on global carry flag.

adj:	push	bp		;save caller frpo
	mov	bp,sp		;set cur frp
	mov	ax,[bp]+4	;pick up digit
	mov	carry,0		;clear carry flag
	cmp	ax,'9'		;digit v. '9'
	jle	adj10		;ck further if le '9'
	mov	carry,1		;else set carry
	sub	ax,10		;return dig-10
	jmp short adj20		;join windup
adj10:	cmp	ax,'0'		;digit v. '0'
	jge	adj20		;no adj if 0-9
	mov	carry,1		;else set carry
	add	ax,10		;return dig+10
adj20:	mov	sp,bp		;del autos
	pop	bp		;retrieve caller frp
	ret	2		;ret past 2 argbytes
	

; align(ms,ls) - align regs, ms has more sig

al_oms	equ	4		;o(reg with more sig)
al_ols	equ	6		;o(reg with less)

align:	push	bp		;save caller frp
	mov	bp,sp		;set cur bp

; if two rpos match, we're done.

al10:	mov	si,[bp]+al_oms	;get o(ms) in si
	mov	di,[bp]+al_ols	;get o(ls)
	mov	al,[si]+r_rpos	;get ms rpos in al
	cmp	al,[di]+r_rpos	;v. ls rpos
	je	al30		;done if equal

; not done, try to leftshift reg with lesser
; significance unless we're at the size limit.
; In that case we right-shift the reg with greater
; significance and discard a fracdigit.

	cmp	byte ptr[di]+r_ndig,vsize ;at limit?
	jge	al20		;yes, must rightshift
	push	di		;no ok to lshift this
	call	lshift		;shift left one pl
	jmp short al10		;and test again
al20:	push	si		;psh o(ms reg)
	call	rshift		;shift off digit
	jmp short al10		;and test again

; done shifting, round guard digit into reg w/moresig

al30:	cmp	guard,'5'	;guarddig v. '5'
	jl	al40		;windup if lt
	inc	byte ptr[si]+r_v;ge 5, bump lo dig

; all done, cleanup stack and ret

al40:	mov	sp,bp		;del autos
	pop	bp		;restore caller bp
	ret	4		;ret past 4 bytes
	

; lswit - code to handle multi-way branch
;
; jump to lswit with ax=comparand, bx=o(casetable),
; where casetable is a vector of integers laid out
; as follows:
;
;	<n+1>		;total includes default
;	<1st value>	;tested against ax
;	...
;	<nth value>	;last value
;	<1st target>	;branch here if ax=1st value
;	...		
;	<nth target>	;branch here if ax=last value
;	<dflt target>	;branch here if no match for ax
;
; ASSUMPTIONS: ds coincides with es, cld mode.
; ALTERS:      bx, cx, di

lswit:	lea	di,[bx]+2	;get o(1st value)
	mov	bx,[bx]		;get casect+1
	mov	cx,bx		;use as repct
	repne scasw             ;srch value vector
	shl	bx,1		;now form 2*(ct+1)
	jmp	word ptr[bx+di]-4;this is o(target),go


; strlen(os1) - count nonnull bytes in s1
; 	ASSUMPTIONS: es==ds, cld mode

strlen:	push	bp		;save caller frp
	mov	bp,sp		;set current frp
	mov	di,[bp]+4	;get o(str) in di
	mov	al,0		;set up comparand
	mov	cx,-1		;set repct of 65535
	repne scasb             ;scan for zero byte
	lea	ax,[di]-1	;now form o(nullbyte)
	sub	ax,[bp]+4	;minus o(string)
	mov	sp,bp		;is strlen, peel autos
	pop	bp		;retrieve caller frp
	ret	2		;ret popping 2 argbytes
	

; rcopy(odest,osrc) - copy src reg to dest reg

rc_od	equ	4		;o(dest)
rc_os	equ	6		;o(src)

rcopy:	push	bp		;psh caller frp
	mov	bp,sp		;set cur frp
	mov	di,[bp]+rc_od	;pick up o(dest)
	mov	si,[bp]+rc_os	;and o(src)
	mov	cx,r_siz	;size of reg
	rep movsb               ;move bytes
	mov	sp,bp		;del autos
	pop	bp		;restore caller frp
	ret	4		;ret past 4 argbytes
	

; putstr(ostr) - pass null-terminated string to putchar

put_os	equ	4		;o(string)

putstr:	push	bp		;push caller frp
	mov	bp,sp		;set cur frp
puts10:	mov	si,[bp]+put_os	;get cur strptr
	lodsb            	;get char, inc si
	mov	[bp]+put_os,si	;replace new os
	cmp	al,0		;char v. null
	je	puts20		;done if null
	mov	ah,0		;else zero-ext
	push	ax		;push as arg
	call	putchar		;enter putchar
	jmp short puts10	;and repeat
puts20:	mov	sp,bp		;all done, peel autos
	pop	bp		;get back caller frp
	ret	2		;ret past 2 argbytes


; putchar(ch) - put char to display; if digit, dot 
;	or minus, add to exit string.

put_ch	equ	4		;char to emit

putchar:push	bp		;save caller frp
	mov	bp,sp		;set cur frp
	mov	al,[bp]+put_ch	;yes, get char
	cmp	al,'-'		;a minus?
	je	putcha10	;yes, go add
	mov	ah,0		;no, zero ext
	push	ax		;and psh as arg
	call	isdig		;to isdig, get 0 or 1
	cmp	ax,0		;get dig or dot?
	je	putcha20	;no, forget it
putcha10:
	mov	ax,word ptr[bp]+put_ch ;get ch again
	mov	di,exstrp	;cur ptr to exit str
	cmp	di,offset exstre-2 ;2 bytes headroom?
	jg	putcha20	;no, omit this byte
	stosb           	;y, store and bump
	mov	exstrp,di	;replace new pointer
	mov	al,0		;now get a null
	stosb			;always terminate str
putcha20:
	push	word ptr[bp]+put_ch ;now psh ch for last time
	call	conout		;and put it to console
	mov	sp,bp		;delete autos
	pop	bp		;restore caller frp
	ret	2		;and return
	

; vgetchar() -- get token from environment using cistring

vgbufmax equ	32		;maxlen for local string
vg_len	equ	-2		;len of this string
vg_off	equ	-4		;o(string)
vg_seg	equ	-6		;s(string)
vg_buf	equ	-38		;local string buffer

vgetchar:
	push	bp		;save caller frp
	mov	bp,sp		;set loc frp
	sub	sp,38		;alloc autospace

; call cistring routine, get back es:bx pointer
; referencing a long string descriptor.

	call	cistring	;call string-getter

; Now we want to make a local copy of this string
; so we can get out of the long-pointer business.
; First, make a local copy of the long string descr.

	mov	si,bx		;set up fetch ptr
	lodsw                   ;pick up strlen
	mov	[bp]+vg_len,ax	;make local copy
	lodsw                   ;pick up stroff
	mov	[bp]+vg_off,ax	;make local copy
	lodsw                   ;pick up strseg
	mov	[bp]+vg_seg,ax	;make local copy

; limit the string length to something our local buffer
; can accept, and get this length in cx in preparation
; for string copy-over

	mov	cx,[bp]+vg_len	;get strlen
	cmp	cx,vgbufmax-1	;len v. max
	jle	vgetch10	;proceed if fit
	mov	cx,vgbufmax-1	;else shorten to max
	mov	[bp]+vg_len,cx	;and update frame item
vgetch10:
	

; (vgetchar continues)
; Now actually copy the string over to our frame.

	mov	es,[bp]+vg_seg	;set up s(str)
	mov	si,[bp]+vg_off	;set up o(str)
	lea	di,[bp]+vg_buf	;set destadr
	jcxz	vgetch30	;for safety's sake
vgetch20:
	lodsb                   ;pick up strbyte
	mov	[di],al		;drop in frame
	inc	di		;bump storeptr
	loop	vgetch20	;and repeat cx times
	mov	byte ptr[di],0	;now terminate loc str

; We now have a local copy of the string; force es
; back into alignment with ds.

vgetch30:
	push	ds		;pick up ds
	pop	es		;and reset es

; if not debugging, echo the string

	cmp	debug,0		;debug environment?
	je	vgetch40	;no, proceed
	lea	ax,[bp]+vg_buf	;yes, get o(locstr)
	push	ax		;push this adr
	call	putstr		;and emit string
vgetch40:

; Internally, we use the single-byte codes bac and clr
; for backspace-digit and clear-entry.  We detect the
; ^H backspace assignment, and the 177o clear assignment,
; and translate them into the bac and clr codes res-
; pectively.  Any multi-character escape sequence we
; don't understand is folded into 176o.

	cmp	word ptr[bp]+vg_len,1 ; len 1?
	jne	vgetch44	      ;all multis illeg
	cmp	byte ptr[bp]+vg_buf,8     ;backspace?
	jne	vgetch42		  ;n, ck clear
	mov	byte ptr[bp]+vg_buf,bac   ;y, set bac code
	jmp short vgetch46	          ;and set len 1
vgetch42:
	cmp	byte ptr[bp]+vg_buf,177o  ;clear?
	jne	vgetch46		  ;n, proceed
	mov	byte ptr[bp]+vg_buf,clr	  ;y, set clr code
	jmp short vgetch46		  ;and set len 1
vgetch44:
	mov	byte ptr[bp]+vg_buf,176o  ;set ill in buf
vgetch46:
	mov	word ptr[bp]+vg_len,1	  ;set len=1
vgetch50:

; Character to return is at leading edge of local buffer,
; get it into al with zero-extension.

	mov	al,[bp]+vg_buf	;get ch in al
	mov	ah,0		;and zero-extend

; Stop now if we see shift-calc code or cr(enter).
; Only difference is exitstring return.

	cmp	al,exitcode	;is this exit code?
	jne	vgetch60	;no, ordinary ret
	mov	exstrp,offset exstro ;y, clr exitstr
	mov	exstro,0	;set null at org
	jmp	exit		;and quit
vgetch60:
	cmp	al,15o		;cr?
	jne	vgetch70	;proceed if not
	jmp	exit		;else done
vgetch70:

; clean up stack and ret ch in ax

	mov	sp,bp		;peel off autos
	pop	bp		;get caller frp
	ret			;and ret (no args)

; cistring() - return typed-in char or escapeseq
;	At this time we are using a single-char
;	console interface, so we make the simpli-
;	fying assumption that all incoming escape
;	sequences will be of length no greater than
;	two.  The return is pl/m-ish: we
;	set es:bx to reference a 'long string
;	desccriptor', which is two bytes each of
;	length, offset, and segment for the string.
;	In our world, es always matches ds, so we
;	leave it alone in this routine...but others
;	might not.  Hence, callers should assume
;	es destroyed.

cistring:
	push	bp		;save caller frp
	mov	bp,sp		;set local frp
	call	conin		;get 1 ch using dci

; have a character in al, now plant in mem and fake
; up a long string descriptor.

	mov	cibyte,al	;set ch in mem
	mov	cilen,1		;set descrlen=1
	mov	ciseg,ds	;set descrseg=ds
	mov	cioff,offset cibyte ;set descroff=o(byte)

; check for escape...if we see one, get another char
; and lengthen return string appropriately.

	cmp	al,27		;escape?
	jne	cistr10		;no, just ret 1 ch
	call	conin		;y, get another ch
	mov	cibyte+1,al	;set in str
	mov	cilen,2		;and make len 2
cistr10:

; non-standard return has es:bx indicating the long 
; string descriptor.  For our purposes, we take es==ds,
; so it suffices to simply set bx.

	mov	bx,offset cilen ;get o(descr)

	mov	sp,bp		;now peel autos
	pop	bp		;restore caller frp
	ret			;and ret (no args)


; **** end of vcalc.a86 ****
