NAME DISK
COMMENT *This program saves and retrieves image
         data form the SIRIUS disk units
        *
VISION      GROUP VARIABLE,VIZSYS
VARIABLE    SEGMENT PUBLIC 'VARI'

FUNC22      DW 19,46,49,35,38,2,20,53,35,56,39,2,21,38,39,46,39,54,39,31 DUP(2)

MESS22      DW 40,43,46,39,48,35,47,39,32,20 DUP(2)

MESS23      DW 38,43,53,45,2,39,52,52,49,52,19 DUP(2)

MESS24      DW 29 DUP(2)

BSCOUNT     DB 0

FCB         DB 2,8 DUP(32),50H,49H,43H,30 DUP(?)
VARIABLE    ENDS

VIZSYS      SEGMENT PUBLIC 'VIZ'
            ASSUME CS:VIZSYS,DS:VISION,SS:VISION
            PUBLIC DISK,FUNC22
            EXTRN IMAGE:ABS,SMALL:NEAR,MENOUT:NEAR,KEYWAIT:NEAR,CHARPUT:NEAR
	    EXTRN CLEAR:NEAR,MESS2OUT:NEAR,GDF:WORD,CHKDOOR:NEAR

DISK:       MOV AX,1
            MOV GDF,AX
            MOV DI,OFFSET FUNC22
            CALL MENOUT
DKEY:       CALL KEYWAIT
            CMP AL,243
            JNE DKEY1	
	    CALL CHKDOOR
	    CMP AL,0
            JNE DKEY
            CALL DELETE
            JMP DKEY
DKEY1:      CMP AL,27
            JNE DKEY2
            CALL MENOUT
            RET
DKEY2:      CMP AL,241
            JNE DKEY3
	    CALL CHKDOOR
            CMP AL,0
	    JNE DKEY
            CALL LOAD
            JMP DKEY
DKEY3:      CMP AL,242
            JNE DKEY4
	    CALL CHKDOOR
	    CMP AL,0
	    JNE DKEY
            CALL SAVE
            JMP DKEY
DKEY4:
            JMP DKEY

FILENAME:   MOV AL,0
            MOV BSCOUNT,AL
            MOV DI,OFFSET MESS22
            CALL MESS2OUT
            MOV BL,28
            MOV BH,24
            MOV CX,32
            CALL CHARPUT
            MOV DI,OFFSET FCB     ;Erase name from FCB
            INC DI
            MOV CX,8
            MOV AL,20H
DELOOP:     MOV [DI],AL
            INC DI
            LOOPNZ DELOOP
            MOV BP,OFFSET FCB
            MOV SI,01
DECYC:      CALL KEYWAIT
            CMP AL,13
            JE FEXIT
            CMP AL,08
            JE BAKSPC
            CMP AL,91             ;TEST FOR LOWER ACSE AND ILLEGAL CHR
            JB LOWCASE
            SUB AL,32 
LOWCASE:    CMP AL,91    
            JA DECYC 
            CMP AL,47
            JB DECYC

            INC BSCOUNT            ;KEEP COUNT OF CHARACTERS FOR BACKSPACE

            MOV [BP+SI],AL
            SUB AL,30
            MOV AH,0
            INC SI
            INC BL
            MOV CX,AX
            CALL CHARPUT
            CMP BSCOUNT,8
            JNE DECYC
FEXIT:      CALL CHKDOOR
            CMP AL,0
            JNE FILENAME
            RET

BAKSPC:     MOV AL,BSCOUNT
            CMP AL,0
            JE FINBAK
            DEC BSCOUNT
            MOV CX,02
            CALL CHARPUT
            DEC BL
            MOV AL,32
            MOV [BP+SI],AL
            DEC SI
FINBAK:     JMP DECYC

ERROR:      MOV AH,0DH
            INT 21H
            MOV DI,OFFSET MESS23
            CALL MESS2OUT
ERRORDEL:   CALL KEYWAIT
            CMP AL,13
            JNE ERRORDEL
ERASE:      MOV DI,OFFSET MESS24
            CALL MESS2OUT
            RET

DELETE:     CALL FILENAME              ;Delete file from directory
            CALL ERASE
            MOV DX,OFFSET FCB
            MOV AH,13H
            INT 21H
            RET

SAVE:       CALL FILENAME
            MOV DX,OFFSET FCB
            MOV AH,16H                 ;Create file
            INT 21H
            CMP AL,0FFH
            JE ERROR
            MOV AX,IMAGE               ;Set up disk transfer vector
            MOV DS,AX
            MOV DX,0
            MOV AH,01AH
            INT 21H
            MOV AX,VARIABLE                             
            MOV DS,AX
            MOV DX,OFFSET FCB
            MOV AX,0
            MOV DI,DX
            MOV [DI+33],AX
            MOV [DI+35],AX
            MOV CX,511
            MOV AH,28H                   ;Write file
            INT 21H
            CMP AL,0
            JNE ERROR
            MOV DX,OFFSET FCB            ;Close file
            MOV AH,10H
            INT 21H
            CALL ERASE
            RET

LOAD:       CALL FILENAME
OK1:        MOV DX,OFFSET FCB            ;Open file
            MOV AH,0FH
            INT 21H
            CMP AL,0
            JE OK2
            JMP ERROR
OK2:        MOV DX,OFFSET FCB            ;Read file
            MOV AX,0
            MOV DI,DX
            MOV [DI+33],AX
            MOV [DI+35],AX
            PUSH DS
            MOV AX,IMAGE
            MOV DS,AX
            MOV DX,0
            MOV AH,01AH
            INT 21H
            POP  DS
            MOV DX,OFFSET FCB
            MOV CX,511
            MOV AH,27H
            INT 21H
            CMP AL,0
            JE OK
            JMP ERROR
OK:         MOV AH,10H                    ;Close file
            INT 21H
            CALL CLEAR
            CALL SMALL
            CALL ERASE
            RET

VIZSYS      ENDS
            END    DISK

                  
    