	NAME GREY
COMMENT* SPECIAL ROUTINE FOR DISPLAYING GREY PICTURE
       *
VISION	GROUP VIZSYS,VARIABLE

VARIABLE   SEGMENT PUBLIC 'VARI'


LVL1	   DB   64
LVL2       DB   80
LVL3       DB   96
LVL4       DB   112
LVL5       DB   128
LVL6       DB   144
LVL7       DB   160
X1	   DB   ?
X2	   DB   ?
Y1	   DB   ?
Y2	   DB   ?
DATAPNT    DW   255
XPOINT     DW   255
YPOINT     DW   0
BITCOUNT   DB   0
CASE       DB   1
COLPNT     DW   0
BYTE1      DB   0
BYTE2      DB   0
PIXVAL     DB   0
CLM	   EQU 01000H+(57600/16)         
VARIABLE   ENDS	


VIZSYS 	SEGMENT PUBLIC 'VIZ'
        ASSUME CS:VIZSYS,DS:VISION,SS:VISION
        PUBLIC FGREY
	EXTRN IMAGE:ABS,CLEAR:NEAR,HIREZ:ABS,THRESH:BYTE,CONT:BYTE
        EXTRN BLIMX:WORD,BLIMY:WORD,XL:WORD,YL:WORD
FGREY:                      

;CALCULATE THRESHOLD LEVELS FROM CONTRAST AND THRESHOLD VALUES
		MOV AX,YL
		SHR AX,1
		MOV BL,199
		SUB BL,AL
		MOV Y1,BL
		MOV AX,BLIMY
		SHR AX,1
		MOV BL,199
		SUB BL,AL
		MOV Y2,BL
		MOV AX,XL
		MOV BX,3
		MOV DX,0
		DIV BX
N1:		MOV X1,AL
		MOV AX,BLIMX 
		MOV BX,3
		MOV DX,0
		DIV BX
N2:		MOV X2,AL
		MOV BP,CLM
		MOV AL,THRESH
		SUB AL,CONT
		MOV LVL3,AL
		SUB AL,CONT
		MOV LVL2,AL
		SUB AL,CONT
		MOV LVL1,AL
		MOV AL,THRESH
		MOV LVL4,AL
		ADD AL,CONT
		MOV LVL5,AL
		ADD AL,CONT
		MOV LVL6,AL
		ADD AL,CONT
	        MOV LVL7,AL
		MOV AL,1
		MOV CASE,AL
		MOV DI,00
;SET INITIAL VALUE OF DATAPOINTER HELD IN BX
		
		MOV BX,255
;		MOV AX,IMAGE
;		MOV DS,AX

;SET CASE TYPE AND ADJUST BIT ROTATION FACTOR ACCORDINGLY


WINDOWCHECK:  	MOV CH,3	
	       
		CMP BITCOUNT,6 
		JE NEWCOLUMN
		CMP BITCOUNT,5
		JNE GETBYTE
		MOV CH,CASE
 		INC CASE
		CMP CASE,4
		JNE GETBYTE  
		MOV CASE,1 
		JMP GETBYTE
;DECREMENT GRAPHICS DX

NEWCOLUMN:	SUB BP,(800/16)
		MOV AL,0
		MOV BITCOUNT,AL
	
;MAIN LOOP FOR FILLING SCREEN DXS

GETBYTE:
		PUSH DS
		MOV AX,IMAGE
		MOV DS,AX
                MOV AL,[BX]
		POP DS
		
;DECODE PIXEL BYTE INTO ONE OF SEVEN POSSIBLE GREY LEVELS THEN
;TRANSLATE THIS INTO TWO BYTE PATTERNS
		
		CMP AL,LVL1
		JNB LEVEL6
		MOV DX,0000H
 		JMP PUTBYTE    ; **** MODIFIED TO AVOID PLOT****

LEVEL6:         CMP AL,LVL6
		JNA LEVEL2
		MOV DX,0707H
		JMP PUTBYTE

LEVEL2:         CMP AL,LVL2
		JNB LEVEL3
		MOV DX,0100H
                JMP PUTBYTE
                
LEVEL3:		CMP AL,LVL3
		JNB LEVEL4
		MOV DX,0104H
		JMP PUTBYTE

LEVEL4:		CMP AL,LVL4
		JNB LEVEL5
		MOV DX,0304H
		JMP PUTBYTE

LEVEL5:		CMP AL,LVL5
		JNB LEVEL7
		MOV DX,0306H
		JMP PUTBYTE

LEVEL7:
		MOV DX,0706H      

;ADJUST BYTE1 & BYTE2 IF CH IS NOT=3

PUTBYTE: 	CMP CH,3
 	 	JE PBYTE

         	MOV CL,3
         	SUB CL,CH		
         	SHR DH,CL
         	SHR DL,CL


;PUT BYTE INTO CURRENT SCREEN LOCATION

PBYTE:     		
  
;CHANGE DATA SEGMENT TO TOP OF GRAPHICS DX
NOTEST:		MOV CL,CH      
CON:		MOV SI,DI
		SHL SI,1			  
		PUSH DS
		MOV DS,BP

		MOV AX,[SI]
	   	SHL AX,CL
		OR AL,DH
		MOV [SI],AX

		MOV AX,[SI+2]
		SHL AX,CL
		OR  AL,DL    
		MOV [SI+2],AX
		POP DS


;CHECK FOR END OF GRAPHICS COLUMN

ENDPLOT:	INC DI
		INC DI
		CMP DI,400-16
		JE RESETDATA                                            
    
;GRAPHICS COLUMN NOT FULL INCREMENT DATA POINTER AND RETURN

		INC BH
		JMP GETBYTE

;IF GRAPHICS COLUMN FINISHED RESET FOR NEW DATA COLUMN

RESETDATA:
		MOV BH,0
		CMP CASE,3
		JE CHANGE
		CMP BITCOUNT,0 
		JE NC
CHANGE:		DEC BL
                CMP BL,255
		JE FINISH
NC:	  
		INC BITCOUNT
		MOV AX,0
		MOV DI,AX

		JMP WINDOWCHECK
 

FINISH:		RET


VIZSYS		ENDS
		END FGREY
