TITLE DIGITHURST VISION SYSTEM OPERATING SYSTEM (SIRIUS VERSION)
COMMENT *
        +++++++++++++++++++++++++++++++++++++++++
        + THIS DOCUMENT CONTAINS TRADE SECRETS  +
        + OF DIGITHURST Ltd. AND SHOULD NOT BE   +
        + RELEASED TO THE  GENERAL PUBLIC.       +
        +                                       +
        + JUNE 1983                             +
        +++++++++++++++++++++++++++++++++++++++++ 
        *
        
VISION      GROUP VARIABLE,STACK,VIZSYS         
VARIABLE    SEGMENT PUBLIC 'VARI'
            PUBLIC WINFLG,NEXCNT,CURCNT,IEND,PERIM,COLFLG
            PUBLIC NLFLG,LINETYPE,DOT,FILT,AREA,GDF
            PUBLIC FUNC0,FUNC1,FUNC2,FUNC3,FUNC4,FUNC5,FUNC6,MESS0                                       
            PUBLIC MESS1,MESS2,MESS3,MESS4,MESS5,MESS6,MESS7,MESS8,MESS9,MENRES
            PUBLIC MESS20,MESS21,MESS25
            PUBLIC THRESH,LVL1,LVL2,LVL3,LVL4,LVL5,IMAGE,GREY,ENVAL,CONT
RGTABLE     DB     3AH,32H,34H,0C9H,19H,06H,19H,19H,03,0EH,20H,0FH,30H,0,0,0
RESTABLE    DB     5CH,50H,51H,0CFH,19H,06H,19H,19H,03,0EH,60H,0FH,10H,0,0,0


FUNC0       DW     19,41,52,39,59,53,37,35,46,39,2,20,36,43,48,35,52,59
            DW     2,21,38,43,53,45,2,22,50,52,43,48,54,39,52,2,23,53,59,53,54,39
            DW     47,2,2,2,2,2,2,2,2,2,2,2

FUNC1       DW     19,52,39,40,52,39,53,42,2,20,41,52,39,59,2,21,47,35,48,43,50
            DW     2,22,47,39,52,41,39,2,23,37,49,48,54,52,35,53,54,2,24,54
            DW     42,52,39,53,42,49,46,38,2,2,2

FUNC2       DW     19,35,52,39,35,2,20,36,49,55,48,38,35,52,59,37 DUP(2)
            DW   

FUNC3       DW     19,57,43,48,38,49,57,2,20,36,49,55,48,38,35,52,59,2,21,35,52
            DW     39,35,2,22,38,43,47,2,23,39,58,43,54,2,24,47,39,48,55,20
            DW     2,25,53,46,49,57,2,2,2,2,2,2

FUNC4       DW     19,57,43,48,38,49,57,2,20,37,35,38,2,21,39,48,42,35
            DW     48,37,39,2,22,41,52,39,59,2,23,52,39,47,49,56,39,2,24,47,39
            DW     48,55,19,2,25,53,46,49,57,2,2,2,2,2 

FUNC5       DW     19,57,43,48,38,49,57,2,20,47,49,56,39,2,21,52,39,53,39
            DW     54,2,22,60,49,49,47,2,23,43,48,56,39,52,54,2,24,41,52,39,59 
            DW     12 DUP(2)

FUNC6       DW     19,50,46,49,54,2,20,52,49,54,35,54,39,2,21,53,37,35,46,39,55
            DW     50,2,22,53,37,35,46,39,38,49,57,48,2,23,37,46,39,35,52,2,24,47
            DW     53,37,35,46,39,2,2,2

MESS0       DW     13,54,49,2,43,48,37,52,39,35,53,39,2,15,54,49,2,38,39,37,52
            DW     39,35,53,39,2,2,2,2,2,2

MESS1       DW     36,43,48,35,52,59,2,38,35,54,35,2,39,58,43,53,54,53,2,49,2,2
MESS15     DW     56,39,52,57,52,43,54,39,2,10,32827,17,32816,11,18 DUP(2)

MESS2       DW     37,49,48,54,52,35,53,54,2,56,35,46,55,39,2,10,2,2,2,11,2,2

MESS3       DW     54,42,52,39,53,42,49,46,38,2,56,35,46,55,39,10,2,2,2,11,2,2


MESS4       DW     53,37,35,46,39,2,56,35,46,55,39,2,2,2,2,10,2,2,2,11,2,2

MESS5       DW     52,49,54,35,54,43,49,48,2,56,35,46,55,39,2,10,2,2,2,11,2,2

MESS6       DW     52,39,35,38,43,48,41,2,37,35,47,39,52,35,2,2,2,2,2,2,2,2

MESS7       DW     37,52,39,35,54,43,48,41,2,36,43,48,35,52,59,2,38,35,54,35,2,2

MESS8       DW     57,43,48,38,49,57,2,35,37,54,43,56,39,2,2,2,2,2,2,2,2,2

MESS9       DW     48,49,2,38,35,54,35,2,39,58,43,53,54,53,2,2,2,2,2,2,2,2

MESS20      DW     35,52,39,35,2,36,31,2,2,2,2,2,2,57,31,2,2,2,2,2,2,2

MESS21      DW     2,36,49,55,48,38,35,52,59,31,2,2,2,2,2,2,58,31,2,2,2,2,2,2,59,31,2,2


MESS25      DW     50,52,39,53,53,2,52,39,54,55,52,48,2,54,49,2,39,58,43,54 

MESS26      DW     37,42,39,37,45,2,38,49,49,52,2,37,46,49,53,39,38,2,49
            DW     48,2,38,52,43,56,39,2,36,2,2,2,2,2,2,10 DUP(2)

MENRES      DW     50 DUP(2)

MICKEY      DW     1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768
SPACE       DW     132
A1          DB     01
B1          DB     100
ENVAL       DB     0
GDF         DW     0 
BDF         DB     0
MSF         DB     1

YPOINT      DW ?
XPOINT      DW ?
AREA        DW ?
IEND        DW ? 
FILT        DW ?
TEMP        DB ? 
WORK        DB ?
WINFLG      DB ?
PERIM       DW ?
NEXCNT      DB ?
CURCNT      DB ?
NLFLG       DB ?
COLFLG      DB ?
DOT         DW ?  
LVL1        DB 64         ;LEVELS FOR GREY ROUTINE
LVL2        DB 80
LVL3        DB 96
LVL4        DB 112
LVL5        DB 128
CONT        DB 20	   ;CONTRAST LEVEL FOR GREY
LINETYPE    DB 0           ;0 PLOT 1=INVERT
COLA        DB ?
COLB        DB ?
COLC        DB ?
PNTR        DW ?
TEMP2       DB ?
THRESH      DB     128                 
LOOKUP1     DW     20000,20800,21600,22400,23200,24000,24800,25600,26400,27200
            DW     28000,28800,29600,30400,31200,32000,32800,33600,34400,35200
            DW     36000,36800,37600,38400,39200,40000,40800,41600,42400,43200
            DW     44000,44800,45600,46400,47200,48000,48800,49600,50400,51200
            DW     52000,52800,53600,54400,55200,56000,56800,57600,58400,59200
VARIABLE    ENDS

STACK         SEGMENT STACK

STACK         ENDS
                      
                              
        
VIZSYS      SEGMENT  PUBLIC 'VIZ'
            ASSUME CS:VIZSYS,DS:VISION,SS:VISION
            PUBLIC PLOT,PKEY,CHAINCOD,CORE,KEYWAIT,DISP,CHARPUT,HIREZ,CLEAR
            PUBLIC GREY,SCREEN,SMALL,VIA,VALOUT,THRESET,CONTRAST,CHKDOOR
            EXTRN FGREY:NEAR,BLIMX:WORD,BLIMY:WORD,XL:WORD,YL:WORD
            EXTRN MESS1OUT:NEAR,MESS2OUT:NEAR,FUNC22:ABS
            EXTRN BOUND:NEAR,MANIPULATE:NEAR,MENOUT:NEAR,RESET:NEAR,UTIL:NEAR
            EXTRN DISK:NEAR,PRINT:NEAR,CAMREAD:NEAR,MSCALE:NEAR,ASCOUT:NEAR,VALUE:WORD
CRTC        EQU    0E800H
SCREEN      EQU    0F000H
REG         EQU    0
REG1        EQU    1
HIREZ       EQU    01000H
STRTPNT     EQU    625*32
IMAGE       EQU    02000H
CHAINCOD    EQU    02EF0H
VIA         EQU    0E800H                       
COUNT       EQU    04
PROG:       MOV AX,VARIABLE     ;Initialize data segment register
            MOV DS,AX
            CALL CLEAR          ;Clears screen 
            MOV DI,OFFSET RGTABLE
            CALL REGSET
            JMP WHOOP
REGSET:     MOV BL,0
            MOV CX,16           ;Set up CRTC
SETSCR:      MOV BH,[DI]        ;Load BH with next element from register table
             MOV AX,CRTC        ;Load DS with segment containing CRTC
             MOV DS,AX  
             MOV SI,0
             MOV [SI],BL        ;Set register number
             MOV SI,01 
             MOV [SI],BH        ;Output value for that register
             MOV AX,VARIABLE    ;Set DS to look at variable segment again
             MOV DS,AX
             INC DI             ;Increment pointer into RGTABLE
             INC BL             ;Increment register number
             LOOPNZ SETSCR
             RET
WHOOP:
                                ;Set up screen pointers

             CALL RESET
                                ;Set up necessary charecter fonts

             MOV SI,0            ;Set up pointer into new screen RAM
             MOV DI,4160         ;Set up pointer into original screen RAM
ASCLOOP:     MOV AX,0           ;Set DS up for original screen RAM
             MOV DS,AX
             MOV BL,[DI]        ;Load BL with element in original screen
             MOV AX,HIREZ       ;pointed to by DI
             MOV DS,AX          ;Set DS up for new screen
             MOV [SI],BL        ;Transfer element
             INC SI             ;Increments both pointers
             INC DI
             CMP DI,6400        ;Loop round until transfer complete
             JNE ASCLOOP


            MOV AX,VARIABLE     ;Reset DS to VARIABLE segment
            MOV DS,AX
                                ;Erase spurious dots in transferred charecter
                                ;fonts
            MOV BX,32           ;Set up addition constant
DOTOFF:     MOV SI,28           ;Set up pointer into new charecter set 
            MOV AX,HIREZ        ;Set up DS for new charecter set
            MOV DS,AX
            MOV CX,60           ;Set up count
DOLOOP:     ADD SI,BX           ;Increment SI by 32
            MOV AX,00 
            MOV [SI],AX         ;Set appropiate byte to zero
            LOOPNZ DOLOOP
            MOV AX,VARIABLE     ;Reset VARIABLE 
            MOV DS,AX


            CALL CLEAR          ;Clear hi-resolution screen

CORE:        MOV AX,400
             MOV BLIMY,AX
             MOV AX,800
             MOV BLIMX,AX
             MOV AX,0
             MOV XL,AX
             MOV YL,AX
             MOV DI,OFFSET FUNC0     
             CALL MENOUT        ;Output MENU1
KEYIN:       CALL KEYWAIT       ;Wait for key
	     CMP AL,241         ;GREYSCALE	
             JNE MKEY1
	     JMP GREYMEN
MKEY1:       CMP AL,242         ;PROCESS                      
             JNE MKEY2
             JMP PROCESS     
CHKDOOR:     PUSH DS            ;CHECK DISK B O.K.
	     MOV AX,0E800H
	     MOV DS,AX
	     MOV DI,0C0H
	     MOV AL,[DI]
	     AND AL,8
	     JNE NODISK
             POP DS
             MOV AL,0
             RET
MKEY2:       CMP AL,243
             JNE MKEY3        
             MOV DI,OFFSET FUNC0
             CALL MENOUT
             CALL DISK
             MOV DI,OFFSET FUNC0
             CALL MENOUT
             JMP KEYIN
NODISK:      POP DS
             MOV DI,OFFSET MESS26
	     CALL MESS1OUT
             MOV DI,OFFSET MESS26+40
	     CALL MESS2OUT
STVWAIT:     CALL KEYWAIT
	     CMP AL,13
	     JNE STVWAIT
	     MOV DI,OFFSET FUNC22
	     CALL MENOUT
             MOV AL,1
             RET      
MKEY3:       CMP AL,244          ;PRINTER 
             JNE MKEY4
             MOV DI,OFFSET FUNC0
             CALL MENOUT
             CALL PRINT 
             MOV DI,OFFSET FUNC0
             CALL MENOUT
             JMP KEYIN  
MKEY4:       CMP AL,245          ;SYSTEM
             JNE MKEY5
             CALL TEXCLR
             MOV DI,OFFSET RESTABLE
             CALL REGSET
             MOV AX,0
             MOV DI,88H
             MOV AL,3AH 
             MOV [DI],AL
             INC DI
             MOV AL,1
             MOV [DI],AL
             INC DI
             MOV AL,0CEH
             MOV [DI],AL
             INC DI
             MOV AL,36H
             MOV [DI],AL
             INT 22H 

MKEY5:      JMP KEYIN



   
GREYMEN:     MOV DI,OFFSET FUNC1
             CALL MENOUT
GKEYIN:      CALL KEYWAIT
             CMP AL,241         ;  REFRESH
             JNE GKEY1
             MOV AX,0
             MOV FILT,AX
             MOV AX,1
             MOV GDF,AX
             CALL CLEAR
             MOV DI,OFFSET MESS6
             CALL MESS1OUT
             MOV DI,OFFSET MENRES
             CALL MESS2OUT
             CALL CAMREAD         
             CALL RESET
             CALL SMALL                    
             JMP GREYMEN

GKEY1:       CMP AL,242        ;GREY
             JNE GKEY2

             MOV CX,GDF 
             CMP CX,1
             JE CONGREY
             MOV DI,OFFSET MENRES
             CALL MESS2OUT
             MOV DI,OFFSET MESS9
             CALL MESS1OUT
             CALL KEYWAIT
             JMP GREYMEN

CONGREY:     CALL CLEAR
             CALL RESET
             CALL FGREY
             JMP GREYMEN

GKEY2:       CMP AL,243         ;MANIPULATE
             JNE GKEY3
             JMP MANIPULATE

GKEY3:       CMP AL,244            ;FILTER
             JNE GKEY4
             MOV AX,1
             MOV FILT,AX
             CALL CLEAR
             MOV DI,OFFSET MESS6
             CALL MESS1OUT
             MOV DI,OFFSET MENRES
             CALL MESS2OUT
             CALL CAMREAD
             CALL RESET
             CALL SMALL
             JMP GREYMEN 

GKEY4:       CMP AL,245     ;CONTRAST
             JNE GKEY5
             CALL CONTRAST
             JMP GREYMEN

GKEY5:       CMP AL,246
             JNE GKEY6       ;THRESHOLD
             CALL THRESET
             CALL CLEAR
             CALL SMALL 
             JMP GREYMEN

GKEY6:       CMP AL,27
             JNE GKEY7
             JMP CORE


GKEY7:       JMP GKEYIN


;Subroutines

ENHANCE:    CALL CLEAR
            MOV AX,2
            MOV FILT,AX
            CALL CAMREAD
            CALL SMALL 
            RET
CHARPUT:    MOV AX,SCREEN   ;Output charecter in CX
            MOV DS,AX       ;To screen position
            PUSH DI         ;(BL,BH) returns
            MOV AX,0
            MOV AL,BL       ;charecter that was there
            MOV DL,2
            MUL DL          ;in DX
            MOV DI,AX
            MOV AX,0
            MOV AL,BH
            MOV DL,100
            MUL DL 
            ADD DI,AX
            MOV DX,[DI]
            MOV [DI],CX
            POP DI
            MOV AX,VARIABLE
            MOV DS,AX
            RET
TEXCLR:     PUSH DS
            MOV DX,SPACE
            MOV AX,SCREEN   ;Clears text screen
            MOV DS,AX
            MOV CX,80*26
            MOV DI,0
TEXAS:      MOV [DI],DX
            INC DI
            INC DI
            LOOPNZ TEXAS
            POP DS
            RET
CLEAR:      MOV AX,HIREZ     ;Clear the screen
            MOV BL,000       ;Set DS pointing to hires RAM
            MOV DS,AX
            MOV DI,20000     ;Set up pointer DI into hires RAM
CLOOP1:      MOV [DI],BL     ;Zero element
             INC DI          ;increment pointer
             CMP DI,60000    ;Loop round until all RAM zero
             JNE CLOOP1
            MOV AX,VARIABLE  ;Reset DS
            MOV DS,AX
            RET

GREY:       MOV AL,THRESH    ;Calculate constants for gray
            SUB AL,CONT      ;levels based on THRESH and CONT
            MOV LVL2,AL
            SUB AL,CONT
            MOV LVL1,AL
            MOV AL,THRESH
            ADD AL,CONT
            MOV LVL3,AL
            ADD AL,CONT
            MOV LVL4,AL
            ADD AL,CONT
            MOV LVL5,AL 
            MOV AX,399       ;Set up Y-coordinate pointer
            MOV DX,AX
            MOV AX,0
            MOV BP,AX        ;Set up X-coordinate pointer
            MOV SI,1         ;Set up pointer into IMAGE
GLOOP:      CALL READEL      ;Read element pointed to by SI
            CMP AL,01        ;See if it is a line pulse
            JE GEOL          ;if it is jump to end of line routine
            PUSH AX
            CALL WIND
            POP AX
            CMP NLFLG,0
            JE CON
            INC BP
            JMP NXT5
CON:        CMP AL,LVL1      ;Test to see if below first level
            JB NXT           ;if it is jump to next level 
            CALL PLOT        ;Plot appropiate point
NXT:        INC BP           ;Increment X-point
            DEC DX           ;Decrement Y-point
            CMP AL,LVL2      ;Comparison as above
            JB NXT1
            CALL PLOT
NXT1:       INC BP
            INC DX
            CMP AL,THRESH     ;As above 
            JB NXT2
            CALL PLOT
NXT2:       DEC BP
            DEC BP
            DEC DX
            CMP AL,LVL3       ;As above 
            JB NXT3
            CALL PLOT
NXT3:                  
            INC BP
            INC BP
            CMP AL,LVL4       ;As above
            JB NXT4
            CALL PLOT
NXT4:       DEC BP
            INC DX
            CMP AL,LVL5       ;As above
            JB NXT5
            CALL PLOT
NXT5:       INC BP
            INC BP
            INC SI            ;Increment pointer into IMAGE 
            JMP GLOOP         ;Loop back to fetch next element
GEOL:       MOV AX,0          ;Set X-point back to start of line
            MOV BP,AX
            DEC DX            ;Decrement Y-point twice
            DEC DX           
            INC SI            ;Increment pointer into IMAGE
            CALL READEL
            CMP AL,01
            JE GEOL
            MOV AX,DX
            CMP AX,1          ;Test to see if we've reached bottem  
            JA  GCYC          ;of the screen     
            RET
GCYC:       JMP GLOOP         ;Loop back to fetch next element
                      
WIND:       CMP BP,BLIMX
            JAE FAIL
            CMP BP,XL
            JB FAIL
            CMP DX,YL
            JB FAIL
            CMP DX,BLIMY
            JA FAIL
            MOV AL,0
            MOV NLFLG,AL
            RET
FAIL:       MOV AL,1
            MOV NLFLG,AL
            RET 

SMALL:      CALL FGREY   
FIN:        RET               ;Returns to main menu            

READEL:     PUSH DS           ;Push DS on stack
            MOV AX,IMAGE      ;Set DS to point at IMAGE 
            MOV DS,AX
            MOV AL,[SI]       ;Load AL with element
            POP DS            ;Pop DS back off stack
            RET
 
 

            
KEYWAIT:    STI                ;Enable interupts
            MOV AH,7           ;Wait for key then returns ASCII code
            INT 21H            ;for key in AL
KEYEND:     RET

PLOT:       CMP BP,800         ;Check to make sure X within screen limit 
	    JA PEX
            CMP DX,399
            JAE PEX
            PUSH AX
            PUSH BX	     
            PUSH CX
            PUSH DI
            PUSH SI
            MOV BX,BP          ;Divide X by 8      
            SHR BX,1 
            SHR BX,1    
            SHR BX,1
            MOV DI,OFFSET LOOKUP1
            AND BX,0FFFEH      ;Use lookup table to find WORD address
            MOV SI,[BX][DI]
            MOV AX,399         ;Subtract Y from 399 to find true screen    
            SUB AX,DX          ;coordinate
            SHL AX,1           ;Multiply by 2 to find coorect number of
            ADD SI,AX          ;bytes down screen then add to X
            MOV BX,BP          ;Now find bit to be used within addressed word
            AND BX,15
            SHL BX,1
            MOV DI,OFFSET MICKEY
PLOOP:                         ;Use lookup table to find correct mask
            MOV AX,[BX][DI]
 
                          
                      
                       
POUT:       MOV CL,LINETYPE    ;Load LINETYPE into CL for later
            PUSH DS            ;Save segment register
            MOV BX,HIREZ       ;Set DS to look at hires screen
            MOV DS,BX
            CMP CL,2           ;If it is 2 inspect point
            JE SPECT
            CMP CL,3           ;If it is 3 plot black point
            JE BLACK
            XOR AX,[SI]         ;Otherwise use mask to set point  
REEN:       MOV [SI],AX
            POP DS             ;Restore all registers
            POP SI
            POP DI
            POP CX
            POP BX
            POP AX
PEX:        RET
SPECT:      MOV BX,[SI]
            AND AX,BX           ;AND WORD with mask to find bit
            PUSH DS
            MOV CX,VARIABLE
            MOV DS,CX
            MOV DOT,AX          ;Then store it in the variable DOT 
            MOV AX,BX
            POP DS
            JMP REEN
BLACK:      XOR AX,0FFFFH
            MOV BX,[SI]
            AND AX,BX
            JMP REEN


THRESET:    MOV DI,OFFSET MESS3
            CALL MESS1OUT
            MOV DI,OFFSET MESS0         
            CALL MESS2OUT
            MOV AL,THRESH        ;Change the threshold value
            CALL VALOUT          ;Output current valu
TLOOP:      CALL KEYWAIT         ;Wait for a key to be pressed
            CMP AL,13            ;If it is ENTER jump to exit routine
            JE TEXIT
            CMP AL,2DH           ;If it is '+' jump to routine that will
            JNE TCYC             ;increse THRESH 
            DEC THRESH           ;Decrement THRESH
TCYC:       CMP AL,2BH           ;Increment THRESH if key is not '-'
            JNE TCYC1
            INC THRESH
TCYC1:      JMP THRESET

TEXIT:      RET          

VALOUT:     MOV BL,15            ;Outputs THRESH in decimal 
            MOV BH,24
            MOV TEMP,100
            MOV AL,THRESH
            MOV TEMP2,AL
            INC BL
VALOOP:     MOV AH,0             ;Outputs THRESH by subsequent divisions
            MOV AL,TEMP2 
            MOV DL,TEMP
            DIV DL
            MOV TEMP2,AH
            MOV DL,18
            ADD AL,DL
            MOV AH,0
            MOV CX,AX
            CALL CHARPUT
            MOV AH,0
            MOV AL,TEMP 
            MOV DL,10
            DIV DL
            MOV TEMP,AL
            INC BL
            CMP BL,19
            JNE VALOOP
            RET

PROCESS:    MOV AX,GDF             ;Check grey scale data exists 
            CMP AX,1
            JE DATX1
            MOV DI,OFFSET MENRES
            CALL MESS2OUT
            MOV DI,OFFSET MESS9
            CALL MESS1OUT
            CALL KEYWAIT
            CMP AL,13
            JNE PROCESS
            JMP CORE

DATX1:      MOV AL,BDF             ;Check if user wishes to overwrite
            CMP AL,1
            JNE DATX2
            MOV DI,OFFSET MESS1
            CALL MESS1OUT
            MOV DI,OFFSET MESS15   ;OVERWRITE DATA Y/N
            CALL MESS2OUT
            CALL KEYWAIT
            CMP AL,89              ;Y
            JE DATX2
            CMP AL,121             ;y
            JE DATX2            
            JMP CONPRO

DATX2:      MOV DI,OFFSET MESS7
            CALL MESS1OUT  
            MOV DI,OFFSET MENRES
            CALL MESS2OUT
            CALL CHAIN
            MOV AL,1
            MOV BDF,AL

CONPRO:     MOV AL,MSF
            CMP AL,0
            JNZ BINARY
            JMP MSCALE
BINARY:     MOV DI,OFFSET FUNC1
            CALL MENOUT          ;Kill main menu
            CALL RESET           ;Reset screen pointers
            MOV DI,OFFSET FUNC2 
            CALL MENOUT          ;Output menu for process routines


PKEY:       CALL KEYWAIT         ;Wait for key to be pressed
            CMP AL,27	         ;EXIT
            JNE PKEY1
            MOV DI,OFFSET FUNC2
            CALL MENOUT          ;Kill process menu
            JMP CORE

           
PKEY1:      CMP AL,241           ;DISP
            JNE PKEY2
            CALL CLEAR           ;Clear hires screen 
            CALL DISP            ;Call routine to display processed data
            JMP PKEY
PKEY2:      CMP AL,243           ;NOMENU
            JNE PKEY3
            MOV DI,OFFSET FUNC2
            CALL MENOUT          ;Kills process menu
            CALL KEYWAIT         ;Wait for key to be pressed
            MOV DI,OFFSET FUNC2
            CALL MENOUT          ;Redisplays process menu
PKEY3:	    CMP AL,242           ;BOUND
            JNE PKEY4
            CALL CLEAR           ;Clear hires screen 
            CALL  BOUND          ;Call routine to display boundary
PKEY4:      JMP PKEY



CHAIN:      MOV CL,THRESH        ;Chain encode image data
            CALL SCAN            ;Call routine that cleans up vertical pixels
            MOV SI,0             ;Set up pointer into image
            MOV DI,0102          ;Set up pointer into processed data
            MOV BX,0             ;Zero pixel count (BH) and colour (BL)
            MOV AX,IMAGE         ;Set DS to image data segment
            MOV DS,AX
CHLOOP:     MOV AL,[SI]          ;Load AL with element
            CMP AL,01            ;See if it is a EOL pulse
            JNE CCYC
            CALL CHEOL           ;If it is call EOL handling routine
CCYC:       CALL NEWEL           ;Call routine to create new encoded element
            CALL GETRUN          ;Call routine that gets a run of similiar pixel
            CALL FINEL           ;Call routine to finish current element
            CMP SI,52444         ;See if we've reached the end of image data
            JB  CHLOOP           ;If not loop up for next element
            MOV AX,CHAINCOD
            MOV DS,AX            ;If we have set DS to encoded data segment
            MOV SI,100
            MOV [SI],DI          ;Write end address of encoded data
            MOV AX,VARIABLE      ;Set DS to point to VARIABLE segment
            MOV DS,AX
            RET                  ;Return from subroutine
CHEOL:      INC SI               ;Increment image data pointer and test to see
            MOV AL,[SI]          ;if element is EOL 
            CMP AL,01
            JE  CHEOL            ;If it is jump to EOL handling routine
            MOV CH,0             ;Set eol flag to zero
            RET
NEWEL:              
            PUSH DS              ;Save current DS
            MOV AX,CHAINCOD      ;Set DS to look at encoded data
            MOV DS,AX
            MOV [DI],CH          ;Write element pointer
            POP DS               ;Retrieve DS
            INC DI               ;Increment encoded data pointer
            CALL THROLD          ;Call threshold routine and save
            MOV BL,AL            ;colour in BL
            RET
GETRUN:     MOV BH,0             ;Set pixel count to zero
CHLOOP1:    MOV AL,[SI]          ;Get element from image and test to see if it
            CMP AL,01            ;is an EOL
            JE  CHYC7
            CALL THROLD          ;Call threshold routine and see if colour is
            CMP BL,AL            ;different
            JNE CHEX             ;if it is see if it is an individual pixel
            INC BH               ;increment pixel count and data pointer
            INC SI
            INC CH
            JMP CHLOOP1          ;Loop back to get next element
CHEX:       INC SI               ;Increment image pointer
            MOV AL,[SI]          ;Load element and see if it is EOL
            CMP AL,01
            JE CHCY8
            MOV AL,[SI]
            CALL THREAT          ;Call threshold routine to see if it is
            CMP AL,BL            ;a diffrent colour
            JNE CHCY8            ;if it is last pixel was not isolated
            INC BH               ;increments pixel count
            INC CH
            JMP CHLOOP1          ;Loop back to get next element
CHCY8:      DEC SI               ;Decrement data pointer
CHYC7:      RET 
FINEL:      PUSH DS              ;Save current DS
            MOV AX,CHAINCOD      ;Set DS to look at encoded data
            MOV DS,AX
            MOV [DI],BH          ;Write pixel count 
            INC DI
            MOV [DI],BL          ;and their colour
            INC DI
            POP DS               ;Retrieve DS
            RET
THROLD:     MOV AL,[SI]          ;Compares current elemnt with threshold
            CMP AL,CL
            JB CHCYC2
            MOV AL,1
            RET
CHCYC2:     MOV AL,0
            RET
SCAN:       MOV AX,IMAGE         ;Set DS to point at image data 
            MOV DS,AX
            MOV DI,256           ;Set pointers to look at elements on 3 lines
            MOV SI,0  
STRT:       MOV AL,[DI]          ;Get first element and store it's colour 
            CALL THREAT          ;in BL
            MOV BL,AL
            MOV AL,[SI]          ;Get secound element and store it's colour
            CALL THREAT          ;in BH
            MOV BH,AL
            MOV AL,[DI+256]      ;Get Third element and store it's colour  
            CALL THREAT          ;in DL
            MOV DL,AL            ;Tests to see if middle pixel isolated
            CMP AL,BH
            JNE NXTPIX
            MOV AL,BH
            CMP AL,BL
            JE NXTPIX            ;If it is set to same colour as pixel above
            MOV AL,[DI]
            MOV [SI],AL
NXTPIX:     INC SI               ;Increment pointers
            INC DI
            CMP DI,0FE00H        ;Loop round until all image scanned
            JE CHINI
            JMP STRT
CHINI:      RET            
THREAT:     CMP AL,CL            ;Compares element with threshold
            JA CHYC1
            MOV AL,0
            RET
CHYC1:      MOV AL,1
            RET
DISP:       PUSH DS               ;Save current EOL
            MOV AX,CHAINCOD       ;Set DS to look at encoded data
            MOV DS,AX
            MOV SI,0100           ;Set up pointer
            MOV AX,[SI]           ;Load end address of encoded data
            POP DS                ;Retrieve DS
            MOV IEND,AX           ;Save end address in IEND 
            MOV SI,102
            MOV AX,0
            MOV AREA,0            ;Set area measurent variable to zer0
            MOV CL,0
            MOV DX,400            ;Set up Y-point 
DLOOP:      CALL GETPIX           ;Call routine to return encoded data element
            CMP AL,0              ;See if it zero
            JNE DCYC              ;If it is EOL implied
            MOV CL,0              ;Reset X-point and pixel count
            MOV BP,0
            DEC DX                ;Move Y-point down 2 lines
            DEC DX
            CMP DX,1              ;See if we have reached end of image
            JE DFIN
DCYC:       MOV AH,0              
            MOV BP,AX
            SHL BP,1              ;BP=X-point*3
            ADD BP,AX
            CALL IDAT             ;Increment data pointers
            CALL GETPIX           ;Get run length
            MOV CL,AL
            CALL IDAT             ;Increment data pointers
            CALL GETPIX           ;Get colour
            CMP AL,0              ;If black skip plot
            JNE DCYC1
            JMP DCYC2
DCYC1:      CALL DPLOT            ;If not plot CL blocks 
            DEC CL
            JE DCYC2
            JMP DCYC1
DCYC2:      CALL IDAT
            CMP SI,IEND
            JNE DLOOP
            RET
GETPIX:     PUSH DS                ;Get encoded element
            MOV AX,CHAINCOD
            MOV DS,AX
            MOV AL,[SI]
            POP DS
            RET
IDAT:       INC SI
            RET
DFIN:       RET
DPLOT:      INC BP                ;Tests to make sure we are with in
            INC BP
            INC BP                ;a window
            CMP DX,YL
            JB FINPLOT
            CMP DX,BLIMY
            JA FINPLOT
            CMP BP,XL
            JB FINPLOT
            CMP BP,BLIMX
            JA FINPLOT                ;if we are it plots a 3*2 block
            INC AREA
            CALL PLOT
            INC BP
            CALL PLOT
            INC BP
            CALL PLOT
            DEC DX
            CALL PLOT
            DEC BP
            CALL PLOT
            DEC BP 
            CALL PLOT
            INC DX

FINPLOT:    RET  

CONTRAST:   MOV DI,OFFSET MESS2
            CALL MESS1OUT
            MOV DI,OFFSET MESS0
            CALL MESS2OUT  
            MOV AL,CONT
            MOV AH,THRESH       ;Move contrast into value
            MOV WORK,AH
            MOV THRESH,AL 
            CALL VALOUT        ;Output value to screen                 
            MOV AH,WORK
            MOV THRESH,AH
CONWAIT:    CALL KEYWAIT       ;Wait for a key to be pressed            
            CMP AL,13          ;Finished
            JE CONFIN
            CMP AL,2BH
            JE CONUP           ;Increment contrast
            CMP AL,2DH
            JE CONDOWN          ;Decrement contrast
            JMP CONWAIT
CONUP:      INC CONT
            JMP CONTRAST
CONDOWN:    DEC CONT
            JMP CONTRAST
CONFIN:     RET


VIZSYS      ENDS                 ;Here endeth the first program
            END PROG
                           
            
            
