;--------------------------------------------------------------------------
;                          ISSUE ROM CODE
;
;                               LO80
;
;                            August 1988
;--------------------------------------------------------------------------

;memory used

;300hw	amount of memory, read by DOS
;302hw
;30Ch	mem test errsum, was w with 1234 fault
;30Dh	was part of 1234 fault, then mem retry cntr, now set to 0 with 30Ch 
;30Ehw
;310hw	boot device no.
;311hb
;316hw
;318hw
;31Ahw
;31Chb	boot error code
;31Dh
;31Fhw
;323hw
;325hw
;327hw
;329hw	cursor posn
;32Bhw	SI on mem fail, flash counter
;32Dh-355hw
;366hw	BM erasure for BASICA
;393hb
;394hb
;3FChw
;3FEhw
;400h	beginning of charset

;-------------------------------------------------------------------------

zero segment at 0h
cseg	segment
zero ends

rom segment
assume cs:rom, ds:zero

disp_dly equ 3ffh

main	proc near

;SET INTERRUPT 2 to CF = IRET

;CS is FE00

                   MOV     WORD PTR CS:[2000h],0h        ;set 00000 to 0

                   MOV     CS:[2008h],0CFF9h              ;set 00008 to CFF9
                   MOV     CS:[200Ah],0F301h              ;set 0000A to F301

                   MOV     CS:[207Eh],SP               ;store SP in 0007E

                   MOV     SP,0E800h                 ;CRT Controller
                   MOV     ES,SP                     ;Turn off display
                   MOV     BYTE PTR ES:[0],1
                   MOV     BYTE PTR ES:[1],0
                   
                   MOV     SP,CS
                   MOV     SS,SP
                   MOV     SP,207Eh                 	;set SP

                   PUSH    AX
                   PUSH    BX
                   PUSH    CX
                   PUSH    DX
                   PUSH    SI
                   PUSH    DI                 
                   PUSH    BP                 
                   
;ROM_CHECK_SUM
                   MOV     AX,0FE00h                 ;PREP. FOR ROM CHECKSUM
                   MOV     ES,AX
                   MOV     CX,1FF9h        	;2000 bytes less chksum store
		   XOR     SI,SI
                   XOR     AX,AX
		   XOR     BX,BX
     CHKSUM_LOOP:  MOV     AL,BYTE PTR ES:[SI]
		   ADD     BX,AX		   ;ADD EVERY BYTE TO
                   INC     SI                      ;CHECKSUM
                   LOOP    CHKSUM_LOOP              ;FE000-FFFF8
		   MOV     AX,ES:[1FFAh]	;CHKSUM stored at 1FFAh
		   CMP     AX,BX                 ;ROM CHECKSUM  
                   JNZ     CHKSUM_ERR
		   JMP     ALTROM

;ERR IN CHKSUM TO PRINTER

CHKSUM_ERR:	   CALL    PRINIT

	           MOV     AL,52h			;R
		   CALL    PRCHAR
	           MOV     AL,4Fh			;O
		   CALL    PRCHAR
	           MOV     AL,4Dh			;M
		   CALL    PRCHAR
	           MOV     AL,20h			;(space)
		   CALL    PRCHAR
	           MOV     AL,43h			;C
		   CALL    PRCHAR
	           MOV     AL,48h			;H
		   CALL    PRCHAR
	           MOV     AL,4Bh			;K
		   CALL    PRCHAR
	           MOV     AL,53h			;S
		   CALL    PRCHAR
	           MOV     AL,55h			;U
		   CALL    PRCHAR
	           MOV     AL,4Dh			;M
		   CALL    PRCHAR
	           MOV     AL,20h			;(space)
		   CALL    PRCHAR
	           MOV     AL,45h			;E
		   CALL    PRCHAR
	           MOV     AL,52h			;R
		   CALL    PRCHAR
	           MOV     AL,52h			;R
		   CALL    PRCHAR

		   CALL    PRTERM

ALTROM:		   MOV     AX,0D000h
                   MOV     DS,AX                   ;DS TO TOP OF RAM
                   MOV     AX,DS:[0]               ;D000:0
                   MOV     BX,AX
                   NOT     AX
                   MOV     DS:[0],AX
                   CMP     DS:[0],AX               ;TEST RAM AT D000:0
                   MOV     DS:[0],BX               ;REPLACE ORIGINAL BYTE
                   JZ      SCR_RAM_FILL		;IF D000:0 IS R/W THEN JMP
                   MOV     CX,64h
 ALTROM_CHK_LOOP:  CMP     BYTE PTR DS:[0],0E9h      ;look for JMP at D0000
                   JNZ     SCR_RAM_FILL
                   LOOP    ALTROM_CHK_LOOP         ;if JMP is always there, 
		   DB	   0EAh
		   DW	   0
		   DW	   0D000h			;JMP to D000:0

SCR_RAM_FILL:      MOV     AX,0F000h
                   MOV     ES,AX	      	;FILL 2k AT BOTTOM OF   
                   MOV     AX,55AAh             ;SCREEN RAM WITH 55AA   
  TOGGLE_SCR_RAM:  XOR     DI,DI                  ;THEN AA55, THEN 0    
                   MOV     CX,800h
                   CLD
                   REPZ    STOSW
                   CMP     AX,0    
                   JZ      LOWMEM_TEST
                   XOR     DI,DI
                   MOV     CX,800h
                   REPZ    SCASW                        ;CHECK THAT FILL OK
                   JNZ     SCR_RAM_FAIL
                   XOR     AX,0FFFFh
                   JL      TOGGLE_SCR_RAM
                   XOR     AX,AX
                   JMP     TOGGLE_SCR_RAM

SCR_RAM_FAIL:      CALL    PRINIT

    	 	   MOV     AL,53h			;S
		   CALL    PRCHAR
	           MOV     AL,43h			;C
		   CALL    PRCHAR
	           MOV     AL,52h			;R
		   CALL    PRCHAR
	           MOV     AL,4Eh			;N
		   CALL    PRCHAR

		   JMP     SLR_FAIL

LOWMEM_TEST:       XOR     AX,AX 
                   MOV     DS,AX		;TEST 00080 TO 0FFFF
                   MOV     CX,0FF7Fh		;FFFFh - 80h
  		   MOV     SI,80h
	    LR_1:  MOV     DL,DS:[SI]		;Store orig. byte
		   MOV     DS:[SI],CL
		   CMP     DS:[SI],CL
		   JNZ     LOWMEM_FAIL
		   MOV     DS:[SI],DL		;Replace orig. byte
		   INC     SI
		   LOOP    LR_1
		   JMP     START

LOWMEM_FAIL:       CALL    PRINIT

                   MOV     AL,4Ch			;L
		   CALL    PRCHAR
	           MOV     AL,4Fh			;O
		   CALL    PRCHAR
	           MOV     AL,57h			;W
		   CALL    PRCHAR

SLR_FAIL:          MOV     AL,20h			;(space)
		   CALL    PRCHAR
	           MOV     AL,52h			;R
		   CALL    PRCHAR
	           MOV     AL,41h			;A
		   CALL    PRCHAR
	           MOV     AL,4Dh			;M
		   CALL    PRCHAR
	           MOV     AL,20h			;(space)
		   CALL    PRCHAR
	           MOV     AL,46h			;F
		   CALL    PRCHAR
	           MOV     AL,41h			;A
		   CALL    PRCHAR
	           MOV     AL,49h			;I
		   CALL    PRCHAR
		   MOV     AL,4Ch			;L
		   CALL    PRCHAR

		   CALL    PRTERM

START:		   MOV     AX,0E800h
		   MOV     ES,AX
		   MOV     WORD PTR ES:[00C2h],35C4h	;INIT VIA 6
    		   MOV     BYTE PTR ES:[00CFh],5
    		   AND     BYTE PTR ES:[00CFh],0FAh	;DISC LEDs OFF

		   XOR     AX,AX			;DS -> 0
                   MOV     DS,AX

;SET 'BM' FLAG TO 0 FOR GETSCRN, KILLSCRN, BASICA

		   MOV     DS:[366h],AX			;AX=0

;SET UP ROM CONSTS. IN MEMORY

		   MOV     WORD PTR DS:[30Ch],0	    ;was store for 1234 faults
		   MOV	   WORD PTR DS:[32Dh],0	    ;booting cycle register
		   MOV	   WORD PTR DS:[32Fh],0
		   MOV	   DS:[331h],0FFFFh
		   MOV	   DS:[333h],0F15h	  	;FL   /E_DISC_SYMBL 
		   MOV	   WORD PTR DS:[335h],6
		   MOV	   WORD PTR DS:[337h],1
		   MOV	   WORD PTR DS:[339h],0
		   MOV	   WORD PTR DS:[33Bh],3Eh
		   MOV	   DS:[33Dh],0F15h		;FL   /E_DISC_SYMBL
		   MOV	   DS:[33Fh],106h
		   MOV	   DS:[341h],2000h
		   MOV	   WORD PTR DS:[343h],0
		   MOV	   WORD PTR DS:[345h],1
		   MOV	   DS:[347h],171Dh		;NT   /NET_SYMBL
		   MOV	   DS:[349h],8000h
		   MOV	   DS:[34Bh],1000h
		   MOV	   WORD PTR DS:[34Dh],0
		   MOV	   WORD PTR DS:[34Fh],1
		   MOV	   DS:[351h],110Dh		;HD   /HD_SYMBL
		   MOV	   DS:[353h],1001h
		   MOV     DS:[355h],0FFFFh

		   MOV	   SS,AX
                   LEA     SP,DS:[3FCh]
                   CALL    STO_CHARSET

                   MOV     AX,4020h 
                   MOV     DS:[327h],AX                ;STO BEG. OF CHARSET ?
                   ADD     AX,25h		
                   MOV     DI,0F000h            
                   MOV     ES,DI
                   XOR     DI,DI
                   MOV     CX,7D0h		;PAINT SCREEN RAM     
                   REPZ    STOSW                    ;WITH 4045 = 4020 + 25

                   MOV     AX,0E800h                 ;VIA 2 /SCREEN
                   MOV     ES,AX                     ;BRIGHTNESS
                   MOV     BYTE PTR ES:[40h],55h     ;PPORT  TALK/LISTEN
                   MOV     BYTE PTR ES:[42h],0FFh
                   CALL    LOAD_CRTC

		   MOV	   AX,121Ch
		   MOV	   BX,1C1Eh			;ISSU
                   MOV     CL,1				;position
                   CALL    FOUR_CHARS                  
		   MOV	   AX,0E25h
		   MOV	   BX,1B18h			;E RO
		   MOV	   CL,5
		   CALL    FOUR_CHARS
		   MOV	   AX,1625h			;M (space)
		   MOV	   CL,9
		   CALL	   TWO_CHARS

		   MOV     AX,DISP_DLY
		   CALL    DELAY_BY_AX

;PIC
		   MOV	   AX,1912h
		   MOV	   BX,0C24h			;PIC:
		   MOV	   CL,0Dh
		   CALL	   FOUR_CHARS

		   MOV     AX,DISP_DLY
		   CALL    DELAY_BY_AX

		   MOV     AX,0E000h
                   MOV     ES,AX
                   MOV     BYTE PTR ES:[0],17h      ;E0000 8259 PIC
                   MOV     BYTE PTR ES:[1],20h
                   MOV     BYTE PTR ES:[1],1
                   CMP     BYTE PTR ES:[1],0
                   JNZ     PIC_FAIL
                   MOV     BYTE PTR ES:[1],0AAh
                   CMP     BYTE PTR ES:[1],0AAh
                   JNZ     PIC_FAIL
                   MOV     BYTE PTR ES:[1],55h
                   CMP     BYTE PTR ES:[1],55h
                   JNZ     PIC_FAIL
                   MOV     BYTE PTR ES:[1],0FFh
                   CMP     BYTE PTR ES:[1],0FFh
                   JNZ     PIC_FAIL
                   MOV     CX,8                 ;SEND 60-67 TO PIC
                   MOV     AL,60h
       PIC_LOOP:   MOV     ES:[0],AL               ;E0000 PIC
                   INC     AL
                   LOOP    PIC_LOOP
                   JMP     PIC_PASS

PIC_FAIL:          MOV	   AX,0F0Ah
		   MOV	   BX,1215h		;FAIL
		   MOV	   CL,11h
		   CALL    FOUR_CHARS
		   JMP     VIA_1

PIC_PASS:	   MOV	   AX,190Ah
		   MOV	   BX,1C1Ch		;PASS
		   MOV	   CL,11h
		   CALL    FOUR_CHARS

VIA_1:		   MOV     AX,DISP_DLY
		   CALL    DELAY_BY_AX

		   MOV	   AX,1919h
		   MOV	   BX,181Bh
		   MOV	   CL,18h
		   CALL	   FOUR_CHARS
		   MOV	   AX,1D24h		;PPORT:
		   MOV	   CL,1Ch
		   CALL	   TWO_CHARS

		   MOV     AX,DISP_DLY
		   CALL    DELAY_BY_AX

		   MOV	   AX,0E000h
		   MOV	   ES,AX
		   MOV     WORD PTR ES:[8022h],0FF03h    ;E8022
                   CMP     WORD PTR ES:[8022h],0FF03h     ;6522 VIA 1
                   JNZ     VIA_1_FAIL
                   MOV     AL,ES:[8021h]
                   CMP     AL,ES:[802Fh]
                   JNZ     VIA_1_FAIL
                   MOV     AX,ES:[8024h]
                   CMP     AX,ES:[8024h]
                   JZ      VIA_1_FAIL
                   MOV     AX,ES:[8028h]
                   CMP     AX,ES:[8028h]
                   JNZ     VIA_1_PASS

VIA_1_FAIL:        MOV	   AX,0F0Ah
		   MOV	   BX,1215h		;FAIL
		   MOV	   CL,1Eh
		   CALL    FOUR_CHARS
		   JMP     VIA_2

VIA_1_PASS:	   MOV	   AX,190Ah
		   MOV	   BX,1C1Ch		;PASS
		   MOV	   CL,1Eh
		   CALL    FOUR_CHARS

VIA_2:		   MOV     AX,DISP_DLY
		   CALL    DELAY_BY_AX

		   MOV	   AX,140Bh
		   MOV	   BX,1918h
		   MOV	   CL,25h
		   CALL	   FOUR_CHARS
		   MOV	   AX,1B1Dh		;KBPORT:
		   MOV	   CL,29h
		   CALL	   TWO_CHARS
		   MOV	   AH,24h
		   MOV	   CL,2Bh
		   CALL    ONE_CHAR

		   MOV     AX,DISP_DLY
		   CALL    DELAY_BY_AX

		   MOV	   AX,0E000h
		   MOV	   ES,AX
		   MOV     WORD PTR ES:[8042h],3FFh    ;E8042
                   CMP     WORD PTR ES:[8042h],3FFh    ;6522 VIA 2
                   JNZ     VIA_2_FAIL
                   MOV     AL,ES:[8041h]
                   CMP     AL,ES:[804Fh]
                   JNZ     VIA_2_FAIL
                   MOV     AX,ES:[8044h]
                   CMP     AX,ES:[8044h]
                   JZ      VIA_2_FAIL
                   MOV     AX,ES:[8048h]
                   CMP     AX,ES:[8048h]
                   JNZ     VIA_2_PASS

VIA_2_FAIL:        MOV	   AX,0F0Ah
		   MOV	   BX,1215h		;FAIL
		   MOV	   CL,2Ch
		   CALL    FOUR_CHARS
		   JMP     PRE_MEM_TEST

VIA_2_PASS:	   MOV	   AX,190Ah
		   MOV	   BX,1C1Ch		;PASS
		   MOV	   CL,2Ch
		   CALL    FOUR_CHARS

PRE_MEM_TEST:	   MOV     AX,DISP_DLY
		   CALL    DELAY_BY_AX

                   MOV     AX,1B0Ah
                   MOV     BX,1624h
                   MOV     CL,34h
                   CALL    FOUR_CHARS                  ;RAM:

                   CMP     WORD PTR DS:[0],0      ;DS:[0000]
                   JZ      START_MEM_TEST
		   XOR	   AX,AX
		   CALL	   REPORT_MEM
		   JMP	   JUMP_OFF

START_MEM_TEST:    MOV     AX,1000h 
		   PUSH	   AX
		   CALL    REPORT_MEM		;mem 256 - 64k already tested
                   POP	   AX
		   MOV     DI,0FFFFh		;default to full memtest
		   MOV     BX,1			;DI=loop length BX=incr
		   MOV     DX,DS:[300h]		;check to see if reboot
		   CMP     DX,0
		   JZ      DS_TO_MEM		;might be all 0 on power up
		   MOV     CL,4
		   SHL     DX,CL
		   CMP     DX,0			;0 if mem stored before
		   JNZ     DS_TO_MEM
		   MOV     DI,1FFFh		;FAST BOOT chk every 8 bytes
		   MOV     BX,8h		;SET FAST BOOT SPEED

DS_TO_MEM:	   MOV     DS,AX		;****  DS > 0 ****

MEMTEST:           MOV     CX,DI		;TEST 64K
		   XOR     SI,SI		;FAST OR SLOW
	    MT_1:  MOV	   DL,DS:[SI]		;save mem contents
		   MOV	   DS:[SI],CL		;FF FE FD FC ...
		   CMP     DS:[SI],CL
		   JNZ     MEM_FAIL
		   MOV	   DS:[SI],DL		;restore mem contents
		   ADD	   SI,BX	;FAST or SLOW BOOT according to BX
		   LOOP	   MT_1

MEM_TEST_INCR:     MOV	   AX,DS
                   ADD     AX,1000h		;Move to next 64K
                   MOV     DS,AX
		   PUSH    DS
		   XOR     BX,BX
		   MOV     DS,BX		;DS to 0 for CALL
		   CALL	   REPORT_MEM		;MEM is in AX
		   POP     DS
		   MOV	   AX,DS
                   CMP     AX,0E000h
                   JNZ     MEMTEST
						;NOW MEM = 896K follow thro'

;now CL = what should be, DS:[SI] what is

MEM_FAIL:          XCHG    CH,CL		;what should be into CH
		   MOV     CL,DS:[SI]		;CX = what should be, what is
		   XOR     CH,CL	         ;errsum now in CH

		   MOV     AX,DS
		   XOR     BX,BX
		   MOV     DS,BX		;**** DS back to 0 ****

		   MOV     DS:[300h],AX         ;STO MEMORY AT 00300
		   MOV     DS:[30Ch],CH		;store errsum
 		   MOV     DS:[32Bh],SI		;store SI=location of mem fail

		   CALL	   REPORT_MEM		;mem amount in AX

		   MOV	   AH,24h		;char to print ":"
		   MOV	   CL,3Ch		;position
		   CALL    ONE_CHAR			; :

		   MOV     AX,DS:[300h]
		   CMP     AX,0E000h		;If 896k then PASS
		   JZ      MEM_PASS

FAIL_TYPE:	   MOV     AH,DS:[30Ch]		;get errsum
	           CMP     AH,0F0h
		   JAE	   MEM_PASS	     ;ERRSUM >F0 = >3 bits fail - PASS

	   MB_7:   CMP     AH,128
		   JB	   MB_6
		   MOV     DH,7
		   JMP	   BIT

	   MB_6:   CMP     AH,64
		   JB      MB_5
	   	   MOV     DH,6
		   JMP	   BIT

	   MB_5:   CMP     AH,32
		   JB      MB_4
	   	   MOV     DH,5
		   JMP	   BIT

	   MB_4:   CMP     AH,16
		   JB      MB_3
	   	   MOV     DH,4
		   JMP	   BIT

	   MB_3:   CMP     AH,8
		   JB      MB_2
	   	   MOV     DH,3
		   JMP	   BIT

	   MB_2:   CMP     AH,4
		   JB      MB_1
	   	   MOV     DH,2
		   JMP	   BIT

	   MB_1:   CMP     AH,2
		   JB      MB_0
	   	   MOV     DH,1
		   JMP	   BIT

	   MB_0:   CMP     AH,1
		   JB      BIT
	   	   MOV     DH,0

	   BIT:	   MOV     AX,0B12h
		   MOV	   BH,1Dh		;BIT
		   MOV     BL,DH		;0-7
		   MOV     CL,3Dh
		   CALL    FOUR_CHARS
		   JMP     JUMP_OFF

MEM_PASS:	   MOV	   AX,190Ah
		   MOV	   BX,1C1Ch		;PASS
		   MOV	   CL,3Dh
		   CALL    FOUR_CHARS

JUMP_OFF:          MOV     BP,0FFF6h
            JO_1:  ADD     BP,0Ah
                   MOV     AX,[BP+32Dh]            ;FFF6+A = 0  SS:[BP+32Dh]
                   CMP     AX,0FFFFh                 ;SS=0000
                   JZ      BOOT_SET
                   MOV     AX,[BP+32Dh]            ;RD 0032D
                   CMP     AX,0FF00h
                   JZ      JO_1
                   MOV     DS:[310h],AX
                   MOV     WORD PTR DS:[30Eh],4000h    ;USED FOR CJA/1
                   PUSH    BP
                   CALL    CALC_JMP_ADDR           ;JUMPS TO FF000
                   POP     BP
                   JZ      JO_1
                   MOV     WORD PTR [BP+32Dh],0FF00h
                   JMP     JO_1

BOOT_SET:	   MOV     WORD PTR DS:[394h],0
		   MOV     WORD PTR DS:[30Ch],0		;reset - no fault
		   MOV     WORD PTR DS:[32Bh],0		;reset flash counter

		   MOV     AX,0E800h		;DISC VIA 4
                   MOV     ES,AX
                   MOV     BYTE PTR ES:[0CFh],5      ;VIA 6  DISC LEDs ON
		   MOV     AL,ES:[0A1h]		;DRIV A: MOTOR STATUS
		   AND     AL,0F0h
		   MOV     ES:[0A1h],AL		   
		   MOV     AL,ES:[0A0h]		;DRIV B: MOTOR STATUS
		   AND     AL,0F0h
		   MOV     ES:[0A0h],AL		   

		   MOV     AX,1FFFh
		   CALL    DELAY_BY_AX

BOOT_RETRY_INIT:   MOV     BP,0FFF6h

BOOT_RETRY:	   MOV     WORD PTR DS:[32Bh],0
		   ADD     BP,0Ah
		   MOV     AX,[BP+32Dh]
		   CMP     AX,0FFFFh
		   JNZ     TO_NORM_BOOT
		   JMP     SERIAL_BOOT

TO_NORM_BOOT:      JMP     NORM_BOOT


;--------------------------------------------------------------

PRINIT:		   MOV	   AX,0E802h
		   MOV	   ES,AX
		   MOV     ES:[2h],0FF03h	 	;setup VIA, PB0 to o/p
		   MOV     BYTE PTR ES:[0h],1		;sets strobe high
		   MOV     CX,7FFh
	       A:  LOOP    A 
		   RET

PRCHAR:  	   PUSH    CX
		   MOV     BYTE PTR ES:[1h],AL		;data
		   MOV     CX,80h
	       B:  LOOP    B
	 	   MOV     BYTE PTR ES:[0h],0		;strobe low 
		   MOV     CX,100h
	       C:  LOOP    C 
		   MOV     BYTE PTR ES:[0h],1		;sets strobe high
		   MOV     CX,1FFFh			;delay until next char
	       D:  LOOP    D
		   POP     CX
  		   RET

PRTERM:		   MOV     AL,0Dh			;CR
		   CALL    PRCHAR
	           MOV	   CX,8h
	      LF:  MOV     AL,0Ah
		   CALL    PRCHAR
		   LOOP    LF
		   RET

STO_CHARSET:       PUSH    DS
                   POP     ES
                   LEA     DI,DS:[400h]
                   PUSH    DS
                   MOV     SI,0B40h		;was LEA SI,[0BD0h]
                   PUSH    CS
                   POP     DS
                   MOV     CX,260h
                   CLD
                   REPZ    MOVSW
                   POP     DS
                   RET

STO_CHAR_TALK:     CALL    STO_CHARSET       ;05FE ;from 04CE- REWRITTEN
    LOAD_CRTC:     MOV     BX,005Ch		;reg 0 horiz total
                   CALL    BX_TO_CRTC
		   MOV     BX,0150h		;reg 1 horiz display
                   CALL    BX_TO_CRTC
		   MOV     BX,0251h		;reg 2 horiz sync (posn)
                   CALL    BX_TO_CRTC
		   MOV     BX,03CFh		;reg 3 sync width
                   CALL    BX_TO_CRTC
		   MOV     BX,0419h		;reg 4 vert total
                   CALL    BX_TO_CRTC
		   MOV     BX,0506h		;reg 5 vert total adjust
                   CALL    BX_TO_CRTC
		   MOV     BX,0619h		;reg 6 vert display
                   CALL    BX_TO_CRTC
		   MOV     BX,0719h		;reg 7 vert sync (posn)
                   CALL    BX_TO_CRTC
		   MOV     BX,0803h		;reg 8 -> non i/lace, non skew
                   CALL    BX_TO_CRTC
		   MOV     BX,090Eh		;reg 9 raster
                   CALL    BX_TO_CRTC
		   MOV     BX,0A20h		;reg 10 cursor -> non display
                   CALL    BX_TO_CRTC
		   MOV     BX,0B00h
                   CALL    BX_TO_CRTC
		   INC	   BH			;=MOV BX,0C00h
                   CALL    BX_TO_CRTC
		   INC     BH			;=MOV BX,0D00h
                   CALL    BX_TO_CRTC
		   INC	   BH			;=MOV BX,0E00h
                   CALL    BX_TO_CRTC
		   INC     BH			;=MOV BX,0F00h
		   CALL    BX_TO_CRTC
		   RET

TWO_CHARS:         MOV     BX,0FFFFh
FOUR_CHARS:        PUSH    AX
                   PUSH    AX
                   PUSH    BX
                   CALL    CURS_INCR
                   POP     DX
                   POP     AX
                   CALL    ONE_CHAR
                   POP     AX
                   MOV     AH,AL
                   CALL    ONE_CHAR
                   MOV     AH,DH
                   CALL    ONE_CHAR
                   MOV     AH,DL
ONE_CHAR: 	   CMP     AH,0FFh
                   JZ      SC_1                    ;IF AH=FF THEN RET
                   XCHG    AH,AL
                   XOR     AH,AH
                   ADD     AX,DS:[327h]
                   MOV     SI,0F000h
                   MOV     ES,SI
                   MOV     SI,DS:[329h]
                   ADD     SI,SI
                   MOV     ES:[SI+0F00h],AX		;ES=F000
                   INC     WORD PTR DS:[329h]
                   MOV     CX,DS:[329h]
CURS_INCR:  	   XOR     CH,CH
                   MOV     DS:[329h],CX               ;00329
                   ADD     CX,780h
                   MOV     BH,0Eh		;cursor location
                   MOV     BL,CH
                   CALL    BX_TO_CRTC
                   MOV     BH,0Fh               ;cursor location
                   MOV     BL,CL
BX_TO_CRTC:        MOV     AX,0E800h
                   MOV     ES,AX
                   MOV     ES:[0],BH
                   MOV     AX,1
                   CALL    DELAY_BY_AX
                   MOV     ES:[1],BL
           SC_1:   RET

DELAY_BY_AX:       PUSH    CX
                   OR      AX,AX
                   JZ      DY_2                    ;STRAIGHT BACK IF AX=0
            DY_1:  MOV     CL,78h
                   SHR     CL,CL
                   DEC     AX
                   JNZ     DY_1
            DY_2:  POP     CX
                   RET

REPORT_MEM:        MOV     CL,6
                   SHR     AX,CL
                   MOV     BL,0Ah
                   DIV     BL
                   MOV     BH,AH
                   XOR     AH,AH
                   DIV     BL
                   XCHG    AH,AL
                   MOV     BL,14h			;K
                   MOV     CL,38h
                   CALL    FOUR_CHARS                 ;O/P AMOUNT OF MEM
		   RET


jump_addresses	dw	0000h   ;FAIL 			BX = 0
		dw	1000h   ;F_DRIV_0:
		dw	10C6h   ;F_DRIV_DR_1: DOORS STABLE OVER TWO READS
		dw	1105h   ;F_DRIV_DR_2: DISC DOORS STABLE OVER TWO READS
		dw	128Ah   ;F_DRIV_1:
		dw	14D1h   ;F_DRIV_2:
		dw	14E3h   ;F_DRIV_3:
		dw	162Eh   ;HD_DMA_1: ES SET UP FOR HARD DISC DMA CTRL
		dw	16A9h   ;HD_DMA_2:
		dw	16C9h   ;HD_DMA_3:
		dw	17CFh   ;HD_DMA_4:
		dw	0000h   ;was xor ax,ax ret	BX = 16
		dw	0000h   ;was xor ax,ax ret	BX = 18
		dw	1B20h   ;NETWORK_1:
		dw	1B7Bh   ;NETWORK_2:
		dw	1BFEh   ;NETWORK_3:
		dw	1C6Bh   ;NETWORK_4:
		dw	1CE7h   ;NETWORK_5:
		dw	0000h  ;was xor ax,ax ret	BX = 24


CALC_JMP_ADDR:     MOV     BYTE PTR DS:[31Ch],00
		   MOV     AL,DS:[311h]
      		   MOV     CL,04
      		   SHR     AL,CL
      		   MOV     DX,DS:[30Eh]
      		   XOR     BX,BX
      		   CMP     DH,40h
      		   JNZ     CJA_2
      		   MOV     AH,05
      		   CMP     DL,AH
      		   JBE     CJA_1
      		   MOV     DL,AH
	   CJA_1:  CMP     AL,02
	           JA      CJA_2
	           INC     AH
	           SHL     AH,1
	           MUL     AH
	           MOV     BL,DL
	           INC     BX
	           SHL     BX,1
	           ADD     BX,AX
	   CJA_2:  CMP     BX,16h		;"BX" in table above
		   JZ      CJA_3
		   CMP     BX,18h
		   JZ      CJA_3
		   CMP     BX,24h
		   JZ      CJA_3
		   MOV     AX,offset jump_addresses
		   ADD     BX,AX
		   MOV     AX,CS:[BX]
	           JMP     AX

	   CJA_3:  XOR     AX,AX
	           RET

EBD_ON_OFF:        MOV	   CL,45h
                   CMP     BYTE PTR DS:[393h],0
                   JZ      EBD_OFF
                   MOV     AX,[BP+333h]			;FL or NT or HD
		   MOV     CL,45h
		   CALL	   TWO_CHARS
		   CALL    BOOT_MSG
                   RET

         EBD_OFF:  MOV     AX,2525h
		   CALL    TWO_CHARS
                   MOV     AX,2525h
                   MOV     BX,2525h
	           MOV	   CL,47h
		   CALL    FOUR_CHARS
		   MOV	   AH,25h
		   MOV     CL,4Bh
		   CALL    ONE_CHAR
		   RET

BOOT_MSG:	   MOV	   AX,0B18h		;BOOT:
		   MOV	   BX,181Dh
	           MOV	   CL,47h
		   CALL    FOUR_CHARS
		   MOV     AH,24h
		   MOV	   CL,4Bh
		   CALL	   ONE_CHAR
                   RET

;----------------------------------------------------------------------


SERIAL_BOOT:       MOV     AX,0E004h		      ;ES to E0040
                   MOV     ES,AX                         ;7201 COMMS. CTRL
                   MOV     AL,ES:[2]
                   MOV     AL,ES:[3]
                   MOV     BYTE PTR ES:[2],18h
                   MOV     BYTE PTR ES:[3],18h
                   MOV     BYTE PTR ES:[2],02h
                   MOV     BYTE PTR ES:[2],10h
                   MOV     BYTE PTR ES:[3],02h
                   MOV     BYTE PTR ES:[3],00h
                   MOV     BYTE PTR ES:[2],04h
                   MOV     BYTE PTR ES:[2],47h
                   MOV     BYTE PTR ES:[2],03h
                   MOV     BYTE PTR ES:[2],0C1h
                   MOV     BYTE PTR ES:[2],05h
                   MOV     BYTE PTR ES:[2],0EAh
                   MOV     BYTE PTR ES:[2],10h
                   MOV     BYTE PTR ES:[2],30h
                   MOV     BYTE PTR ES:[2],01h
                   MOV     BYTE PTR ES:[2],04h

                   MOV     AX,0E804h		      ;ES to E8040   
                   MOV     ES,AX                    ;VIA 2  KBD, SCREEN 
                   OR      BYTE PTR ES:[3],03h
                   AND     BYTE PTR ES:[3],0C3h
                   AND     BYTE PTR ES:[1],0FCh

                   MOV     AX,0E002h			 ;ES to E0020  
                   MOV     ES,AX                         ;8253  TIMER         
                   MOV     BYTE PTR ES:[3],36h               
                   MOV     BYTE PTR ES:[0],41h               
                   MOV     BYTE PTR ES:[0],00h                 

                   MOV     AX,0E004h                      ;ES to E0040  
                   MOV     ES,AX                          ;7201 COMMS. CTRL
                   MOV     CX,4E20h
                   MOV     BYTE PTR ES:[2],10h
                   MOV     BYTE PTR ES:[2],30h

                   MOV     AX,0E804h			 ;ES to E8040
                   MOV     ES,AX                        ;VIA 2 KBD, SCREEN    
                   TEST    BYTE PTR ES:[1],0Ch
		   JZ      SB_0
                   JMP     BOOT_INIT

SB_0:              MOV     AX,0E004h			;ES to E0040  
                   MOV     ES,AX                         ;7201 COMMS. CTRL
                   TEST    BYTE PTR ES:[2],40h
		   JNZ     SB_1
                   JMP     BOOT_INIT

SB_1:              TEST    BYTE PTR ES:[2],01h
                   JNZ     SB_2
                   MOV     AX,0001h
                   CALL    DELAY_BY_AX
                   LOOP    SB_1
                   JMP     BOOT_INIT

SB_2:              MOV     BX,0200h
                   MOV     AX,0000
                   MOV     DS,AX
                   MOV     DI,4000h
SB_3:              MOV     CX,0FFFFh
SB_4:              TEST    BYTE PTR ES:[2],01
                   JNZ     SB_5
                   LOOP    SB_4
                   JMP     BOOT_INIT

SB_5:              MOV     AL,ES:[0]			;7201 COMMS CTRL
                   MOV     BYTE PTR ES:[2],01
                   MOV     AH,ES:[2]
                   AND     AH,30h
		   JZ      SB_6
                   JMP     BOOT_INIT

SB_6:              MOV     ES:[0],AL
                   MOV     [DI],AL
                   INC     DI
                   DEC     BX
                   JNZ     SB_3
                   MOV     WORD PTR DS:[3FCh],4000h	 ;SET INT FF TO 40000h
                   MOV     WORD PTR DS:[3FEh],0000
                   INT     0FFh                          ;BOOT

;===============================================================


BOOT_FAIL_CODE:    MOV     AH,DS:[31Ch]	;error code
                   MOV     AL,AH
                   MOV     CL,04
                   SHR     AH,CL
                   AND     AL,0Fh
		   MOV     BH,AL
		   MOV     AL,AH		;err code in AL,BH
		   MOV     AH,21h		;X
		   MOV     BL,25h		;(space)
                   MOV     CL,4Ch
                   CALL    FOUR_CHARS		;O/P ERROR CODE
		   JMP     BF_0

BOOT_FAIL:         MOV     AX,2121h		;NO ERROR CODE
		   MOV     BX,2525h
		   MOV     CL,4Ch
		   CALL    FOUR_CHARS		;XX (space) (space)

BF_0:              TEST    WORD PTR [BP+335h],4
                   JZ      BF_1
                   MOV     WORD PTR DS:[30Eh],4004h
                   PUSH    BP
                   CALL    CALC_JMP_ADDR		;JUMPS TO FF4D1
                   POP     BP
BF_1:              TEST    WORD PTR [BP+335h],2
                   JZ      BF_3
                   MOV     WORD PTR DS:[30Eh],4005h
                   PUSH    BP
                   CALL    CALC_JMP_ADDR		;JUMPS TO FF4E3
                   POP     BP
                   JNZ     BF_3
BF_2:              PUSH    BP
                   CALL    CALC_JMP_ADDR		;JUMPS TO FF4E3
                   POP     BP
                   JZ      BF_2
                   JMP     BF_4

BF_3:              MOV     AX,4E20h
                   CALL    DELAY_BY_AX

BF_4:              MOV     AX,[BP+335h]
                   TEST    AX,0001
                   JZ      BF_5
                   MOV     WORD PTR [BP+32Dh],0FF00h
BF_5:              JMP     BOOT_SET

;-----------------------------------------------------------------------


BOOT_INIT:         XOR     BP,BP
NORM_BOOT:         MOV     AX,[BP+331h]
                   MOV     [BP+32Fh],AX
                   CMP     WORD PTR [BP+32Dh],0
                   JNZ     BT_1
                   MOV     AX,[BP+33Bh]
                   MOV     [BP+339h],AX

BT_1:              MOV     BYTE PTR DS:[393h],0
                   CALL    EBD_ON_OFF

                   MOV     AX,[BP+32Dh]
                   CMP     AX,0FF00h
                   JNZ     FLASH_EBD
                   JMP     BOOT_RETRY

FLASH_EBD:         INC     WORD PTR DS:[32Bh]		;count
                   MOV     AX,DS:[32Bh]
                   CMP     AX,001Fh
                   JNZ     BT_2
                   XOR     BYTE PTR DS:[393h],1
                   CALL    EBD_ON_OFF
                   MOV     WORD PTR DS:[32Bh],0		;reset flash counter

BT_2:              MOV     AX,[BP+32Dh]
                   MOV     DS:[310h],AX
                   MOV     WORD PTR DS:[30Eh],4001h
                   PUSH    BP
                   CALL    CALC_JMP_ADDR
                   POP     BP
                   JZ      BOOT
                   MOV     AX,0005
                   CALL    DELAY_BY_AX
                   DEC     WORD PTR [BP+32Fh]
                   JNZ     BT_3
                   JMP     BOOT_RETRY

BT_3:              MOV     AX,[BP+32Dh]
                   OR      AX,AX
                   JZ      BT_4
                   SUB     BP,0Ah
                   JMP     FLASH_EBD

BT_4:              ADD     BP,0Ah
                   JMP     FLASH_EBD


BOOT:              MOV     AX,[BP+333h]
                   MOV     CL,45h
		   CALL    TWO_CHARS		;FL or HD or NT
		   CALL    BOOT_MSG		;BOOT:
		   MOV     AX,1814h		;OK
		   MOV     BX,2525h		;CLR PREV. ERR CODE
		   MOV     CL,4Ch
		   CALL    FOUR_CHARS

                   MOV     BL,[BP+334h]		;prob. not needed
                   MOV     AH,[BP+333h]
                   MOV     BH,DS:[310h]		;Boot dev. no. in [310]
                   AND     BH,0Fh
                   MOV     WORD PTR DS:[30Eh],4002h
                   PUSH    BP
                   CALL    CALC_JMP_ADDR		;JUMPS TO FF105
                   POP     BP
                   JZ      BT_5
                   JMP     BOOT_FAIL_CODE

BT_5:              MOV     AX,DS:[31Dh]
                   MOV     CL,04
                   SHR     AX,CL
                   MOV     DS:[32Bh],AX
                   MOV     BX,DS:[300h]		;read amount of mem
                   LEA     DI,DS:[400h]
                   SHR     DI,CL
                   SUB     BX,DI
                   SUB     BX,AX
                   CMP     BX,DS:[321h]
                   JNB     BT_6
                   JMP     BOOT_FAIL

BT_6:              CMP     WORD PTR DS:[31Fh],0
                   JNZ     BT_7
                   MOV     BX,DS:[300h]
                   SUB     BX,DS:[321h]
                   MOV     DS:[31Fh],BX

BT_7:              ADD     AX,DI
                   CMP     DS:[31Fh],AX
                   JNB     BT_8
                   JMP     BOOT_FAIL

BT_8:              XOR     DX,DX
                   MOV     AX,DS:[321h]
                   DIV     WORD PTR DS:[32Bh]
                   MOV     DS:[31Ah],AX
                   MOV     AX,DS:[31Fh]
                   MOV     DS:[318h],AX
                   MOV     WORD PTR DS:[316h],0
                   MOV     AX,DS:[32Bh]
                   MUL     WORD PTR DS:[31Ah]
                   MOV     DS:[32Bh],AX
                   MOV     WORD PTR DS:[30Eh],4003h
                   PUSH    BP
                   CALL    CALC_JMP_ADDR		;JUMPS TO FF28A
                   POP     BP
                   JZ      BT_9
                   JMP     BOOT_FAIL_CODE

BT_9:              MOV     AX,DS:[32Bh]
                   CMP     AX,DS:[321h]
                   JZ      BT_B
		   dw      3ec4h
		   dw      0316h			;LES DI,DS:[0316h]
                   MOV     WORD PTR DS:[318h],0
                   LEA     AX,DS:[400h]
                   MOV     DS:[316h],AX
                   MOV     WORD PTR DS:[31Ah],1
                   MOV     WORD PTR DS:[30Eh],4003h
                   PUSH    BP
                   PUSH    ES
                   PUSH    DI
                   MOV     BX,0100h
                   CALL    BX_TO_CRTC		;************
                   CALL    CALC_JMP_ADDR		;JUMPS TO FF28A
                   POP     DI
                   POP     ES
                   POP     BP
                   JZ      BT_A
                   JMP     BOOT_FAIL_CODE

BT_A:              LEA     SI,DS:[400h]
                   MOV     AX,DS:[321h]
                   SUB     AX,DS:[32Bh]
                   MOV     CL,03
                   SHL     AX,CL
                   MOV     CX,AX
                   REPZ    MOVSW

BT_B:              MOV     AX,BP
                   MOV     CL,0Ah
                   DIV     CL
                   MOV     DH,AL
                   MOV     DL,[BP+336h]
                   CMP     DL,10h
                   JZ      BT_C
                   CMP     DL,80h
                   JNZ     BT_D
                   MOV     AL,DS:[310h]
                   AND     AL,0Fh
                   ADD     DL,AL
                   JMP     BT_D

BT_C:              MOV     AL,DS:[310h]
                   MOV     CL,4
                   SHL     AL,CL
                   ADD     DL,AL
BT_D:              MOV     DS:[302h],DX
                   CMP     WORD PTR DS:[325h],0
                   JNZ     BT_E
                   MOV     AX,DS:[31Fh]
                   MOV     DS:[325h],AX
                   MOV     WORD PTR DS:[323h],0
BT_E:              MOV     AX,DS:[323h]
                   MOV     CX,DS:[325h]
                   CMP     BYTE PTR DS:[1],0
                   JZ      BT_F
                   MOV     AX,DS:[2]
                   MOV     CX,DS:[4]

BT_F:              MOV     DS:[3FCh],AX
                   MOV     DS:[3FEh],CX
                   MOV     WORD PTR DS:[30Eh],4004h
                   PUSH    BP
                   CALL    CALC_JMP_ADDR		;JUMPS TO FF4D1
                   POP     BP
                   INT     0FFh

;=======================================================================


main endp
rom ends
end main


