name    check_coproc
;
;
;
;
;
        cc_cr           equ     0DH     ; carriage return
        cc_lf           equ     0AH     ; line feed

assume  cs:code,ds:data
;
code    segment         public
start:
        mov     ax,data                 ; set data segment
        mov     ds,ax
;
; Test if 8087 is present in PC or PC/XT, or 80287 is in PC/AT
;
        fninit                          ; initialize coprocessor
        xor     ah,ah                   ; zero ah register and memory byte
        mov     byte ptr control+1,ah
        fnstcw  control    ; store coprocessor's control word in memory
        mov     ah,byte ptr control+1
        cmp     ah,03h     ; upper byte of control word will be 03 if
                           ; 8087 or 80287 coprocessor is present
        jne     no_coproc
;
coproc:
        mov     ah,09h                  ; print string - coprocessor present
        mov     dx,offset msg_yes
        int     21h
        jmp     done
;
no_coproc:
        mov     ah,09h                  ; print string - coprocessor not present
        mov     dx,offset msg_no
        int     21h
;
done:
        mov     ah,4CH                  ; terminate program
        int     21h
code    ends

data    segment        public
control dw             00
msg_yes db      cc_cr,cc_lf,
        db      'System has an 8087 or 80287',cc_cr,cc_lf,'$'
msg_no  db      cc_cr,cc_lf,
        db      'System does not have an 8087 or 80287',cc_cr,cc_lf,'$'
data    ends

        end     start                   ; start is entry point
