/******** TEST FOSSIL DRIVER FOR PROPER CARRIER DETECT ********/

#include <conio.h>
#include <ctype.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "v9fos.h"

unsigned PORT = 0;		/* port number (0-1) */
unsigned BPS = 1200;	/* bps rate */
unsigned int CD;		/* last CD status */
struct FOSSTAT FS;		/* FOSSIL status */

#define CTRL(x) ((x)-((x)>='a'&&(x)<='z'?'a':'A')+1)

hangup()
{
	register int ret = -1;
	time_t t = time(NULL);

	FOSdtr(PORT, FALSE);
	for (;;) {
		FS = FOSstatus(PORT);
		if (!(CD = FS.DCD)) {
			cprintf("\r\n*HANGUP SUCCESSFUL*\r\n");
			ret = 0;
			break;
		}
		if (time(NULL) - t > 1) {
			cprintf("\r\nCARRIER NOT LOST!\r\n\a");
			break;
		}
	}
	FOSdtr(PORT, TRUE);
	return ret;
}

main(int ac, char*av[])
{
	cprintf("usage: port bps\r\n"
			"       0|1  300|1200|...|9600\r\n\n");

	switch (ac) {
	default:
		BPS = atoi(av[2]);
	case 2:
		PORT = atoi(av[1]);
	case 1:
		break;
	}

	cprintf("port %u at %u bps\r\n\n", PORT, BPS);

	if (!FOSinstalled()) {
		cprintf("FOSSIL not installed\r\n");
		return 1;
	}

	{
		unsigned ver;
		int fun = FOSinitport(PORT, &ver);
		cprintf("FOSSIL Version %u Functions 0-%d\r\n\n", ver, fun);
	}

	{
		struct FOSINFO info;

		FOSgetinfo(PORT, &info, sizeof(info));
		cprintf(
			"%16s: %u\r\n"
			"%16s: %Fs\r\n"
			"%16s: %u\r\n"
			"%16s: %u\r\n"
			"%16s: %u x %u\r\n\n",
			"Driver rev level", info.dver,
			"Driver id string", info.id,
			"In buffer size", info.isiz,
			"Out buffer size", info.osiz,
			"Screen size", info.cols, info.rows
		);
	}

	FOSbaud(PORT, BPS, 8, 1, 0);

	cprintf("Ctrl-C to quit.\r\n"
		"Ctrl-D drops DTR (to hang up modem).\r\n"
		"Ctrl-O shells to DOS.\r\n\n");

	for (;;) {								/* endless polling loop */
		FS = FOSstatus(PORT);

		if (CD != FS.DCD)
			cprintf("\r\n*%s*\r\n\a", (CD = FS.DCD) ?
				"CONNECTED" : "CARRIER LOST");

		if (FS.RDA)							/* incoming chars */
			FOSputansi(FOSgetwait(PORT));

		if (FOSkeypeek() != -1) {			/* outgoing chars */
			register int k = FOSkeywait();

			switch ((char)k) {
			case CTRL('C'):
				return 0;
			case CTRL('D'):
				hangup();
				break;
			case CTRL('O'):
				cprintf("\r\ntype 'exit' to return\r\n");
				spawnl(P_WAIT, getenv("COMSPEC"), NULL);
				cprintf("\r\n(return from shell)\r\n\n");
				break;
			default:
				FOSputnowait(PORT, k);
				break;
			}
		}
	}

	return 0;
}
