title	"Program to redefine control keys at interrupt level. 6/13/84"
.radix	16

comment |This program redefines ^C and ^H on the Victor 9000, which cannot be
done by keygen.exe ^C is translated into ^DEL (1f) to bypass system traps.  ^H
is translated to ^] to distinguish it from backspace (for PMATE move right
command). It also patches in the SHIFT-ALT code
|

VI	= 1		;1 if for VI, 0 for 9000
cmake	= 73		;C make key code
hmake	= 3dh		;H make key code
psmake	= 87		;Pause make code
ctrl	= 06c		;LOCK key (used after modcon symbol as control key)
pcmake	= 0b9		;Percent key make code
pcbrak	= 0b8
altmak	= 0fbh		;ALT make

bint	= 80		;Bitmap interrupt vector

intvct	segment	at 0
	org	118
int46	dd	?	;Keyboard interrupt vector
	org	4*bint
bitptr	dd	?
	dd	?	;Leave room for scroller.exe vector
keyval	db	?	;Keyboard peek area
intvct	ends

prefix	segment	at 0
int20	db	?
	org	80
oint46	dd	?
oint46f	equ	word ptr oint46
keyds	dw	?
stadr	dw	?
shift	db	?
kstate	db	?
pause	db	?
prefix	ends

video	segment	at 0f000
vidbeg	dw	?
	org	9c2
vidend	dw	?
video	ends

cseg	segment
	assume	cs:cseg,ds:prefix,es:intvct

start	proc	far
	push	ds	;Set up return to system
	xor	ax,ax
	push	ax
if VI			;If VI, just patch uc Alt
	call	cipatc
else
	mov	word ptr shift,ax
	mov	es,ax
	les	di,es:int46
	mov	oint46f,di	;Save old int 46 vector
	mov	oint46f+2,es

;Find out where keyboard state and current key code value are stored
;by pattern matching the code (different OS's have different locs)

	mov	ax,1e8e	;Op code for mov ds,[]
	mov	cx,100	;Scan for addr of ds value
start1:	repnz	scasb
	jcxz	start4
	cmp	ah,es:[di]
	jnz	start1
	inc	di
	mov	ax,es:[di]
	mov	keyds,ax
start2:	mov	si,offset fndsta+100
	mov	cx,5
	repz	cmpsb
	jnz	start2
	mov	ax,es:[di]
	mov	stadr,ax	;Save state addr
start4:	call	cipatc
	jz	start9	;If already loaded, don't take over interrupt vector
	mov	dx,offset keyint+100
	mov	ax,2546	;Set interrupt vector
	int	21
	mov	dx,offset prgend+100	;end but stay resident
	mov	int20+1,27	;Set up resident return
endif
start9:	ret

start	endp

keyint:	push	ax	;Here on keyboard interrupt
	push	ds
	push	bx
	mov	ds,cs:oint46f+2
	mov	bx,cs:keyds	;Point ds at keyboard data area
	mov	ax,[bx]
	mov	ds,ax
	mov	bx,cs:stadr	;Point at keyboard state
	cmp	byte ptr [bx],1
	jz	keyi00
	jmp	keyi11	;If not state 1, don't do anything
keyi00:	inc	bx	;Point at kbdchr
	mov	al,[bx]	;Get character from keyboard
	mov	ah,al	;Bits are reversed
	and	ah,1	;Save make/break bit
	jz	keyin0
	mov	cs:pause,0	;Any make kills pause
keyin0:	and	al,0fe	;remove make/break bit
	push	bx
	mov	bx,offset chngtb+100	;list of changes

keyin4:	cmp	cs:byte ptr [bx],0
	jz	keyin3
	cmp	al,cs:[bx]
	jnz	keyin2
	mov	al,cs:1[bx]
	jmp	short keyin3

keyin2:	add	bx,2
	jmp	keyin4

keyin3:	pop	bx
	cmp	al,ctrl	;Ctrl Key?
	jnz	keyin5
	mov	cs:shift,ah	;Store ctrl status
	or	al,ah
	mov	ah,0	;Hide ctrl makes from keyval
keyin5:	cmp	al,pcbrak
	jnz	keyi52
	mov	al,altmak
keyi52:	or	al,ah	;Restore make/break bit
	mov	[bx],al
	test	cs:shift,1	;Ctrl pressed?
	jz	keyin1

keyin6:	cmp	al,hmake	;H make key? (for PMATE move right)
	jnz	keyin7
	mov	byte ptr [bx],0b5h	;Bracket make code - xlates to ^]
	jmp	short keyin1

keyin7:	cmp	al,psmake	;Pause make key? Hang?
	jnz	keyin1	;Ignore for now
	sti
	mov	cs:pause,al
	pushf
	call	cs:oint46	;Handle state 1 interrupt, fake int
keyin8:	cmp	cs:pause,al
	jz	keyin8

keyin9:	pop	bx
	pop	ds
	pop	ax
	iret		;Ignore pause code

keyin1:	test	ah,1	;Make key?
	jz	keyi11
	xor	bx,bx
	mov	ds,bx
	assume	ds:intvct
	mov	keyval,ah
keyi11:	pop	bx
	pop	ds
	pop	ax
	assume	cs:prefix
	jmp	cs:oint46

	assume	cs:cseg

;Table of key changes.  List of key codes, followed by code to change it
;to.  End in 0

chngtb:			;Null table - keygen does same thing
;	db	6c,0fa	;change lock to alt
;	db	0fa,6c	;change alt to lock
	db	0

prgend:		;end of stuff which must stay resident

;Console Patch for SHIFT-ALT. 10/26/83

nokeys	= 68

KD0		=	0	;key descriptor data field
KD1		=	1	;key descriptor legend field
KD2		=	2	;key descriptor functions field
KD1$2		=	1	;word alias for byte pair KD1/KD2
index		=	3	;index into descriptor tables
key$hit		=	5	;flag: key hit active
shift$all	=	6	;flag: shift lock mode active
caps$on		=	7	;flag: caps lock mode active
mode$keys	=	8	;00 flag: dead key active
caps$lock	=	9	;01 flag: caps lock key active
shift$lock	=	0a	;02 flag: shift lock key active
left$shift	=	0bh	;03 flag: left shift key active
right$shift	=	0c	;04 flag: right shift key active
alternate	=	0dh	;05 flag: alt key active
control$mode	=	0e	;06 flag: control key active
repeat$mode	=	0f	;07 flag: repeat key active
clr$kb		=	10	;08 flag: clear keyboard key
hold$line	=	11	;09 flag: advance line key active
hold$page	=	12	;10 flag: advance page key active
last$event	=	13	;last event of non-function key
nextdata0	=	14	;1st byte of 1 or 2 char sequence
nextdata1	=	15	;2nd byte of 2 char sequence
ch$ptr		=	16	;pointer to character data
ch$cnt		=	1a	;character count of data
ch$index	=	1c	;ch$ptr index to current char

	org	200
nxtevn:	push	bp	;Set up PL/M call
	mov	bp,sp
	push	cx	;Room for key$num
	push	cx	;Room for a
	mov	ax,0
	les	bx,[bp+6]	;Get structure pointer
	mov	es:ch$cnt[bx],ax
nxtev2:	mov	es:ch$index[bx],ax
nxtev3:	mov	al,[bp+4]	;Get keycode
	and	al,7f
	mov	[bp-2],ax
	cmp	al,68
	mov	al,0
	jc	keyok
	jmp	illegal
keyokf	equ	word ptr $
keyok:	cmp	byte ptr [bp+4],80
	jc	nxtstr
	dec	ax
nxtstr:	mov	es:key$hit[bx],al
	test	byte ptr es:alternate[bx],0ff
	jz	nxtshf
nxtsh2:

if VI
	or	al,al	;Check for Ctrl-ALT-Del
	jz	nxtsh6
	test	byte ptr es:control$mode[bx],0ff
	jz	nxtsh6
	cmp	word ptr [bp-02],67
	jnz	nxtsh4
	int	19	;Reboot
nxtsh4:	cmp	word ptr [bp-02],1DH
	jnz	nxtsh6
	mov	dx,0D22
	mov	al,0
	out	dx,al
	int	19
nxtsh6:
endif
	mov	ax,2*68
	add	ax,[bp-2]	;Add keynum
	mov	es:index[bx],ax
	mov	si,ax
	shl	si,1	;Convert to word pointer
	cmp	word ptr es:left$shift[bx],0	;SHIFT-ALT?
	jz	pushax
	add	ax,370	;Yep. Use fourth tables
pushax:	push	ax	;(26f for VI)
	jmp	short nxtcnt
endptc:

if VI
	org	85f6-8579+200
nxtcnt:
	org	8618-8579+200
nxtshf:
	org	8805-8579+200
illegal:
else

nxtcnt:
	org	0cbh-52+200+33-3a
nxts29:			;V BIOS 2.9 offset
	org	0cbh-52+200
nxtshf:

	org	38bdh-3652+200+38-44
ille29:			;V BIOS < 2.9 offset
	org	38bdh-3652+200
illegal:
endif

cipatc:	xor	di,di

if VI
	mov	es,di
	les	di,es:[0a4]	
endif

cipat2:	mov	si,offset nxtevn+100
	mov	cx,offset nxtev2 - offset nxtevn
	dec	cx
	repz	cmpsb
	jnz	cipat2
	add	di,5	;Point at nxtev3
	add	si,5
	mov	cx,offset endptc - offset nxtev3
ife VI
	cmp	byte ptr es:[di+2c],2e	;cs: code?
	jz	cipat3
	mov	keyokf+0fe,offset ille29-offset keyok
	mov	byte ptr nxtsh2+0ffff,offset nxts29-offset nxtsh2
	dec	cx
endif
cipat3:	push	cx	;Already loaded?
	push	si
	push	di
	repz	cmpsb
	pop	di
	pop	si
	pop	cx
	jz	cipat9
	rep	movsb
	inc	cx	;RNZ
cipat9:	ret

fndsta:	push	bp	;Code to scan for to find keyboard state address
	mov	bp,sp
	assume	ds:prefix	;Fake out assembler
	mov	bl,byte ptr stadr

cseg	ends

	end
