                 Technical Note from White Crane Systems

     The version of COMMAND.COM supplied for the Victor 9000 with MS-DOS
2.11 contains a bug which causes it to re-load more often than necessary. 
The instructions below show how to fix this bug using DEBUG.

     COMMAND.COM consists of two parts--a resident and a transient part. 
When a large application runs it can use the memory where the transient
part of COMMAND.COM resides. When the application exits, the resident part
of COMMAND.COM does a checksum on the transient part.  If the transient
code was wiped out it is reloaded.

     Common practice on a hard disk system is to keep all executable files
(.COM, .EXE, and .BAT) in one directory named \BIN.  With the path set to
\BIN, all these programs can be executed from any directory. Unfortunately,
the transient code contains the load directory, and this directory is 
included in the checksum.  The result is that after you run a file which 
is loaded from the \BIN directory, COMMAND.COM has to re-load, even if the 
transient part was not overwritten.

     This bug can be fixed by changing the checksum routine in COMMAND.COM
so that it does not include the load directory.  The following commands
perform this fix:


C>DEBUG COMMAND.COM
a 04EB                                  ;assemble this code
xxxx:04EB       XOR     DX,DX           ;(this code performs the checksum
xxxx:04ED       MOV     CX,176F         ; only up to the "LOAD=" string.)
xxxx:04F0       CLD
xxxx:04F1       LODSW
xxxx:04F2       ADD     DX,AX
xxxx:04F4       LOOP    04F1
xxxx:04F6       JMP     0103
xxxx:04F9       <RETURN>                ;end of assemble

a 0103                                  ;assemble more code
xxxx:0103       LODSB                   ;(this code continues the checksum
xxxx:0104       CMP     AL,3D           ; after the load directory string)
xxxx:0106       JNZ     0113
xxxx:0108       ADD     SI,41
xxxx:010B       MOV     CX,00B1
xxxx:010E       LODSW
xxxx:010F       ADD     DX,AX
xxxx:0111       LOOP    010E
xxxx:0113       POP     DS
xxxx:0114       RET
xxxx:0115       <RETURN>                ;end of assemble

w                                       ;write out new version
q                                       ;quit debug


     That's all there is to it.  Be sure to perform this fix only on the
copy of COMMAND.COM that you use to boot, and not on your original DOS
disk. You should apply this patch even if you are planning on using the
RES command to force COMMAND.COM to stay resident.  Credit for this patch 
goes to Charles Dayton of Dayton Software.

     The following lines allow you to automatically patch command.com if
you have a copy of the program patch.com.  Just put a copy of command.com,
patch.com and this file on a disk together and run the command:

	PATCH COMMAND

Patch 1.00 - by White Crane Systems
command.com
000003 00 AC 
000004 00 3C 
000005 00 3D 
000006 00 75 
000007 00 0B 
000008 00 83 
000009 00 C6 
00000A 00 41 
00000B 00 B9 
00000C 00 B1 
00000E 00 AD 
00000F 00 03 
000010 00 D0 
000011 00 E2 
000012 00 FB 
000013 00 1F 
000014 00 C3 
0003EB B9 33 
0003EC 82 D2 
0003ED 30 B9 
0003EE FC 6F 
0003EF D1 17 
0003F0 E9 FC 
0003F1 33 AD 
0003F2 D2 03 
0003F3 AD D0 
0003F4 03 E2 
0003F5 D0 FB 
0003F6 E2 E9 
0003F7 FB 0A 
0003F8 1F FC 
checksum 51FD
