;
; The header files model.h, prologue.h, epilogue.h are specific to the
; Computer Innovations CI-C86 compiler. Your compiler is probably different.
;
include model.h
INCLUDE PROLOGUE.H
	public ssdaxpy
; 8087 main loop for lsol
; ssdaxpy ()
;
.8087
ssdaxpy   proc	  near
	push	bp
	mov	bp,sp
; Current syntax ssdaxpy(x,y,n,a,stride1,stride2) y=y+ax
;
;	This routine is equivalent to the following C funciton.
;
;	ssdaxpy(x,y,n,a,stride1,stride2)
;	double *x,*y,a;
;	int n,stride1,stride2;
;	{
;		int i;
;		for(i=0;i<n;i++){
;			*y=*y+a*(*x);
;			 x+=stride1;
;			 y+=stride2;
;		}
;	}
;
;	This code is only good for the small model.
;
	push di
	push si
	push cx
	push ax
	mov di,4[bp]   ;vector 1 (x)
	mov si,6[bp]   ;vector 2 (y)
	mov cx,8[bp]   ;vector length
	finit
	fld qword ptr 10[bp]	;get a
	mov ax,18[bp]		;stride for vector 1
	mov bx,20[bp]		;stride for vector 2
done:
	fld qword ptr [di]   ;get *x
	fmul st,st(1)	     ;mult by a
	add di,ax
	fadd qword ptr [si] ;add ax to y
	fwait		      ;let the 8087 finish
	fstp qword ptr [si]   ;put it back in y
	add si,bx
	loop done
	finit
	pop cx
	pop cx
	pop si
	pop di
	pop bp
	ret
ssdaxpy   endp
INCLUDE EPILOGUE.H
end
