;CTIME.ASM
;A program to display the time
;on the bottom right of line 25
;For use only with the ISSUE CLOCK+ card
;and the SIRIUS Computer
;Don Ward 1986
;
;
cseg segment
assume cs:cseg,ds:cseg
org 100H
start:	jmp init
;---------------------------------------------------------------------
address dw 0EFFCh		;clock segment
screen  dw 0F000h		;start of screen RAM
mins    db 0			;last displayed minutes
secs    db 0			;time of last colon flash
rtc	label	dword
saveoff dw 0			;interrupt vector
saveseg dw 0
;--------------------------------------------------------------------
;
;clock interrupt routine
;
clock:	push ds
	push es
	push ax
	push bx
	push cx
	push dx
	push si
	push di
	push cs
	pop  ds
	mov es,address		;clock
	mov ah,es:0		;get seconds
	test ah,10000000b	;update in progress
	jnz  exit
	cmp ah,secs		;has 1 second elapsed
	jz  exit		;since last entry
	mov al,es:2		;yes, get minutes
	mov secs,ah		;save for next time
	mov bx,0E800h		;get screen pointer
	mov es,bx
	mov byte ptr es:0,12
	mov ch,es:1
	mov byte ptr es:0,13
	mov cl,es:1
	shl cx,1
	add cx,0F88h
	mov di,cx
	mov es,screen
	mov ah,es:[di+4]	;flash colon
	xor ah,01Ah		;converts colon-space-colon
	mov es:[di+4],ah
	cmp al,mins		;have minutes changed
	jz  exit		;no, no update
	mov mins,al		;save for next time
	mov bl,10
	cbw
	div bl
	add al,148		;font offset
	add ah,148
	mov es:[di+6],al	;update screen
	mov es:[di+8],ah
	mov es,address
	mov al,es:4       	;get hours
	cbw
	div bl
	mov es,screen
	add ah,148
	mov es:[di+2],ah	;update screen
	cmp al,0
	jz  blank		;suppress leading zero
	add al,16
blank:	add al,132		;font offset for space
	mov es:[di],al
exit:   pop di
	pop si
	pop dx
	pop cx
	pop bx
	pop ax
	pop es
	pop ds
	jmp dword ptr cs:rtc
;------------------------------------------------------------------
init:	xor ax,ax		;install new interrupt routine
	mov es,ax		;get interrupt vector
	mov ax,'ck'
	cmp ax,es:480h
	jnz inst
	int 20h			;exit, already installed
inst:	mov es:480h,ax		;pinch first font cell as marker
	mov ax,es:108h
	mov saveoff,ax
	mov ax,es:10Ah
	mov saveseg,ax
	cli			;inhibit interrupts
	mov ax,offset clock	;while changing interrupt vector
	mov es:108h,ax
	mov es:10Ah,cs
	sti			;allow interrupts
	mov dx,offset init   	;terminate
	int 27h			;and stay resident
;
;-------------------------------------------------------------

cseg ends
end  start
