;*********************************************************************
;  STRIP.EXE   A Program to strip out the 8th bit from WordStar Files.
;*********************************************************************
;
; Written by:      Bob Gallagher, Jr.
;
;                  Sept. 14, 1983
;
; WordStar keeps track of where words end by setting the most significant
; bit of the last character of each word. Although WordStar displays these
; characters normally, they are actually non-ASCII characters. You may
; notice the difference if you print the file to the screen using the
; MS-DOS 'TYPE' command. Some printers (not all) will become very
; confused if you print to the printer from MS-DOS. Many printers and
; terminals will display these characters as graphics characters.
;
; This utility will take a WS file you name and make a copy to another
; filename. This new 'object' file will be in standard ASCII format.

;
; To Use:  type "STRIP d:sourcefile d:objectfile"
;
;          Where sourcefile is the name of the WordStar file you
;          wish converted and objectfile is the name of the resulting
;          'stripped' file.
;
; Program reads the parameters (Source file, Destination file) from
; the Base Page FCBs to new FCBs in the DATA segment. 128 byte
; sectors are read to the DTA, each byte is AND'd with 128D to
; clear the high bit, then the 128 bytes are written to the 
; destination file.
;
; Yet to add...No parameter errors.
;              Destination file exists error.
;              Count bytes in last unfilled sector.
;
;
DGROUP	GROUP	DATA
CGROUP	GROUP	CODE
DATA	SEGMENT	PUBLIC	'DATA'
;@@@@@@@@@@@@  Insert data here  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;
MSDOS		EQU	21H
EOL		EQU	24H
ZERO		EQU	 0H
CR		EQU	0DH
LF		EQU	0AH
SPACE		EQU	20H
CMDPROGTERM	EQU	0H
CMDKEYIN	EQU	1H
CMDVIDOUT	EQU	2H
CMDPRNTOUT	EQU	5H
CMDPRNTSTR	EQU	9H
CMDOPEN		EQU	0FH
CMDCLOSE	EQU	10H
CMDCREATE	EQU	16H
CMDDELETE	EQU	13H
CMDSEQREAD	EQU	14H
CMDSEQWRT	EQU	15H
CMDSETDTA	EQU	1AH
;
;
ERROR1 		DB	CR,LF,"  ** CAN'T OPEN SOURCE FILE **",CR,LF,EOL
ERROR2 		DB	CR,LF,"  ** FATAL READ ERROR **",CR,LF,EOL
ERROR3 		DB	CR,LF,"  ** DISK FULL **",CR,LF,EOL
ERROR4 		DB	CR,LF,"  ** FATAL WRITE ERROR **",CR,LF,EOL
;
FCB1		DB	ZERO,"            ",25 DUP(ZERO)
FCB2		DB	ZERO,"            ",25 DUP(ZERO)
;
DTA		DB	128 DUP(0)
;
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
DATA	ENDS
;
CODE	SEGMENT	PUBLIC	'CODE'
	ASSUME	CS:CGROUP,DS:DGROUP
EXAMPLE	PROC	NEAR
BEGIN:
	PUSH	ES		   ; save base page return.
;
	CALL RUN_MODULE 	   ; run the program @ offset 08  (at the
;				     code area below).
;
EXIT	PROC	FAR		   ; PUSH 0 onto the STACK and RET (a way	
	XOR	AX,AX		   ; exit the program).
	PUSH	AX
	RET
EXIT	ENDP
;
RUN_MODULE:			   ; start of 'logical' program.	
	MOV	AX,DATA		   ; set data register.
	MOV	DS,AX
;
; Note: DS is set to the beginning of the data segment area above. The
;	ES register still points to base page initialized by MS-DOS.	
;
;
;@@@@@@@@@@@@@@@@   Insert Code Here   @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;
;
;
START:						; Move both FBCs in base page
		MOV	SI,5CH			; to FCBs in DATA area.
		MOV	DI,OFFSET FCB1
		MOV	CX,6			; Counter 12 bytes/6 words.  
L1:		MOV	AX,ES:[SI]
		MOV	[DI],AX
		ADD	DI,2
		ADD	SI,2
		LOOP	L1
		MOV	SI,6CH
		MOV	DI,OFFSET FCB2
		MOV	CX,6
L2:		MOV	AX,ES:[SI]
		MOV	[DI],AX
		ADD	SI,2
		ADD	DI,2
		LOOP	L2
;
;
;
;
		MOV	DX,OFFSET FCB1		; Open source file.
		CALL	OPEN
;
		MOV	DX,OFFSET FCB2		; Create destination file.
		CALL	CREATE
;
		MOV	DX,OFFSET DTA		; Set Disk Transfer Address
		CALL	SETDTA
;
;						
;
		MOV	AX,0			; Initialize counters:
		MOV	SI,AX			; SI = DTA Buffer Counter 
		MOV	CX,AX			; BL = Record Counter
		MOV	BX,CX			; CX = Block Counter
;
;
ROUTINE:
		MOV	FCB1+12,CL	; Init FBC1 for read.  
		MOV	FCB1+13,CH
		MOV     FCB1+32,BL
;
		MOV	DX,OFFSET FCB1  ; read record.
		CALL	READ
		CMP	AL,2
		JE	ERR_READ
		CMP	AL,1										
 		JE	DONE
;
;
		MOV	SI,0       	; Process DTA Buffer.
PROCESS:	MOV	AL,DTA[SI]
		AND   	AL,01111111B
		MOV	DTA[SI],AL
		ADD	SI,1
		CMP	SI,128
		JNE	PROCESS
;
;
		MOV	FCB2+12,CL	; Init FBC2 for WRITE. 
		MOV	FCB2+13,CH
		MOV     FCB2+32,BL
;
		MOV	DX,OFFSET FCB2
		CALL	WRITE		; Write record.
		CMP	AL,2
		JE	ERR_WRITE
		CMP	AL,1
		JE	ERR_FULL
;
		ADD	BL,1
		JNC	ROUTINE
		ADC	CX,0
    		JMP	ROUTINE
;
;
;
;
;
ERR_OPEN:
		MOV	DX,OFFSET ERROR1
		CALL 	PRINT
		JMP	DONE
;
ERR_READ:
		MOV	DX,OFFSET ERROR2
		CALL    PRINT
		JMP     DONE
; 
ERR_WRITE:	
		MOV	DX,OFFSET ERROR4
		CALL    PRINT
		JMP	DONE
;
ERR_FULL:
		MOV	DX,OFFSET ERROR3
		CALL    PRINT
		JMP	DONE
;
;
DONE: 
		MOV 	DX,OFFSET FCB1
		CALL	CLOSE           
		MOV	DX,OFFSET FCB2
		CALL	CLOSE
		RET
;
;++++++++++++++++++++++++
; SUBROUTINES
;++++++++++++++++++++++++
;
;         
PRINT: 		MOV	AH,CMDPRNTSTR	; Print String.
		INT 	MSDOS
		RET
;
;       
READ:   	MOV	AH,CMDSEQREAD	; Read 128 Byte Block.
		INT	MSDOS
		RET
;
;       
WRITE:  	MOV	AH,CMDSEQWRT	; Write 128 Byte Block.
		INT	MSDOS
		RET

OPEN:		MOV	AH,CMDOPEN	; Open file.
		INT	MSDOS
		CMP 	AL,0
		JNE	ERR_OPEN
                RET
;
SETDTA:		MOV	AH,CMDSETDTA	; Set DTA.
		INT	MSDOS
 		RET
;
CLOSE:		MOV	AH,CMDCLOSE
		INT	MSDOS
		RET
CREATE:
		MOV	AH,CMDCREATE
		INT	MSDOS
		RET


;@@@@@@@@@   End your main code with RET (Before your subroutines)   @@@@@@@@@@
;
EXAMPLE	ENDP
CODE	ENDS
	END

