;****************************************************************************
;*****									*****
;*****	Proprietary Rights Notice: All rights reserved. This material	*****
;*****	contains  the   valuable   properties  and  trade  secrets of	*****
;*****									*****
;*****			Victor Technologies, Inc.(VICTOR)		*****
;*****		of	Scotts Valley, California, USA.			*****
;*****									*****
;*****	embodying  substantial  creative   efforts  and  confidential 	*****
;*****	information, ideas, and expressions; no part  of which may be	*****
;*****	reproduced  or  transmited  in  any  form  or  by  any means; 	*****
;*****	electronic,  mechanical,   or   otherwise;   including  photo 	*****
;*****	copying  and  recording or in connection with any information 	*****
;*****	storage or retrieval system without the permission in writing 	*****
;*****	from VICTOR.							*****
;*****									*****
;*****	Copyright notice:	Copyright (C) 1984, 1985		*****
;*****									*****
;*****	An unpublished work by:						*****
;*****									*****
;*****		Victor Technologies, Inc.				*****
;*****		380 El Pueblo Road	   				*****
;*****		Scotts Valley, California, 95066			*****
;*****									*****
;****************************************************************************

; Revision History:
;	11/09/84 - E. A. Joakimides  Version 1.0 (First Cut)
;	11/11/84 - E. A. Joakimides  Version 1.1
;			Included HVP Escape sequence
;			Made parameter value of 0 equivalent to 1 (the
;			  default value) for CUP, HVP, CUU, CUD, CUF & CUB
;			Implemented Key Reassignments (simple version --
;			  e.g. fixed buffer, no loading from disk)
;	01/07/85 - E. A. Joakimides  Version 1.1a
;			Corrected invalid termination MS-DOS call

name	ANSI

;	These initial segement declarations are at the start so that
;	the linking order is established

baseseg		segment	'baseseg'
baseseg		ends

initcode	segment	'initcode'
initcode	ends

initstack	segment	stack 'initstack'
initstack	ends

initdata	segment	'initdata'
initdata	ends

;		Dummy segment to establish start address of the resident
;		part of the program

mem_hdr		segment	'mem_hdr'
		db	10h dup (?)	; Make allowance for memory header
mem_hdr		ends

resident	segment  'resident'
resident	ends

keyseg		segment	'keyheap'
keyseg		ends

code		segment	'code'
code		ends


UDC_AnsiId	equ	0A2C1h	;Our identifier. Returned by UDC function 6

msdosint 	equ	021h		;msdos function request interrupt
xbiosint 	equ	0dfh		;super bios function request
interrupt

ESC		equ	01bh		; ASCII Escape character

UDC_MaxFn	equ	6
UDC_GETFn	equ	0
UDC_PUTFn	equ	1
UDC_GETstatFn	equ	2
UDC_PUTstatFn	equ	3
UDC_GETvectorFn equ	4
UDC_SETvectorFn equ	5
UDC_GETidFn	equ	6


;****************************************************************************
;			Resident Data Starts Here			    *
;****************************************************************************

keyseg		segment	'keyheap'

;	Keyseg contains the heap for the key translation.
;	The heap is very simple, since KeyTable contains pointers into
;	the heap & KeyTransSz contains the length of each string.
;	So that there are no garbage collection problems, the heap is
;	always compacted, thus the first (and only) available space is
;	immediately after the in use area.

keymap		dw	2000 dup (?)	; *** TEMPORARY for Version 1.1
					; In 1.2 this should be a load time
					; alocated buffer

keyseg		ends

code		segment	'code'

;	Data which must appear in the code segment of the resident part


save_es		dw	0			;store for vector entry
save_bx		dw	0			;store for vector entry

UDC_pending	db	0

UDC_semaphore	db	0

PutState	dw	UPNormal	; Pointer to parser state

PutCount	db	0	;Count of the number of queued raw chars
PutPointer	dw	?	;Pointer to the location of the next out char
PutBuffer	db	256 dup (?)	;Buffer for queueing raw escape chars

ParsedPointer	dw	?	;Pointer to the location of next parsed char
ParsedBuffer	db	512 dup (?)	;Buffer for queueing parsed chars
ParsedBufEnd	equ	(this byte) - 1


GetCount	db	0	;Count of the number of queued incoming chars
GetBuffer	db	10 dup (?)	;Buffer for queueing local characters

UDC_getparms	dw	1			;device 1: UDC
UDC_CONvector	dw	2 dup (?)			;pass through vector

KeyTransPointer	dd	?	; Segment & offset into the key translation
				; string, or local map buffer
KeyTransCount	db	0	; <> 0 implies translation is being done,
				; and it contains the count
			    
				; Key translation heap variables
MaxKeyBytes	dw	2000		; Maximum size of the heap
AvailKeyByte	dw	0		; Offset to first available byte
					; which also is number of bytes in use
KeySelector	dw	keyseg		; Segment address for the key heap.

				; KeyTable & KeyTransSz are used together
				; to do key translation. Specifically:
			; If KeyTransSz[code] <> 0 then	; Do translate
			; begin
			;    If KeyTransSz[code] = 1 or 2 then	; Immediate
			;	  take translated byte(s) from KeyTable[code]
			;    else use KeyTable[code] as an offset into
			;		the KeyHeap for the translated bytes
			;  end;

KeyTable	dw	256 dup (0)
KeyTransSz	db	256 dup (0)


;	Escape Sequence Mapping Tables

;	Three tables are used for the escape sequence mapping.
;
;	     ***************************************************
;	     *   ALL THREE TABLES MUST BE IN THE SAME ORDER    *
;	     *   IF ONE IS CHANGED, CHANGE THE OTHERS          *
;	     ***************************************************
;
;	ESCTable	- contains the ANSI escape character (one byte per
;			  escape sequence). This is the main table, in that
;			  the index derived from matching the escape char
;			  with a character in this table is used as an index
;			  for the following two tables.
;	ESCActionTable	- contains the address of the routine corresponding
;			  to the ESCTable character escape sequence.
;	ESCMapTable	- This is not valid for all escape sequence, but
;			  it does accomodate the majority of the common ones.
;			  It contains one byte, which is the VT52 esc char;
;			  in addition, the hi order bit indicates if a count
;			  is valid for this escape sequence.

ECSTable_start	equ	this byte

ESCTable	db	'A'		; CUU
		db	'B'		; CUD
		db	'C'		; CUF
		db	'D'		; CUB
		db	'H'		; CUP
		db	'f'		; HVP
		db	's'		; SCP
		db	'u'		; RCP
		db	'n'		; DSR
		db	'K'		; EL
		db	'J'		; ED
		db	'm'		; SGR
		db	'h'		; SM
		db	'l'		; RM
		db	'p'		; KKR

ESCTableSz	equ	(this byte) - ECSTable_start


ESCActionTable	dw	UP_GenMap	; CUU
		dw	UP_GenMap	; CUD
		dw	UP_GenMap	; CUF
		dw	UP_GenMap	; CUB
		dw	UP_CursPos	; CUP
		dw	UP_CursPos	; HVP
		dw	UP_GenMap	; SCP
		dw	UP_GenMap	; RCP
		dw	UP_GenMap	; DSR
		dw	UP_GenMap	; EL
		dw	UP_GenMap	; ED
		dw	UP_SetAttr	; SGR
		dw	UP_SetMode	; SM
		dw	UP_SetMode	; RM
		dw	UP_KeyAssn	; KKR

CountValid	equ	80h

ESCMapTable	db	CountValid+'A'	; CUU
		db	CountValid+'B'	; CUD
		db	CountValid+'C'	; CUF
		db	CountValid+'D'	; CUB
		db	            0	; CUP
		db	            0	; HVP
		db		   'j'	; SCP
		db		   'k'	; RCP
		db		   'n'	; DSR
		db		   'K'	; EL
		db		   'z'	; ED (Reset also Clears the 25th line)
		db		    0	; SGR
		db		   'v'	; SM
		db		   'w'	; RM
		db		    0	; KKR


	;		ANSI SGR (Set Graphics Rendition) parameter values

ANSI_AttrOff	equ	0
ANSI_Bold	equ	1
ANSI_Under	equ	4
ANSI_Reverse	equ	7

	;		ANSI SM/RM (Set/Reset Mode) parameter values

ANSI_EOLWrap	equ	7


	;		VT52 Escape Sequence Equates

	; If the escape seq equ's seem backward, it is because
	; word store is used (e.g. low byte goes first in memory)

VT52_SetMode	equ	781bh		; Esc x -- Set Mode
					; Parameters for VT52_SetMode
VT52_25thLine	equ	'1'			; Enable 25th Line


VT52_CursPos	equ	591bh		; ESC Y [row][col]-- Position Cursor
VT52_BoldOff	equ	291bh		; ESC ) -- Bold off (Low Intensity)
VT52_BoldOn	equ	281bh		; ESC ( -- Bold on (High Intensity)
VT52_UnderOff	equ	311bh		; ESC 1 -- Underscore off
VT52_UnderOn	equ	301bh		; ESC 0 -- Underscore on
VT52_ReverseOff	equ	711bh		; ESC q -- Reverse Video off
VT52_ReverseOn	equ	701bh		; ESC p -- Reverse Video on



;****************************************************************************
;			Resident Code Starts Here			    *
;****************************************************************************


	assume	cs:code, ds:code


;****************************************************************************
;			Main entry from BIOS				    *
;			AX =	0 - GET CON				    *
;				1 - PUT CON				    *
;				2 - GET STATUS				    *
;				3 - PUT STATUS				    *
;				4 - READ VECTOR				    *
;				5 - SET VECTOR				    *
;				6 - GET UDC ID				    *
;****************************************************************************


UDC_entry	proc	far

	cmp	ax,UDC_maxFn
	ja	UDC_passthru		;if not valid pass it on
	push	bx			;	(save bx)
	mov	bl,0ffh			;set UDC_semaphore and
	xchg	bl,cs:UDC_semaphore	;  keep previous setting
	or	bl,bl			;If previous non_zero then recursing
	pop	bx			;	(restore bx)
	jnz	UDC_passthru		;Recursing. Pass request on.

	push	ds
;
	mov	cs:save_es,ES		;save entry vector
	mov	cs:save_bx,bx		;save entry vector
;
	mov	bx,cs
	mov	ds,bx
	mov	es,bx

	mov	bx,ax			;dispatch to UDC subfunctions
	shl	bx,1
	call 	UDC_dispatch[bx]

	MOV	UDC_semaphore,0
	pop	ds
	ret

UDC_passthru:				;unrecognized call & recursing exit..
	jmp  CS:dword ptr UDC_CONvector ;...for passing on control

UDC_dispatch	dw	UDC_get
		dw	UDC_put
		dw	UDC_getstat
		dw	UDC_putstat
		dw	UDC_getvector
		dw	UDC_setvector
		dw	UDC_getid

UDC_entry	endp


;****************************************************************************
;			Get character					    *
;			Entry:	AX = 0					    *
;			Exit:	AL = Return data byte			    *
;****************************************************************************


UDC_get	proc	near


	cmp	KeyTransCount,0		;Any local data available
	jne	UGresult		;Yes, continue to return the queued
					; or locally generated chars
					;No. Pass the request on down.
	call	dword ptr UDC_CONvector
					;Got the next character
	mov	bl,al			;Move key code into an index reg
	xor	bh,bh			;  as a word
	cmp	KeyTransSz[bx],0	;Is the translation size 0
	jne	UGTrans			;No. Do a translation

	cmp	al,ESC			;Is it an Escape
	jne	UGexit			;No. Pass it back to caller.

			; Yes, it is an escape. Check for ESC Y which is
			; the cursor position responce. It's the only one
			; we trap. So that the user is not confused, also
			; check for character available, which would be true
			; if either users typed ahead, or this is really a
			; system responce. Otherwise, if a program, such as
			; PMATE is expecting a single ESC it would not get
			; to it until the next character is typed.

	mov	ax,UDC_GetstatFN	; Get status
	call	dword ptr UDC_CONvector
	or	al,al			;Is a character available?
	jz	UGRetESC		;None avail. It's a single escape.

	mov	ax,UDC_GetFn		;Yes. Get the character.
	call	dword ptr UDC_CONvector

	mov	GetCount,1		;Set GetCount to 1

	cmp	al,'Y'			;Is it ESC Y (position report).
	je	UGMapPos		;Yes. Need to map it.

	mov	GetBuffer,al		;No. Save the last gotten character
	jmp short UGMapExit		;Return the ESC to the caller

UGMapPos:			; Map ESC Y <line> <col> to ESC [ #; # R
	mov	al,'['
	mov	GetBuffer,al
	call	UGMapNum	; Get & Map number (line)
	mov	al,';'
	call	UGStore		; Store ; in the buffer
	call	UGMapNum	; Get & Map number (column)
	mov	al,'R'
	call	UGStore		; Store R in the buffer

UGMapExit:
	mov	bl,GetCount
	mov	KeyTransCount,bl	
	mov	bx,offset GetBuffer	;Set KeyTransPointer to GetBuffer
	mov	WORD PTR KeyTransPointer,bx	
	mov	bx,cs			; Also set KeyTransPointer.Selector
	mov	WORD PTR KeyTransPointer+2,bx	; to our CS
UGretESC:
	mov	al,ESC		;Done. Now return the ESC to the caller
	jmp short UGexit


UGresult:			;return current data byte queued

	les	bx,KeyTransPointer	;Get pointer into the buffer
	mov	al,ES:[bx]		;Get the byte
	inc	bx
	mov	WORD PTR KeyTransPointer,bx   ;Update the pointer
	dec	KeyTransCount		;Update the count

UGexit:
	ret


UGTrans:			; This code needs translation
	mov	ah,KeyTransSz[bx]	; Move size into
	mov	KeyTransCount,ah	;   KeyTransCount
	add	bx,bx			; Adjust byte index to word
	cmp	ah,2			; If size is > 2 then
	ja	UGTransLong		;   it is a long string
					; Else it's an immediate
	add	bx,offset KeyTable	; get offset of KeyTable[bx]
	mov	WORD PTR KeyTransPointer,bx	; for KeyTransPointer.offset
	mov	bx,cs			; Also set KeyTransPointer.Selector
	mov	WORD PTR KeyTransPointer+2,bx	; to our CS
	jmp short UGResult

UGTransLong:				; Translation string is in the Key Heap
	mov	bx,KeyTable[bx]		; KeyTable[bx] has the offset
	mov	WORD PTR KeyTransPointer,bx	
	mov	bx,KeySelector		; Also set KeyTransPointer.Selector
	mov	WORD PTR KeyTransPointer+2,bx	; to the KeyHeap
	jmp short UGResult


UDC_get	endp


UGStore		proc	near

;   	Service procedure for UDC_get
;	Stores character from al to location of GetBuffer[GetCount] & 
;	    updates GetCount
;	Uses BX

	mov	bl,GetCount
	inc	bl	     		; Increment count
	mov	GetCount,bl		; & save new value
	dec	bl
	xor	bh,bh			; "Convert" byte to word
	mov	GetBuffer[bx],al	; Store the character
	ret

UGStore	endp


UGMapNum		proc	near

;   	Service procedure for UDC_get
;	Gets an input character from the console & converts it from a VT52
;	    number to an ASCII 1 or 2 character number & stores it in the
;	    current buffer.
;	Calls next console on the worm, thus register integrity is suspect.

	mov	ax,UDC_GetFn			; Get next character.
	call	dword ptr UDC_CONvector

	sub	al,01fh				; Make number 0 relative
	xor	ah,ah
	mov	bl,10
	div	bl
	or	al,al				; Is high order non-zero
	jz	UGMapNum01
	
	or	al,30h				; Convert quotient to ASCII
	call	UGStore				; and Store in buffer

UGMapNum01:
	mov	al,ah				; Get remainder (units digit)
	or	al,30h				; Convert to ASCII
	call	UGStore				; and Store in buffer

	ret

UGMapNum	endp



;****************************************************************************
;			Put character					    *
;			Entry:	AX = 1					    *
;				CL = console output data from caller	    *
;			Exit:	AL = 00 multicode sequence not pending	    *
;				AL = FF multicode sequence pending	    *
;****************************************************************************

UDC_put	proc	near


	cmp	UDC_pending,0		;check pending multi-sequence
	jne	UDC_passthruput		;last callee wants more
					;Do not interfere (be transparent)

	jmp	WORD PTR PutState	;Get address of current state


UDC_passthruput:
	call    dword ptr UDC_CONvector
	mov	UDC_pending,al		;save multi-sequence flag
	ret

;	Following are the different UDC_put states:
;
;	    UPNormal	- looking for an ESC
;
;		While processing an ESC, as well as parsing the data,
;		the characters are accumulated as are. If the ESC seq
;		gets aborted (e.g. state ==> NotOurs ) the accumulated
;		characters are passed on. A maximum of 255 characters
;		will be accumulated in the parsed buffer and 512 in the
;		accumulated (raw) buffer.
;	    HaveESC	- looking for [  -- Not found ==> NotOurs
;	    ESCNormal	- looking for a number or a letter
;			  a letter terminates the ESC seq ==> ESCEnd
;			  a number starts the number parser ==> ESCNum
;			  a quote (") starts the quote parser ==> ESCQuote
;			  a control char <= 20h or >=7fh ==> NotOurs
;			  otherwise it is treated as noise
;	    ESCNum	- while the character is a number do
;				number := ( number * 10 + character ) MOD 256
;			  if not a number ==> ESCNormal
;	    ESCQuote	- accumulates characters until either another " is 
;			  found, or the buffer is full, or a control char is
;			  detected. A " ==> ESCNormal; else ==> NotOurs.
;	    ESCEnd	- if the letter is NOT a recognized ESC seq letter
;				then ==> NotOurs
;			  otherwise, Map to the VT52 ESC seq & pass it on.
;			  Actually goes to NotOurs after placing the VT52 ESC
;			  in the raw buffer.
;	    NotOurs	- Passes all of the characters of the raw buffer on.
;			  When finished, ==> UPNormal

UPNormal:
	cmp	cl,ESC		; Is it an ESC
	jne	UDC_passthruput	; No. Send it on its way

	mov	PutCount,0	; Initialize the buffer variables
	mov	PutPointer,offset PutBuffer
	mov	ParsedPointer,offset ParsedBuffer

	call	UPStore		; Save the raw character
	mov	ax,offset HaveESC

UP_ChangeState:
	mov	PutState,ax	; Change state

UP_ESCreturn:
	mov	al,0ffh		; Indicated multiple seq pending
	ret

HaveEsc:
	cmp	cl,'['		; Is it an open bracket
	jne	NotOurs		; No. It is not ours.

	call	UPStore		; Save the raw character

	mov	ax,offset ESCNormal
	jmp short UP_ChangeState



ESCNormalNow:			; Change state to ESCNormal & also process
				; the character immediately

	mov	ax,offset ESCNormal
	mov	PutState,ax	; Change State

ESCNormal:
	cmp	cl,7Fh		; Is it in the lower ASCII set
	ja	NotOurs		; No. Abort

	cmp	cl,'A'		; Is it a letter.
	jnb	ESCEnd

	cmp	cl,'0'		; Is it a number
	jb	EN_control
	cmp	cl,'9'
	ja	EN_noise	; No. Treat as noise

	call	UPStore		; Store it in the raw buffer, and
	sub	cl,'0'		; convert to its actual value
	call	UPStoreResult	; and store it in the parse buffer

	mov	ax,offset ESCNum	; Change State
	jmp short UP_ChangeState

EN_control:
	cmp	cl,20h		; Is it a control character
	jb	NotOurs		; Yes. Abort.

	cmp	cl,'"'		; Is it a quote	     
	jne	EN_noise

	mov	ax,offset ESCQuote
	mov	PutState,ax	; Change State

EN_noise:			; Otherwise, it is a noise character
	call	UPStore		; Save the raw character
	jmp short UP_ESCreturn	; and return for more


ESCNum:
	cmp	cl,'0'		; Is it a number
	jb	ESCNormalNow
	cmp	cl,'9'
	ja	ESCNormalNow	; No. Go back to ESC Normal state

	call	UPStore		; Store it in the raw buffer,
	call	UPStoreNum	; accumulate the number
	jmp short UP_ESCreturn	; and return for more
	 

ESCQuote:
	call	UPStore		; Save the raw character
	cmp	cl,'"'		; Is it the closing quote
	je	ESCQuote01	; Yes. Change states

	call	UPStoreResult

	jmp short UP_ESCreturn  ; Return to get some more

ESCQuote01:
	mov	ax,offset ESCNormal
	jmp short UP_ChangeState	; and return for more


NotOurs:
	call	UPStore		; First save the raw character

NotOursLoop:			; Now empty the raw buffer
	mov	bx,PutPointer	; Get next byte from the buffer
	mov	cl,[bx]
	inc	bx		; and also increment and
	mov	PutPointer,bx	; update the pointer

	mov	ax,UDC_PutFn	; Indicate Put Function
	call    dword ptr UDC_CONvector

	dec	PutCount	; Is the Count 0?
	jnz	NotOursLoop	; Not yet. Keep going.

	mov	UDC_pending,al		;save multi-sequence flag
NotOursEnd:
	mov	bx,offset UPNormal
	mov	PutState,bx	; Change state
	ret


ESCEnd:
	push	cx		; Save the character
	push	di		; Save DI (am not sure it's needed, but ...)
	mov	al,cl		; Looking for this character
	mov	cx,ESCTableSz	; Get the Table size
	push	cs
	pop	es		; Fix ES
	mov	di,offset ESCTable
	cld
	repnz scasb		; Search the table for a match

	jnz	ESCEnd_NotFound	; Character does not match.

	pop	di		; Restore DI
	pop	ax		; Clear the stack. Don't need char anymore
	mov	bx,ESCTableSz-1	; Calculate the index into
	sub	bx,cx		;	the table
	mov	cx,bx		; Save the byte index for the Mapping procedure
	add	bx,bx		; Times 2, since these are words
	call	ESCActionTable[bx]	; Do the mapping
	cmp	PutCount,0	; Just in case nothing to pass on.
	jnz	NotOursLoop	; Mapped ESC seq is left in the raw buffer

	xor	al,al		; Indicate no multiple seq pending
	jmp short NotOursEnd	; and clean up.

ESCEnd_NotFound:
	pop	di		; Restore DI
	pop	cx		; Restore CX
	jmp short NotOurs	; Abort

	
UDC_put	endp



UPStore		proc	near

;   	Service procedure for UDC_put
;	Stores character from cl to location of PutPointer[PutCount] & 
;	    updates PutCount
;	If the buffer is about to overflow, it jumps to NotOursLoop so
;	    that the ESC sequence is aborted.
;	Uses BX

	mov	bl,PutCount
	xor	bh,bh			; "Convert" byte to word
	mov	PutBuffer[bx],cl	; Store the character
	inc	PutCount		; Increment count
	jz	UPStoreError		; Buffer is about to overflow
	ret

UPStoreError:
	pop	bx			; Get rid of the return address
	jmp short NotOursLoop

UPStore	endp


UPStoreResult	proc	near

;   	Service procedure for UDC_put
;	Stores character from cl to location pointed to by ParsedPointer & 
;	    updates ParsedPointer
;	If the buffer is about to overflow, it jumps to NotOursLoop so
;	    that the ESC sequence is aborted.
;	Uses BX

	mov	bx,ParsedPointer	; Get the pointer
	cmp	bx,offset ParsedBufEnd	; At the end of the buffer?
	ja	UPStoreResError		; Buffer is about to overflow
	mov	[bx],cl			; Store the character
	inc	bx			; Increment the pointer
	mov	ParsedPointer,bx
	ret

UPStoreResError:
	pop	bx			; Get rid of the return address
	jmp short NotOursLoop

UPStoreResult	endp


UPStoreNum		proc	near

;   	Service procedure for UDC_put
;	Used to convert an ASCII number of the form nnn (n is ASCII number)
;	    to an eight bit binary number.
;	The new digit is in cl, the previous digit(s) is in
;	    [ParsedPointer-1].
;	[ParsedPointer-1] := [ParsedPointer-1] * 10 + NUM( cl )
;	The character is treated as a number and converted to its actual
;	    value before being added.
;	Uses AX, BX

	mov	bx,ParsedPointer
	mov	al,[bx-1]
	mov	ah,10
	mul	ah			; al := al * 10
	sub	cl,'0'			; Convert to its actual value
	add	al,cl			; and add it to the previous value
	mov	[bx-1],al		; Store the character
	ret


UPStoreNum	endp


;****************************************************************************
;		  Escape Sequence Mapping Procedures			    *
;****************************************************************************

;	Expect bx to be a word index into the map tables
;	   and cx to be a byte index.

UP_GenMap	proc	near

;	General Mapping -- Maps into a single character escape sequence
;		optionally with a repeat count. (A repeat count of 0 is
;		treated as no repeat count -- or count = 1.)

	mov	al,ESC			; Put an ESC in the low order byte
	mov	bx,cx			; Need a byte index.
	mov	ah,ESCMapTable[bx]	; Get resulting escape character
	test	ah,CountValid		; Is a count possible?
	jz	UP_GenMapDefault

	xor	ah,CountValid		; Turn off the CounValid bit
	mov	bx,offset ParsedBuffer
	cmp	bx,ParsedPointer	; Any data parsed?
	je	UP_GenMapDefault	; No. Use Default count

	mov	cl,ParsedBuffer		; Get the first value
	add	cx,cx			; 2 bytes per repetition
	and	cx,0ffh			; Make sure it is  <= 254
	jz	UP_GenMapDefault	; If param=0 then use default count
	mov	PutCount,cl		; Save the count for the output

	shr	cl,1			; Div 2 since moving words
	push	di			; Save DI, just in case
	mov	di,offset PutBuffer	; Point to PutBuffer
	push	cs
	pop	es			; Fix ES
	cld
	rep stosw

	pop	di			; Restore DI
	jmp short UP_GenMapDone

UP_GenMapDefault:
	mov	WORD PTR PutBuffer,ax	; Default is always 1
	mov	PutCount,2

UP_GenMapDone:
	ret

UP_GenMap	endp

UP_CursPos	proc	near

;	Map cursor position. If position parameter(s)=0 or is not specified
;		default to 1

	xor	bx,bx			; BX is offset of where the ESC seq
			; starts. This is because sometimes 2 ESC seq are
			; needed. (The first enables the 25th line)
	mov	ax,'  '			; Default to row 1, col 1
	mov	cx,ParsedPointer
	sub	cx,offset ParsedBuffer	; Calculate number of parameters
	jz	UP_CursPos04		; If = 0 then use the default

	mov	al,ParsedBuffer		; Get the row position value
	or	al,al			; Is it 0
	jnz	UP_CursPos01		; No, leave as is.

	inc	al			; Yes. Map 0 into 1
	jmp short UP_CursPos02

UP_CursPos01:
	cmp	al,25			; Is it for row 25?
	jne	UP_CursPos02		; No.
					; Yes. Also need to do VT52 enable 25th
	mov	WORD PTR PutBuffer,VT52_SetMode
	mov	PutBuffer+2,VT52_25thLine
	mov	bx,3			; Have another 3 bytes to pass on

UP_CursPos02:
	add	al,' '-1		; Adjust row for VT52

	dec	cx			; Decrement parameter count
	jz	UP_CursPos04		; Only 1 spec. Use Column default.

	mov	ah,ParsedBuffer+1	; Get the column position
	or	ah,ah			; If it = 0
	jnz	UP_CursPos03
	inc	ah			; then treat as default of 1
UP_CursPos03:
	add	ah,' '-1		; and adjust for the VT52

UP_CursPos04:				; Row & Column are in ax
	mov	WORD PTR PutBuffer+2[bx],ax

	mov	ax,VT52_CursPOS		; Set up the VT52 escape seq
	mov	WORD PTR PutBuffer[bx],ax
	add	bl,4			; Account for the 4 bytes
	mov	PutCount,bl

	ret

UP_CursPos	endp



UP_SetAttr	proc	near

;	Map Set Graphics Rendition. Most of the attributes are ignored,
;		since we are dealing with a monochrome screen. The only
;		ones handled are Bold (Intensity), Underscore and Reverse.

	xor	bx,bx			; BX is count of bytes in PutBuffer
	mov	cx,ParsedPointer
	sub	cx,offset ParsedBuffer	; Calculate number of parameters
	jz	UP_SetAttrDone		; If = 0 then nothing to do

	push	si			; Save these, just in case
	push	di
	mov	si,offset ParsedBuffer
	mov	di,offset PutBuffer
	push	cs
	pop	es

UP_SetAttrLoop:
	cmp	bx,256			; Is there still room in buffer?
	jnb	UP_SetAttrAbort		; No. Abort

	lodsb				; Get the next attribute
	cmp	al,ANSI_AttrOff
	jne	UP_SA_Loop01

	cmp	bx,256-4		; Is there room for 4 more in buffer?
	jnb	UP_SetAttrAbort		; No. Abort

	mov	ax,VT52_BoldOff		; Turn off Bold
	stosw
	mov	ax,VT52_ReverseOff	; Turn off Reverse
	stosw
	add	bx,4			; Account for extra 4 bytes
	mov	ax,VT52_UnderOff	; Turn off Underline
	jmp short UP_SA_Loop04		; Finish up like the others

UP_SA_Loop01:
	cmp	al,ANSI_Bold
	jne	UP_SA_Loop02

	mov	ax,VT52_BoldOn
	jmp short UP_SA_Loop04		; Finish up.

UP_SA_Loop02:
	cmp	al,ANSI_Under
	jne	UP_SA_Loop03

	mov	ax,VT52_UnderOn
	jmp short UP_SA_Loop04		; Finish up.

UP_SA_Loop03:
	cmp	al,ANSI_Reverse
	jne	UP_SA_LoopEnd		; Ignore any others

	mov	ax,VT52_ReverseOn

UP_SA_Loop04:				; Finish up.
	stosw				; Store it in the buffer
	inc	bx			; Add 2 to the count
	inc	bx


UP_SA_LoopEnd:
	loop	UP_SetAttrLoop		; Get next parameter

UP_SetAttrAbort:
	pop	di			; Restore
	pop	si
	

UP_SetAttrDone:
	mov	PutCount,bl

	ret

UP_SetAttr	endp



UP_SetMode	proc	near

;	Map Set and Reset Mode.
;	The only mode change we handle is Enable/Disable wrap at line end.

	mov	bx,offset ParsedBuffer
	cmp	bx,ParsedPointer	; Any data parsed?
	je	UP_SetModeIgnore	; No. Ignore it.

	cmp	ParsedBuffer,ANSI_EOLWrap ; Is code for Wrap at end of line
	jne	UP_SetModeIgnore	; No. Ignore it.

	mov	al,ESC			; Put an ESC in the low order byte
	mov	bx,cx			; Need a byte index.
	mov	ah,ESCMapTable[bx]	; Get resulting escape character
	mov	WORD PTR PutBuffer,ax	; Default is always 1
	mov	PutCount,2

	ret

UP_SetModeIgnore:
	mov	PutCount,0		; Indicate nothing to pass on.
	ret

UP_SetMode	endp



UP_KeyAssn	proc	near

	;	Assign translation to an incoming code.
	;	The first parsed byte is the key code.
	;	If there is only one byte, or exactly two byte with
	;	   the same value then this cancels any translation;
	;	otherwise the string following is presented whenever
	;	   the keycode is seen by the Get function.

	mov	cx,ParsedPointer
	sub	cx,offset ParsedBuffer	; Calculate number of parameters
	jz	UP_KeyAssnRet		; None -- ignore it

	mov	bx,WORD PTR ParsedBuffer	; Get the first 2 bytes
	dec	cx			; Don't count key code
	jz	UP_KACancel		; If only one byte then cancel
	cmp	cx,1			
	jne	UP_KADefine
	cmp	bh,bl			; If exactly 2 equal bytes
	jne	UP_KADefine		; then cancel translation

UP_KACancel:
	xor	bh,bh			; Get code value
	call	UP_KAFree		;   & free the heap space
	jmp short UP_KeyAssnRet		; and return


UP_KADefine:
	xor	bh,bh			; Get code value
	call	UP_KAFree		; First free the old heap space
					; All set. Define the new string
	mov	KeyTransSz[bx],cl	; First set the Trans size
	add	bx,bx			; Change byte index to word
	cmp	cl,2			; Can this be an immediate?
	ja	UP_KADefineLong		; No.
					; <= 2 This can be immediate.
	mov	ax,WORD PTR ParsedBuffer+1 ; Get bytes 2 & 3
	mov	KeyTable[bx],ax		;  and store in KeyTrans
	jmp short UP_KeyAssnRet		; All done. Return

UP_KADefineLong:
	mov	ax,AvailKeyByte		; Get the offset of the first avail
	xor	ch,ch			; convert size to a word
	add	ax,cx			; and add the new size.
	jc	UP_KADefineBad		; Just in case at end of 65K heap.
	cmp	ax,MaxKeyBytes		; Is there room in the heap
	jna	UP_KADefineLong01	; There's room. Can do the define.

UP_KADefineBad:				; Cannot do the define
	shr	bx,1			; Convert word index to byte
	mov	KeyTransSz[bx],0	; Clear KeyTransSz
	jmp short UP_KeyAssnRet		; and return

UP_KADefineLong01:
	push	si			; Save si & di
	push	di
	mov	si,offset ParsedBuffer+1 ; Set source to ParsedBuffer
	mov	di,AvailKeyByte		; Set destination to
	mov	es,KeySelector		;   next available KeyHeap byte
	mov	KeyTable[bx],di		; Also fix KeyTable with Heap offset
	mov	AvailKeyByte,ax		; Now can update AvailKeyByte
	cld
	rep movsb			; Move trans string to KeyHeap

	pop	di
	pop	si			; Restore si & di

UP_KeyAssnRet:
	mov	PutCount,0		; Nothing to pass on
	ret

UP_KeyAssn	endp


UP_KAFree	proc	near

	; Service procedure for UP_KeyAssn to free Key Heap space
	; Enter with bx set to the byte index of the key code for
	; the free.
	; All registers are preserved.

	push	ax			; save register we will use
	push	bx
	push	cx
	push	si
	push	di

			; ax is used in UP_KAFreeLoop -- Don't destroy
	mov	al,KeyTransSz[bx]	; Get old value of trans size
	cmp	al,2			; If 0, 1 or 2 then either no
	jna	UP_KAFreeRet		;  trans or immediate
					; E.g No heap space alocated.

	add	bx,bx			; Convert byte index to word
	mov	di,KeyTable[bx]		; Get the destination offset
	mov	si,di			; Calculate the source offset as
	xor	ah,ah
	add	si,ax			; dest + trans size
	mov	cx,AvailKeyByte
	sub	cx,ax			; Update the AvailKeyByte offset
	mov	AvailKeyByte,cx		; and calculate the # of bytes to
	sub	cx,di			; move.
	jz	UP_KAFreeRet		; At end of heap. Nothing to do.

	push	di			; Save it for later.
	mov	es,KeySelector
	push	ds			; save ds
	push	es			; and set it to
	pop	ds			; es (e.g. KeySelector)
	cld
	rep movsb			; Compact the heap
	pop	ds			; Restore ds

	pop	di			; Restore saved di (start of compacting)
			; Now need to go through KeyTable & adjust offsets
	mov	si,offset KeyTable+510	; Address of last table entry
	mov	cx,255			; Number of table entries
UP_KAFreeLoop:
	cmp	di,[si]
	ja	UP_KAFreeLpEnd		; No need for adjustment

	mov	bx,cx			; Need index in an index register
	cmp	KeyTransSz[bx],2	; Make sure it's an offset
	jna	UP_KAFreeLpEnd		; Not an offset. Don't adjust

	sub	[si],ax			; Decrement the offset

UP_KAFreeLpEnd:
	dec	si
	dec	si			; Decrement si by 2
	loop	UP_KAFreeLoop

UP_KAFreeRet:
	pop	di
	pop	si
	pop	cx
	pop	bx
	pop	ax			; restore registers used

	mov	KeyTransSz[bx],0	; And clear KeyTransSz

	ret

UP_KAFree	endp



;****************************************************************************
;			Get Status					    *
;			Entry:	AX = 2					    *
;			Exit:	AL = 00 Indicates no data ready		    *
;				AL = FF Indicates data ready		    *
;****************************************************************************

UDC_getstat	proc	near


	cmp	KeyTransCount,0		; Are there data in local buffer
	je	UGS10			; No. Get status from further down

	mov	al,0FFh			; Yes. Return char available stat
	ret

UGS10:
	call	dword ptr UDC_CONvector
	ret

UDC_getstat	endp


;****************************************************************************
;			Put status					    *
;				(Always Ready to put. Pass it through)	    *
;			Entry:	AX = 3					    *
;			Exit:	AL = 00 Indicates not ready		    *
;				AL = FF	Ready				    *
;****************************************************************************

UDC_putstat	proc	near


	call	dword ptr UDC_CONvector

	ret

UDC_putstat	endp




;****************************************************************************
;			Read UDC vector					    *
;			Entry:	AX = 4					    *
;			Exit:	AL = FF  vector set properly		    *
;				ES:BX = long address of pass on module	    *
;****************************************************************************

UDC_GETvector	proc	near


	mov	bx,offset UDC_CONvector
	mov	ax,2[bx]
	mov	es,ax
	mov	bx,0[bx]
	mov	al,0ffh			;return proper status
	ret

UDC_GETvector	endp



;****************************************************************************
;			Set UDC vector					    *
;			Entry:	AX = 5					    *
;				save_es and save_bx make up		    *
;				ES:BX = Long address of new module	    *
;			Exit:	AL = 00  vector set			    *
;				AL = FF  vector not set properly	    *
;****************************************************************************

UDC_SETvector	proc	near


	mov	ES,save_es		;restore
	mov	bx,save_bx		;  vector pointers
	mov	word ptr UDC_CONvector,bx
	mov	word ptr UDC_CONvector+2,es
	ret

UDC_SETvector	endp



;****************************************************************************
;			Get UDC id					    *
;			Entry:	AX = 6					    *
;			Exit:	AX = UDC_AnsiId  (A2C1h)             	    *
;****************************************************************************

UDC_getid	proc	near


	mov	ax,UDC_AnsiId		; return my id
	ret

UDC_getid	endp

code	ends


;****************************************************************************
;			Initialization Data Starts Here			    *
;****************************************************************************


initstack	segment	stack 'initstack'

		dw  	80h dup(?)
InitStackEnd	dw	?

initstack	ends


baseseg		segment	'baseseg'

		org	80h		;bdos buffer
CmdTailSize	db	?		;Command tail size
CmdTail 	db	?		;Start of the command tail

baseseg		ends


initdata	segment	'initdata'


UDC_setparms	dw	1			;device 1: UDC
		dw	UDC_entry,code

UDC_next	dw      2 dup (?)


signon1		db   0dh,0ah,'ANSI 1.1a installed.',0dh,0ah,'$'
err_signon	db   ' -- ANSI 1.1a terminating.',0dh,0ah,'$'
alrdy_in_msg	db   0dh,0ah,'Already installed$'
UDC_errmsg	db   0dh,0ah,'System error$'

basepageseg 	dw 	?

initdata	ends


;****************************************************************************
;			Initialization Code Starts Here			    *
;****************************************************************************

initcode	segment	'initcode'
		assume	cs:initcode, ds:initdata

AllocMem proc	near

	mov	ah,48h
	int	msdosint
	ret

AllocMem endp


ModMem proc	near

	mov	ah,4ah
	int	msdosint
	ret

ModMem endp


FreeMem proc	near

	mov	ah,49h
	int	msdosint
	ret

FreeMem endp


FixMem	proc	near


	mov	es,basepageseg		; Start of the program
	mov	bx,10h			; Only keep the Base page
	call	ModMem
		; Now get the remaining memory up to the start of the resident
		;  part, making provisions for the 10byte memory headers.
		; e.g. space = resident - basepageseg - 10h - 1 - 1
		;	10h is size of basepage, 1 for each of the two headers
	mov	bx,resident
	sub	bx,basepageseg
	sub	bx,10h+1+1
	call	AllocMem
	push	ax			; Save this address
		; Now get the remaining memory (e.g. the program itself)
	mov	bx,0f000h		; First call returns maximum which
	call	AllocMem		; can be allocated
	call	AllocMem		; Second call gets it
		; Finally return the piece in the middle
	pop	es
	call	FreeMem

	ret

FixMem	endp

;****************************************************************************
;				Program Start				    *
;****************************************************************************

PgmStart:
	mov	dx,ds
	mov	ax,initdata		;set DS: to initialize data
	mov	ds,ax

	mov	basepageseg,es
	mov	ax,code			;set ES: to resident data
	mov	es,ax
	assume	es:code

	mov	bx,offset udc_getparms	;point to BIOS vector destination
	mov	ax,14			;request get vector
	int	xbiosint		; call super bios
	or	ax,ax			;error from super BIOS?
	jnz	udc_initerr			;yes, error exit
;
;  Now check if already installed
;
	mov	ax,UDC_CONvector	; Move first UDC address to
	mov	UDC_next,ax		;    UDC_next
	mov	ax,UDC_CONvector+2	;	(both
	mov	UDC_next+2,ax		;	      words)

	assume	es:nothing		; ES changes value in loop

UDC_check:
	mov	ax,UDC_GETidFn
	call dword ptr UDC_next		; Who is there?
	cmp	ax,UDC_AnsiId
	jne	UDC_not_I

	mov	dx,offset alrdy_in_msg	; Calculator already in.
	jmp short UDC_INITerr_msg	; Abort

UDC_not_I:
	mov	ax,UDC_GETvectorFn	; Get next UDC vector
	call dword ptr UDC_next
	mov	ax,es
	or	ax,bx			; Was return zero?
	jz	UDC_check_ok		;  Yes. All done.
;					;  No. Carry on.
	mov	UDC_next,bx		;Store next UDC vector
	mov	UDC_next+2,es		;	address
	jmp short UDC_check		;Check next UDC

UDC_check_ok:
	push	ds			; set es to ds, for Super BIOS call
	pop	es

;	All is checked. Install ourselves at the closest to the user side.

	mov	bx,offset udc_setparms	;point to secondary UDC carrier
	mov	ax,15			;request set vector
	int	xbiosint		;call Super Bios to set vector addr
	or	ax,ax			;error from Super Bios??
	jnz	udc_initerr			;bad error - exit

	mov	AH,9			;console string out
	mov	dx,offset signon1	;addr of signon msg
	int	msdosint

					; Everything is initialized
					; Return unused memory, including
					; init data, code & stack, and
					; terminate & stay resident
	call	fixmem

	mov	ah,31h			; Keep process
	xor	dx,dx			; with 0 paragraphs retained and
	xor	al,al			; with "no error" return code (0)
	int	msdosint


UDC_INITerr:
	mov	dx,offset UDC_errmsg
UDC_INITerr_msg:
	mov	ah,9
	int	msdosint		;Display first part of msg

	mov	dx,offset err_signon
	mov	ah,9
	int	msdosint		;Display standard part of err msg


	mov	ah,4ch			; Terminate process
	mov	al,0ffh			; with return code 0ffh
	int	msdosint

initcode 	ends

	end	PgmStart
