TITLE	Initialize Serial Ports A and B
SUBTTL	Copyright (c) 1985 Charles M Dayton.  All rights reserved.
NAME	INITSIO
;-----------------------------------------------------------------
COMMENT	\
	AUTHOR
		Charles M Dayton

	END USER
		Victor 9000 Users - Freebie

	VERSIONS
		1.00 -  3/27/85

	HISTORY
		 3/27/85 - completed 1.00

	COMMENTS
		Initializes serial ports A and B for the Victor 9000,
		allowing the removal of the serial device drivers
		(PORTA.EXE and PORTB.EXE) from CONFIG.SYS when using
		MSDOS 2.11.
	\
;-----------------------------------------------------------------
CSEG		SEGMENT
		ASSUME	CS:CSEG, DS:CSEG
		ORG	100h
START		PROC	NEAR
		jmp	init_sio
START		ENDP
;-----------------------------------------------------------------
SEG_E002	dw	0e002h
SEG_E004	dw	0e004h
SEG_E800	dw	0e800h

TITLE_MS	db	'Initialize Serial I/O Ports A and B',13,10
		db	'Copyright (c) 1985 by Charles M Dayton',13,10
		db	'Version 1.00 - March 27, 1985',13,10
		db	10,'$'

;-----------------------------------------------------------------
INIT_SIO	PROC	NEAR
		mov	ah,9			;print title
		mov	dx,offset title_ms
		int	21h

	;set the serial ports to use the internal clock

	;NOTE: the setting of internal/external clock usually needs
	;to be done only once.  MSDOS 2.11 presumes that the serial
	;device drivers will do it.

		mov	es,seg_e800
		mov	al,es:[43h]		;get current DDRA

	;leave bits 7 and 6 alone (they are inputs and should be low)
	;force bits 5,4,3 and 2 low (making them inputs)
	;force bits 1 and 0 high (making them outputs)

		and	al,0c0h
		or	al,3
		mov	es:[43h],al		;update DDRA
		and	byte ptr es:[41h],0fch	;select internal clock

	;reset both channels (ports) of the 7201 serial controller chip

	;NOTE: like setting of the clock (above), resetting the serial
	;channels usually needs to be done just once.

		mov	es,seg_e004
		mov	byte ptr es:[2],18h	;reset channel A
		mov	byte ptr es:[3],18h	;reset channel B

	;can not fool with the 7201 chip for 4 clock cycles after
	;doing a channel reset, so let's set the baud rate generator

		mov	es,seg_e002
		mov	byte ptr es:[3],36h	;set baud rate A
		mov	byte ptr es:[0],41h	;(1200 baud)
		mov	byte ptr es:[0],0

		mov	byte ptr es:[3],76h	;set baud rate B
		mov	byte ptr es:[1],41h	;(1200 baud)
		mov	byte ptr es:[1],0

	;setting the baud rate generator will have taken much more
	;than 4 clock cycles, so back to the 7201 we go

	;NOTE: the Control Registers (cr) can be set in any order
	;the order below (2,4,3,5,1) mimics the Victor Hardware
	;Reference Manual example (pp. 254-257)

		mov	es,seg_e004
		mov	byte ptr es:[2],2	;cr2a
		mov	byte ptr es:[2],10h	;  bus interface option

		mov	byte ptr es:[2],4	;cr4a
		mov	byte ptr es:[2],44h	;  1 stop/no parity
		mov	byte ptr es:[3],4	;cr4b
		mov	byte ptr es:[3],44h	;  1 stop/no parity

		mov	byte ptr es:[2],3	;cr3a
		mov	byte ptr es:[2],0e1h	;  8 recv bits
		mov	byte ptr es:[3],3	;cr3b
		mov	byte ptr es:[3],0e1h	;  8 recv bits

		mov	 byte ptr es:[2],5	;cr5a
		mov	 byte ptr es:[2],0eah	;  8 tran bits/DTR/RTS
		mov	 byte ptr es:[3],5	;cr5b
		mov	 byte ptr es:[3],0eah	;  8 tran bits/DTR/RTS

		mov	byte ptr es:[2],11h	;cr1a (an reset intrs)
		mov	byte ptr es:[2],0	;  no serial interrupts
		mov	byte ptr es:[3],11h	;cr1b (and reset intrs)
		mov	byte ptr es:[3],0	;  no serial interrupts

		sti				;back to normal
		int	20h			;back to DOS
INIT_SIO	ENDP
;-----------------------------------------------------------------
CSEG		ENDS
		END	START
