TITLE LIST5.COM - FRED HOLUBOW - 6/29/85
PAGE 60,132
;*********************************************************************
;  BUILT UP FROM DISASSEMBLY OF LIST549.COM [IBM-PC PROG.]
;  ADAPTED FOR THE VICTOR 9000 BY Fred Holubow 312-621-0640
;  CONTAINS VICTOR 9000 SPECIFIC ROUTINES-- 
;*********************************************************************
;
MAIN	SEGMENT	PARA PUBLIC 'CODE'
	ORG	100H
LIST 	PROC	FAR
;
	ASSUME	CS:MAIN
	ASSUME 	DS:MAIN
	ASSUME	SS:MAIN
	ASSUME	ES:MAIN
.RADIX  16
;
START:
	MOV     SP,OFFSET LINE_BUF + 200H
        PUSH    DS
        SUB     AX,AX
        PUSH    AX
        MOV     STKPT,SP
        CALL    DOSVER
        CALL    RDFLNAM
        CALL    FINDFIL
        CALL    ALLOMEM
REINIT: CALL    INITTOP
        CALL    WRTBOT
        JMP     BEGIN

NORM_EXIT:
	MOV     SP,STKPT
        MOV     BX,FILHAND  
        MOV     AH,3E
        INT     21

;DOSCALL CLOSE$H     	;Close file (BX=handle)
	MOV	AH,4F
	INT	21H
;DOSCALL FIND$NEXT	;find next dir entry

	OR	AL,AL
	JNZ	LEAVE_PRG
	MOV	SI,FILE_NAME_PTR
	CALL	FIND_NEXT_FILE
	CALL	CLRSCR
	MOV	WORD PTR FILE_PTR,0000
	MOV	BYTE PTR SCRN_LINE,02
	MOV	BYTE PTR SCRN_COLUMN,01
	MOV	BYTE PTR NUM_FILE_READS,00
	JMP	REINIT

LEAVE_PRG:
	
	MOV	SP,STKPT
	MOV	DI,OFFSET LINE_BUF
	MOV	CX,0050
	MOV	AL,20
	REPZ	STOSB
	MOV	DX,1901
	MOV	CX,0050
	MOV	SI,OFFSET LINE_BUF
	MOV	BH,0C0
	CALL	LINE_TO_SCRN
	MOV	AX,0600
	MOV	BX,SCRL_ATTR
	MOV	CX,0
	MOV	DX,184FH
	CALL	VIDEO_IO
	CALL	CLRSCR


        MOV     ES,MEMPTR   
        MOV     AH,49
        INT     21

;DOSCALL FREE$MEM    	;Free allocated memory (ES=seg)

        RET
;------------------------------------------------------------------------
;				
;------------------------------------------------------------------------
ERR_EXIT:
	MOV     SP,STKPT
        MOV     AH,09
        INT     21

;DOSCALL PRINT$      	; Display string @DX till terminator

        RET
LIST	ENDP	FAR
;
;********************INITIALIZE DATA VARIABLES************************
;
CR	EQU	0DH
LF	EQU	0AH
TAB	EQU	09
ESC	EQU	1BH
NUM_SINGLE_CMD	EQU	1BH
NUM_ESC_CMD	EQU	0DH
UNDLN		DB	60
NORMAL		DB	40
SCRL_ATTR	DW	4000
FILE_PTR	DW	00
FILE_PTR2	DW	00
BYTES_READ	DW	00
FILE_PTR1	DW	00
		DB	30 DUP(0)
COLNUM		DW	50
SCRNADDR	DW      0F000
FONTPTR		DB	00
STKPT		DW	00
LINE_BUF_PTR	DW	00
SCRN_LINE	DB	02
SCRN_COLUMN	DB	01
ATTRIB		DB	02
NUM_FILE_READS	DB	00
COLUMN_START	DW	00
FILE_NAME_PTR	DW	00
MOV_FILE_PTR1	DW	00
MOV_FILE_PTR2	DW	00
MEMPTR		DW	00
date1		dw	00
date2		dw	00
FILHAND		DW	00
CONSTSZ		DW	10
MEMSIZ		DW	00
SEARCH_FLAG	DB	00
CMD_PTR		DB	08
LF_CTR		DB	01
CR_CTR		DB	00
CMD_MSG		DB	'Command',10
SCANNING_MSG	DB	'Scanning'
READ_MSG	DB	'Reading '
SCAN_MSG	DB	'Scan   ',10
FIND_MSG	DB	'Find   ',10
BOT_MSG		DB	'Command',10
BLNK_BOT_HLP_MSG	DB	20 DUP(' ')
        	DB      'Keys:Arrows U,D=Scrl +,- Q=exit ?=Help '
NOT_FOUND_MSG	DB	'*** Text not found ***'
TOP_MSG		DB	'   *** Top of file ***'
EOF_MSG   	DB      '   *** End-of-file ***'
FIL_NAME_BUF	DB	'LIST'
BUFSIZE		DB	40
BUFCNT		DB	00
NAMBUF		DB	4CH DUP(0)
ERR_MSG1	DB	CR,LF,'Not enough memory',CR,LF,'$'
ERR_MSG2	DB	CR,LF,'Wrong DOS version',CR,LF,'$'	
ENT_FILENAME	DB	CR,LF,'Enter filename: $'
ERRMS		DB	'  Open failed, return code='
RETCODE		DW	0000
     		DB	'$'
     		DB	'File not found $'
     		DB	'Path not found $'
     		DB	'Too many files $'
     		DB	'Access denied  $'
     		DB	0AH DUP(0)
SINGLE_CMDS	DB	CR,' ',ESC,'QDU?H/RLTPAFXBW78+-K\S',0F1H,0FAH
ESC_CMDS	DB	'CD" HA=B;ZEws'		;Esc Cmd
SINGLE_CMD_LIST	LABEL	WORD		;Single Command List
	DW	OFFSET SCRL_DN
	DW	OFFSET SCRL_DN
	DW	OFFSET NORM_EXIT
	DW	OFFSET NORM_EXIT
	DW	OFFSET SCRL_DN
	DW	OFFSET SCRL_UP
	DW	OFFSET HELP
	DW	OFFSET HELP
	DW	OFFSET STR_SEARCH
	DW	OFFSET RIGHT
	DW	OFFSET LEFT
	DW	OFFSET TOP
	DW	OFFSET PRINT_TGL
	DW	OFFSET AGAIN
	DW	OFFSET STR_SEARCH
	DW	OFFSET LEAVE_PRG
	DW	OFFSET BOTTOM
	DW	OFFSET WRAP_TGL
	DW	OFFSET STRIP_BIT
	DW	OFFSET SET_BIT
	DW	OFFSET SCRL_DN
	DW	OFFSET SCRL_UP
	DW	OFFSET KILL_CMD
	DW	OFFSET TEXT_MATCH
	DW	OFFSET TEXT_MATCH
	DW	OFFSET HELP
	DW	OFFSET LEAVE_PRG
ESC_CMD_LIST	LABEL	WORD		;Escape Command List
	DW	OFFSET RIGHT
	DW	OFFSET LEFT
	DW	OFFSET SCRL_UP
	DW	OFFSET SCRL_DN
	DW	OFFSET TOP
	DW	OFFSET LINE_UP
	DW	OFFSET AGAIN
	DW	OFFSET LINE_DN
	DW	OFFSET HELP
	DW	OFFSET NORM_EXIT
	DW	OFFSET BOTTOM
	DW	OFFSET RESET_FILEPTR
	DW	OFFSET RESET_COLUMN
HELPSCR   DB      CR,LF,TAB,'LIST - Version 5.49',TAB,TAB,TAB,'6/29/85',CR,LF
        DB      'IBM Ver. Written by Vernon D. Buerg--adapted to Victor 9000 '
	DB	'by F.HOLUBOW',LF,CR
        DB      LF
        DB      TAB,TAB,'= Commands and Keys =',LF,CR
        DB      LF
        DB      TAB,'Enter  ',TAB,'continue to next page   '
	DB	TAB,'F1,H,?  Display HELP info',CR,LF
        DB      TAB,'X      ',TAB,'terminate and exit      '
        DB      TAB,'F10     Terminate and exit',CR,LF
        DB      TAB,'Q, ESC ',TAB,'quit and list next file '
	DB	TAB,'W       Wrap long lines on/off',CR,LF
        DB      TAB,'T, HOME',TAB,'restart from Top of file'
	DB	TAB,'P       Printer toggle on/off',CR,LF
        DB      TAB,'B, CLR ',TAB,'skip to Bottom of block '
	DB	TAB,'7 or 8  strip or leave hi-bit',CR,LF
        DB      TAB,'D or + ',TAB,'scroll Down one page    '
	DB	TAB,'Space   continue to next page',CR,LF
        DB      TAB,'U or - ',TAB,'scroll Up one page      '
	DB	TAB,'K       kill previous command',CR,LF
        DB      TAB,'S      ',TAB,'Scan for exact text match'
	DB	TAB,'\text   Scan for exact match',CR,LF
	DB	TAB,'F      ',TAB,'Find any case text match'
	DB	TAB,'/text   Find any case match',CR,LF
	DB	TAB,'A      ',TAB,'find or scan text Again',CR,LF,LF
	DB	TAB,'Cursor arrows:',CR,LF
        DB      TAB,TAB,'left-arrow   ',TAB,'scroll Left 20 columns',CR,LF
        DB      TAB,TAB,'right-arrow  ',TAB,'scroll Right 20 columns',CR,LF
        DB      TAB,TAB,'up-arrow     ',TAB,'Previous, up one line',CR,LF
        DB      TAB,TAB,'down-arrow   ',TAB,'Next, down one line',CR,LF,'$'
;
;
;------------------------------------------------------------------------
;				
;------------------------------------------------------------------------
BEGIN:  
	CALL    READFIL
        MOV     BL,NORMAL
        MOV     ATTRIB,BL
        JNZ     WRITE_SCRN
        JMP     EOF_RETURN

WRITE_SCRN:  
	DEC     BYTE PTR SCRN_LINE	;02
        CMP     BYTE PTR LF_CTR,00	;01
        JZ      L061F
        INC     BYTE PTR SCRN_LINE	;02
        MOV     BYTE PTR SCRN_COLUMN,01	;01
L061F:  MOV     AX,FILE_PTR	
        TEST    BYTE PTR CMD_PTR,01 
        JZ      L0631
        AND     BYTE PTR CMD_PTR,0FE
        JMP     EOF_RETURN

L0631:  CALL    WRITE_SCRN_LN
        MOV     CX,LINE_BUF_PTR
        ADD     SCRN_COLUMN,CL
        MOV     DH,SCRN_LINE
        CMP     DH,19
        JNZ     WRITE_SCRN
        CMP     BYTE PTR LF_CTR,00
        JZ      WRITE_SCRN
CMD_ENTER:  
	MOV     AH,06
	MOV	DL,0FFH
	INT	21H		;Keyboard I/O Call
	JZ	L065F
        CALL    INT_16		;Keyboard I/O Call
        TEST    BYTE PTR CMD_PTR,40
        JNZ     CMD_ENTER
        JMP     L0663
L065F:  CALL    INT_16		;Keyboard I/O Call

L0663:  MOV     SI,OFFSET BLNK_BOT_HLP_MSG
        CALL    BOTTOM_MSG
        CMP     AL,ESC
        JNZ     L0670
        JMP     NORM_EXIT

L0670:  CMP     AL,00
        JNZ     L0682
        XCHG    AH,AL
        MOV     DI,OFFSET ESC_CMDS
        MOV     BP,OFFSET ESC_CMD_LIST
        MOV     CL,NUM_ESC_CMD		;Esc Command List Length
        JMP     L0690

L0682:  CMP     AL,61
        JL      L0688
        SUB     AL,20
L0688:  MOV     DI,OFFSET SINGLE_CMDS
        MOV     BP,OFFSET SINGLE_CMD_LIST
        MOV     CL,NUM_SINGLE_CMD   	;Single Key Command List Length
L0690:  MOV     SI,DI
        MOV     CH,00
        PUSH    DS
        POP     ES
        REPNZ SCASB		;Find Command Procedure
        JNZ     CONT0
        DEC     DI
        SUB     DI,SI
        SHL     DI,1
        MOV     BX,DS:[BP+DI]
        JMP     BX		;Jump to Command Procedure
CONT0:	MOV	AH,02
	MOV	DL,07
	INT	21
	JMP	CMD_ENTER

REWRITE_SCRN:  
	CALL    BACK_UP_SCRN
SCRL_DN: 
	MOV     AX,FILE_PTR
        CMP     AX,BYTES_READ
        JNB     EOF_RETURN
        MOV     FILE_PTR2,AX
        MOV     BYTE PTR SCRN_LINE,02
        CALL    CLR_WINDOW
        JMP     WRITE_SCRN

L04EB:	JMP	SCRL_DN

TOF_RETURN:
	MOV	SI,OFFSET TOP_MSG
	CALL	BOTTOM_MSG
	JMP	REWRITE_SCRN

EOF_RETURN:  
	MOV     SI,OFFSET EOF_MSG
        CALL    BOTTOM_MSG
        JMP     CMD_ENTER

RIGHT:
	TEST    BYTE PTR CMD_PTR,04
        JNZ     L06D5
        CMP     WORD PTR COLUMN_START,00DC
        JB      L06D8
L06D5:  JMP     CMD_ENTER

L06D8:  ADD     WORD PTR COLUMN_START,+14 
        JMP     REWRITE_SCRN
;--------------------------------------------------------------------------

RESET_COLUMN:  
	MOV     WORD PTR COLUMN_START,0000 
        JMP     REWRITE_SCRN
;--------------------------------------------------------------------------

LEFT:
	TEST    BYTE PTR CMD_PTR,04
        JNZ     L06F7
        CMP     WORD PTR COLUMN_START,+00 
        JNZ     L06FA
L06F7:  JMP     CMD_ENTER

L06FA:  SUB     WORD PTR COLUMN_START,+14 
        JMP     REWRITE_SCRN
;---------------------------------------------------------------------------

AGAIN:
	CALL    STRG_SEARCH0		
        JMP     SCRL_DN
;--------------------------------------------------------------------------

HELP:
	CALL    PRTHELP		
        CALL    BACK_UP_SCRN
        JMP     CMD_ENTER
;---------------------------------------------------------------------------

STR_SEARCH:
	CALL    STRG_SEARCH1		
        JMP     SCRL_DN
;--------------------------------------------------------------------------
TEXT_MATCH:
	CALL	STRG_SEARCH2
	JMP	SCRL_DN

WRAP_TGL:
	XOR     BYTE PTR CMD_PTR,04     
	mov	word ptr column_start,0
        JMP     REWRITE_SCRN
;--------------------------------------------------------------------------

STRIP_BIT:
	AND     BYTE PTR CMD_PTR,0F7    
        JMP     TOP
;---------------------------------------------------------------------------

SET_BIT:
	OR      BYTE PTR CMD_PTR,08     
        JMP     TOP
;---------------------------------------------------------------------------

PRINT_TGL:
	XOR     BYTE PTR CMD_PTR,10     
        JMP     REWRITE_SCRN
;---------------------------------------------------------------------------

KILL_CMD:  
	XOR     BYTE PTR CMD_PTR,40     
        JMP     REWRITE_SCRN
;--------------------------------------------------------------------------

RESET_FILEPTR:  
	MOV     WORD PTR FILE_PTR,0000   
        JMP     SCRL_DN
;---------------------------------------------------------------------------

BOTTOM:
	call	readfil
	jnz	bottom	
	MOV     AX,BYTES_READ	      
        MOV     FILE_PTR,AX
	and	byte ptr cmd_ptr,0fe
	mov	di,offset file_ptr1
	push	ds
	pop	es
	sub	ax,ax
	mov	cx,0017
	repz	stosw
        JMP     REWRITE_SCRN
;--------------------------------------------------------------------------

	cmp	byte ptr num_file_reads,1
	jz	reset_fileptr
TOP:
	CALL	ZERO_FILE_PTR
        CALL    CLR_WINDOW
        MOV     BYTE PTR SCRN_LINE,02
        MOV     BYTE PTR SCRN_COLUMN,01
        SUB     AX,AX
        MOV     FILE_PTR1,AX
        MOV     NUM_FILE_READS,AL
        JMP     BEGIN
;---------------------------------------------------------------------------

LINE_DN:
	MOV     AX,FILE_PTR
        CMP     AX,BYTES_READ
        JB      L077E
        JMP     EOF_RETURN

L077E:  
	MOV	DI,OFFSET FILE_PTR1
	MOV	SI,OFFSET FILE_PTR1+2
	PUSH	ES
	PUSH	DS
	POP	ES
	MOV	CX,0030
	REPZ	MOVSB
	POP	ES
	CALL	SCROLL_WINDOW_UP
        MOV     BYTE PTR SCRN_LINE,18
        MOV     BYTE PTR SCRN_COLUMN,01
	MOV	AX,FILE_PTR
	MOV	FILE_PTR2,AX
        JMP     L061F
;---------------------------------------------------------------------------

SCRL_UP:
	CMP	WORD PTR FILE_PTR,0
	JNZ	CONT1
	JMP	TOF_RETURN
CONT1:	CALL    BACK_UP_SCRN
        JMP     REWRITE_SCRN
;---------------------------------------------------------------------------

BACK_UP_SCRN	PROC	NEAR
	MOV     CX,0017
L07B2:  CALL    BACK_UP_LN
	call	newproc
        LOOP    L07B2
        MOV     BYTE PTR SCRN_COLUMN,01
        RET
BACK_UP_SCRN	ENDP

;------------------------------------------------------------------------
;				
;------------------------------------------------------------------------
LINE_UP:
	CMP     WORD PTR FILE_PTR1,+00
        JZ      L07E0
	MOV	DI,FILE_PTR2
	CMP	DI,FILE_PTR1
        JNB     L07C7
L07E0:	CMP	BYTE PTR NUM_FILE_READS,01
	JA	L07F0
	JMP	TOF_RETURN
L07F0:	SUB	BYTE PTR NUM_FILE_READS,02
	CALL	READFIL
	MOV	AX,FILE_PTR1
	MOV	FILE_PTR,AX
	CALL	BACK_UP_LN
L07C7:  CALL    SCROLL_WINDOW_DN
        MOV     AX,FILE_PTR
        MOV     FILE_PTR2,AX
        MOV     AX,FILE_PTR1
        MOV     FILE_PTR,AX
        CALL    BACK_UP_LN
	call	newproc
        MOV     BYTE PTR SCRN_LINE,02
        MOV     BYTE PTR SCRN_COLUMN,01
        CALL    WRITE_SCRN_LN
        MOV     AX,FILE_PTR2
        MOV     FILE_PTR,AX
        CALL    BACK_UP_LN
        JMP     CMD_ENTER

BACK_UP_LN	PROC	NEAR  
STR1:	PUSH    CX
        PUSH    DI
        PUSH    DX
        MOV     DI,FILE_PTR
        OR      DI,DI
	JNZ	DEC1
	CMP	BYTE PTR NUM_FILE_READS,01
	JBE	L0837
	SUB	BYTE PTR NUM_FILE_READS,02
	CALL	READFIL
	MOV	DI,BYTES_READ
	MOV	FILE_PTR,DI
	CALL	STR1
	JMP	L0837
DEC1:   DEC     DI
        DEC     DI
        MOV     FILE_PTR,DI
        MOV     CX,DI
        MOV     ES,MEMPTR
        STD
        MOV     AL,0A
        REPNZ   SCASB
        CLD
        MOV     DX,FILE_PTR 
        MOV     FILE_PTR,CX 
        JCXZ    L0837
        INC     CX
        SUB     DX,CX
        INC     CX
        MOV     FILE_PTR,CX 
        TEST    BYTE PTR CMD_PTR,04
        JZ      L0837
L0828:  MOV     CX,0050
        SUB     DX,CX
        JZ      L0837
        JS      L0837
        ADD     FILE_PTR,CX
        JMP     L0828

L0837:  POP     DX
        POP     DI
        POP     CX
        RET
BACK_UP_LN	ENDP
;------------------------------------------------------------------------
;	newproc
;------------------------------------------------------------------------
newproc	proc	near
	PUSH	ES
	push	cx
	PUSH	DS
	POP	ES
	MOV	SI,OFFSET COLNUM-3
	MOV	DI,OFFSET COLNUM-1
	MOV	CX,0030
	STD
	REPZ	MOVSB	
	CLD
	mov	ax,file_ptr
	mov	file_ptr1,ax
	pop	cx
	POP	ES
	ret
newproc	endp
;------------------------------------------------------------------------
;	Reads the File		zero-flag set on exit with no read				
;------------------------------------------------------------------------
READFIL	PROC	NEAR
	PUSH    DS
        POP     ES
        MOV     CX,0008
        LEA     SI,READ_MSG
        LEA     DI,BOT_MSG
        REPZ    MOVSB
        CALL    WRTBOT
        MOV     CX,0008
        MOV     SI,OFFSET CMD_MSG	;'Command',10,'ScanningReading 
        TEST    BYTE PTR CMD_PTR,80
        JZ      L085B
        LEA     SI,SCANNING_MSG
L085B:  LEA     DI,BOT_MSG
        REPZ    MOVSB
 	SUB	CX,CX
 	MOV	CL,NUM_FILE_READS
 	MOV	AX,MEMSIZ
 	MUL	CX
 	MOV	CX,DX
 	MOV	DX,AX
 	CALL	MOVE_FILE_PTR
        MOV     BX,FILHAND
        MOV     CX,MEMSIZ 
        MOV     DS,MEMPTR
        SUB     DX,DX
        MOV     AH,3F
        INT     21

;DOSCALL READ$BYT    	;Read CX Bytes (BX=handle, DX -> buff)(AX)

        push    cs
	pop	ds
        OR      BYTE PTR CMD_PTR,01	;Read 0 char, set byte 1
        OR      AX,AX
        JZ      L08B0
        AND     BYTE PTR CMD_PTR,0FE	;Read some char, zero byte 1
        MOV     ES,MEMPTR	
        TEST    BYTE PTR CMD_PTR,08	
        JNZ     L0898			;if set, strips hi-bit
        MOV     CX,AX
        SUB     DI,DI
L0891:  AND     BYTE PTR ES:[DI],7F
        INC     DI
        LOOP    L0891
L0898:  MOV     BYTES_READ,AX	
        MOV     DI,AX
        MOV     BYTE PTR ES:[DI],1A
        SUB     AX,AX
        MOV     FILE_PTR,AX	
        INC     BYTE PTR NUM_FILE_READS	;00,00
L08B0:  PUSHF
        CALL    WRTBOT
        POPF
        RET
READFIL	ENDP
;------------------------------------------------------------------------
;	Writes line to screen as determined by various parameters.
;	Procedure reads line to line_buf then write to correct screen
;	line.  Also directs output to printer if appropriate.				
;------------------------------------------------------------------------
WRITE_SCRN_LN	PROC	NEAR
	CMP     BYTE PTR SCRN_LINE,02
        JB      L08C3
        MOV     AX,FILE_PTR
	SUB	BX,BX
	MOV	BL,SCRN_LINE
	SUB	BL,02
	ADD	BL,BL
	MOV	[BX+OFFSET FILE_PTR1],AX
L08C3:  CALL    FILL_LINE_BUF	
        MOV     CX,LINE_BUF_PTR
        SUB     CL,LF_CTR
        SUB     CL,CR_CTR
        MOV     LINE_BUF_PTR,CX
        MOV     SI,OFFSET LINE_BUF
        CMP     BYTE PTR SCRN_LINE,02
        JNB     L08E7
        MOV     BYTE PTR SCRN_LINE,02
L08E7:  MOV     DH,SCRN_LINE
        MOV     DL,SCRN_COLUMN
        ADD     SI,COLUMN_START
        SUB     CX,COLUMN_START
	MOV	BH,ATTRIB
        CALL    LINE_TO_SCRN
        TEST    BYTE PTR CMD_PTR,10
        JZ      L092D
        MOV     AH,06
	MOV	DL,0FFH

        INT     21H	;Keyboard I/O Call

        JNZ     L092D
        MOV     CX,LINE_BUF_PTR
        MOV     SI,OFFSET LINE_BUF
        MOV     BX,CX
        MOV     WORD PTR [BX+SI],0A0DH
        MOV     AL,LF_CTR
        ADD     CL,AL
        ADD     CL,AL
	jz	l092d
L091F:  LODSB
L0920:  MOV     AH,05
        MOV     DL,AL

        INT     21	;Printer I/O Call

        LOOP    L091F
L092D:  INC     BYTE PTR SCRN_LINE
        MOV     BL,NORMAL
        MOV     ATTRIB,BL
        RET
WRITE_SCRN_LN	ENDP
;------------------------------------------------------------------------
;	FILL LINE BUFFER
;	Uses line_buffer and file in ram.  Finds end of file, sets word
;	wrap, and forces lines to FF char length				
;------------------------------------------------------------------------
FILL_LINE_BUF	PROC	NEAR
	PUSH    ES
        PUSH    CX
        PUSH    SI
        PUSH    DI
L093E:  TEST    BYTE PTR CMD_PTR,01
        JZ      L0959
        MOV     AX,BYTES_READ	
        MOV     FILE_PTR,AX	
        CALL    READFIL
        JNZ     L0953
        JMP     L09E7

L0953:  MOV     DI,LINE_BUF_PTR	
        JMP     L095B

L0959:  SUB     DI,DI
L095B:  MOV     WORD PTR LF_CTR,0000
        MOV     ES,MEMPTR	
L0965:  MOV     SI,FILE_PTR
        MOV     AL,ES:[SI]
        CMP     AL,1A
        JNZ     L097B
        MOV     LINE_BUF_PTR,DI
        OR      BYTE PTR CMD_PTR,01
        JMP     L093E

L097B:  CMP     AL,09
        JNZ     L0998
        MOV     CX,DI
        ADD     CX,+08
        AND     CX,0FFF8
        SUB     CX,DI
L098A:  MOV     BYTE PTR [DI+OFFSET LINE_BUF],20
        INC     DI
        LOOP    L098A
        INC     WORD PTR FILE_PTR
        JMP     L0965

L0998:  MOV     [DI+OFFSET LINE_BUF],AL
        INC     DI
        INC     WORD PTR FILE_PTR
        CMP     AL,0DH
        JNZ     L09AB
        INC     BYTE PTR CR_CTR
        JMP     L09B9

L09AB:  CMP     AL,20
        JZ      L09B9
        CMP     AL,0A
        JNZ     L09B9
        INC     BYTE PTR LF_CTR
        JMP     L09D9

L09B9:  CMP     DI,00FF
        JNB     L09D9
        TEST    BYTE PTR CMD_PTR,04
        JZ      L09CB
        CMP     DI,+51
        JA      L09CD
L09CB:  JMP     L0965

L09CD:  INC     BYTE PTR LF_CTR
        DEC     WORD PTR FILE_PTR
        DEC     WORD PTR FILE_PTR
L09D9:  MOV     LINE_BUF_PTR,DI
        CMP     BYTE PTR LINE_BUF,0F
        JNZ     L09E7
        JMP     L0959

L09E7:  POP     DI
        POP     SI
        POP     CX
        POP     ES
        RET
FILL_LINE_BUF	ENDP
;------------------------------------------------------------------------
;	Moves one line to the screen
; 	CX=LINE LENGTH		DH=SCREEN LINE #
;	SI=INPUT STRG ADDR	DL=START COLUMN #
;
;	Limits CX to 50H but doesn't check if CX+DX > 50H
;				
;------------------------------------------------------------------------
LINE_TO_SCRN   PROC	NEAR
	PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    DI
        PUSH    ES
        PUSH    SI
        SUB     AX,AX
        XCHG    DH,AL
        MOV     DI,DX
        DEC     DI
        DEC     AX
        OR      CX,CX
        JLE     L0A56
        MOV     DX,0050
        CMP     CX,DX
        JBE     L0A08
        MOV     CX,DX
L0A08:  MUL     WORD PTR COLNUM
        ADD     DI,AX
        SHL     DI,1
        MOV     DL,FONTPTR
        MOV     ES,SCRNADDR
L0A18:  LODSB
        CMP     AL,20
        JNB     L0A3C
        CMP     AL,00
        JNZ     L0A31
        CMP     BH,NORMAL	
        JNZ     L0A3C		;Cmp to 'NORMAL' & jump if not
        INC     DI
        INC     DI
        JMP     L0A54

L0A31:  TEST	BYTE PTR CMD_PTR,08
	JNZ	L0A3C
	CMP	DI,0F00
	JNB	L0A3C
	ADD	AL,40
	MOV	BH,0C0
L0A3C:  MOV     BL,AL		;Attribute in BH and Char in AL
L0A50:  MOV     AX,BX
	ADD	AL,FONTPTR
        STOSW
L0A54:  LOOP    L0A18
L0A56:  POP     SI
        POP     ES
        POP     DI
        POP     DX
        POP     CX
        POP     BX
        POP     AX
        RET
LINE_TO_SCRN	ENDP
;------------------------------------------------------------------------
;    	String Search and Search Again				
;------------------------------------------------------------------------
STRG_SEARCH0:  
	CMP	BYTE PTR STRSIZE,20
	JNZ	STRG_SEARCH2
	PUSH    DI
        PUSH    SI
        PUSH    DS
        POP     ES
        JMP     L0A74

STRG_SEARCH1:
	MOV	BYTE PTR SEARCH_FLAG,01
	MOV	AX,OFFSET FIND_MSG
	JMP	STRG_SEARCH3

STRG_SEARCH2:
	MOV	BYTE PTR SEARCH_FLAG,00
	MOV	AX,OFFSET SCAN_MSG

STRG_SEARCH3:  
	PUSH    DI
        PUSH    SI
        PUSH    DS
        POP     ES
	MOV	SI,AX
	MOV	DI,OFFSET BOT_MSG
	MOV	CX,0008
	REPZ	MOVSB
	CALL	WRTBOT
        MOV     BYTE PTR STRSIZE,20
        MOV     DX,OFFSET STRSIZE
	MOV	BH,NORMAL
        MOV     AH,0A
        INT     21

;DOSCALL INSTR$      0D21	; Input keyboard string (DX -> size,cnt,buffer)

	TEST	BYTE PTR SEARCH_FLAG,01
	JZ	L0A74
	MOV	CX,0020
	MOV	SI,OFFSET STRBUF
STRG_LOOP1:
	LODSB
	CMP	AL,61
	JB	ENDLOOP
	CMP	AL,7A
	JA	ENDLOOP
	SUB	AL,20
	MOV	[SI-1],AL
ENDLOOP:
	LOOP	STRG_LOOP1

L0A74:  MOV     SI,OFFSET SCANNING_MSG
        MOV     DI,OFFSET BOT_MSG
        MOV     CX,0008
        REPZ    MOVSB
        CALL    WRTBOT
        OR      BYTE PTR CMD_PTR,80
        OR      CL,STRCNT
        JZ      L0ADA
        MOV     AX,FILE_PTR1
        MOV     FILE_PTR,AX
        CALL    FILL_LINE_BUF
L0A96:  CALL    FILL_LINE_BUF
        TEST    BYTE PTR CMD_PTR,01
        JNZ     L0ADA
        MOV     AX,FILE_PTR
        CMP     AX,BYTES_READ
        JNB     L0ADA
        MOV     DX,LINE_BUF_PTR
	MOV	AL,STRCNT
	CBW
        SUB     DX,AX
        JLE     L0A96
        CLD
        SUB     CH,CH	  
        MOV     BX,OFFSET LINE_BUF
	TEST	BYTE PTR SEARCH_FLAG,01
	JZ	STRG1
	MOV	CX,LINE_BUF_PTR
	MOV	SI,BX
STRG_LOOP2:
	LODSB
	CMP	AL,61
	JB	STRG2
	CMP	AL,7A
	JA	STRG2
	SUB	BYTE PTR [SI-1],20
STRG2:	LOOP	STRG_LOOP2
STRG1:	MOV	SI,BX
	MOV	DI,OFFSET STRBUF
        MOV     CL,STRCNT
        REPZ    CMPSB
        JZ      L0ACD
        INC     BX
        DEC     DL
        JNZ     STRG1
        JMP     L0A96

L0ACD:  CALL    PRT_BOT_SCANNING
        MOV     BYTE PTR ATTRIB,00	;Sets Attrib
        CALL    BACK_UP_LN
        JMP     L0AFD

L0ADA:  MOV     AX,FILE_PTR1
        MOV     FILE_PTR,AX
        CALL    PRT_BOT_SCANNING
        MOV     SI,OFFSET NOT_FOUND_MSG
        AND     BYTE PTR UNDLN,0BF	;Change to Hi-intensity
        CALL    BOTTOM_MSG
        OR      BYTE PTR UNDLN,40	;Returns to Low-intensity
        AND     BYTE PTR CMD_PTR,0FE
        MOV     BYTE PTR SCRN_COLUMN,01
L0AFD:  AND     BYTE PTR CMD_PTR,7F
        POP     SI
        POP     DI
        RET

;------------------------------------------------------------------------
; 	Various Screen Scrolls and Clears				
;------------------------------------------------------------------------
CLR_WINDOW:  
	PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        MOV     AX,0600
        JMP     L0B1F

SCROLL_WINDOW_UP:  
	PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        MOV     AX,0601
        JMP     L0B1F

SCROLL_WINDOW_DN:  
	PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        MOV     AX,0701
L0B1F:  MOV     BX,SCRL_ATTR
        MOV     CX,0100
        MOV     DX,174F

        CALL    VIDEO_IO	;Video I/O Call

        POP     DX
        POP     CX
        POP     BX
        POP     AX
        RET

;------------------------------------------------------------------------
;	Clears Screen and Home and Inits Fontptr and CRTC
;	Victor 9000 specific	
;------------------------------------------------------------------------
CLRSCR	PROC	NEAR
        MOV     AH,02
        MOV     DL,ESC
	INT	21
	MOV	DL,45
        INT     21
	MOV	DL,ESC
	INT	21
	MOV	DL,48
	INT	21
	MOV	ES,SCRNADDR	;INIT FONTPTR
	MOV	AX,WORD PTR ES:0
	AND	AX,7FF
	SUB	AX,20
	MOV	FONTPTR,AL
        RET
CLRSCR	ENDP
;------------------------------------------------------------------------
;	Should poke 'LIST' to screen			
;------------------------------------------------------------------------
INITTOP   PROC	NEAR
	CALL    CLRSCR
	call	newproc1
        MOV     WORD PTR BUFSIZE,003a
        MOV     DX,0101
        MOV     SI,OFFSET FIL_NAME_BUF
        MOV     CX,0050
        MOV     BH,UNDLN
        CALL    LINE_TO_SCRN
        RET
INITTOP	ENDP
;------------------------------------------------------------------------
;	Rewrites bottom line saying "Scanning"			
;------------------------------------------------------------------------
PRT_BOT_SCANNING	PROC	NEAR
	MOV     SI,OFFSET CMD_MSG	;'Command',10,'ScanningReading 
        MOV     DI,OFFSET BOT_MSG
        MOV     CX,0008
        REPZ    MOVSB
        CALL    WRTBOT
        RET
PRT_BOT_SCANNING	ENDP
;------------------------------------------------------------------------
; 	Writes the Bottom Command Line, uses the message at BOT_MSG				
;------------------------------------------------------------------------
WRTBOT  PROC	NEAR
	PUSH    DI
        PUSH    SI
        MOV     DX,1901
        MOV     CX,0050
        MOV     BH,UNDLN
        MOV     SI,OFFSET BOT_MSG
        CALL    LINE_TO_SCRN
        MOV     DX,1808
	CALL	GOTO_XY
        POP     SI
        POP     DI
        RET
WRTBOT	ENDP
;------------------------------------------------------------------------
;	Prints an underlined msg at position 0AH on bottom line 16 char long				
;------------------------------------------------------------------------
BOTTOM_MSG	PROC	NEAR
	MOV     DX,190A
        MOV     CX,0016
        MOV     BH,UNDLN
        CALL    LINE_TO_SCRN
        RET
BOTTOM_MSG	ENDP
;------------------------------------------------------------------------
;	Prints Helpscreen				
;------------------------------------------------------------------------
PRTHELP 	PROC	NEAR
	CALL    CLR_WINDOW
        MOV     DX,0100
	CALL	GOTO_XY

        MOV     DX,OFFSET HELPSCR
        MOV     AH,09
        INT     21

;DOSCALL PRINT$,HELPSCR	;CR,LF,TAB,'LIST - Version 5.2',TAB,TAB,TAB,'9/29/84'
        MOV     DX,1808
	CALL	GOTO_XY
        RET
PRTHELP	ENDP
;------------------------------------------------------------------------
;	This procedure moves the cursor
;		DH	Row (Y)
;		DL	Column (X)
;	Victor 9000 specific
;------------------------------------------------------------------------
GOTO_XY	PROC	NEAR
	PUSH	AX
	PUSH	BX
	MOV	BX,DX
	MOV	AH,2
	MOV	DL,ESC		;Enable 25th line
	INT	21
	MOV	DL,'x'
	INT	21
	MOV	DL,'1'
	INT	21
	MOV	DL,ESC		;Move cursor
	INT	21
	MOV	DL,'Y'
	INT	21
	MOV	DL,BH
	ADD	DL,20
	INT	21
	MOV	DL,BL
	ADD	DL,20
	INT	21
	MOV	DL,ESC		;Disable 25th line
	INT	21
	MOV	DL,'y'
	INT	21
	MOV	DL,'1'
	INT	21
	POP	BX
	POP	AX
	RET
GOTO_XY	ENDP
;------------------------------------------------------------------------
;      Ascertains if DOS 2.0 or greater(exits if not)				
;------------------------------------------------------------------------
DOSVER	PROC	NEAR
	MOV     AH,30
        INT     21

;DOSCALL VERSION?$   	;Return DOS Version number (i.e. AL=2, AH=00)

        CMP     AL,02
        JB      L0C16
        RET

L0C16:  MOV     DX,OFFSET ERR_MSG2	;CR,LF,'DOS 2.0 or later required',CR,LF,$
        JMP     ERR_EXIT
DOSVER	ENDP
;--------------------------------------------------------------------------
;	Adjusts memory size and exits on too little
;--------------------------------------------------------------------------	
ALLOMEM	PROC	NEAR
L0C1C:  MOV     BX,138H		;Protects to PARA BX
        NOP
        MOV     AH,4A
        INT     21

;DOSCALL SET$BLOCK   	;Modify allocated memory blocks (ES=seg, BX=size)

        MOV     BX,0FFF
L0C27:  MOV     AH,48
        INT     21

;DOSCALL ALLOC$MEM   	;Allocate memory (BX= # par)(AX)

        JB      L0C27
        MOV     MEMPTR,AX
        MOV     CX,0020
        MOV     AX,BX
        SUB     AX,CX
        CMP     AX,CX
        JB      L0C43
        MUL     WORD PTR CONSTSZ      
        MOV     MEMSIZ,AX
        RET

L0C43:  MOV     DX,OFFSET ERR_MSG1	;CR,LF,'Not enough memory',CR,LF,$
        JMP     ERR_EXIT
ALLOMEM	ENDP

;--------------------------------------------------------------------------
;      Reads filename into buffer at NAMBUF
;--------------------------------------------------------------------------
RDFLNAM	PROC	NEAR
	XOR     AX,AX
        XOR     CX,CX
        MOV     AL,BYTE PTR START-80H	;80H or FCB
        OR      CX,AX
        JZ      L0C63
        MOV     DI,OFFSET NAMBUF
        MOV     SI,0081
L0C5A:  LODSB
        CMP     AL,20
        JZ      L0C60
	CMP	AL,0DH
	JZ	L0C62
        STOSB
L0C60:  LOOP    L0C5A
L0C62:	CMP	BYTE PTR NAMBUF,0
	JZ	L0C63
        RET

;------------------------------------------------------------------------
;	Requests filename and enters into buffer			
;------------------------------------------------------------------------
L0C63:  MOV     DX,OFFSET ENT_FILENAME	;CR,LF,'Enter filename: $'
        MOV     AH,09
        INT     21

;DOSCALL PRINT$,D0250	;CR,LF,'Enter filename: $'

        MOV     AH,0A
        MOV     DX,OFFSET BUFSIZE	;40,00
        INT     21

;DOSCALL INSTR$      0202	; Input keyboard string (DX -> size,cnt,buffer)

        SUB     BX,BX
        OR      BL,BUFCNT	;00,00
        JZ      L0C63
        MOV     [BX]+NAMBUF,BH
        RET
RDFLNAM	ENDP

;------------------------------------------------------------------------
;	Find if file exists and exit with error msg				
;------------------------------------------------------------------------
FINDFIL	PROC	NEAR
L0C7E:  MOV     DX,OFFSET TRABUF
        MOV     AH,1A
        INT     21

;DOSCALL SET$DTA     0CF1	; Set Disk Transfer Address to DX

        MOV     DX,OFFSET NAMBUF
        SUB     CX,CX
        MOV     AH,4E
        INT     21

;DOSCALL FIND$DIR    	;Find first directory entry (DX->path, CX=ATTR)

        JB      L0CBB
        OR      AL,AL
        JNZ     L0CBB
        MOV     SI,OFFSET NAMBUF+4BH
        MOV     CX,004C
        STD
L0C9B:  LODSB		      ;Strips filename from path (:,/)
        CMP     AL,5C
        JZ      L0CA7
	CMP	AL,2F
	JZ	L0CA7
        CMP     AL,3A
        JZ      L0CA7
        LOOP    L0C9B
        DEC     SI
L0CA7:	MOV	WORD PTR FILE_NAME_PTR,SI  

FIND_NEXT_FILE:	
	MOV     DI,SI
        MOV     SI,OFFSET TRABUF+1EH
        ADD     DI,+02
        CLD
        MOV     CX,000DH
L0CB3:  LODSB			;Loads filename to NAMBUF
	STOSB
        CMP     AL,00
	LOOPNZ	L0CB3
L0CBB:	MOV	AL,20
        REPZ	STOSB
        MOV     DX,OFFSET NAMBUF
        MOV     AX,3D00
        INT     21

;DOSCALL OPEN$P,NAMBUF	;Open file (DX -> path)
	

        MOV     FILHAND,AX
        JB      L0CF0
	mov	bx,ax
	mov	ax,5700
	int	21
;DOSCALL DATE$TIME    ;get/set file date and time in cx:dx
	
	jb	l0c85
	mov	date1,dx
	mov	date2,cx
l0c85:	call	zero_file_ptr
	ret
;--------------------------------------------------------------------------

L0CF0:  MOV     RETCODE,AX	;00,00
        CMP     AL,02		; File not found
        JL      L0CE2
        CMP     AL,05		; Access denied
        JA      L0CE2
        SUB     BX,BX
        MOV     BL,AL
        MOV     CL,04
        SHL     BX,CL
        LEA     DX,[BX]+ERRMS-2
        JMP     ERR_EXIT

L0CE2:  AAM
        XCHG    AH,AL
        OR      RETCODE,AX	;00,00
        MOV     DX,OFFSET ERRMS	;'  Open failed, return code=$'
        JMP     ERR_EXIT
ZERO_FILE_PTR:	
	SUB	CX,CX
	SUB	DX,DX
MOVE_FILE_PTR:	
	MOV	AL,00
	MOV	AH,42
	MOV	BX,FILHAND
	INT	21H
;DOSCALL LSEEK$		;MOVE READ/WRITE PTR

	RET
FINDFIL	ENDP
;------------------------------------------------------------------------
;
;------------------------------------------------------------------------
newproc1 proc near
	push	cx
	push	dx
	push	di
	mov	dx,date1
	mov	ax,dx
	mov	cl,05
	shr	ax,cl
	and	ax,0f
	mov	bl,2dh
	mov	di,offset nambuf + 3ch
	call	l0d0e
	mov	ax,dx
	and	ax,1f
	call	l0d0e
	mov	ax,dx
	mov	cl,09
	shr	ax,cl
	add	ax,0050
	mov	bl,20
	call	l0d0e
	mov	dx,date2
	mov	ax,dx
	mov	cl,0bh
	shr	ax,cl
	mov	bl,3a
	call	l0d0e
	mov	ax,dx
	mov	cl,05
	shr	ax,cl
	and	ax,003f
	mov	bl,20
	call	l0d0e
	pop	di
	pop	dx
	pop	cx
	ret
newproc1	endp
;------------------------------------------------------------------------
l0d0e:	push	es
	push	ds
	pop	es
	aam
	or	ax,3030
	xchg	al,ah
	stosw
	mov	al,bl
	stosb
	pop	es
	ret
;------------------------------------------------------------------------
;
;----------------------------------------------------------------------------;
;	This procedure uses the AX,BH,CX,DX registers. This program          ;
;	duplicates the IBM DOS Interrupt #10 that controls the screen.       ;
;	The procedure is Victor 9000 specific.	                             ;                                               ;
;									     ;
;	AH	contains the mode number while the other registers           ;
;               are treated as stated by the IBM documentation               ;
;	BL	is loaded with the base address of the character set	     ;
;		(FONTPTR or 64H normally)				     ;
;                                                               	     ;	     ;
;----------------------------------------------------------------------------;
VIDEO_IO	PROC	NEAR
	STI
	CLD
	PUSH 	ES
	PUSH 	DS
	PUSH 	DX	
	PUSH	CX
	PUSH	BX
	PUSH	SI
	PUSH	DI
	PUSH	AX
	MOV	AL,AH
	XOR	AH,AH
	CMP	AX,6
	JE	SCROLL_UP
	CMP	AX,7
	JE	SCROLL_DN
	POP	AX
	JMP	VIDEO_RETURN
VIDEO_IO	ENDP
;
;
SCROLL_UP	PROC	NEAR
	MOV	ES,SCRNADDR
	POP	AX
	MOV	BL,FONTPTR
	PUSH	BX
	MOV	BL,AL
	MOV	AX,CX
	CALL	SCRN_POSITION
	JZ	N7
	ADD	SI,AX
	MOV	AH,DH
	SUB	AH,BL
N2:	CALL	MOV_ROW
	ADD	SI,BP
	ADD	DI,BP
	DEC	AH
	JNZ	N2
N3:	POP	AX
	ADD	AL,' '
N4:	CALL	CLR_ROW
	ADD	DI,BP
	DEC	BL
	JNZ	N4
	JMP	VIDEO_RETURN
N7:	MOV	BL,DH
	JMP	N3
SCROLL_UP	ENDP
;
;
SCROLL_DN	PROC	NEAR
	STD
	MOV	ES,SCRNADDR
	POP	AX
	MOV	BL,FONTPTR
	PUSH	BX
	MOV	BL,AL
	MOV	AX,DX
	CALL	SCRN_POSITION
	JZ	N16
	SUB	SI,AX
	MOV	AH,DH
	SUB	AH,BL
N13:	CALL	MOV_ROW
	SUB	SI,BP
	SUB	DI,BP
	DEC	AH
	JNZ	N13
N14:	POP	AX
	ADD	AL,' '
N15:	CALL	CLR_ROW
	SUB	DI,BP
	DEC	BL
	JNZ	N15
	JMP	VIDEO_RETURN
N16:	MOV	BL,DH
	JMP	N14
SCROLL_DN	ENDP
;
;
SCRN_POSITION	PROC	NEAR
	CALL	POSITION
	MOV	DI,AX
	MOV	SI,AX
	SUB	DX,CX
	INC	DH
	INC	DL
	XOR	CH,CH
	MOV	BP,COLNUM
	ADD	BP,BP
	MOV	AL,BL
	MUL	BYTE PTR COLNUM
	ADD	AX,AX
	PUSH	ES
	POP	DS
	CMP	BL,0
	RET
SCRN_POSITION	ENDP
;
;
POSITION	PROC	NEAR
	PUSH	BX
	MOV	BX,AX
	MOV	AL,AH
	MUL	BYTE PTR COLNUM
	XOR	BH,BH
	ADD	AX,BX
	SHL	AX,1
	POP	BX
	RET
POSITION	ENDP
;
;
MOV_ROW	PROC	NEAR
	MOV	CL,DL
	PUSH	SI
	PUSH	DI
	REP	MOVSW
	POP	DI
	POP	SI
	RET
MOV_ROW	ENDP
;
;
CLR_ROW	PROC	NEAR
	MOV	CL,DL
	PUSH	DI
	REP	STOSW
	POP	DI
	RET
CLR_ROW	ENDP
;
;
VIDEO_RETURN	PROC	NEAR
	POP	DI
	POP 	SI
	POP	BX
	POP	CX	
	POP	DX
	POP	DS
	POP	ES
	RET
VIDEO_RETURN	ENDP
;
INT_16	PROC	NEAR
	PUSH 	BX
	PUSH	DX
	SUB	BX,BX
M2:	MOV	AH,8
	INT	21H
	MOV	DL,AL
	MOV	AH,0BH
	INT	21H
	OR      AL,AL
	JZ	M1
	INC	BX
	JMP	M2
M1:	SUB	AH,AH
	MOV	AL,DL
	CMP	BX,0
	JZ	M3
	XCHG	AH,AL
M3:	POP	DX
	POP	BX
	RET
INT_16	ENDP		
;
STRSIZE		DB	20
STRCNT		DB	0
STRBUF		DB	20 DUP(0)
TRABUF		DB	20 DUP(?)
LINE_BUF	EQU	$
;END CODE
MAIN	ENDS
	END	START 


