\    ansi.drv
\    asm.4th
\    clib.doc
\    cmdline.lib
\    common.drv
\    comport.4th
\    convert.lib
\    cstype.lib
\    dda.lib
\    default.drv
\    dmath.lib
\    doscom.lib
\    dosgo.4th
\    dosint.4th
\    dosint.lib
\    dostsr.lib
\    dvapi.lib
\    emit.lib
\    ems.4th
\    fifo.lib
\    form#.lib
\    forthlib.4th
\    gemit.4th
\    hardware.lib
\    herc.4th
\    herc.lib
\    hiallot.4th
\    ibm.4th
\    ibm.drv
\    ibmmini.4th
\    ibmmini.drv
\    interrup.lib
\    keycodes.4th
\    keycodes.lib
\    lazyfile.4th
\    line-in.lib
\    mdda.lib
\    menu.4th
\    menu.lib
\    mfifo.4th
\    num-in.lib
\    number.lib
\    numbers.lib
\    optimize.4th
\    sfp.4th
\    sfp.lib
\    sfpcore.lib
\    sfpin.lib
\    sfplog.lib
\    sfpout.lib
\    sfptrig.lib
\    shell.lib
\    stack.lib
\    strings.4th
\    strings.lib
\    tasker.4th
\    time.lib
\    trailing.lib
\    trig.lib
\    type.lib
\    users.lib
\    vars.4th
\    windows.4th
\    windows.drv
\    word.lib
\    yn.lib
\    zipthis.bat

FORTH   DECIMAL

DEPTH 1 = #IF
}}  #IF CR .( MAIN program                              )  LIBSTATS #THEN #ELSE
CR .( )
CR .(  MAIN: STACK IS NOT BALANCED )
CR .( )
NOMAP END  #THEN


FIND FORTHLIB  #IF  DROP      CR CR
CR .( ͸)
CR .(     2nd inclusion      FORTHLIB.4TH        2nd inclusion ۳)
CR .( ͸͵) #ELSE
                       CREATE FORTHLIB
CR .( ͵)
CR .(                        FORTHLIB.4TH                          )
CR .( ͵) #THEN

\ ------------------------------------------------------------------------
{{
\                pick out functional blocks by keyword
\

FIND MENU                 #IF  DROP     INCLUDE      MENU.LIB  #THEN
FIND DOSINT               #IF  DROP     INCLUDE    DOSINT.LIB  #THEN
FIND SFP                  #IF  DROP     INCLUDE       SFP.LIB  #THEN
FIND STRINGS              #IF  DROP     INCLUDE   STRINGS.LIB  #THEN
FIND DVAPI                #IF  DROP     INCLUDE     DVAPI.LIB  #THEN
\
?DEFINE TICKS
?DEFINE STOPWATCH   OR    #IF           INCLUDE      TIME.LIB  #THEN


?DEFINE SIN
?DEFINE COS         OR
?DEFINE ISIN        OR
?DEFINE ICOS        OR    #IF           INCLUDE      TRIG.LIB  #THEN
\
UNDEF HGR                               INCLUDE      HERC.LIB  #THEN
UNDEF DDA                               INCLUDE       DDA.LIB  #THEN
UNDEF MDDA                              INCLUDE      MDDA.LIB  #THEN
UNDEF #IN                               INCLUDE    NUM-IN.LIB  #THEN
UNDEF NUMBER?                           INCLUDE    NUMBER.LIB  #THEN
UNDEF CONVERT                           INCLUDE   CONVERT.LIB  #THEN
UNDEF WORD                              INCLUDE      WORD.LIB  #THEN
UNDEF Y/N                               INCLUDE        YN.LIB  #THEN
UNDEF SHELL                             INCLUDE     SHELL.LIB  #THEN
\
?DEFINE READ#
?DEFINE READD#      OR
?DEFINE READ$       OR
?DEFINE #PARAMETERS OR
?DEFINE -LEADING    OR    #IF           INCLUDE   CMDLINE.LIB  #THEN
\
?DEFINE PUSH
?DEFINE POP         OR    #IF           INCLUDE     STACK.LIB  #THEN
                                        INCLUDE  HARDWARE.LIB

\ ------------------------------------------------------------------------
\
\                            character conversion
\
{{                                                                      DECIMAL
UNDEF ALPHANUMERIC
1 1 IN/OUT  NEED ALPHABETIC        1 1 IN/OUT  NEED NUMERIC
: ALPHANUMERIC  ( ASC -- F ) DUP NUMERIC  SWAP ALPHABETIC  OR  ;  #THEN

UNDEF NUMERIC               1 1 IN/OUT   NEED DIGIT   #THEN
FIND USER  #IF DROP
U: NUMERIC  ( ASC -- F )      DIGIT LOCALBASE @ U<  ;        #THEN
U: NUMERIC  ( ASC -- F )      DIGIT BASE @ U<  ;

UNDEF ALPHABETIC
 1 1 IN/OUT   NEED CAPITAL       1 1 IN/OUT   NEED SMALL-LETTER
: ALPHABETIC ( ASC -- F )    DUP SMALL-LETTER SWAP CAPITAL OR ;   #THEN

UNDEF CAPITALIZE                    1 1 IN/OUT   NEED SMALL-LETTER
: CAPITALIZE ( ASC -- ASC )      DUP SMALL-LETTER IF  95 AND  THEN  ; #THEN


U: CAPITAL  ( ASC -- F )          ASCII A  ASCII Z WITHIN  ;
U: SMALL-LETTER  ( ASC -- F )     ASCII a  ASCII z WITHIN  ;
U: PRINTABLE  ( ASC -- F )        BL 127 WITHIN   ;     #THEN
U: WITHIN   ( N LO HI -- F )      >R OVER U>  SWAP  R>  U> OR  NOT   ;
U: DIGIT    ( ASC -- N )          ASCII 0 -   DUP 9 U> IF  7 - THEN  ;



}}  #IF CR .( character conversion                      )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

{{
        U: #BITS   ( N -- N )
         0   BEGIN SWAP ?DUP   WHILE  DUP 1- AND SWAP 1+  REPEAT  ;

        U: CELLS    ( N -- N )   2*  ;
        U: CELL+    ( N -- N )   2+  ;

        U: .S  ( -- )        DEPTH  0  ?DO  I PICK U.  LOOP  ;

}}  #IF CR .(              #BITS CELLS CELL+ .S         )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

INCLUDE NUMBERS.LIB

\ ------------------------------------------------------------------------
                                                                       HEX
{{
FIND USER
#IF  DROP
    U: HEX     10 LOCALBASE ! ;
    U: DECIMAL 0A LOCALBASE ! ;
    U: BINARY  02 LOCALBASE ! ;
    U: OCTAL   08 LOCALBASE ! ;
#ELSE
    PRIMITIVE U: HEX     10 BASE ! ;
    PRIMITIVE U: DECIMAL 0A BASE ! ;
    PRIMITIVE U: BINARY  02 BASE ! ;
    PRIMITIVE U: OCTAL   08 BASE ! ;
#THEN

}} #IF  CR .( radix switch                              )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

\ ADDR is the start of a table with the format
\   0,1    16bit  number of table entries
\   2,3    16bit  entry id
\   4,5    16bit  entry response if matching id
\  [2-5] form one entry which is repeated [0-1] times


{{
U: LOOKUP   ( N ADDR -- N | 0 )
      SKIM 0 ?DO
        2DUP @ = IF  NIP 2+ @ 0  LEAVE THEN
         2+ 2+  LOOP
      IF DROP 0 THEN  ;

}} #IF  CR .( associative lookup                        )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

{{                                                                      DECIMAL

\ Ŀ
\  TRIPLE LENGTH + MIXED MODE 
\ 
\
\      UM/MOD   ( D N -- R Q )
\      UM*      ( N N -- D )

        U: UD*/    ( D N N -- D )
              UD*/MOD  ROT  DROP   ;
        U: UD*/MOD ( D N N -- REM D )
           >R T* R> UD/MOD  ;
        U: T*      ( D N -- T )
                ROT OVER  UM*  2SWAP  UM*  0  -ROT  D+   ;
        U: UD/MOD  ( T N -- R D )
              DUP >R   UM/MOD  R>  SWAP >R  UM/MOD R>   ;
        U: M+!     ( N ADDR -- )
              >R S>D R@  2@  D+  R>  2!  ;
        U: D+!     ( D ADDR -- )
              DUP >R     2@  D+  R>  2!  ;
        U: *PI      ( N -- N*PI )
             355 113 */  ;

}} #IF  CR .( triple length arithmetic                  )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

INCLUDE DMATH.LIB

\ ------------------------------------------------------------------------

{{
\ Ŀ
\  SINGLE MATH 
\ 
UNDEF U2/   CODE U2/   ( N -- N )
   SI POP   AX POP   AX 1 SHR   AX PUSH    SI JMPI   END-CODE  #THEN
UNDEF C>S   CODE C>S    ( 8 to 16 BIT SIGN EXTENSION )
   SI POP   AX POP  CBW  AX PUSH   SI  JMPI    END-CODE  #THEN


}} #IF  CR .( single length arithmetic                  )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

UNDEF <#           INCLUDE FORM#.LIB       #THEN
UNDEF -TRAILING    INCLUDE TRAILING.LIB    #THEN

\ ------------------------------------------------------------------------

{{
U: ERASE    0 FILL  ;
U: BLANK   BL FILL  ;

UNDEF FILL
   CODE FILL  BX POP AX POP CX POP DI POP LOOP IF,
  DX DS <SEG DX ES >SEG REPZ BYTE STOS THEN,
  BX JMPI END-CODE
#THEN


UNDEF LFILL ( SEG OFFS N BYTE -- )
   CODE LFILL
   BX POP
   AX POP
   CX POP
   DI POP
   ES POPSEG
   LOOP IF,
     REPZ BYTE
     STOS
   THEN,
   BX JMPI
   END-CODE
#THEN

UNDEF LFILLW ( SEG OFFS N WORD -- )
   CODE LFILLW
   BX POP
   AX POP
   CX POP
   DI POP
   ES POPSEG
   LOOP IF,
     REPZ
     STOS
   THEN,
   BX JMPI
   END-CODE
#THEN




}} #IF  CR .( block fill                                )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

?DEFINE EXPECT ?DEFINE QUERY OR  ?DEFINE IN$   OR
 #IF   INCLUDE LINE-IN.LIB   #THEN

\ ------------------------------------------------------------------------


CR .(  char in/out ͵)

{{

U: SPACES       DUP 0>  IF 0 DO SPACE LOOP EXIT THEN DROP  ;
U: SPACE        BL EMIT ;

\ FIND #OUT  #IF  DROP  #ELSE  VARIABLE #OUT  #THEN
\ U: TAB  ( N -- )        #OUT @ - SPACES  ;



                                                                     HEX

U: ?KEY        ?TERMINAL DUP  IF DROP KEY THEN      ;
U: ATKEY       KEY  ?DUP 0=   IF  KEY   080 OR   THEN  ;

FIND PAUSE  #IF  DROP
U: KEY         BEGIN ?TERMINAL UNTIL  00 08 BDOS   ;
U: ?TERMINAL   00 0B BDOS  0<> ;

#ELSE
U: KEY         00 08 BDOS ;
U: ?TERMINAL   00 0B BDOS  0<> ;
#THEN




}} #IF  CR .( console input                             )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

{{
HEX
1 1 IN/OUT NEED SHIFTKEY
U: ?RSHIFT     1 SHIFTKEY  ;
U: ?LSHIFT     2 SHIFTKEY  ;
U: ?SHIFT      3 SHIFTKEY  ;
U: ?CTRL       4 SHIFTKEY  ;
U: ?ALT        8 SHIFTKEY  ;
U: ?LCTRL    100 SHIFTKEY  ;
U: ?LALT     200 SHIFTKEY  ;

FIND PAUSE  #IF DROP
U: SHIFTKEY   PAUSE   0 0417  @L  AND  0<>   ;    #ELSE
U: SHIFTKEY           0 0417  @L  AND  0<>   ;    #THEN

}} #IF  CR .( keyboard input                            )  LIBSTATS #THEN

\ -------------------------------------------------------------------
         (  Character Output,  pick the good screen driver. )

                                                                        HEX
UNDEF TYPE  REQUIRE EMIT    #THEN


FIND WINDOWS     #IF  DROP     INCLUDE   WINDOWS.DRV  #THEN
FIND IBMMINI     #IF  DROP     INCLUDE   IBMMINI.DRV  #THEN
FIND IBM         #IF  DROP     INCLUDE       IBM.DRV  #THEN
                               INCLUDE   DEFAULT.DRV

\ ------------------------------------------------------------------------

{{                                                                      HEX


            FIND EMIT
               #IF  DROP


                  ?DEFINE CS:TYPE
                  #IF
CR .(  --- CS:TYPE IS ?DEFINED ---                   message    )
                     SEPDSEG?
                     #IF
CR .(  --- SEPDSEGS    ---                           message    )
                       : CS:TYPE  0 ?DO  CS: COUNT EMIT LOOP DROP ;
                     #ELSE
CR .(  --- NO SEPDSEGS ---                           message    )
                        CODE CS:TYPE END-CODE REQUIRE TYPE
                     #THEN
                  #THEN


                  UNDEF TYPE
CR .(  TYPE is EMIT based for non-standard out       message    )
                  : TYPE 0 ?DO COUNT EMIT LOOP DROP ;  #THEN

               #THEN




?DEFINE EMIT
?DEFINE TYPE
?DEFINE CS:TYPE
?DEFINE CONSOLE
?DEFINE PRINTER
?DEFINE MESSAGES
   OR OR OR OR OR
   #IF
      VARIABLE of DSEG 1 of !
   #THEN

\ of = Output File
\  0     Standard Input Device
\  1     Standard Output Device    ( CONSOLE )
\  2     Standard Error Device     ( MESSAGES )
\  3     Standard AUX Device
\  4     Standard Printer          ( PRINTER )


UNDEF CONSOLE
   CODE CONSOLE 1 # of [] MOV RET END-CODE
#THEN


UNDEF PRINTER
   CODE PRINTER 4 # of [] MOV RET END-CODE
#THEN


UNDEF MESSAGES
   CODE MESSAGES 2 # of [] MOV RET END-CODE
#THEN
}} #IF  CR .( video I/O                                 )  LIBSTATS #THEN

\ ------------------------------------------------------------------------



UNDEF EMIT                              INCLUDE    EMIT.LIB    #THEN
UNDEF CS:TYPE                           INCLUDE    CSTYPE.LIB  #THEN
UNDEF TYPE                              INCLUDE    TYPE.LIB    #THEN



\ DETERMINE THE PAGE-ZERO ADDRESS OF THE CURRENTLY ACTIVE DISPLAY ADAPTER
HEX
U: ADAPTER  ( -- ADDR )      B000   40 49 C@L 7 - IF DROP B800 THEN  ;
FIND EMIT  #IF DROP   INCLUDE COMMON.DRV            #THEN



CR .( ͵)

\ ------------------------------------------------------------------------
                                                                        HEX
{{

UNDEF BDOS     CODE BDOS     FIND PAUSE #IF DROP  CALL' PAUSE #THEN
    AL AH MOV BX DX MOV 21 INT AH AH XOR  RET
END-CODE #THEN



UNDEF BYE
   FIND bye  #IF  DROP   #ELSE
   CODE bye     HEX
       4C00 # AX MOV
        21 INT
    END-CODE    #THEN
   CODE BYE        ' bye JMP

END-CODE  #THEN

UNDEF RETURN   CODE RETURN     AX POP AX POP 4C # AH  MOV  21 INT
END-CODE  #THEN


}} #IF  CR .( DOS process control                       )  LIBSTATS #THEN

\ ---------------------------------------------------------------------

{{

                                                                        HEX
\ brings back location of dos busy flag. Execute once, then use the
\ address brought back by this function to determine with a C@L whether
\ DOS fns may be used right after the memory read.
UNDEF DOS-BUSY-FLAG
CODE  DOS-BUSY-FLAG    ( -- SEG ADDR )
     SI POP
     34 # AH MOV
     21 INT
     ES PUSHSEG
     BX PUSH
     SI JMPI
END-CODE
#THEN

UNDEF TSR     ( RETCODE -- )
MEMEND 1-  4 >>  0FFF AND  1+  CONSTANT paragraphs
CODE TSR
      AX POP
      AX POP                   ( RETURN CODE )
      paragraphs # DX MOV      ( SIZE IN PARAGRAPHS )
      31 # AH MOV
      21 INT
      END-CODE
#THEN


UNDEF SET-HANDLER
CODE SET-HANDLER  ( seg offset intnumber -- )
 SI POP AX POP DX POP BX POP 
 DS PUSHSEG BX DS >SEG
 25 # AH MOV  21 INT   ( set interrupt vector call )
 DS POPSEG SI JMPI  END-CODE
#THEN


UNDEF GET-HANDLER
CODE GET-HANDLER ( intnumber -- seg offset )
          35 # AH MOV  21 INT  ( get interrupt vector call )
 BX AX MOV  BX ES <SEG  
 RET  END-CODE
#THEN
}}  #IF CR .( tsr and interrupt support                 ) LIBSTATS  #THEN

\ ------------------------------------------------------------------------

{{
UNDEF MODE
CODE MODE
      SI POP
      AX POP
      AH AH XOR
      HEX 10  INT
      SI JMPI
   END-CODE
#THEN


}}  #IF CR .( bios                                      ) LIBSTATS  #THEN




{{
UNDEF CMOVE    CODE CMOVE
    BX POP  CX POP DI POP SI POP
    LOOP IF,
        AX DS     <SEG AX    ES >SEG    REPZ BYTE MOVS
    THEN,
   BX JMPI
END-CODE  #THEN

UNDEF CMOVE>
   CODE CMOVE>
        BX POP         \  return address
        AX POP         \  cnt
        DI POP         \  dest
        SI POP         \  src
        LOOP IF,
           AX CX MOV     AX DEC
           AX SI ADD
           AX DI ADD
           STD
           AX DS <SEG
           AX ES >SEG
           REPZ BYTE MOVS
           CLD
        THEN,
        BX JMPI
    END-CODE
  #THEN


UNDEF CMOVEL
CODE CMOVEL   ( SEG ADDR SEG ADDR N -- )
        BX POP
        CX POP
        DI POP
        ES POPSEG
        SI POP
        AX DS   <SEG
        DS POPSEG

        LOOP IF,
          REPZ BYTE MOVS
        THEN,
        AX DS >SEG
        BX JMPI
END-CODE
#THEN



UNDEF SCAN
\ ADDR COUNT ASCII -- ADDR CNT
\ returns addr,cnt of first occurance of ASCII
CODE SCAN    ( d c a -- n n )
   BX POP
   AX POP
   CX POP
   LOOP IF,
      DI POP
      DX DS <SEG
      DX ES >SEG
      REPNZ BYTE SCAS
      =0 IF,
         CX INC
         DI DEC
      THEN,
      DI PUSH
   THEN,
   CX PUSH
   BX JMPI
   END-CODE
#THEN


UNDEF SCANL
\ SEG ADDR COUNT ASCII -- SEG ADDR CNT
\ returns addr,cnt of first occurance of ASCII
CODE SCANL    ( s d c a -- s a c )
   BX POP
   AX POP
   CX POP
   LOOP IF,
     DI POP
     ES POPSEG
     REPNZ BYTE SCAS
     =0 IF,
        CX INC
        DI DEC
     THEN,
     ES PUSHSEG
     DI PUSH
   THEN,
   CX PUSH
   BX JMPI
   END-CODE
#THEN



UNDEF SKIP
CODE SKIP
   BX POP
   AX POP
   CX POP
   LOOP IF,
     DI POP
     DX DS <SEG
     DX ES >SEG
     REPZ BYTE SCAS
     =0 ~ IF,
        CX INC
        DI DEC
     THEN,
     DI PUSH
   THEN,
   CX PUSH
   BX JMPI
END-CODE
#THEN


UNDEF COMPARE
CODE COMPARE    ( addr addr c -- -1 | OFFS 0 )
         BX POP
         CX POP
         DI POP
         SI POP
         LOOP IF,
            CX DX MOV
            DS PUSHSEG
            ES POPSEG
            REPE BYTE CMPS
            =0 ~ IF,
              CX DX SUB
              CX CX XOR
              CX INC
              DX DEC
              DX PUSH
            THEN,
         THEN,
         CX DEC
         CX PUSH
         BX JMPI
END-CODE
#THEN

UNDEF COMPAREL
CODE COMPAREL   ( S O S O C -- -1 | OFFS 0 )
         AX DS <SEG
         BX POP
         CX POP
         DI POP
         ES POPSEG
         SI POP
         DS POPSEG
         LOOP IF,
            CX DX MOV
            REPE BYTE CMPS
            =0 ~ IF,
              CX DX SUB
              CX CX XOR
              CX INC
              DX DEC
              DX PUSH
            THEN,
         THEN,
         CX DEC
         CX PUSH
         AX DS >SEG
         BX JMPI
END-CODE
#THEN



}}  #IF CR .( block move, scan, skip, compare           )  LIBSTATS  #THEN

\ ------------------------------------------------------------------------

{{                                                                        HEX
U: ALLOT  DP +! ;
U: HERE  DP @ ;
U: PAD   DP @ 64 + ;


U: C,  DP @ C! 1 DP +! ;
U: ,   DP @ !  2 DP +! ;

\ LONG ADDRESS INTO  SEGM OFFS. OFFSET GUARANTEED 0...F
U: SEG:OFFS  ( D -- Seg Offs )               10 UM/MOD  SWAP  ;
U: LONGADDR  ( Seg Offs -- 20bitaddress )  0 ROT  10 UM*  D+  ;



}} #IF  CR .( memory allocation                         )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

{{

U: 2ROT  5 ROLL 5 ROLL ;
U: PLUCK 2 PICK  ;

U: SKIM  ( ADDR -- ADDR' N )     DUP 2+ SWAP @  ;

UNDEF ROLL
   CODE ROLL
       BX POP  DI POP  AX SS <SEG AX ES >SEG
       DI CX MOV CX INC  DI 1 SHL SP DI ADD DI SI MOV SI DEC SI DEC
       SS: [DI] PUSH STD CLI REPZ MOVS STI CLD
       SP INC SP INC BX JMPI
   END-CODE

#THEN

UNDEF 2SWAP
CODE  2SWAP
           SI POP
           AX POP   BX POP   CX POP   DX POP
           BX PUSH  AX PUSH  DX PUSH  CX PUSH
           SI JMPI
END-CODE   #THEN


UNDEF ROL     CODE ROL
      SI POP   AX POP   AX 1 ROL   AX PUSH   SI JMPI
END-CODE     #THEN


UNDEF ROR    CODE ROR
      SI POP   AX POP   AX 1 ROR   AX PUSH   SI JMPI
END-CODE     #THEN


UNDEF DEPTH
   CODE DEPTH  S0 [] AX MOV  SP AX SUB  AX 1 SAR   RET END-CODE
#THEN

U: 3DUP                         DUP  2OVER  ROT  ;

PRIMITIVE
U: 2OVER                           3 PICK 3 PICK ;

}} #IF  CR .( stack operations                          )  LIBSTATS #THEN

\ ------------------------------------------------------------------------

{{
                                                                          HEX
U: */MOD >R M* R> M/MOD ;
U: MU/MOD >R 0 R@ UM/MOD R> SWAP >R UM/MOD R> ;

}} #IF  CR .( mixed mode arithmetic                     ) LIBSTATS #THEN

\ ------------------------------------------------------------------------

{{                                                                        HEX
UNDEF (do)
   CODE (do)
      8000 # DX MOV
      AX DX SUB
      CX DX ADD
      BP DEC
      BP DEC
      DX [BP] MOV
      RET
#THEN

UNDEF (?do)
   CODE (?do)
      8000 # DX MOV
      AX DX SUB
      CX DX ADD
      BP DEC
      BP DEC
      DX [BP]  MOV
      AX CX CMP
      RET
#THEN

}} #IF  CR .( loops                                     ) LIBSTATS #THEN

\ ------------------------------------------------------------------------

}} #IF
       CR .(                                           Ĵ)
       CR .(                     included from library ) LIBSTATS #THEN
       CR .( Ĵ)
       CR .(                       object size total   ) HERE 256 - 5 U.R
                                                           .(  bytes       )
FIND HIHERE  #IF    DROP
       CR .( ĳ)
       CR .(  last code address upwards                )   HERE    5 U.R
                                                           .(              )
       CR .(  memory allocation downwards              ) HIHERE    5 U.R
                                                           .(              )
       CR .(  MEMEND                                   ) MEMEND 1- 5 U.R
                                                           .(              )
           #ELSE
       CR .(            scratch data space below stack )
                   MEMEND rssize dssize + -  HERE -  5 U.R .(  bytes       )
      #THEN
       CR .( )
 {{


