;                            PROGRAM  ESC
;
;   Program to send escape sequences to the Victor 9000 console. 
;
;       The sequence is passed to the console from the  
;     DOS command line.  No error checking is done by ESC.
;
;
;                             Written by
;
;                             J. E. Diem
;                           2020 Short St.
;                       New Orleans, LA 70118
;
;                     Tel. Home (504)866-7214
;                          Work (504)588-5265
;                          Work (504)865-5727
; 
;                            March 3, 1984
;
;
;                              USAGE
;
;      At  DOS  command prompt type  ESC parameter string (CR).
;                             Examples
;         1: ESC H (CR)  sends cursor to home position.
;         2: esc E (CR)  erases the entire screen.
;         3: esc m288    sets the Text Window in the Grafix Kernel
;                        to begin and end at line 24. 
STACK    SEGMENT PARA STACK 'STACK'
         DB      100 DUP(0)       ;100 bytes of stack space
STACK    ENDS
;
DATA     SEGMENT PARA PUBLIC 'DATA'
LNGTH    DB      0                ; length of the parameter string
                                  ; to ESC gets moved to here.
PARM     DB      128 DUP(0)       ; parameter string input to ESC
                                  ; gets moved to here.
DATA     ENDS
;
CODE     SEGMENT PARA PUBLIC 'CODE'
MAIN     PROC    FAR
;
         ASSUME  CS:CODE
         PUSH    DS               ;save address for return from
         MOV     AX,0             ;program to DOS.
         PUSH    AX
;
;       This block moves the parameter string passed to ESC
;           from DOS command line and its length from the
;             Program Segment Prefix (PSP) to DATA.
;
;  The string is moved from PSP:81H to OFFSET PARM in data segment;
;  its length is moved from PSP:80H to OFFSET LNGTH in data segment.
;  
;  Before the move DS must point to PSP as the source segment of 
;  the string to be moved; ES must point to DATA as the destination
;  segment.  Since DOS, on loading ESC, makes DS and ES point to
;  PSP, ES must be made to point to DATA before the move; DS is made
;  to point to DATA after the moves.
;
         MOV     AX,DATA          ;set up addressability for
         MOV     ES,AX            ;designation in DATA of 
         ASSUME  ES:DATA          ;the sequence and its length.
;
                                  ;DS still points to start of PSP.
                                  ;ES now points to DATA.
;
         MOV     SI,80H           ;move length of sequence
         MOV     DI,OFFSET LNGTH  ;from PSP:80H to
         CLD                      ;LNGTH in
         MOVSB                    ;data segment.
;
         MOV     CL,DATA:LNGTH    ;CX now holds what is in DS:80H
         MOV     CH,0H            ;i.e. length of parameter string
                                  ;passed to LINE.
; 
         MOV     SI,81H           ;move parameter string
         MOV     DI,OFFSET PARM   ;from PSP:81H to
         CLD                      ;PARM in
         REP     MOVSB            ;data segment.
;
;  The sequence is now at OFFSET PARM in DATA;
;  its length is at OFFSET LNGTH in DATA
;
         MOV     AX,DATA          ;make DS point 
         MOV     DS,AX            ;to data segment.
         ASSUME  DS:DATA
;
         MOV     AH,2H            ;move number of function which
                                  ;outputs character to console to AH.
         MOV     DL,1BH           ;output ESC
         INT     21H              ;to console driver.
;
;  prepare to output the string to the console
;
         MOV     BX,OFFSET PARM   ;make BX point to start of string.
;
         MOV     CL,LNGTH         ;put length of parameter
         MOV     CH,0H            ;string in CX.
         DEC     CX               ;decrements length of string by 1
                                  ;to account for leading space.
;
ST_LP:   MOV     DL,[BX+1]        ;This loop 
         INT     21H              ;outputs the
         INC     BX               ;string to
         LOOP    ST_LP            ;the console.
;
         RET                      ;return to DOS.
MAIN     ENDP
CODE     ENDS
         END
