TITLE		'132C.A86'
PAGE	44,109
; ***********************************************************************
; *                                                                     *
; *			132 COLUMN INTERFACE				*
; *									*
; *			VERSION 1.2 (MS-DOS)				*
; *									*
; *			LAST CHANGED  6-11-82, by Chris Williams	*
; *			AGAIN ON      8-05-82, by Barry MacDonald       *
; *				      8-22-82, by Terry Joakimides	*
; *									*
; *                                                                     *
; ***********************************************************************
; *                                                                     *
; *  Proprietary Rights Notice:   All rights  reserved.  This material  *
; *  contains  the   valuable   properties   and   trade  secrets   of  *
; *  Sirius Systems Technology, Inc.  (SIRIUS)                          *
; *  of  Scotts Valley,  California,  USA.                              *
; *  embodying   substantial   creative   efforts   and   confidential  *
; *  information, ideas,  and  expressions;  no part of  which  may be  *
; *  reproduced or transmited in any form or by any means--electronic,  *
; *  mechanical, or otherwise-- including  photo copying and recording  *
; *  or  in  connection  with  any  information  storage or  retrieval  *
; *  system  without permission  in writing  from SIRIUS.               *
; *                                                                     *
; *  Copyright notice:  Copyright (C) 1982                              *
; *                                                                     *
; *  An unpublished work by:                                            *
; *                                                                     *
; *                  Sirius System Technology, Inc.                     *
; *                  380 El Pueblo Road                                 *
; *                  Scotts Valley, California 95066                    *
; *                                                                     *
; ***********************************************************************/
		page

UDC_132C_ID	EQU	0132Ch		;Identifier for 132C
TAB_STOP	EQU	8
SCOLS		EQU	50			; 50 COLUMNS IN HIRES MODE
SROWS		EQU	25			; 25 CHAR LINES
DWORDS		EQU	SCOLS*SROWS*16		; 20000 WORDS ON SCREEN
DBYTES		EQU	2*DWORDS		; 40000 BYTES ON SCREEN
MAX_XDOTS	EQU	16*SCOLS		; 800 DOTS WIDE
MAX_YDOTS	EQU	16*SROWS		;  BY 400 HIGH
COL_BYTE	EQU	2*MAX_YDOTS		; # BYTE PER COLUMN
REV_ATTR	EQU	8000H			; REVERSE VIDEO ATTRIBUTE
LOW_ATTR	EQU	4000H			; LOW INTENSITY ATTRIBUTE
UND_ATTR	EQU	2000H			; UNDERLINE ATTRIBUTE
NON_ATTR	EQU	1000H			; NON-DISPLAY ATTRIBUTE
RES_ATTR	EQU	0800H			; RESERVED ATTRIBUTE
DOT_OFF		EQU	0
SCN_SEG		EQU	0F000H			; SCREEN SEGMENT
SCN_OFF		EQU	0
FIFOS		EQU	16			; 16 CHAR FIFO
msend		equ	20h			;msdos function -- end of job
msdos		equ	21h			;msdos function request int
msres		equ	27h			;msdos remain resident int
xbios		equ	223			;SIRIUS super bios func int

prog	segment
assume	cs:prog,ds:prog,es:prog

	ORG	0
BEGIN	equ	$

PDUMMY	dw	1				; DUMMY PTR FOR PASS_VEC

	ORG	8000H				;use es: to get to crtc
CRTC	DW	1

		PAGE
		ORG	0100h

DOT_BUFF	DB	0		;DOT_BUFF gets used by the
		DB DBYTES DUP(?)
END_BUF		DB	0		;   Initialization code & data
AFTER_BUF	EQU	$

		PAGE
;
;********* Initialization Code and Data, in DOT_BUF.
;		Is cleared at the end of install
;
		ORG	0100h

		jmp short install	;Jump to start

; **** ERROR EXITS are first (to allow short jumps)

already_in:				;Error. Already installed.
	mov	dx,offset already_in_msg
	jmp	abort_exit

ABORT:
	mov	dx,offset init_err_msg		; error
abort_exit:				;dx already points to message
	mov	ah,9
	int	msdos				;Display 1st part of message

	mov	dx,offset err_msg		;Standard part of err msg
	mov	ah,9
	int	msdos				;Display 2nd part of message

	int	msend	;*** Exit non resident *** RETURN  to MS-DOS ***

abort_bad_mem:				;Error. Dots not in low 64KB
	mov	dx,offset bad_load_msg
	jmp short abort_exit

;*********** START OF INSTALL *********************************************

INSTALL:

	mov	ax,ds			;ready to request vector
	mov	es,ax			;set the ES: same as data/code
	mov	bx,offset XBIOS_param	;point to XBIOS parameter block
	mov	ax,14			;request get base UDCvector
	int	xbios			; call super bios
	or	ax,ax			;error from super BIOS?
	jnz	abort			; yes. abort.

	les	bx,dword ptr XBIOS_param+2  ;Make XBIOS(14) return consistent
					; with UDC function 4 return.

UDC_walk_loop:			;Walk through the UDCs and BIOS consoles

		;	Need to remember the last three consoles
	mov	ax,UDC_last		;UDC_penultim := UDC_last
	mov	UDC_penultim,ax
	mov	ax,UDC_last+2
	mov	UDC_penultim+2,ax
	mov	ax,UDC_stub		;UDC_last := UDC_stub
	mov	UDC_last,ax
	mov	ax,UDC_stub+2
	mov	UDC_last+2,ax
	mov	UDC_stub,bx		;UDC_stub := current UDCvector
	mov	UDC_stub+2,es

	mov 	ax,6			;request current UDC identifier
	call dword ptr UDC_stub		; get the id
	cmp	ax,UDC_132C_ID		;Is it myself?
	je	already_in		;Yes. Abort.
;					 No. Continue the walk.

	mov	ax,4			;request the next UDCvector
	call dword ptr UDC_stub		;get the new vector addr
					;   returned in es:bx
;****   bios bug?????????     *************
;			returns al=0 if no error????????
;	or	al,al			;If al = 0 then error
;	jz	abort

	mov	ax,es			;If es:bx <> 0 then
	or	ax,bx			;	still more UDCs installed
	jnz	UDC_walk_loop		;   Continue with the walk through
;
;    Have gone through all of the UDCs. Almost ready to install.
;	First check if DOTS are in the right place (in 1st 64KB)

	mov	ax,ds
	add	ax,(END_BUF-BEGIN)/16
	and	ax,0f000h
	jnz	abort_bad_mem

;    Last check done. Now ready to install, but first need to initialize
;	some memory and OS dependent variables.

	MOV	DL,1BH				; CLEAR SCREEN (ESC E)
	MOV	ah,2
	INT	msdos

	MOV	DL,'E'
	MOV	ah,2
	INT	msdos

	MOV	AX,SCN_SEG			; LOOK AT CHAR ON SCREEN
	MOV	ES,AX
	MOV	SI,SCN_OFF
	MOV	AX,ES:[SI]			; GET SCREEN CHAR
	AND	AX,3FFH				; KEEP FONT CELL POINTER
	SUB	AX,20H				; FIRST ASCII CHAR SPACE-20H
	SHL	AX,1				; SEG FOR NORMAL CHARSET
	MOV	NORMAL_SEG,AX			; SAVE NORMAL CHAR SEGMENT
	MOV	NORMAL_OFF,0			; SAVE NORMAL CHAR OFFSET
	MOV	BX,OFFSET NON_ACTIVE		; START NOT ACTIVE
	MOV	PUT_VEC,BX

	MOV	AX,OFFSET CHRSET		; SAVE SMALL CHAR OFFSET
	MOV	SMALL_OFF,AX
	MOV	SMALL_SEG,ds			; SAVE SMALL CHAR SEGMENT
	MOV	CHAR_OFF,AX			; DEFAULT SMALL CHARS
	MOV	CHAR_SEG,ds	
;
;    FINALLY! Ready to install!
;
				; Fix the pass through vector
	les	ax,dword ptr UDC_last	;132C is installed after
	mov	PASS_VEC,ax		;    UDC_penultim / or / at base
	mov	PASS_VEC+2,es		;  and before  UDC_last

	mov	ax,cs			; es:bx := entry into 132C
	mov	es,ax			;	e.g. es := cs
	mov	bx,offset long_conout	;	     bx := [long_conout]

	mov	ax,UDC_penultim		;If UDC_penultim = 0 THEN
	or	ax,UDC_penultim+2	;   only BIOS and stub are in.
	jnz	install_after_UDC	; e.g. Install after another UDC
;					;ELSE
;					;     Install at base (via XBIOS(15))
;
	mov	XBIOS_param+2,bx	;Fix parameter block
	mov	XBIOS_param+4,es	;  with our entry point
	mov	bx,ds			;For Super Bios es:bx point to
	mov	es,bx			;	the 
	mov	bx,offset XBIOS_param	;	   parameter block	
	mov	ax,15			;request set vector
	int	xbios			;call Super Bios to set vector addr
	or	ax,ax			;error from Super Bios??
	jz	end_install		;No.
	jmp	abort			;Yes. Abort

install_after_UDC:
;
	mov	ax,5			;UDC set vector function
	call dword ptr UDC_penultim	;set the new vector
;
;****  DONE! And installed!

end_install:

	mov	dx,offset good_load_msg		;show user we are here
	mov	ah,9				;o/p upto $
	int	msdos				;call O/S

;    Only thing left to do is to clear the DOT_BUFF and exit

	mov	ax,ds				; Set ES for repeated
	mov	es,ax				;	STORE
	MOV	DI,OFFSET DOT_BUFF		; ERASE HIRES FIELD
	MOV	CX,DWORDS
	XOR	AX,AX
	jmp	finish_install			;JMP to resident part.
;
;********* END OF OVERLAYABLE CODE *****************************************
;
		PAGE
;
;********* OVERLAYABLE DATA ************************************************
;
good_load_msg	db	0dh,0ah,'132C ms1.2 installed.',0dh,0ah,'$'
err_msg		db	' -- 132C ms1.2 terminating.',0dh,0ah,'$'
init_err_msg	db	0dh,0ah,'System error$'
bad_load_msg	db	0dh,0ah,'Improper memory location$'
already_in_msg	db	0dh,0ah,'Already installed$'

;	UDC_penultim (penultimate), UDC_last & UDC_stub are used by INSTALL
;	to trace through all of the UDC routines installed.
;	Search starts at the base vector and continues until the stub is
;	is reached (thus the very latest vector set, points to the stub.
;	If UDC_penultim = 0 (e.g. there is no penultimate UDC -- only
;	the BIOS and the stub) 132C installs itself at the base.
;	If UDC_penultim is non_zero (e.g. there is a penultimate UDC),
;	132C installs itself between that and UDC_last (which hopefully
;	is the BIOS *** this is NOT a good scheme *** just guesswork).
UDC_penultim	dw	0,0		;double word for UDC vector
UDC_last	dw	0,0		;	"	"	"
UDC_stub	dw	0,0		;	"	"	"

XBIOS_param	DW	1,0,0		; 1=Console, <empty>, <empty>
;
;********* END OF OVERLAYABLE DATA *****************************************
;

		PAGE
;
;********* START OF RESIDENT DATA  ******************************************

		ORG  OFFSET AFTER_BUF	;Rest of the junk must stay in memory

XPOS		DW	0	; X OF TOP LEFT OF CHAR CELL
YPOS		DW	0	; Y OF TOP LEFT OF CHAR CELL
SAVE_XPOS	DW	0	; SAVE CURSOR COLUMN
SAVE_YPOS	DW	0	; SAVE CURSOR LINE
FIFO_INDEX	DW	0	; # CHARS IN FIFO
FIFO_BUFF	DB	FIFOS DUP(?)	; FIFO BUFFER
CELL_WIDTH	DW	0	; WIDTH OF CHAR CELL IN DOTS
CELL_HEIGHT	DW	0	; HEIGHT OF CHAR CELL IN RASTER LINES
CELL_MASK	DW	0	; MASK FOR CHAR CELL
COLM_MAX	DW	0	; MAX # OF CHAR COLUMNS
LINE_MAX	DW	0	; MAX # OF CHAR LINES
TOP_LINE	DW	0	; TOP LINE OF THE SCREEN
BOT_LINE	DW	0	; BOTTOM LINE OF THE SCREEN
NORMAL_OFF	DW	1	; NORMAL CHAR OFFSET
NORMAL_SEG	DW	1	; NORMAL CHAR SEGMENT
SMALL_OFF	DW	1	; SMALL CHAR OFFSET
SMALL_SEG	DW	1	; SMALL CHAR SEGMENT
CHAR_OFF	DW	1	; ACTIVE CHARSET OFFSET
CHAR_SEG	DW	1	; ACTIVE CHARSET SEGMNET
PUT_VEC		DW	1	; DISPATCH FOR PUT_CON
INSERT_FLAG	DB	0	; IF INSERT MODE ON THEN FLAG = 1
DISCARD_FLAG	DB	0	; IF DISCARD THEN FLAG=1
ATTRIBUTE_FLAG	DB	40H	; ALL FIVE ATTRIBUTES, DEFAULT LOW INT.
CURSOR_FLAG	DB	0	; IF OFF THEN FLAG=FLAG OR 1
				; IF UNDERSCORE THEN FLAG=FLAG OR 2
CRLF_FLAG	DB	0	; IF AUTO LF ON CR THEN FLAG=FLAG OR 1
				; IF AUTO CR ON LF THEN FLAG=FLAG OR 2
LITERAL_FLAG	DB	0	; IF LITERAL THEN FLAG = 1
GRAPHIC_FLAG	DB	0	; IF GRAPHIC THEN FLAG = 1
BOT_FLAG	DB	0	; IF BOT ENABLED THEN FLAG = 1
BUF_COUNT	DB	0	; COUNT OF CBUFF CHARS SENT TO VT52
CBUFF		DB	8  DUP (?)	; 8 CHAR BUFFER FOR ESC SEQUENCES
CELL_BUFF	DW	16 DUP (?)	; SCREEN CELL BUFFER
BIOS18		DB	18	; FOR DIRECT BIOS CALL

TEXT_TAB	DW	05C00H,05001H,05102H,0CF03H
		DW	01904H,00605H,01906H,01907H
		DW	00308H,00E09H,0000AH,00F0BH
		DW	0000CH,0000DH,0000EH,0810FH

HIRES_TAB	DW	03A00H,03201H,03402H,0C903H
		DW	01904H,00605H,01906H,01907H
		DW	00308H,00E09H,0200AH,00F0BH
		DW	0200CH,0000DH,0000EH,0000FH


ESC_SIZE	DB	0		; 20H ' '
		DB	0		; 21H '!'
		DB	0		; 22H '"'
		DB	2		; 23H '#'  TRANSMIT PAGE
		DB	2		; 24H '$'  TRANSMIT CURSOR CHAR
		DB	0		; 25H '%'
		DB	0		; 26H '&'
		DB	0		; 27H '''
		DB	2		; 28H '('  HIGH INTENSITY ON
		DB	2		; 29H ')'  HIGH INTENSITY OFF
		DB	0		; 2AH '*'
		DB	0		; 2BH '+'
		DB	0		; 2CH ','
		DB	0		; 2DH '-'
		DB	0		; 2EH '.'
		DB	0		; 2FH '/'
		DB	2		; 30H '0'  ENTER UNDERLINE MODE
		DB	2		; 31H '1'  EXIT  UNDERLINE MODE
		DB	0		; 32H '2'
		DB	0		; 33H '3'
		DB	0		; 34H '4'
		DB	0		; 35H '5'
		DB	0		; 36H '6'
		DB	0		; 37H '7'
		DB	2		; 38H '8'  LITERAL CHARACTER
		DB	0		; 39H '9'
		DB	0		; 3AH ':'
		DB	0		; 3BH ';'
		DB	0		; 3CH '<'
		DB	0		; 3DH '='
		DB	0		; 3EH '>'
		DB	0		; 3FH '?'
		DB	2		; 40H '@'  ENTER INSERT CHAR MODE
		DB	2		; 41H 'A'  CURSOR UP


		DB	2		; 42H 'B'  CURSOR DOWN
		DB	2		; 43H 'C'  CURSOR FORWARD
		DB	2		; 44H 'D'  CURSOR BACKWARD
		DB	2		; 45H 'E'  CLEAR DISPLAY
		DB	2		; 46H 'F'  ENTER GRAPHICS MODE
		DB	2		; 47H 'G'  EXIT GRAPHICS MODE
		DB	2		; 48H 'H'  CURSOR HOME
		DB	2		; 49H 'I'  REVERSE INDEX
		DB	2		; 4AH 'J'  ERASE TO END OF PAGE
		DB	2		; 4BH 'K'  ERASE TO END OF LINE
		DB	2		; 4CH 'L'  INSERT LINE
		DB	2		; 4DH 'M'  DELETE LINE
		DB	2		; 4EH 'N'  DELETE CHARACTER
		DB	2		; 4FH 'O'  EXIT INSERT CHAR MODE
		DB	0		; 50H 'P'
		DB	0		; 51H 'Q'
		DB	0		; 52H 'R'
		DB	0		; 53H 'S'
		DB	0		; 54H 'T'
		DB	0		; 55H 'U'
		DB	0		; 56H 'V'
		DB	0		; 57H 'W'
		DB	2		; 58H 'X'  Exchange frgnd/bkgnd (?)
		DB	4		; 59H 'Y'  DIRECT CURSOR ADDRESSING
		DB	2		; 5AH 'Z'  IDENTIFY AS VT52 (ESC/K)
		DB	0		; 5BH '['
		DB	0		; 5CH '\'
		DB	2		; 5DH ']'  TRANSMIT BOTTOM LINE
		DB	2		; 5EH '^'
		DB	0		; 5FH '_'
		DB	0		; 60H '`'
		DB	0		; 61H 'a'
		DB	2		; 62H 'b'  ERASE TO BEGINNING OF PAGE
		DB	0		; 63H 'c'
		DB	0		; 64H 'd'
		DB	0		; 65H 'e'
		DB	0		; 66H 'f'
		DB	0		; 67H 'g'
		DB	2		; 68H 'h'  REVERSE TAB
		DB	0		; 69H 'i'
		DB	2		; 6AH 'j'  SAVE CURSOR POSITION
		DB	2		; 6BH 'k'  SET CURSOR TO SAVED POS
		DB	2		; 6CH 'l'  ERASE ENTIRE LINE
		DB	5		; 6DH 'm'  SET SIZE
		DB	2		; 6EH 'n'  CURSOR POSITION REPORT
		DB	2		; 6FH 'o'  ERASE BEGINNING OF LINE
		DB	2		; 70H 'p'  ENTER REVERSE VIDEO MODE
		DB	2		; 71H 'q'  EXIT REVERSE VIDEO MODE
		DB	0		; 72H 'r'
		DB	0		; 73H 's'
		DB	0		; 74H 't'
		DB	0		; 75H 'u'
		DB	2		; 76H 'v'  WRAP AROUND AT END OF LINE
		DB	2		; 77H 'w'  DISCARD AT END OF LINE
		DB	3		; 78H 'x'  SET MODE(S)
		DB	3		; 79H 'y'  RESET MODE(S)
		DB	2		; 7AH 'z'  RESET TO 80 COLUMN MODE
		DB	2		; 7BH '{'  KEYBOARD ENABLED
		DB	2		; 7CH '|'  ENABLE 132 COLUMN MODE
		DB	2		; 7DH '}'  KEYBOARD DISABLE
		DB	0		; 7EH '~'
		DB	0		; 7FH DEL


PASS_VEC	DD	PDUMMY		; LONG PTR TO next UDC

save_es		dw	0		;store for entry para
save_bx		dw	0		;store for entry para
SAVE_DS		DW	0


CTRL_TAB	DW	PASS_1,PASS_1,PASS_1,PASS_1,PASS_1,PASS_1,PASS_1,PASS_1
		DW	CTBS,CTHT,CTLF,PASS_1,PASS_1,CTCR,CTSO,CTSI
		DW	PASS_1,PASS_1,PASS_1,PASS_1,PASS_1,PASS_1,PASS_1,PASS_1
		DW	PASS_1,PASS_1,PASS_1,CTESC,PASS_1,PASS_1,PASS_1,PASS_1

.XLIST
	INCLUDE B:CSET.ASM
.LIST
		PAGE
;
;******** START OF RESIDENT CODE ********************************************
;
finish_install:				;Resident portion of install

	REP	STOSw				;Clear DOT_BUFF

	MOV	Dx,offset end_end+1		; RESET TO CCP
	INT	msres				;stop remain resident

;****	RETURN  to MS-DOS


;**************************************************
;	MAIN ENTRY FROM BIOS
;	AX =	0 - GET CON
;		1 - PUT CON	
;		2 - GET STATUS
;		3 - PUT STATUS
;		4 - READ VECTOR
;		5 - SET VECTOR
;		6 - GET UDC ID
;**************************************************
QUICK_EXIT:				;Cannot handle request, leave quickly
	jmp  dword ptr CS:PASS_VEC	;  and pass it to the next UDC

LONG_CONOUT:
	CMP	AL,7		; ACCEPT 0 - 6 ONLY
	JNB	QUICK_EXIT

	MOV	CS:SAVE_DS,DS
	mov	CS:save_es,es	;save the POSSIBLE entry parameter
	mov	CS:save_bx,bx	; ditto
;
	MOV	BX,CS
	MOV	DS,BX		; BOTH DS AND ES AT THIS SEGMENT
	MOV	ES,BX
	MOV	BX,AX
	SHL	BX,1		; WORD TABLE
	CALL	LONG_TABLE[BX]

	MOV	DS,SAVE_DS

dummy	proc	far			;do a far return
	RET
dummy	endp

LONG_TABLE	DW	GET_CON,PUT_CON,GET_STATUS,PUT_STATUS	; 0-3
		DW	READ_VEC,SET_VEC,GET_UDC_ID		; 4-6

;**************************************************
OLD_VEC:
	PUSH	ES
	PUSH	DS
	MOV	DS,SAVE_DS		; RESTORE DATA SEG FOR OLD VEC
	PUSH	BX
	CALL dword ptr CS:PASS_VEC
	POP	BX
	mov	CS:save_ds,ds		; SAVE_DS again, in case we recursed
	POP	DS
	POP	ES
	OR	AL,AL			; RETURN STATUS
	RET

;**************************************************
;	GET CHARS FROM CONOUT
;	ENTRY:	AX = 0
;	EXIT:	AL = RETURN DATE BYTE
;**************************************************
GET_CON:
	MOV	CX,FIFO_INDEX
	OR	CX,CX			; FIFO EMPTY ?
	JE	NO_CHARS		; YES
	MOV	AL,FIFO_BUFF		; RETURN TOP CHAR IN BUFFER
	XOR	BX,BX			; SCROLL PTR START AT BEGINNING
GETC100:
	MOV	AH,FIFO_BUFF+1[BX]	; POP TOP CHAR OUT OF FIFO
	MOV	FIFO_BUFF[BX],AH
	INC	BX
	CMP	BX,CX
	JL	GETC100
	DEC	FIFO_INDEX
	RET
NO_CHARS:
	XOR	AX,AX			; AX = 0 FOR UDC GET
	CALL	OLD_VEC
	RET

;**************************************************
;	FIFO IN
;**************************************************
FIFO_IN:
	MOV	BX,FIFO_INDEX		; INDEX INTO FIFO
	MOV	FIFO_BUFF[BX],AL	; SAVE CHAR
	INC	BX
	CMP	BX,FIFOS		; STOP AT END
	JL	FIN100
	MOV	BX,FIFOS-1
FIN100:
	MOV	FIFO_INDEX,BX
	RET

;**************************************************
;	PUT CONOUT TO 132 COLUMNS
;	ENTRY:	AX = 1
;		CL = CONSOLE OUTPUT DATA FROM CALLER
;	EXIT:	AL = 00 MULTICODE SEQUENCE NOT PENDING
;		AL = FF MULTICODE SEQUENCE PENDING
;**************************************************
PUT_CON:
	JMP	PUT_VEC		; JMP INDIRECT
				; DISPATCH TO:
				; 	NON_ACTIVE,NON_ACT_SEQ,SEQ_ACTIVE
				; 	PUT_ACTIVE,BUFFER_ESC

;**************************************************
;	GET STATUS
;	ENTRY:	AX = 2
;	EXIT:	AL = 00 INDICATES NO DATA READY
;		AL = FF INDICATES DATA READY
;**************************************************
GET_STATUS:
	MOV	AX,FIFO_INDEX
	OR	AX,AX
	JE	GETST100	; NO - CHARS
	MOV	AL,0FFH		; GOT A CHAR WAITING
	RET
GETST100:
	MOV	AX,2		; UDC INSTAT
	CALL	OLD_VEC
	RET

;**************************************************
;	PUT STATUS
;	ENTRY:	AX = 3
;	EXIT:	AL = FF - ALWAYS READY TO PUT
;**************************************************
PUT_STATUS:
	MOV	AL,0FFH		; AL = FF - CHAR READY
	RET

;**************************************************
;	READ UDC VECTOR
;	ENTRY:	AX = 4
;	EXIT:	AL = FF  VECTOR SET PROPERLY
;		ES:BX = LONG ADDRESS OF PASS ON MODULE
;**************************************************
READ_VEC:
	mov	bx,offset pass_vec	;point to vector
	mov	ax,2[bx]		;get vector seg
	mov	ES,ax			;into seg reg
	mov	bx,0[bx]		; get the vector offset
;
	MOV	AL,0FFH
	RET

;**************************************************
;	SET UDC VECTOR
;	ENTRY:	AX = 5
;		save_es and save_bx make up
;		ES:BX = LONG ADDRESS OF NEW MODULE
;	EXIT:	AL = 00  VECTOR NOT SET
;		AL = FF  VECTOR SET PROPERLY
;**************************************************
SET_VEC:
	mov	ES,save_es		;restore the entry
	mov	bx,save_bx		; parameters
;
	MOV	WORD PTR PASS_VEC,BX	;save vector offset
	MOV	WORD PTR PASS_VEC+2,ES	;save vector segment
	MOV	AL,0FFH
	RET

;**************************************************
;	GET UDC ID
;	ENTRY:	AX = 6
;	EXIT:	AX = UDC_132C_ID             
;**************************************************
GET_UDC_ID:
	MOV	AX,UDC_132C_ID		; AX = My id
	RET

;**************************************************
;		PUT CHARACTER ROUTINES
;**************************************************
NON_ACTIVE:
	CMP	CL,'|'			; NO - TURN ON 132 COLUMN MODE ?
	JNE	PASS_IT			; NO
	CMP	CBUFF,1BH		; MAYBE - WAS LAST CHAR AN ESC ?
	JNE	PASS_IT			; NO - DON'T ENABLE
	CALL	ENABLE_132		; TURN ON 132 MODE
	call	clear			;clear the hi-res screen
	CALL	TOGGLE_CURSOR		; SHOW A CURSOR
	XOR	AL,AL			; NO SEQ PENDING
	RET

PASS_IT:
	MOV	CBUFF,CL			; SAVE TO TEST NEXT TIME
	MOV	AX,1				; UDC PUT
	CALL	OLD_VEC
	JZ	PASX100				; SEQUENCE NOW PENDING
	MOV	PUT_VEC,OFFSET NON_ACT_SEQ	; ASSUME ORIGINAL WANTS SEQ.
PASX100:
	RET

;**************************************************
NON_ACT_SEQ:
	MOV	AX,1				; UDC PUT
	CALL	OLD_VEC
	JNZ	NONA100				; SEQUENCE NOW PENDING
	MOV	PUT_VEC,OFFSET NON_ACTIVE
NONA100:
	RET

;**************************************************
PASS_BUFFER:
	CALL	SEND_BUFFER
	OR	AL,AL				; A SEQUENCE PENDING ?
	JNZ	PASB400				; YES - SEQ ACTIVE
	RET
PASB400:
	MOV	PUT_VEC,OFFSET SEQ_ACTIVE	; ASSUME SEQUENCE
	RET

;**************************************************
SEND_BUFFER:
	XOR	BX,BX
SENB100:
	MOV	CL,CBUFF[BX]		; PASS ALL CHARS IN BUFFER
	MOV	AX,1			; UDC PUT
	CALL	OLD_VEC
	INC	BL
	CMP	BL,BUF_COUNT
	JB	SENB100
	RET

;**************************************************
SEQ_ACTIVE:
	MOV	AX,1				; UDC PUT
	CALL	OLD_VEC
	JNZ	SEQA100
	MOV	PUT_VEC,OFFSET PUT_ACTIVE
SEQA100:
	RET

;**************************************************
PUT_ACTIVE:
	TEST	LITERAL_FLAG,1	; PRINT LITERALLY ?
	JNE	PUTC170		; YES
	XOR	CH,CH		; CH=0
	CMP	CL,20H		; YES - A CTRL CHAR ?
	JB	CTRL100		; YES
	CMP	CL,7FH		; NO - A DEL ?
	JE	PUTC350		; YES - NO DISPLAY
PUTC170:
	CALL	TOGGLE_CURSOR	; TURN CURSOR OFF
	TEST	INSERT_FLAG,1	; IN INSERT MODE ?
	JE	PUTC200		; NO
	CALL	INSERT_CHAR	; MOVE ALL CHARS RIGHT FROM CURSOR
PUTC200:
	TEST	GRAPHIC_FLAG,1	; IN GRAPHIC MODE ?
	JE	PUTC207		; NO
	CMP	CL,'^'		; IN GRAPHIC CHARS ?
	JB	PUTC207		; NO
	CMP	CL,'~'		; CHECK HIGHEST GRAPHIC
	JNE	PUTC205		; IF GRAPHIC THEN ADJUST
	INC	CL		; ELSE PARA. THEN DISPLAY 7FH
	JMP SHORT PUTC207
PUTC205:
	SUB	CL,'^'
PUTC207:
	CALL	CLEAR_CELL
	CALL	CHAR_OR_CELL	; COPY CHAR IN CL TO CELL_BUFF
	TEST	ATTRIBUTE_FLAG,LOW_ATTR/256	; HIGH INTENSITY
	JNE	PUTC210		; NO
	CALL	LSHIFT_CELL	; SHIFT CELL LEFT
	CALL	CHAR_OR_CELL	; SHADOW PRINT CHAR
PUTC210:
	CALL	ADD_UNDERLINE	; ADD UNDERLINE IF ON
	CALL	ADD_REVERSE	; ADD REVERSE IF ON
	CALL	PUT_CELL	; PUT THE CELL ON THE SCREEN
	MOV	LITERAL_FLAG,0	; DID A LITERAL CLEAR FLAG
	INC	XPOS		; MOVE FORWARD ONE CHAR COLUMN
	MOV	AX,XPOS
	CMP	AX,COLM_MAX	; AT RIGHT SIDE OF SCREEN ?
	JL	PUTC300		; NO
	MOV	AL,DISCARD_FLAG
	OR	AL,AL		; YES - IS DISCARD MODE ON ?
	JE	PUTC240		; NO
	MOV	AX,COLM_MAX	; YES - STAY AT RIGHT COLUMN
	DEC	AX
	MOV	XPOS,AX
	JMP SHORT	PUTC300
PUTC240:
	MOV	XPOS,0		; WRAP TO LEFT COLUMN
	CALL	CTLF		; THEN DO LINE FEED
PUTC300:
	CALL	TOGGLE_CURSOR	; TURN CURSOR BACK ON
PUTC350:
	XOR	AL,AL		; NO SEQ PENDING
	RET

;**************************************************
;	CONTROL CODES
;**************************************************
CTRL100:
	CMP	CL,1BH		; SPECIAL TEST FOR ESC
	JE	CTESC		; YES - RETURN DIFFERENT
	MOV	BX,CX
	SHL	BX,1
	CALL	TOGGLE_CURSOR	; CURSOR OFF
	CALL	CTRL_TAB[BX]
	CALL	TOGGLE_CURSOR	; CURSOR ON
	XOR	AL,AL		; NO SEQ PENDING
	RET
;**************************************************
PASS_1:
	MOV	AX,1		; UDC PUT
	CALL	OLD_VEC
	RET

;**************************************************
CTESC:
	MOV	CBUFF,CL			; ESC FIRST CHAR IN BUFFER
	MOV	BUF_COUNT,1			; ONE CHAR IN BUFFER
	MOV	PUT_VEC,OFFSET BUFFER_ESC	; BUFFER ESC SEQUENCE
	MOV	AL,0FFH				; SEQ IS PENDING
	RET

;**************************************************
CTBS:
	MOV	AX,XPOS		; BACKSPACE
	DEC	AX		; BACKWARD ONE CHAR COLUMN
	JNS	BS500		; IF NOT AT LEFT SIDE OF SCREEN
	TEST	DISCARD_FLAG,1	; IN DISCARD MODE ?
	JNE	BS600		; YES - NO WRAP
	MOV	AX,COLM_MAX	; ELSE WRAP AROUND
	DEC	AX
	MOV	BX,YPOS
	CMP	BX,TOP_LINE	; AT TOP LINE ?
	JE	BS500		; YES - STAY THERE
	DEC	BX		; SIMULATE BOT+1
	CMP	BX,BOT_LINE	; AT BOT+1 ?
	JE	BS500		; YES - STAY THERE
	MOV	YPOS,BX		; ELSE - WRAP UP
BS500:
	MOV	XPOS,AX
BS600:
	RET

;**************************************************
CTHT:
	MOV	AX,XPOS		; HORIZONTAL TAB
	ADD	AX,TAB_STOP
	AND	AX,0FFF8H
	CMP	AX,COLM_MAX	; OFF END ?
	JL	HT550		; NO
	MOV	AX,COLM_MAX	; ELSE - STICK AT LAST COLUMN
	DEC	AX
HT550:
	MOV	XPOS,AX
	RET

;**************************************************
CTLF:
	CALL	LINE_FD		; LINE FEED
	TEST	CRLF_FLAG,2	; AN AUTO CR ON LF ?
	JE	LF100		; NO
	MOV	XPOS,0		; YES - DO A RETURN
LF100:
	RET

LINE_FD:
	MOV	AX,YPOS
	MOV	BX,BOT_LINE
	CMP	AX,BX
	JE	LF300
	INC	BX		; CHECK BOTTOM +1
	CMP	AX,BX
	JE	LF200		; IF BOT+1 DO NOTHING
	INC	AX
	MOV	YPOS,AX
LF200:
	RET			; IF BOT+1 DO NOTHING
LF300:
	MOV	SI,TOP_LINE	; SCROLL FROM TOP TO BOTTOM LINE
	MOV	DI,BOT_LINE	; PRINT ON BOTTOM LINE
	MOV	YPOS,DI		; STAY ON BOTTOM LINE - 1
	CALL	SCROLL_UP
	RET

;**************************************************
CTCR:	
	MOV	XPOS,0		; RETURN, MOVE TO LEFT COLUMN
	TEST	CRLF_FLAG,1	; AN AUTO LF ON CR ?
	JE	CR100		; NO
	CALL	LINE_FD		; YES
CR100:
	RET

;**************************************************
CTSO:
	MOV	BX,6		; SHIFT OUT - 132 COLUMN MODE
	MOV	CX,10		; 6 X 10 CELL
	CALL	SET_CELL_SIZE	; TOP_LINE=0
	MOV	AX,SMALL_SEG	; BOT_LINE=38
	MOV	CHAR_SEG,AX	; SMALL CHARSET
	MOV	AX,SMALL_OFF
	MOV	CHAR_OFF,AX
	RET

;**************************************************
CTSI:
	MOV	BX,10		; SHIFT IN - 80 COLUMN MODE
	MOV	CX,16		; 10 X 16 CELL
	CALL	SET_CELL_SIZE	; TOP_LINE=0
	MOV	AX,NORMAL_SEG	; BOT_LINE=23
	MOV	CHAR_SEG,AX	; NORMAL CHARSET
	MOV	AX,NORMAL_OFF
	MOV	CHAR_OFF,AX
	RET

;**************************************************
;	BUFFER CHARS FOR ESCAPE SEQUENCE
;**************************************************
BUFFER_ESC:
	MOV	BL,BUF_COUNT
	XOR	BH,BH
	MOV	CBUFF[BX],CL		; PUT CHAR INTO ESC SEQUENCE BUFFER
	INC	BL			; BUMP COUNT
	MOV	BUF_COUNT,BL
	MOV	DL,CBUFF+1
	CMP	DL,'4'			; KEY SET IS A SPECIAL CASE
	JE	BUFT200			;  ACCEPT ALL 0-255 CODES
	CMP	CL,18H			; CTRL X - ABORT ESC SEQUENCE ?
	JE	ABORT_ESC		; YES
BUFT200:
	XCHG	DL,BL			; DL=LENGTH, BL=ESC SEQ CHAR
	SUB	BL,20H			; ASCII PRINT CHARS ONLY
	JB	ABORT_ESC		; ELSE ABORT
	CMP	DL,ESC_SIZE[BX]		; GOT ALL OF CHARS IN SEQUENCE ?
	JB	CONT_SEQ		; NO - GET MORE
	MOV	PUT_VEC,OFFSET PUT_ACTIVE	; BACK TO ACTIVE
	SHL	BX,1			; WORD POINTER
	CALL	TOGGLE_CURSOR		; CURSOR OFF
	CALL	ESC_DISPATCH[BX]	; ESC DISPATCH --->
	CALL	TOGGLE_CURSOR		; CURSOR ON
	XOR	AL,AL			; NO SEQ PENDING
	RET

ABORT_ESC:
	MOV	PUT_VEC,OFFSET PUT_ACTIVE	; BACK TO ACTIVE
	XOR	AL,AL				; NO SEQ PENDING
	RET

CONT_SEQ:				; ELSE CONTINUE SEQUENCE
	MOV	AL,0FFH			; CONTINUING SEQUENCE
	RET

	PAGE
;**************************************************
;
;	ESCAPE SEQUENCES
;
;**************************************************


;**************************************************
;	TRANSMIT PAGE 
;	ESC #  (1BH,23H)
;**************************************************
TRANSMIT_PAGE:
	MOV	AL,0DH			; RETURN
	CALL	FIFO_IN
	MOV	AL,0AH			; LINE FEED
	CALL	FIFO_IN
	RET

;**************************************************
;	TRANSMIT CHARACTER AT CURSOR
;	ESC $  (1BH,24H)
;**************************************************
TRANSMIT_CHAR:
	MOV	AL,0DH			; RETURN
	CALL	FIFO_IN
	MOV	AL,0AH			; LINE FEED
	CALL	FIFO_IN
	RET

;**************************************************
;	SET HIGH INTENSITY MODE
;	ESC (  (1BH,28H)
;**************************************************
LOW_INT_OFF:
	AND	ATTRIBUTE_FLAG,NOT (LOW_ATTR/256)	; LOW INTENSITY OFF
	RET

;**************************************************
;	RESET HIGH INTENSITY MODE
;	ESC )  (1BH,29H)
;**************************************************
LOW_INT_ON:
	OR	ATTRIBUTE_FLAG,LOW_ATTR/256		; LOW INTENSITY ON
	RET

;**************************************************
;	ENTER UNDERLINE CHARACTER MODE
;	ESC 0  (1BH,30H)
;**************************************************
UNDERLINE_ON:
	OR	ATTRIBUTE_FLAG,UND_ATTR/256	; TURN UNDERLINE ON
	RET

;**************************************************
;	EXIT UNDERLINE CHARACTER MODE
;	ESC 1  (1BH,31H)
;**************************************************
UNDERLINE_OFF:
	AND	ATTRIBUTE_FLAG,NOT (UND_ATTR/256)	; TURN UNDERLINE OFF
	RET

;**************************************************
;	LITERAL CHARACTER
;	ESC 8  (1BH,38H)
;**************************************************
LITERAL:
	MOV	LITERAL_FLAG,1		; NEXT CHAR IS A LITERAL
	RET

;**************************************************
;	ENTER INSERT CHARACTER MODE
;	ESC @  (1BH,40H)
;**************************************************
INSERT_CHAR_ON:
	MOV	INSERT_FLAG,1			; ENABLE INSERT CHAR
	RET

;**************************************************
;	CURSOR UP
;	ESC A  (1BH,41H)
;**************************************************
CURSOR_UP:
	MOV	AX,YPOS
	CMP	AX,TOP_LINE		; AT TOP OF SCREEN ?
	JE	CUP100			; YES - STAY THERE
	DEC	AX			; SIMULATE BOT+1
	CMP	AX,BOT_LINE		; ON BOTTOM LINE ?
	JE	CUP100			; YES - STAY THERE
	MOV	YPOS,AX
CUP100:
	RET

;**************************************************
;	CURSOR DOWN
;	ESC B  (1BH,42H)
;**************************************************
CURSOR_DOWN:
	MOV	AX,YPOS
	MOV	BX,BOT_LINE
	CMP	AX,BX			; ON BOTTOM LINE ?
	JE	CDN100			; YES - STAY THERE
	INC	BX			; ON BOT+1 ?
	CMP	AX,BX
	JE	CDN100			; YES - STAY THERE
	INC	AX			; ELSE - MOVE DOWN ONE LINE
	MOV	YPOS,AX
CDN100:
	RET
 
;**************************************************
;	CURSOR FORWARD
;	ESC C  (1BH,43H)
;**************************************************
CURSOR_FORWARD:
	MOV	AX,XPOS
	INC	AX			; MOVE FORWARD ONE CHAR COLUMN
	CMP	AX,COLM_MAX		; AT RIGHT SIDE OF SCREEN ?
	JL	CRT100			; NO
	MOV	AX,COLM_MAX		; YES - STAY THERE
	DEC	AX
CRT100:
	MOV	XPOS,AX
	RET

;**************************************************
;	CURSOR BACKWARD
;	ESC D  (1BH,44H)
;**************************************************
CURSOR_BACKWARD:
	MOV	AX,XPOS
	DEC	AX			; BACKWARD ONE CHAR COLUMN
	JNS	CLF100			; IF NOT AT LEFT SIDE OF SCREEN
	SUB	AX,AX			; ELSE STAY THERE
CLF100:
	MOV	XPOS,AX
	RET

;**************************************************
;	CLEAR DISPLAY
;	ESC E  (1BH,45H)
;**************************************************
CLEAR:
	MOV	SI,TOP_LINE
	MOV	DI,BOT_LINE
	MOV	AX,YPOS
	CMP	AX,DI			; BEYOND BOTTOM LINE
	JLE	CLEAR100		; NO
	INC	DI			; DI = BOT+1
	MOV	SI,DI			; CLEAR FROM BOT+1 TO BOT+1
	CALL	ERASE_LINES		; ERASE BOT LINE +1
	MOV	XPOS,0			; MOVE TO BEGINNING OF BOT LINE +1
	RET
CLEAR100:
	CALL	ERASE_LINES		; ERASE LINE RANGE
	CALL	HOME			; HOME CURSOR
	RET

;**************************************************
;	ENTER GRAPHICS MODE
;	ESC F  (1BH,46H)
;**************************************************
GRAPHIC_ON:
	MOV	GRAPHIC_FLAG,1		; ENABLE GRAPHICS
	RET

;**************************************************
;	EXIT GRAPHICS MODE
;	ESC G  (1BH,47H)
;**************************************************
GRAPHIC_OFF:
	MOV	GRAPHIC_FLAG,0		; DISABLE GRAPHICS
	RET

;**************************************************
;	HOME CURSOR
;	ESC H  (1BH,48H)
;**************************************************
HOME:
	XOR	AX,AX
	MOV	XPOS,AX		; LEFT COLUMN
	MOV	AX,TOP_LINE
	MOV	YPOS,AX		; TOP LINE
	RET

;**************************************************
;	REVERSE LINE FEED
;	ESC I  (1BH,49H)
;**************************************************
REV_LINE_FEED:
	MOV	SI,TOP_LINE
	MOV	DI,BOT_LINE
	MOV	AX,YPOS
	CMP	AX,SI			; AT TOP OF SCREEN
	JE	RVLF100			; YES - SCROLL
	dec	ax			;simulate bot+1
	CMP	AX,DI
	JE	RVLF200			; DONT SCROLL IF ON BOT+1
	DEC	YPOS			; ELSE MOVE UP ONE LINE
	JMP SHORT	RVLF200
RVLF100:
	CALL	SCROLL_DOWN		;  SCROLL THE SCREEN DOWN
RVLF200:
	RET

;**************************************************
;	ERASE TO END OF PAGE
;	ESC J  (1BH,4AH)
;**************************************************
ERASE_EOP:
	CALL	ERASE_EOL	; FIRST ERASE TO END OF LINE
	MOV	AX,YPOS
	MOV	SI,AX
	INC	SI
	MOV	DI,BOT_LINE
	CMP	AX,DI		; IF AT BOTTOM THEN DONE
	JE	EEOP200
	DEC	AX		; SIMULATE BOT+1
	CMP	AX,DI		; AT BOT+1 ?
	JE	EEOP200		; YES - DONE
	CALL	ERASE_LINES
EEOP200:
	RET

;**************************************************
;	ERASE TO END OF LINE
;	ESC K  (1BH,4BH)
;**************************************************
ERASE_EOL:
	MOV	AX,XPOS			; SAVE CURSOR COLUMN POSITION
	PUSH	AX
	CALL	CLEAR_CELL		; BLANK FOR ERASE
EOL100:
	CALL	PUT_CELL		; CLEAR A CHAR CELL
	INC	XPOS
	MOV	AX,XPOS
	CMP	AX,COLM_MAX		; ERASED THE END OF LINE ?
	JL	EOL100			; NO
	POP	AX			; RESTORE CURSOR POSITION
	MOV	XPOS,AX
	RET

;**************************************************
;	INSERT LINE
;	ESC L  (1BH,4CH)
;**************************************************
INSERT_LINE:
	MOV	SI,YPOS		; SCROLL FROM THIS LINE ...
	MOV	DI,BOT_LINE	;  TO BOTTOM LINE ...
	MOV	AX,SI
	DEC	AX		; SIMULATE BOT+1
	CMP	AX,DI		; DONT INSERT AT BOT+1
	JE	INST100
	CALL	SCROLL_DOWN	;  DOWN ONE LINE
	MOV	XPOS,0		; POSITION TO BEGINNING OF LINE
INST100:
	RET

;**************************************************
;	DELETE LINE
;	ESC M  (1BH,4DH)
;**************************************************
DELETE_LINE:
	MOV	SI,YPOS		; SCROLL FROM THIS LINE ...
	MOV	DI,BOT_LINE	;  TO BOTTOM LINE ...
	MOV	AX,SI
	DEC	AX		; SIMULATE BOT+1
	CMP	AX,DI		; DONT DELETE IF AT BOT+1
	JE	DELE100
	CALL	SCROLL_UP	;  UP ONE LINE
	MOV	XPOS,0		; POSITION TO BEGINNING OF LINE
DELE100:
	RET

;**************************************************
;	DELETE CHARACTER
;	ESC N  (1BH,4EH)
;**************************************************
DELETE_CHAR:
	MOV	AX,XPOS		; SAVE CHAR COLUMN POS
	PUSH	AX
DLC100:
	INC	XPOS
	MOV	AX,XPOS
	CMP	AX,COLM_MAX	; MOVED ALL CHARS RIGHT ?
	JGE	DLC200		; YES
	CALL	GET_CELL	; GET CELL TO RIGHT
	DEC	XPOS
	CALL	PUT_CELL	; PUT ON TOP OF HERE
	INC	XPOS
	JMP SHORT	DLC100
DLC200:
	DEC	XPOS
	CALL	CLEAR_CELL	; WIPE CELL BUFFER
	CALL	PUT_CELL	; ERASE RIGHT MOST CELL
	POP	AX		; MOVE CURSOR BACK TO ORIGINAL POS
	MOV	XPOS,AX
	RET

;**************************************************
;	EXIT INSERT CHARACTER MODE
;	ESC O  (1BH,4FH)
;**************************************************
INSERT_CHAR_OFF:
	MOV	INSERT_FLAG,0	; INSERT CHARACTER MODE OFF
	RET

;**************************************************
;	EXCHANGE LINE
;	ESC X  (1BH,58H)
;**************************************************
exchange_line:
	RET			;do nothing yet

;**************************************************
;	DIRECT CURSOR ADDRESSING
;	ESC Y[1][C]  (1BH,59H,XXH,XXH)
;**************************************************
DIRECT_CURSOR:
	MOV	AL,CBUFF+2	; HEX LINE #
	XOR	AH,AH		; AH=0
	SUB	AL,20H
	JB	DCR800		; NOT ASCII
	MOV	BL,CBUFF+3	; HEX COLUMN #
	XOR	BH,BH		; AH=0
	SUB	BL,20H
	JB	DCR800		; NOT ASCII
DCR150:
	CMP	AX,TOP_LINE	; ABOVE TOP LINE ?
	JGE	DCR200		; NO
	MOV	AX,TOP_LINE	; CLIP TO TOP
	JMP SHORT	DCR300
DCR200:
	MOV	CX,BOT_LINE
	CMP	AX,CX		; BELOW OR EQUAL BOTTOM LINE ?
	JLE	DCR300		; YES - OK THEN
	INC	CX		; NO - ON BOT+1 LINE ?
	CMP	AX,CX
	JNE	DCR350		; NO - DONT DO ANYTHING
	TEST	BOT_FLAG,1	; YES - BOT+1 LINE ENABLED ?
	JE	DCR350		; NO - DO COLUMN ONLY
DCR300:
	MOV	YPOS,AX		; CHANGE LINE POSITION
DCR350:
	CMP	BX,COLM_MAX	; BEYOND MAX COLUMNS ?
	JL	DCR400		; NO - LEAVE OK
	MOV	BX,COLM_MAX	; YES - CLIP TO COLM_MAX-1
	DEC	BX
DCR400:
	MOV	XPOS,BX
DCR800:
	RET

;**************************************************
;	IDENTIFY AS VT52 (ESC/K)
;	ESC Z  (1BH,5AH)
;**************************************************
IDENT_VT52:
	MOV	AL,1BH			; ESC
	CALL	FIFO_IN
	MOV	AL,'/'			; "/"
	CALL	FIFO_IN
	MOV	AL,'K'			; "K"
	CALL	FIFO_IN
	RET

;**************************************************
;	TRANSMIT BOTTOM LINE
;	ESC ]  (1BH,5DH)
;**************************************************
TRANSMIT_BOT:
	MOV	AL,0DH			; RETURN
	CALL	FIFO_IN
	MOV	AL,0AH			; LINE FEED
	CALL	FIFO_IN
	RET

;**************************************************
;	ERASE BEGINNING OF DISPLAY
;	ESC b  (1BH,62H)
;**************************************************
ERASE_BOP:
	CALL	ERASE_BOL	; ERASE TO BEGINNING OF LINE
	MOV	SI,TOP_LINE
	MOV	DI,BOT_LINE
	MOV	AX,YPOS
	CMP	AX,SI		; AT TOP LINE ?
	JE	EBOP100		; YES - DONE
	DEC	AX		; SIMULATE BOT+1
	CMP	AX,DI		; AT LINE BOT+1
	JE	EBOP100		; YES - DONE
	MOV	DI,AX		; ERASE FROM TOP TO CURSOR-1 LINE
	CALL	ERASE_LINES
EBOP100:
	RET

;**************************************************
;	REVERSE TAB
;	ESC h  (1BH,68H)
;**************************************************
REVERSE_TAB:
	MOV	AX,XPOS
	SUB	AX,TAB_STOP
	AND	AX,0FFF8H	; OFF LEFT SIDE OF SCREEN
	JNS	REVT100		; NO
	SUB	AX,AX		; STOP ON LEFT SIDE
REVT100:
	MOV	XPOS,AX
	RET

;**************************************************
;	SAVE CURSOR POSITION
;	ESC j  (1BH,6AH)
;**************************************************
SAVE_POS:
	MOV	AX,XPOS		; SAVE CURSOR COLUMN
	MOV	SAVE_XPOS,AX
	MOV	AX,YPOS		; SAVE CURSOR LINE
	MOV	SAVE_YPOS,AX
	RET

;**************************************************
;	SET CURSOR TO SAVED POSITION
;	ESC k  (1BH,6BH)
;**************************************************
RESTORE_POS:
	MOV	AX,SAVE_YPOS	; GET CURSOR LINE
	MOV	BX,SAVE_XPOS	; GET CURSOR COLUMN
	JMP	DCR150		; DO A CURSOR POSITION

;**************************************************
;	ERASE ENTIRE LINE
;	ESC l  (1BH,6CH)
;**************************************************
ERASE_LINE:
	MOV	SI,YPOS		; ERASE THIS LINE
	CALL	ERASE_ONE
	RET

;**************************************************
;	SET SIZE
;	ESC m[c1][c2][c3] (1BH,6DH,XXH,XXH,XXH)
;**************************************************
SET_SIZE:
	MOV	BL,CBUFF+2	; DISPATCH #
	CMP	BL,'1'		; SET CELL SIZE ?
	JE	SET_CELL	; YES
	CMP	BL,'2'		; SET SCREEN SIZE ?
	JE	SET_SCREEN
	RET

SET_CELL:
	XOR	BH,BH		; BH=0
	MOV	BL,CBUFF+3	; CELL WIDTH
	SUB	BL,1FH
	CMP	BL,1		; TOO SMALL WIDTH
	JL	SCEL500		; YES
	CMP	BL,10H		; TOO BIG ?
	JG	SCEL500		; YES - DON'T CHANGE
	SUB	CH,CH		; CH=0
	MOV	CL,CBUFF+4	; CELL HEIGHT
	SUB	CL,1FH
	CMP	CL,1		; TOO SMALL HEIGHT
	JL	SCEL500		; YES - DON'T CHANGE
	CMP	CL,10H		; TOO BIG
	JG	SCEL500		; YES
	CALL	SET_CELL_SIZE
SCEL500:
	RET

SET_SCREEN:
	MOV	AX,LINE_MAX	; GET MAX LINE #
	DEC	AX
	XOR	BH,BH		; BH=0
	MOV	BL,CBUFF+3	; TOP LINE #
	SUB	BL,20H		; TOO SMALL TOP LINE #
	JS	SSCN500		; YES
	CMP	BX,AX		; TOO BIG ?
	JG	SSCN500		; YES - DON'T CHANGE
	SUB	CH,CH		; CH=0
	MOV	CL,CBUFF+4	; BOT_LINE
	SUB	CL,20H
	CMP	BX,CX		; BOT MUST BE GREATER THAN OR EQUAL TOP
	JG	SSCN500		; ELSE - DON'T CHANGE
	CMP	CX,AX		; TOO BIG
	JG	SSCN500		; YES
	CALL	SET_SCRN_SIZE
SSCN500:
	RET

;**************************************************
;	CURSOR POSITION REPORT
;	ESC n  (1BH,6EH)
;**************************************************
REPORT_CURSOR:
	MOV	AL,1BH		; ESC
	CALL	FIFO_IN
	MOV	AL,'Y'		; "Y"
	CALL	FIFO_IN
	MOV	AX,YPOS		; LINE #
	ADD	AL,20H
	CALL	FIFO_IN
	MOV	AX,XPOS		; COLUMN #
	ADD	AL,20H
	CALL	FIFO_IN
	RET

;**************************************************
;	ERASE BEGINNING OF LINE
;	ESC o  (1BH,6FH)
;**************************************************
ERASE_BOL:
	MOV	AX,XPOS		; SAVE CURSOR COLUMN POSITION
	PUSH	AX
	CALL	CLEAR_CELL	; TO ERASE
EBOL100:
	CALL	PUT_CELL	; ERASE
	DEC	XPOS
	JGE	EBOL100		; TO BEGINNING OF LINE
	POP	AX		; RESTORE CURSOR COLUMN POSITION
	MOV	XPOS,AX
	RET

;**************************************************
;	ENTER REVERSE VIDEO MODE
;	ESC p  (1BH,70H)
;**************************************************
REVERSE_ON:
	OR	ATTRIBUTE_FLAG,REV_ATTR/256		; TURN REVERSE ON
	RET

;**************************************************
;	EXIT REVERSE VIDEO MODE
;	ESC q  (1BH,71H)
;**************************************************
REVERSE_OFF:
	AND	ATTRIBUTE_FLAG,NOT (REV_ATTR/256)	; TURN REVERSE OFF
	RET

;**************************************************
;	WRAP AROUND AT END OF LINE
;	ESC v  (1BH,76H)
;**************************************************
WRAP_MODE:
	MOV	DISCARD_FLAG,0		; ENABLE WRAP MODE
	RET

;**************************************************
;	DISCARD AT END OF LINE
;	ESC w  (1BH,77H)
;**************************************************
DISCARD_MODE:
	MOV	DISCARD_FLAG,1		; ENABLE DISCARD MODE
	RET

;**************************************************
;	SET MODE(S)
;	ESC x [Ps] (1BH,78H)
;**************************************************
SET_MODES:
	XOR	BH,BH			; BH = 0
	MOV	BL,CBUFF+2		; FIND WHAT TO SET
	SUB	BL,'1'			; BELOW ASCII "0" ?
	JS	SET_DONE		; YES - EXIT
	CMP	BL,9			; FROM 0 - 9 ?
	JL	SETM500			; YES
	SUB	BL,7
	CMP	BL,7			; BELOW ASCII "A" ?
	JL	SET_DONE		; YES - EXIT
	CMP	BL,12			; A - C ?
	JGE	SET_DONE		; NO - EXIT
SETM500:
	SHL	BX,1
	JMP	SET_TAB[BX]

SET_TAB		DW	ENABLE_BOT,SET_DONE,SET_DONE,BLK_CUR
		DW	CUR_OFF,SET_DONE,SET_DONE,SET_LF
		DW	SET_CR,SEND_BUFFER,SEND_BUFFER,SEND_BUFFER

ENABLE_BOT:
	OR	BOT_FLAG,1		; ENABLE BOT LINE
SET_DONE:
	RET
BLK_CUR:
	AND	CURSOR_FLAG,NOT 2	; ENABLE BLOCK CURSOR
	RET
CUR_OFF:
	OR	CURSOR_FLAG,1		; CURSOR OFF
	RET
SET_LF:
	OR	CRLF_FLAG,1		; ENABLE AUTO LINE FEED ON CR
	RET
SET_CR:
	OR	CRLF_FLAG,2		; ENABLE AUTO CR ON LINE FEED
	RET

;**************************************************
;	RESET MODE(S)
;	ESC y [Ps] (1BH,79H)
;**************************************************
RESET_MODES:
	XOR	BH,BH			; BH = 0
	MOV	BL,CBUFF+2		; FIND WHAT TO SET
	SUB	BL,'1'			; BELOW ASCII "1" ?
	JS	REST_DONE		; YES - EXIT
	CMP	BL,9			; FROM 0 - 9 ?
	JL	REST500			; YES
	SUB	BL,7
	CMP	BL,7			; BELOW ASCII "A" ?
	JL	REST_DONE		; YES - EXIT
	CMP	BL,12			; A - C ?
	JGE	REST_DONE		; NO - EXIT
REST500:
	SHL	BX,1
	JMP	RESET_TAB[BX]

RESET_TAB	DW	DISABLE_BOT,REST_DONE,REST_DONE,UND_CUR
		DW	CUR_ON,REST_DONE,REST_DONE,REST_LF
		DW	REST_CR,SEND_BUFFER,SEND_BUFFER,SEND_BUFFER

DISABLE_BOT:
	AND	BOT_FLAG,NOT 1		; DISABLE BOT LINE
REST_DONE:
	RET
UND_CUR:
	OR	CURSOR_FLAG,2		; ENABLE UNDERSCORE CURSOR
	RET
CUR_ON:
	AND	CURSOR_FLAG,NOT 1	; CURSOR ON
	RET
REST_LF:
	AND	CRLF_FLAG,NOT 1		; NO AUTO LINE
	RET
REST_CR:
	AND	CRLF_FLAG,NOT 2		; NO AUTO CR
	RET

;**************************************************
;	RESET TO 80 COLUMN TEXT MODE
;	ESC z  (1BH,7AH)
;**************************************************
RESET:
	MOV	PUT_VEC,OFFSET NON_ACTIVE
	CALL	SEND_BUFFER		; SEND TO VT52
	RET

;**************************************************
;	KEYBOARD ENABLE
;	ESC {  (1BH,7BH)
;**************************************************
KEYBOARD_ON:
	CALL	SEND_BUFFER		; VT52 DOES THIS
	RET

;**************************************************
;	ENABLE 132 COLUMN DISPLAY
;	ESC |  (1BH,7CH)
;**************************************************
ENABLE_132:
	MOV	PUT_VEC,OFFSET PUT_ACTIVE
	CALL	SETHIRES			; SET TO HIRES MODE
	CALL	CTSO				; SET TO 6 X 10, 132 COLUMNS
	RET

;**************************************************
;	KEYBOARD DISABLE
;	ESC }  (1BH,7DH)
;**************************************************
KEYBOARD_OFF:
	CALL	SEND_BUFFER		; VT52 DOES THIS
	RET

;**************************************************
;	SCROLL UP
;	ENTER	SI = TOP    LINE # INCLUSIVE
;		DI = BOTTOM LINE # INCLUSIVE
;**************************************************
SCROLL_UP:
	PUSH	DI			; SAVE BOTTOM LINE # TO ERASE IT
	SUB	DI,SI			; # LINES -1 TO MOVE
	MOV	AX,CELL_HEIGHT		; CALC # WORDS TO MOVE
	MUL	DI
	MOV	BX,AX
	MOV	AX,CELL_HEIGHT		; CALC TO ADDR
	SHL	AX,1			; TIMES TWO FOR WORDS
	MUL	SI
	MOV	BP,AX			; SCROLL UP TO THIS LINE
	ADD	BP,OFFSET DOT_BUFF

;	BP = WHERE TO MOVE WORDS TO
;	BX = # WORDS TO MOVE
	CLD				; MOVE FOR LOW TO HI MEMORY
	MOV	DL,SCOLS		; # OF COLUMNS TO SCROLL UP
SCU100:
	MOV	DI,BP			; TO
	MOV	SI,BP			; CALC FROM ADDR
	MOV	AX,CELL_HEIGHT
	SHL	AX,1			; TIMES TWO FOR WORDS
	ADD	SI,AX
	MOV	CX,BX			; COUNT
	REP	MOVSW	
	ADD	BP,COL_BYTE			; NEXT COLUMN LEFT
	DEC	DL
	JG	SCU100
	POP	SI			; LINE TO ERASE
	CALL	ERASE_ONE
	RET

;**************************************************
;	SCROLL DOWN
;	ENTER	SI = TOP    LINE # INCLUSIVE
;		DI = BOTTOM LINE # INCLUSIVE
;**************************************************
SCROLL_DOWN:
	PUSH	SI			; SAVE TOP LINE # TO ERASE IT
	SUB	SI,DI			; # LINES -1 TO MOVE
	NEG	SI			; BECAUSE IT WAS MINUS
	MOV	AX,CELL_HEIGHT		; CALC # WORDS TO MOVE
	MUL	SI
	MOV	BX,AX
	MOV	AX,CELL_HEIGHT		; CALC TO ADDR
	SHL	AX,1			; TIMES TWO FOR WORDS
	INC	DI			; BOTTOM LINE +1
	MUL	DI
	MOV	BP,AX			; SCROLL DOWN TO THIS LINE
	DEC	BP			; BACKUP ONE WORD
	DEC	BP
	ADD	BP,OFFSET DOT_BUFF

;	BP = WHERE TO MOVE WORDS TO
;	BX = # WORDS TO MOVE
	STD				; MOVE FOR HI TO LOW MEMORY
	MOV	DL,SCOLS		; # OF COLUMNS TO SCROLL DOWN
SCD100:
	MOV	DI,BP			; TO
	MOV	SI,BP			; CALC FROM ADDR
	MOV	AX,CELL_HEIGHT
	SHL	AX,1			; TIMES TWO FOR WORDS
	SUB	SI,AX
	MOV	CX,BX			; COUNT
	REP	MOVSW	
	ADD	BP,COL_BYTE			; NEXT COLUMN LEFT
	DEC	DL
	JG	SCD100
	POP	SI			; LINE TO ERASE
	CALL	ERASE_ONE
	RET

;**************************************************
;	ERASE LINES
;	ENTER:	SI = TOP LINE NUMBER 
;		DI = BOTTOM LINE NUMBER
;	ES EQUAL DS
;	DESTROYS DL,CX,DI,AX
;**************************************************
ERASE_ONE:
	MOV	DI,SI

ERASE_LINES:
	SUB	DI,SI			; CALC # LINES TO ERASE
	INC	DI
	MOV	AX,CELL_HEIGHT		; NOW CALC # RASTER LINES
	MUL	DI
	MOV	BX,AX
	MOV	AX,CELL_HEIGHT
	SHL	AX,1			; FOR WORDS
	MUL	SI			; CALC ADDR OF FIRST LINE
	MOV	SI,AX
	ADD	SI,OFFSET DOT_BUFF
	SUB	AX,AX			; FILL WITH ZERO
	MOV	DL,SCOLS		; NUMBER 16 BIT COLUMNS
ERL100:
	MOV	DI,SI
	MOV	CX,BX			; # WORD IN COLUMN TO ERASE
	CLD
	REP	STOSW	
	ADD	SI,COL_BYTE		; NEXT COLM LEFT
	DEC	DL			; DONE ALL COLMS ?
	JG	ERL100			; NO
	RET

;**************************************************
;	INSERT A CHARACTER SPACE
;	ENTER:	XPOS AND YPOS
;	SCROLLS ALL CHARS FROM XPOS,YPOS
;	TO END OF LINE RIGHT ONE CHAR COLUMN
;	AND ERASES XPOS,YPOS CHAR
;**************************************************
INSERT_CHAR:
	PUSH	CX
	MOV	AX,XPOS		; SAVE CURSOR POSITION
	PUSH	AX
	MOV	AX,COLM_MAX	; START RIGHT COLUMN
	DEC	AX
	MOV	XPOS,AX
IRC100:
	POP	AX		; START POSITION
	CMP	AX,XPOS		; DONE ?
	JE	IRC200		; YES
	PUSH	AX
	DEC	XPOS
	CALL	GET_CELL	; GET SCREEN CELL TO LEFT
	INC	XPOS
	CALL	PUT_CELL	; PUT IT HERE
	DEC	XPOS
	JMP SHORT	IRC100
IRC200:
	CALL	CLEAR_CELL	; ERASE ORIGINAL POS
	CALL	PUT_CELL
	POP	CX
	RET

;**************************************************
;	CALCULATE ADDR FOR POSITION ON SCREEN
;	ENTER	POSITION = XPOS,YPOS
;	EXIT	BP = ADDR OF TOP WORD IN CELL
;		CL = SHIFT COUNT
;		BX = MASK FOR WIDTH OF CHAR CELL
;**************************************************
CALC_ADDR:
	MOV	AX,XPOS			; ABS X POSITION
	MOV	BX,CELL_WIDTH		; CALC ABS POSITION OF ARRAY
	MUL	BX
	MOV	CX,AX			; SAVE IN CX
	AND	CL,0FH			; 16 BIT SHIFT COUNT
	AND	AX,03F0H		; 16*COL#  (COLUMN NUMBER)
	MOV	BX,COL_BYTE/16		; FOR MULT BY 800/16=50
	MUL	BX			; (16*COL#)*(800/16)=WORD/COLUMN
	MOV	BP,AX
	MOV	AX,YPOS			; CALC ABS LINE FOR CELL
	MOV	BX,CELL_HEIGHT
	SHL	BX,1			; TIMES 2 FOR WORDS
	MUL	BX
	ADD	BP,AX			; GEN ADDR TO FIRST FONT CELL WORD
	ADD	BP,OFFSET DOT_BUFF
	MOV	BX,CELL_MASK		; MASK FOR CELL_WIDTH WIDE CHARS
	RET

;**************************************************
;	TOGGLE CURSOR
;	ENTER	POSITION = XPOS,YPOS
;**************************************************
TOGGLE_CURSOR:
	PUSH	BX
	PUSH	CX
	TEST	CURSOR_FLAG,1	; CURSOR ON ?
	JNE	NO_CURSOR	; NO - SKIP ALL THIS
	CALL	GET_CELL	; GET THE CELL FROM SCREEN INTO CELL_BUFF
	TEST	CURSOR_FLAG,2	; A BLOCK CURSOR ?
	JE	CXOR100		; YES - GO DO A BLOCK CURSOR
	MOV	CX,CELL_HEIGHT
	MOV	BX,CELL_MASK
	PUSH	ES
	MOV	SI,CHAR_SEG
	MOV	ES,SI
	MOV	SI,CHAR_OFF
	MOV	AX,8000H		; MSB FLAGS UNDERLINE
	XOR	DI,DI
CUND100:
	TEST	ES:[SI],AX		; UNDERLINE HERE
	JE	CUND200			; NO
	XOR	CELL_BUFF[DI],BX
CUND200:
	INC	DI
	INC	DI
	INC	SI
	INC	SI
	LOOP	CUND100
	POP	ES
	JMP SHORT	CXOR200
CXOR100:
	CALL	XOR_CELL	; XOR FOR A BLOCK CURSOR
CXOR200:
	CALL	PUT_CELL	; PUT BACK ON SCREEN
NO_CURSOR:
	POP	CX
	POP	BX
	RET

;**************************************************
;	OR CHAR FROM TABLE TO CELL_BUFF
;	ENTER:	CL = CHARACTER
;		CHAR_SEG=SEGMENT FOR TABLE
;		CHAR_OFF=OFFSET FOR TABLE
;**************************************************
CHAR_OR_CELL:
	PUSH	CX
	MOV	SI,CHAR_OFF	; CHARS COME FROM HERE
	MOV	AX,32		; CHARS IN TABLE 16 WORDS HIGH
	MUL	CX
	ADD	SI,AX
	MOV	DI,OFFSET CELL_BUFF
	MOV	CX,CELL_HEIGHT	; # WORDS TO OR IN
	MOV	AX,CHAR_SEG
	MOV	DS,AX
	CLD
CTC200:
	LODSW			; GET CHAR WORD
	OR	AX,ES:[DI]	; OR TO CELL
	STOSW	
	LOOP	CTC200
	MOV	AX,CS		; RESTORE DS
	MOV	DS,AX
	POP	CX
	RET

;**************************************************
;	ADD UNDERLINE TO CELL_BUFF IF ON
;**************************************************
ADD_UNDERLINE:
	TEST	ATTRIBUTE_FLAG,UND_ATTR/256
	JE	ADDU400				; NO UNDERLINE
ADDU050:
	MOV	CX,CELL_HEIGHT
	MOV	BX,CELL_MASK
	MOV	AX,8000H			; MSB FLAGS UNDERLINE
	XOR	DI,DI
ADDU100:
	TEST	CELL_BUFF[DI],AX		; UNDERLINE HERE
	JE	ADDU200				; NO
	MOV	CELL_BUFF[DI],BX
ADDU200:
	INC	DI
	INC	DI
	LOOP	ADDU100
ADDU400:
	RET

;**************************************************
;	ADD REVERSE TO CELL_BUFF IF ON
;**************************************************
ADD_REVERSE:
	TEST	ATTRIBUTE_FLAG,REV_ATTR/256
	JE	ADDR100			; NO REVERSE
	CALL	XOR_CELL
ADDR100:
	RET

;**************************************************
;	SHIFT CELL LEFT ONE DOT
;**************************************************
LSHIFT_CELL:
	PUSH	CX
	MOV	CX,CELL_HEIGHT
	XOR	DI,DI
LSCL100:
	SHL	CELL_BUFF[DI],1		; SHIFT ONE WORD
	INC	DI
	INC	DI
	LOOP	LSCL100
	POP	CX
	RET

;**************************************************
;	GET CHARACTER CELL
;	READ SCREEN CELL INTO CELL_BUFF
;	NORMALIZED TO THE LSB SIDE OF THE BUFFER
;	ENTER	POSITION = XPOS,YPOS
;**************************************************
GET_CELL:
	CALL	CALC_ADDR		; SET BP TO ADDR OF SCREEN CELL
	MOV	SI,BP			; GET FROM HERE POINTER
	MOV	DI,OFFSET CELL_BUFF	; ADDRESS TO PUT NORMALIZED CELL
	MOV	CH,BYTE PTR CELL_HEIGHT		; NUMBER WORDS IN A CELL
	CLD
GCL100:
	LODSW				; GET LEFT WORD
	SHR	AX,CL			; ADJUST FOR SHIFT
	AND	AX,BX			; MASK OFF BAD STUFF
	STOSW				; PUT IN BUFFER
	DEC	CH
	JG	GCL100
	XOR	CL,0FH			; NEGATE CL
	INC	CL
	CMP	CL,BYTE PTR CELL_WIDTH	; DO A RIGHT SIDE ?
	JGE	GCL300			; NO
	MOV	SI,BP			; MOVE TO NEXT COLUMN RIGHT
	ADD	SI,COL_BYTE
	MOV	DI,OFFSET CELL_BUFF	; ADDRESS TO PUT NORMALIZED CELL
	MOV	CH,BYTE PTR CELL_HEIGHT		; NUMBER WORDS IN A CELL
GCL200:
	LODSW				; GET LEFT WORD
	SHL	AX,CL			; ADJUST FOR SHIFT
	AND	AX,BX			; MASK OFF BAD STUFF
	OR	AX,[DI]			; OR INTO BUFFER
	STOSW	
	DEC	CH
	JG	GCL200
GCL300:
	RET

;**************************************************
;	PUT CHARACTER CELL
;	PUT CELL_BUFF CHAR ON THE SCREEN
;	ENTER	POSITION = XPOS,YPOS
;**************************************************
PUT_CELL:
	CALL	CALC_ADDR		; BP = ADDR OF SCREEN CELL
	MOV	DI,BP			; ADDR TO PUT CHAR
	MOV	SI,OFFSET CELL_BUFF	; ADDRESS OF CELL
	MOV	CH,BYTE PTR CELL_HEIGHT		; LOOP CTR
	SHL	BX,CL			; ADJUST MASK
	CLD
PCL100:
	LODSW				; WORD FROM CELL
	SHL	AX,CL
	MOV	DX,[DI]			; ADD IN WORD FROM SCREEN
	XOR	AX,DX
	AND	AX,BX			; MASK UNWANTED STUFF
	XOR	AX,DX			; REMOVE AND ADD NEW 
	STOSW				; BACK TO SCREEN
	DEC	CH			; DONE ALL OF LEFT SIDE OF CELL ?
	JG	PCL100			; NO
	XOR	CL,0FH			; NEGATE CL
	INC	CL
	CMP	CL,BYTE PTR CELL_WIDTH		; ANY DOTS SHIFT INTO NEXT
	JGE	PCL300			; NO - ALL DONE THEN
	MOV	DI,BP
	ADD	DI,COL_BYTE		; NEXT COLUMN RIGHT
	MOV	SI,OFFSET CELL_BUFF	; ADDRESS OF CELL
	MOV	CH,BYTE PTR CELL_HEIGHT		; LOOP CTR
	MOV	BX,CELL_MASK		; MASK FOR OTHER SIDE
	SHR	BX,CL			; ADJUST MASK 
PCL200:
	LODSW				; WORD FROM CELL
	SHR	AX,CL
	MOV	DX,[DI]			; ADD IN WORD FROM SCREEN
	XOR	AX,DX
	AND	AX,BX			; MASK UNWANTED STUFF
	XOR	AX,DX			; REMOVE AND ADD NEW 
	STOSW				; BACK TO SCREEN
	DEC	CH			; DONE ALL OF LEFT SIDE OF CELL ?
	JG	PCL200
PCL300:
	RET

;**************************************************
;	CLEAR CHARACTER CELL_BUFF
;**************************************************
CLEAR_CELL:
	PUSH	CX
	MOV	CX,CELL_HEIGHT		; # WORDS TO CLEAR
	MOV	DI,OFFSET CELL_BUFF
	SUB	AX,AX			; AL=0
	CLD
	REP	STOSW	
	POP	CX
	RET

;**************************************************
;	XOR CHARACTER CELL_BUFF
;**************************************************
XOR_CELL:
	MOV	DI,CELL_HEIGHT		; # WORDS TO XOR
	SHL	DI,1	
	MOV	AX,CELL_MASK
XCEL100:
	XOR	CELL_BUFF-2[DI],AX
	DEC	DI
	DEC	DI
	JG	XCEL100
	RET

;**************************************************
;	SET CELL SIZE
;	ENTER:	BX = CELL WIDTH
;		CX = CELL HEIGHT
;**************************************************
SET_CELL_SIZE:
	MOV	CELL_WIDTH,BX	; SAVE WIDTH
	MOV	CELL_HEIGHT,CX	;  AND HEIGHT
	SUB	AX,AX		; AX = 0
SETC100:
	STC			; GEN CELL MASK
	RCL	AX,1
	DEC	BX
	JG	SETC100
	MOV	CELL_MASK,AX	; SAVE MASK
	XOR	DX,DX		; DX = 0
	MOV	AX,MAX_XDOTS	; 800 DOTS HORZ
	MOV	CX,CELL_WIDTH	; DIVIDE BY CELL WIDTH
	DIV	CX
	MOV	COLM_MAX,AX	; EQUAL MAX COLUMNS
	XOR	DX,DX		; DX = 0
	MOV	AX,MAX_YDOTS	; 400 LINES VERT
	MOV	CX,CELL_HEIGHT	; DIVIDE BY CELL HEIGHT
	DIV	CX
	MOV	LINE_MAX,AX	; EQUAL MAX LINES
	XOR	BX,BX		; TOP LINE = 0
	MOV	CX,LINE_MAX
	DEC	CX
	DEC	CX		; BOTTOM LINE = 38
				; FALL THROUGH TO SET SCREEN SIZE

;**************************************************
;	SET SCREEN SIZE
;	ENTER:	BX = TOP LINE #
;		CX = BOTTOM LINE #
;**************************************************
SET_SCRN_SIZE:
	MOV	TOP_LINE,BX	; SAVE TOP AND BOTTOM LINE
	MOV	BOT_LINE,CX
	CALL	HOME		; HOME THE CURSOR
	RET

;**************************************************
;	SET HIRES MODE
;**************************************************
SETHIRES:
	PUSH	ES
	MOV	AX,0E000H		; SET FOR 50 COLUMNS BY 25 LINES
	MOV	ES,AX
	MOV	SI,OFFSET HIRES_TAB
	MOV	CX,16			; 16 WORDS
	CLD
SH100:
	LODS	HIRES_TAB
	MOV	ES:CRTC,AX
	LOOP	SH100
	MOV	AX,SCN_SEG		; FILL SCREEN COLUMN WISE
	MOV	ES,AX
	MOV	BX,SCN_OFF
	MOV	CH,SCOLS
	MOV	AX,CS			; CALC CHAR # FOR SCREEN
	ADD	AX,(DOT_BUFF-BEGIN)/16
	SHR	AX,1			; 32 CHAR IN A CELL
	OR	AX,LOW_ATTR		; ADD LOW INTENSITY ATTRIBUITE
SH200:
	PUSH	BX			; SAVE BEGINNING ADDR
	MOV	CL,SROWS
SH300:
	MOV	ES:[BX],AX
	INC	AX
	ADD	BX,2*SCOLS
	DEC	CL
	JG	SH300
	POP	BX
	ADD	BX,2			; SKIP RIGHT TO NEXT COLUMN
	DEC	CH
	JG	SH200
	POP	ES
	RET

;**************************************************
;	SET TEXT MODE
;**************************************************
SETTEXT:
	PUSH	ES
	MOV	AX,0E000H
	MOV	ES,AX
	MOV	SI,OFFSET TEXT_TAB
	MOV	CX,16
	CLD
ST100:
	LODS	TEXT_TAB
	MOV	ES:CRTC,AX
	LOOP	ST100
	POP	ES
	RET

ENDCODE		EQU	$

ESC_DISPATCH	DW	PASS_BUFFER	; 20H ' '
		DW	PASS_BUFFER	; 21H '!'
		DW	PASS_BUFFER	; 22H '"'
		DW	TRANSMIT_PAGE	; 23H '#'  TRANSMIT PAGE
		DW	TRANSMIT_CHAR	; 24H '$'  TRANSMIT CURSOR CHAR
		DW	PASS_BUFFER	; 25H '%'
		DW	PASS_BUFFER	; 26H '&'
		DW	PASS_BUFFER	; 27H '''
		DW	LOW_INT_OFF	; 28H '('  HIGH INTENSITY ON
		DW	LOW_INT_ON	; 29H ')'  HIGH INTENSITY OFF
		DW	PASS_BUFFER	; 2AH '*'
		DW	PASS_BUFFER	; 2BH '+'
		DW	PASS_BUFFER	; 2CH ','
		DW	PASS_BUFFER	; 2DH '-'
		DW	PASS_BUFFER	; 2EH '.'
		DW	PASS_BUFFER	; 2FH '/'
		DW	UNDERLINE_ON	; 30H '0'  ENTER UNDERLINE MODE
		DW	UNDERLINE_OFF	; 31H '1'  EXIT  UNDERLINE MODE
		DW	SET_DONE	; 32H '2'
		DW	SET_DONE	; 33H '3'
		DW	PASS_BUFFER	; 34H '4'
		DW	PASS_BUFFER	; 35H '5'
		DW	PASS_BUFFER	; 36H '6'
		DW	PASS_BUFFER	; 37H '7'
		DW	LITERAL		; 38H '8'  LITERAL CHARACTER
		DW	PASS_BUFFER	; 39H '9'
		DW	PASS_BUFFER	; 3AH ':'
		DW	PASS_BUFFER	; 3BH ';'
		DW	PASS_BUFFER	; 3CH '<'
		DW	PASS_BUFFER	; 3DH '='
		DW	PASS_BUFFER	; 3EH '>'
		DW	PASS_BUFFER	; 3FH '?'
		DW	INSERT_CHAR_ON	; 40H '@'  ENTER INSERT CHAR MODE
		DW	CURSOR_UP	; 41H 'A'  CURSOR UP
		DW	CURSOR_DOWN	; 42H 'B'  CURSOR DOWN
		DW	CURSOR_FORWARD	; 43H 'C'  CURSOR FORWARD
		DW	CURSOR_BACKWARD	; 44H 'D'  CURSOR BACKWARD
		DW	CLEAR		; 45H 'E'  CLEAR DISPLAY
		DW	GRAPHIC_ON	; 46H 'F'  ENTER GRAPHICS MODE
		DW	GRAPHIC_OFF	; 47H 'G'  EXIT GRAPHICS MODE
		DW	HOME		; 48H 'H'  CURSOR HOME
		DW	REV_LINE_FEED	; 49H 'I'  REVERSE INDEX
		DW	ERASE_EOP	; 4AH 'J'  ERASE TO END OF PAGE
		DW	ERASE_EOL	; 4BH 'K'  ERASE TO END OF LINE
		DW	INSERT_LINE	; 4CH 'L'  INSERT LINE
		DW	DELETE_LINE	; 4DH 'M'  DELETE LINE
		DW	DELETE_CHAR	; 4EH 'N'  DELETE CHARACTER
		DW	INSERT_CHAR_OFF	; 4FH 'O'  EXIT INSERT CHAR MODE
		DW	PASS_BUFFER	; 50H 'P'
		DW	PASS_BUFFER	; 51H 'Q'
		DW	PASS_BUFFER	; 52H 'R'
		DW	PASS_BUFFER	; 53H 'S'
		DW	PASS_BUFFER	; 54H 'T'
		DW	PASS_BUFFER	; 55H 'U'
		DW	PASS_BUFFER	; 56H 'V'
		DW	PASS_BUFFER	; 57H 'W'
		dw	exchange_line	; 58H 'X'  Exchange frgnd/bkgnd (?)
		DW	DIRECT_CURSOR	; 59H 'Y'  DIRECT CURSOR ADDRESSING
		DW	IDENT_VT52	; 5AH 'Z'  IDENTIFY AS VT52 (ESC/K)
		DW	SET_DONE	; 5BH '['
		DW	SET_DONE	; 5CH '\'
		DW	TRANSMIT_BOT	; 5DH ']'  TRANSMIT BOTTOM LINE
		DW	SET_DONE	; 5EH '^'
		DW	PASS_BUFFER	; 5FH '_'
		DW	PASS_BUFFER	; 60H '`'
		DW	PASS_BUFFER	; 61H 'a'
		DW	ERASE_BOP	; 62H 'b'  ERASE TO BEGINNING OF PAGE
		DW	PASS_BUFFER	; 63H 'c'
		DW	PASS_BUFFER	; 64H 'd'
		DW	PASS_BUFFER	; 65H 'e'
		DW	PASS_BUFFER	; 66H 'f'
		DW	PASS_BUFFER	; 67H 'g'
		DW	REVERSE_TAB	; 68H 'h'  REVERSE TAB
		DW	PASS_BUFFER	; 69H 'i'
		DW	SAVE_POS	; 6AH 'j'  SAVE CURSOR POSITION
		DW	RESTORE_POS	; 6BH 'k'  SET CURSOR TO SAVED POS
		DW	ERASE_LINE	; 6CH 'l'  ERASE ENTIRE LINE
		DW	SET_SIZE	; 6DH 'm'  SET SIZE
		DW	REPORT_CURSOR	; 6EH 'n'  CURSOR POSITION REPORT
		DW	ERASE_BOL	; 6FH 'o'  ERASE BEGINNING OF LINE
		DW	REVERSE_ON	; 70H 'p'  ENTER REVERSE VIDEO MODE
		DW	REVERSE_OFF	; 71H 'q'  EXIT REVERSE VIDEO MODE
		DW	PASS_BUFFER	; 72H 'r'
		DW	PASS_BUFFER	; 73H 's'
		DW	PASS_BUFFER	; 74H 't'
		DW	PASS_BUFFER	; 75H 'u'
		DW	WRAP_MODE	; 76H 'v'  WRAP AROUND AT END OF LINE
		DW	DISCARD_MODE	; 77H 'w'  DISCARD AT END OF LINE
		DW	SET_MODES	; 78H 'x'  SET MODE(S)
		DW	RESET_MODES	; 79H 'y'  RESET MODE(S)
		DW	RESET		; 7AH 'z'  RESET TO 80 COLUMN MODE
		DW	KEYBOARD_ON	; 7BH '{'  KEYBOARD ENABLED
		DW	ENABLE_132	; 7CH '|'  ENABLE 132 COLUMN MODE
		DW	KEYBOARD_OFF	; 7DH '}'  KEYBOARD DISABLE
		DW	PASS_BUFFER	; 7EH '~'
		DW	PASS_BUFFER	; 7FH DEL


END_END:

PROG		ENDS

		END
